/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.colos.ejs.library.ConfigurableElement;
import org.colos.ejs.library.DelayedAction;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.GroupVariable;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.PropertyEditor;
import org.colos.ejs.library.control.VariableEditor;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;

public abstract class ControlElement
implements ConfigurableElement {
    protected EjsControl myGroup = null;
    protected Hashtable<String, String> myPropertiesTable = new Hashtable();
    protected Object myObject = null;
    private boolean myActiveState = true;
    private Vector<MethodWithOneParameter> myActionsList = new Vector();
    private GroupVariable[] myProperties = null;
    private String[] myPropertiesNames = null;
    protected boolean isUnderEjs = false;
    private boolean actionsWhenIdle = true;
    MethodWithOneParameter[] myMethodsForProperties = null;
    Value[] myExpressionsForProperties = null;
    protected PropertyEditor myEjsPropertyEditor = null;
    VariableEditor myEjsVariableEditor = null;
    public static final int NAME = 0;
    public static final int ACTION = 0;
    public static final int VARIABLE_CHANGED = 1;
    public static final int METHOD_FOR_VARIABLE = 2;
    public static final int ACTION_ERROR = 1001;
    public static final int ACTION_SUCCESS = 1002;
    public static final String METHOD_TRIGGER = "_expr_";

    public static int indexOf(String _var, String[] _vars) {
        int i = 0;
        int n = _vars.length;
        while (i < n) {
            if (_var.equals(_vars[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static List<Object> getDataInformationMenuEntries(final Component _parent, final Data _data) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolForData.getTool().showTable(_parent, _data);
            }
        });
        list.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolForData.getTool().showDataTool(_parent, _data);
            }
        });
        return list;
    }

    public ControlElement() {
        List<String> info = this.getPropertyList();
        this.myPropertiesNames = new String[info.size()];
        this.myProperties = new GroupVariable[info.size()];
        this.myMethodsForProperties = new MethodWithOneParameter[info.size()];
        this.myExpressionsForProperties = new Value[info.size()];
        int i = 0;
        while (i < info.size()) {
            String property;
            this.myPropertiesNames[i] = property = info.get(i);
            this.myProperties[i] = null;
            this.myMethodsForProperties[i] = null;
            this.myExpressionsForProperties[i] = null;
            ++i;
        }
    }

    public Object getObject() {
        return this.myObject;
    }

    public String getObjectClassname() {
        return this.myObject.getClass().getName();
    }

    public String getServerClassname() {
        return "org.colos.ejs.library.server.SocketViewElement";
    }

    public Object getObject(String _name) {
        if (_name == null || _name.trim().length() <= 0) {
            return this.getObject();
        }
        return null;
    }

    protected EjsControl getEjsControl() {
        return this.myGroup;
    }

    public void addMenuEntries() {
    }

    public void replaceVisual(Frame _owner) {
    }

    public void setPropertyEditor(PropertyEditor _editor) {
        this.myEjsPropertyEditor = _editor;
    }

    public final boolean editorIsReading() {
        return this.myEjsPropertyEditor == null ? false : this.myEjsPropertyEditor.isReading();
    }

    public void setVariableEditor(VariableEditor _editor) {
        this.myEjsVariableEditor = _editor;
    }

    public final void setFieldListValue(int _index, Value _value) {
        this.setFieldListValue(_index, _value, true);
    }

    protected final void setFieldListValue(int _index, Value _value, boolean andReport) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        if (this.myMethodsForProperties[_index] == null && this.myExpressionsForProperties[_index] == null) {
            if (this.myProperties[_index] != null) {
                this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[_index].getName(), this.toStringValue(_value), _value);
            } else {
                String name = this.myPropertiesNames[_index];
                for (JTextComponent field : this.myEjsPropertyEditor.getFieldList()) {
                    if (!field.getName().equals(name)) continue;
                    field.setText(this.toStringValue(_value));
                    field.setCaretPosition(0);
                    field.setBackground(Color.white);
                    this.setProperty(name, this.toStringValue(_value));
                    this.reset();
                    break;
                }
            }
        }
        if (andReport) {
            this.myEjsVariableEditor.updateControlValues(false);
        }
    }

    protected final void setFieldListValueWithAlternative(int _index, int _index2, Value _value) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        if (this.myMethodsForProperties[_index] == null && this.myExpressionsForProperties[_index] == null) {
            if (this.myProperties[_index] != null) {
                this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[_index].getName(), this.toStringValue(_value), _value);
                this.setFieldListValue(_index2, _value);
                return;
            }
            String name = this.myPropertiesNames[_index];
            for (JTextComponent field : this.myEjsPropertyEditor.getFieldList()) {
                if (!field.getName().equals(name)) continue;
                field.setText(this.toStringValue(_value));
                field.setCaretPosition(0);
                field.setBackground(Color.white);
                this.setProperty(name, this.toStringValue(_value));
                this.reset();
            }
        }
        this.myEjsVariableEditor.updateControlValues(false);
    }

    public final void setFieldListValues(int[] _variableIndex, Value[] _values) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        boolean changeInControl = false;
        int i = 0;
        int n = _variableIndex.length;
        while (i < n) {
            int index = _variableIndex[i];
            if (index >= 0 && this.myMethodsForProperties[index] == null && this.myExpressionsForProperties[index] == null) {
                if (this.myProperties[index] != null) {
                    changeInControl = true;
                    this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[index].getName(), _values[i].getString(), _values[i]);
                } else {
                    String name = this.myPropertiesNames[index];
                    if (!this.propertyIsTypeOf(name, "DEPRECATED") || this.myGroup == null || this.myGroup.getBoolean("_Ejs_ShowDeprecated_")) {
                        for (JTextComponent field : this.myEjsPropertyEditor.getFieldList()) {
                            if (!field.getName().equals(name)) continue;
                            field.setText(_values[i].getString());
                            field.setCaretPosition(0);
                            field.setBackground(Color.white);
                            this.setProperty(name, _values[i].getString());
                            this.reset();
                        }
                    }
                }
            }
            ++i;
        }
        if (changeInControl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControlElement.this.myEjsVariableEditor.updateControlValues(false);
                }
            });
        }
    }

    public abstract List<String> getPropertyList();

    public abstract String getPropertyInfo(String var1);

    public String getPropertyCommonName(String _property) {
        return _property;
    }

    public Value parseConstant(String _propertyType, String _value) {
        String noQuotesValue;
        Value constantValue;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("boolean") >= 0 && (constantValue = ConstantParser.booleanConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Color") >= 0 && (constantValue = ConstantParser.colorConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("File") >= 0 && ResourceLoader.getResource(noQuotesValue = _value.startsWith("\"") && _value.endsWith("\"") ? _value.substring(1, _value.length() - 1) : _value) != null) {
            return new StringValue(_value);
        }
        if (_propertyType.indexOf("Font") >= 0) {
            Font currentFont = null;
            if (this.getVisual() != null) {
                currentFont = this.getVisual().getFont();
            }
            if ((constantValue = ConstantParser.fontConstant(currentFont, _value)) != null) {
                return constantValue;
            }
        }
        if (_propertyType.indexOf("Format") >= 0 && (constantValue = ConstantParser.formatConstant(_value)) != null) {
            return constantValue;
        }
        if ((_propertyType.indexOf("Margins") >= 0 || _propertyType.indexOf("Rectangle") >= 0) && (constantValue = ConstantParser.rectangleConstant(_value)) != null) {
            return constantValue;
        }
        return null;
    }

    public String toStringValue(Value _value) {
        if (_value instanceof StringValue) {
            return "\"" + _value.getString() + "\"";
        }
        return _value.getString();
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, _value.toString());
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, null);
            }
        }
    }

    public String getDefaultValueString(int _index) {
        return "???";
    }

    public Value getValue(int _index) {
        return null;
    }

    public final Value getValue(String _property) {
        return this.getValue(this.propertyIndex(_property));
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        return this.setProperty(_property, _value, true);
    }

    public ControlElement setProperty(String _property, String _value, boolean _storeIt) {
        int index;
        if ((_property = _property.trim()).equals("_ejs_")) {
            this.isUnderEjs = true;
        }
        if ((index = this.propertyIndex(_property)) < 0) {
            if (_value == null) {
                this.myPropertiesTable.remove(_property);
            } else if (_storeIt) {
                this.myPropertiesTable.put(_property, _value);
            }
            return this;
        }
        this.myMethodsForProperties[index] = null;
        this.myExpressionsForProperties[index] = null;
        if (this.myProperties[index] != null) {
            this.myProperties[index].removeElementListener(this, index);
            this.myProperties[index] = null;
        }
        if (_value == null) {
            if (this.myProperties[index] != null) {
                this.myProperties[index].removeElementListener(this, index);
                this.myProperties[index] = null;
            }
            this.setDefaultValue(index);
            this.myPropertiesTable.remove(_property);
            return this;
        }
        if (!this.propertyIsTypeOf(_property, "NotTrimmed")) {
            _value = _value.trim();
        }
        String originalValue = _value;
        Value constantValue = null;
        if (_value.startsWith("%") && _value.endsWith("%") && _value.length() > 2) {
            _value = _value.substring(1, _value.length() - 1);
        } else if (!(_value.startsWith("@") && _value.endsWith("@") && _value.length() > 2 || _value.startsWith("#") && _value.endsWith("#") && _value.length() > 2)) {
            if (!_value.startsWith("\"") && !_value.startsWith("'")) {
                if (this.propertyIsTypeOf(_property, "CONSTANT")) {
                    constantValue = new StringValue(_value);
                }
                if (constantValue == null) {
                    String propType = this.propertyType(_property);
                    if (propType.equals("String") && !this.propertyIsTypeOf(_property, "VARIABLE_EXPECTED")) {
                        constantValue = new StringValue(_value);
                    }
                    if (propType.equals("String|String[]") && !this.propertyIsTypeOf(_property, "VARIABLE_EXPECTED") && !_value.endsWith("}")) {
                        constantValue = new StringValue(_value);
                    }
                }
            }
            if (constantValue == null) {
                constantValue = this.parseConstant(this.propertyType(_property), _value);
            }
            if (constantValue == null) {
                constantValue = Value.parseConstantOrArray(_value, true);
            }
        }
        if (constantValue != null) {
            this.setValue(index, constantValue);
            if (_storeIt) {
                this.myPropertiesTable.put(_property, originalValue);
            }
            return this;
        }
        if (this.myGroup == null) {
            if (_storeIt) {
                this.myPropertiesTable.put(_property, originalValue);
            }
            return this;
        }
        boolean isNormalVariable = true;
        boolean isExpression = false;
        if (_value.startsWith("#") && _value.endsWith("#") && _value.length() > 2) {
            _value = _value.substring(1, _value.length() - 1);
            isNormalVariable = true;
        } else if (_value.startsWith("@") && _value.endsWith("@") && _value.length() > 2) {
            originalValue = _value = _value.substring(1, _value.length() - 1);
            isNormalVariable = false;
            isExpression = true;
        } else if (_value.startsWith("new ")) {
            originalValue = _value;
            isNormalVariable = false;
            isExpression = false;
        } else if (_value.indexOf(40) >= 0) {
            isNormalVariable = false;
        }
        if (isNormalVariable) {
            Value newValue = null;
            newValue = this.getValue(index);
            if (newValue == null) {
                newValue = this.propertyIsTypeOf(_property, "double") ? new DoubleValue(0.0) : (this.propertyIsTypeOf(_property, "boolean") ? new BooleanValue(false) : (this.propertyIsTypeOf(_property, "int") ? new IntegerValue(0) : (this.propertyIsTypeOf(_property, "String") ? new StringValue(_value) : new ObjectValue(null))));
            }
            this.myProperties[index] = this.myGroup.registerVariable(_value, this, index, newValue);
        } else if (isExpression) {
            String returnType = null;
            if (this.propertyIsTypeOf(_property, "double")) {
                returnType = "double";
            } else if (this.propertyIsTypeOf(_property, "boolean")) {
                returnType = "boolean";
            } else if (this.propertyIsTypeOf(_property, "int")) {
                returnType = "int";
            } else if (this.propertyIsTypeOf(_property, "String")) {
                returnType = "String";
            } else if (this.propertyIsTypeOf(_property, "Action")) {
                returnType = "Action";
            } else {
                this.myPropertiesTable.put(_property, originalValue);
                return this;
            }
            if (!returnType.equals("Action")) {
                this.myExpressionsForProperties[index] = new InterpretedValue(_value, this.myEjsPropertyEditor);
                this.myGroup.methodTriggerVariable.addElementListener(this, index);
                this.myProperties[index] = this.myGroup.methodTriggerVariable;
            }
        } else if (this.getProperty("_ejs_") == null) {
            Object target;
            String returnType = null;
            if (this.propertyIsTypeOf(_property, "String")) {
                returnType = "String";
            } else if (this.propertyIsTypeOf(_property, "Color")) {
                returnType = "Object";
            } else if (this.propertyIsTypeOf(_property, "double")) {
                returnType = "double";
            } else if (this.propertyIsTypeOf(_property, "boolean")) {
                returnType = "boolean";
            } else if (this.propertyIsTypeOf(_property, "int")) {
                returnType = "int";
            } else if (this.propertyIsTypeOf(_property, "double[]")) {
                returnType = "Object";
            } else if (this.propertyIsTypeOf(_property, "int[]")) {
                returnType = "Object";
            } else if (this.propertyIsTypeOf(_property, "Object")) {
                returnType = "Object";
            } else {
                System.out.println("Error for property " + _property + " of the element " + this.toString() + ". Cannot be set to : " + originalValue);
                this.myPropertiesTable.put(_property, originalValue);
                return this;
            }
            String[] parts = MethodWithOneParameter.splitMethodName(_value);
            if (parts == null) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! method <" + originalValue + "> not found");
                this.myPropertiesTable.put(_property, originalValue);
                return this;
            }
            if (parts[0] == null) {
                parts[0] = "_default_";
            }
            if ((target = this.myGroup.getTarget(parts[0])) == null) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + parts[0] + "> not assigned");
                System.err.println("when setting property " + _property + " to " + _value);
                this.myPropertiesTable.put(_property, originalValue);
                return this;
            }
            _value = parts[2] == null ? String.valueOf(parts[1]) + "()" : String.valueOf(parts[1]) + "(" + parts[2] + ")";
            this.myMethodsForProperties[index] = new MethodWithOneParameter(2, target, _value, returnType, null, this);
            this.myGroup.methodTriggerVariable.addElementListener(this, index);
            this.myProperties[index] = this.myGroup.methodTriggerVariable;
            this.myGroup.update();
            this.myGroup.finalUpdate();
        }
        if (_storeIt) {
            this.myPropertiesTable.put(_property, originalValue);
        }
        return this;
    }

    public final ControlElement setProperties(String _propertyList) {
        Hashtable<String, String> propTable = new Hashtable<String, String>();
        StringTokenizer tkn = new StringTokenizer(_propertyList, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (token.trim().length() <= 0) continue;
            int index = token.indexOf("=");
            if (index < 0) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Token <" + token + "> invalid for " + this.toString());
                continue;
            }
            propTable.put(token.substring(0, index).trim(), token.substring(index + 1));
        }
        return this.setProperties(propTable);
    }

    private void preprocess(String _property, Hashtable<String, String> _propertyTable) {
        String value = _propertyTable.get(_property);
        if (value != null) {
            this.setProperty(_property, value);
            _propertyTable.remove(_property);
        }
    }

    private ControlElement setProperties(Hashtable<String, String> _propertyTable) {
        String key;
        this.preprocess("_ejs_", _propertyTable);
        Hashtable<String, String> postTable = new Hashtable<String, String>();
        Enumeration<String> e = _propertyTable.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            if (this.propertyIsTypeOf(key, "PREVIOUS")) {
                this.preprocess(key, _propertyTable);
                continue;
            }
            if (!this.propertyIsTypeOf(key, "POSTPROCESS")) continue;
            String value = _propertyTable.get(key);
            _propertyTable.remove(key);
            postTable.put(key, value);
        }
        e = _propertyTable.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            this.setProperty(key, _propertyTable.get(key));
        }
        e = postTable.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            this.setProperty(key, (String)postTable.get(key));
        }
        return this;
    }

    public final String getProperty(String _property) {
        return this.myPropertiesTable.get(_property);
    }

    public final boolean propertyIsTypeOf(String _property, String _keyword) {
        String info = this.getPropertyInfo(_property);
        if (info == null) {
            return false;
        }
        _keyword = _keyword.toLowerCase();
        StringTokenizer tkn = new StringTokenizer(info, " |");
        while (tkn.hasMoreTokens()) {
            if (!tkn.nextToken().toLowerCase().equals(_keyword)) continue;
            return true;
        }
        return false;
    }

    public final String propertyType(String _property) {
        String info = this.getPropertyInfo(_property);
        if (info == null) {
            return "double";
        }
        StringTokenizer tkn = new StringTokenizer(info, " ");
        if (tkn.countTokens() >= 1) {
            return tkn.nextToken();
        }
        return "double";
    }

    public Component getComponent() {
        return null;
    }

    public Component getVisual() {
        return null;
    }

    public boolean acceptsChild(ControlElement _child) {
        return false;
    }

    public void reset() {
    }

    public void initialize() {
    }

    public void onExit() {
    }

    @Deprecated
    public final void flush() {
    }

    public int propertyIndex(String _property) {
        if (this.myPropertiesNames != null) {
            int i = 0;
            while (i < this.myPropertiesNames.length) {
                if (this.myPropertiesNames[i].equals(_property)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean implementsProperty(String _property) {
        return this.propertyIndex(_property) >= 0;
    }

    public final void variablePropertiesClear() {
        if (this.myPropertiesNames != null) {
            int i = 0;
            while (i < this.myPropertiesNames.length) {
                this.setProperty(this.myPropertiesNames[i], null);
                ++i;
            }
        }
    }

    public String toString() {
        String name = this.myPropertiesTable.get("name");
        if (name != null) {
            return name;
        }
        String text = this.getClass().getName();
        int index = text.lastIndexOf(".");
        if (index >= 0) {
            text = text.substring(index + 1);
        }
        return "Unnamed element of type " + text;
    }

    public void destroy() {
        this.setProperty("parent", null);
        if (this.myProperties != null) {
            int i = 0;
            while (i < this.myProperties.length) {
                if (this.myProperties[i] != null) {
                    this.myProperties[i].removeElementListener(this, i);
                }
                ++i;
            }
        }
    }

    public final ControlElement addAction(int _type, Object _target, String _method) {
        this.myActionsList.addElement(new MethodWithOneParameter(_type, _target, _method, null, null, this));
        return this;
    }

    public final ControlElement addAction(int _type, Object _target, String _method, MethodWithOneParameter _secondAction) {
        this.myActionsList.addElement(new MethodWithOneParameter(_type, _target, _method, null, _secondAction, this));
        return this;
    }

    public final ControlElement addAction(int _type, String _method) {
        if (this.getProperty("_ejs_") != null) {
            _method = "_ejs_.execute(\"" + _method + "\")";
        }
        Object target = null;
        MethodWithOneParameter secondAction = null;
        String[] parts = MethodWithOneParameter.splitMethodName(_method);
        if (parts == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Method <" + _method + "> not assigned");
            return this;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        if (this.myGroup != null) {
            target = this.myGroup.getTarget(parts[0]);
            if (_type != 1 && this.getProperty("_ejs_SecondAction_") != null && this.myGroup.getTarget("_default_") != null) {
                secondAction = new MethodWithOneParameter(_type, this.myGroup.getTarget("_default_"), this.getProperty("_ejs_SecondAction_"), null, null, this);
            }
        }
        if (target == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + parts[0] + "> not assigned");
            System.err.println("when adding action property " + _type + " to " + _method);
            return this;
        }
        if (parts[2] == null) {
            return this.addAction(_type, target, String.valueOf(parts[1]) + "()", secondAction);
        }
        return this.addAction(_type, target, String.valueOf(parts[1]) + "(" + parts[2] + ")", secondAction);
    }

    public final void removeAction(int _type, Object _target, String _method) {
        if (_method == null) {
            return;
        }
        Enumeration<MethodWithOneParameter> e = this.myActionsList.elements();
        while (e.hasMoreElements()) {
            MethodWithOneParameter meth = e.nextElement();
            if (!meth.equals(_type, _target, _method)) continue;
            if (!this.myActionsList.removeElement(meth)) {
                System.err.println(String.valueOf(this.getClass().getName()) + ": Error! Action " + _method + " not removed");
            }
            return;
        }
    }

    public final void removeAction(int _type, String _method) {
        String[] parts;
        if (_method == null) {
            return;
        }
        if (this.getProperty("_ejs_") != null) {
            _method = "_ejs_.execute(\"" + _method + "\")";
        }
        if ((parts = MethodWithOneParameter.splitMethodName(_method)) == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Method <" + _method + "> not removed");
            return;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        Object target = null;
        if (this.myGroup != null) {
            target = this.myGroup.getTarget(parts[0]);
        }
        if (target == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + parts[0] + "> not assigned");
            System.err.println("when removing action property " + _type + " : " + _method);
            return;
        }
        this.removeAction(_type, target, String.valueOf(parts[1]) + "(" + parts[2] + ")");
    }

    public final void invokeActions() {
        this.invokeActions(0);
    }

    private final boolean isControlUpdatingSimulation() {
        if (this.myGroup != null) {
            return this.myGroup.isUpdatingSimulation();
        }
        return true;
    }

    protected final void setImmediateActions(boolean _rightNow) {
        this.actionsWhenIdle = !_rightNow;
    }

    protected final boolean hasDelayedActions() {
        return this.actionsWhenIdle;
    }

    public final void invokeActions(int _type) {
        block4: {
            if (!this.myActiveState || !this.isControlUpdatingSimulation()) break block4;
            Simulation sim = this.getSimulation();
            if (sim != null && this.actionsWhenIdle) {
                for (MethodWithOneParameter method : this.myActionsList) {
                    sim.invokeMethodWhenIdle(new MethodDelayedAction(method, _type, this));
                }
            } else {
                for (MethodWithOneParameter method : this.myActionsList) {
                    method.invoke(_type, this);
                }
            }
        }
    }

    public final void variableChangedDoNotUpdate(int _variableIndex, Value _value) {
        block5: {
            if (this.myGroup != null && this.myProperties != null) {
                this.myGroup.setReportingChange(true);
                this.myGroup.variableChanged(this.myProperties[_variableIndex], this, _value);
                this.myGroup.setReportingChange(false);
            }
            if (!this.myActiveState || !this.isControlUpdatingSimulation()) break block5;
            Simulation sim = this.getSimulation();
            if (sim != null && this.actionsWhenIdle) {
                for (MethodWithOneParameter method : this.myActionsList) {
                    sim.invokeMethodWhenIdle(new MethodDelayedAction(method, 1, this));
                }
            } else {
                for (MethodWithOneParameter method : this.myActionsList) {
                    method.invoke(1, this);
                }
            }
        }
    }

    public final void variableChanged(int _variableIndex, Value _value) {
        if (this.myMethodsForProperties[_variableIndex] != null) {
            return;
        }
        this.variableChangedDoNotUpdate(_variableIndex, _value);
        if (this.myGroup != null) {
            this.myGroup.updateSimulationWhenIdle();
        }
    }

    public final void variableExtraChanged(int _variableIndex, Value _value) {
        if (this.myMethodsForProperties[_variableIndex] != null) {
            return;
        }
        if (this.myGroup != null && this.myProperties != null) {
            this.myGroup.variableChanged(this.myProperties[_variableIndex], this, _value);
        }
        if (this.myGroup != null) {
            this.myGroup.updateSimulationWhenIdle();
        }
    }

    public final void variablesChanged(int[] _variableIndex, Value[] _value) {
        boolean doMore = false;
        if (this.myGroup != null && this.myProperties != null) {
            int i = 0;
            while (i < _variableIndex.length) {
                if (this.myMethodsForProperties[_variableIndex[i]] == null) {
                    this.myGroup.variableChanged(this.myProperties[_variableIndex[i]], this, _value[i]);
                    doMore = true;
                }
                ++i;
            }
        }
        if (!doMore) {
            return;
        }
        if (this.myActiveState) {
            Simulation sim = this.getSimulation();
            if (sim != null && this.actionsWhenIdle) {
                for (MethodWithOneParameter method : this.myActionsList) {
                    sim.invokeMethodWhenIdle(new MethodDelayedAction(method, 1, this));
                }
            } else {
                for (MethodWithOneParameter method : this.myActionsList) {
                    method.invoke(1, this);
                }
            }
        }
        if (this.myGroup != null) {
            this.myGroup.updateSimulationWhenIdle();
        }
    }

    public final void setActive(boolean _act) {
        this.myActiveState = _act;
    }

    public final boolean isActive() {
        return this.myActiveState;
    }

    public final void setGroup(EjsControl _group) {
        this.myGroup = _group;
    }

    public final EjsControl getGroup() {
        return this.myGroup;
    }

    public final Simulation getSimulation() {
        if (this.myGroup == null) {
            return null;
        }
        return this.myGroup.getSimulation();
    }

    private static class MethodDelayedAction
    implements DelayedAction {
        MethodWithOneParameter method;
        int type;
        Object object;

        private MethodDelayedAction(MethodWithOneParameter _method, int _type, Object _object) {
            this.method = _method;
            this.type = _type;
            this.object = _object;
        }

        @Override
        public void performAction() {
            this.method.invoke(this.type, this.object);
        }
    }
}

