/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.SwingWorker;
import org.opensourcephysics.tools.ResourceLoader;

public class MoodleConnection
implements EmersionLink {
    static ImageIcon moodleIcon = ResourceLoader.getIcon("org/colos/ejs/library/resources/Moodle.png");
    private URL moodle_upload_file = null;
    private URL send_files_list = null;
    private String ejsapp_id = null;
    private String user_id = null;
    private String context_id = null;
    private String moodle_lang = null;
    private String moodle_user = null;
    private String moodle_pass = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();
    private ProgressDialog progressMonitor;
    private LongTask task;
    private Timer timer;
    private int previous;

    public MoodleConnection(JApplet _applet, Simulation _simulation) {
        this.simulation = _simulation;
        String urlSaveStr = _applet.getParameter("moodle_upload_file");
        int fin = urlSaveStr.indexOf("upload_file.php");
        String urlLoadStr = String.valueOf(urlSaveStr.substring(0, fin)) + "send_files_list.php";
        try {
            this.moodle_upload_file = new URL(urlSaveStr);
            this.context_id = _applet.getParameter("context_id");
            this.user_id = _applet.getParameter("user_id");
            this.ejsapp_id = _applet.getParameter("ejsapp_id");
            this.moodle_lang = _applet.getParameter("language");
            this.moodle_user = _applet.getParameter("username");
            this.moodle_pass = _applet.getParameter("password");
            _simulation.setLocale(this.moodle_lang);
            System.out.println("Connected to Moodle\n");
        }
        catch (MalformedURLException mue) {
            if (this.moodle_upload_file != null) {
                System.out.println("Malformed URL exception for URL = <" + urlSaveStr + ">");
            }
            this.moodle_upload_file = null;
        }
        try {
            this.send_files_list = new URL(urlLoadStr);
        }
        catch (MalformedURLException mue) {
            if (this.send_files_list != null) {
                System.out.println("Malformed URL exception for URL = <" + urlLoadStr + ">");
            }
            this.send_files_list = null;
        }
        if (this.context_id == null) {
            System.out.println("context_id parameter was not found");
        }
        if (this.user_id == null) {
            System.out.println("user_id parameter was not found");
        }
        if (this.ejsapp_id == null) {
            System.out.println("ejsapp_id parameter was not found");
        }
        if (this.moodle_lang == null) {
            System.out.println("language parameter was not found");
        }
        if (this.moodle_user == null) {
            System.out.println("username parameter was not found");
        }
        if (this.moodle_pass == null) {
            System.out.println("password parameter was not found");
        }
    }

    @Override
    public boolean isConnected() {
        return this.moodle_upload_file != null && this.send_files_list != null;
    }

    @Override
    public void setParentComponent(Component _component) {
        this.parentComponent = _component;
    }

    @Override
    public void setNameLabel(String _label) {
        this.savePanel.nameLabel.setText(_label);
    }

    @Override
    public void setAnnotationLabel(String _label) {
        this.savePanel.annotationLabel.setText(_label);
    }

    private void delay(int mseconds) {
        try {
            Thread.sleep(mseconds);
        }
        catch (InterruptedException e) {
            System.out.println("Delay interrupted!");
        }
    }

    @Override
    public String saveBinary(String _filename, String _annotation, byte[] _data) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        this.task = new LongTask(_filename, _annotation, _data);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return _filename;
    }

    @Override
    public String saveImage(String _filename, String _annotation, Image _image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        int index = _filename.lastIndexOf(46);
        if (index == 0) {
            _filename = String.valueOf(_filename) + ".gif";
        }
        if ((_filename = index > 0 ? String.valueOf(_filename.substring(0, index)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + _filename.substring(index) : String.valueOf(_filename) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".gif").length() <= 0) {
            return null;
        }
        this.task = new LongTask(_filename, _annotation, _image);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return _filename;
    }

    @Override
    public String saveText(String _filename, String _annotation, String _text) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        int index = _filename.lastIndexOf(46);
        if (index == 0) {
            _filename = String.valueOf(_filename) + ".txt";
        }
        if ((_filename = index > 0 ? String.valueOf(_filename.substring(0, index)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + _filename.substring(index) : String.valueOf(_filename) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".txt").length() <= 0) {
            return null;
        }
        this.task = new LongTask(_filename, _annotation, _text, true);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return _filename;
    }

    @Override
    public String saveXML(String _filename, String _annotation, String _xml) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        int index = _filename.lastIndexOf(46);
        if (index == 0) {
            _filename = String.valueOf(_filename) + ".xml";
        }
        if ((_filename = index > 0 ? String.valueOf(_filename.substring(0, index)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + _filename.substring(index) : String.valueOf(_filename) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".xml").length() <= 0) {
            return null;
        }
        this.task = new LongTask(_filename, _annotation, _xml, false);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return _filename;
    }

    @Override
    public byte[] readBinary(String _ext) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    @Override
    public String readText(String _filename) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    @Override
    public String readXML(String _fileName) {
        String fileToLoad;
        if (!this.isConnected()) {
            return null;
        }
        if (_fileName == null) {
            try {
                URLConnection conn = this.send_files_list.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write("ejsapp_id=" + this.ejsapp_id);
                wr.flush();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                _fileName = rd.readLine();
                wr.close();
                rd.close();
            }
            catch (Exception e) {
                System.out.println("CAN'T OPEN CONNECTION: " + e);
            }
            fileToLoad = "url:" + this.readPanel.chooseFile(_fileName);
        } else {
            fileToLoad = _fileName;
        }
        return fileToLoad;
    }

    @Override
    public Image readImage(String _ext) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = MoodleConnection.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    private void httpRequest(String _filename, String _textToSend, byte[] _data, Image _image) {
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "***232404jkg4220957934FW**";
        try {
            URLConnection urlConnection = this.moodle_upload_file.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Connection", "Keep-Alive");
            urlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            DataOutputStream dos = new DataOutputStream(urlConnection.getOutputStream());
            dos.writeBytes(String.valueOf(twoHyphens) + boundary + lineEnd);
            dos.writeBytes("Content-Disposition: form-data; name=\"user_file\"; filename=\"" + _filename + "\"" + lineEnd);
            dos.writeBytes(lineEnd);
            if (_textToSend != null) {
                dos.writeBytes(_textToSend);
            }
            if (_data != null) {
                dos.write(_data);
            }
            if (_image != null) {
                BufferedImage bufferedImage = this.toBufferedImage(_image);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "gif", baos);
                baos.flush();
                byte[] resultImageAsRawBytes = baos.toByteArray();
                baos.close();
                dos.write(resultImageAsRawBytes);
            }
            dos.writeBytes(lineEnd);
            dos.writeBytes(String.valueOf(twoHyphens) + boundary + twoHyphens + lineEnd);
            DataInputStream inStream = new DataInputStream(urlConnection.getInputStream());
            inStream.close();
            dos.flush();
            dos.close();
        }
        catch (MalformedURLException ex) {
            System.out.println("CLIENT REQUEST: " + ex);
        }
        catch (IOException ioe) {
            System.out.println("CLIENT REQUEST: " + ioe);
        }
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception _exc) {
        _exc.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), _exc.getLocalizedMessage());
    }

    static /* synthetic */ void access$1(MoodleConnection moodleConnection, int n) {
        moodleConnection.delay(n);
    }

    static /* synthetic */ void access$2(MoodleConnection moodleConnection, String string, String string2, byte[] byArray, Image image) {
        moodleConnection.httpRequest(string, string2, byArray, image);
    }

    static /* synthetic */ void access$3(MoodleConnection moodleConnection, Exception exception) {
        moodleConnection.showException(exception);
    }

    private class LongTask {
        private int lengthOfTask;
        private int current = 0;
        private String statMessage;
        private String filename;
        private String annotation;
        private Image image;
        private String txt;
        private byte[] data;
        private boolean isText;
        private String kindFragment;
        private boolean isOk = false;

        LongTask(String _filename, String _annotation, Image _image) {
            this.kindFragment = "image";
            this.filename = _filename;
            this.annotation = _annotation;
            this.image = _image;
            this.lengthOfTask = 100;
        }

        LongTask(String _filename, String _annotation, String _txt, boolean _isText) {
            this.kindFragment = "text";
            this.filename = _filename;
            this.annotation = _annotation;
            this.txt = _txt;
            this.isText = _isText;
            this.lengthOfTask = 100;
        }

        LongTask(String _filename, String _annotation, byte[] _data) {
            this.kindFragment = "data";
            this.filename = _filename;
            this.annotation = _annotation;
            this.data = _data;
            this.lengthOfTask = 100;
        }

        void go() {
            this.current = 0;
            new SwingWorker(){

                @Override
                public Object construct() {
                    if (LongTask.this.kindFragment.equals("image")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.image);
                    }
                    if (LongTask.this.kindFragment.equals("text")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.txt, LongTask.this.isText);
                    }
                    return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.data);
                }
            };
        }

        int getCurrent() {
            return this.current;
        }

        void stop() {
            this.current = this.lengthOfTask;
        }

        boolean getStatus() {
            return this.isOk;
        }

        boolean done() {
            return this.current >= this.lengthOfTask;
        }

        String getMessage() {
            return this.statMessage;
        }

        static /* synthetic */ void access$0(LongTask longTask, int n) {
            longTask.current = n;
        }

        static /* synthetic */ int access$1(LongTask longTask) {
            return longTask.current;
        }

        static /* synthetic */ void access$2(LongTask longTask, String string) {
            longTask.statMessage = string;
        }

        static /* synthetic */ int access$3(LongTask longTask) {
            return longTask.lengthOfTask;
        }

        static /* synthetic */ void access$4(LongTask longTask, boolean bl) {
            longTask.isOk = bl;
        }

        static /* synthetic */ MoodleConnection access$12(LongTask longTask) {
            return longTask.MoodleConnection.this;
        }

        /*
         * Exception performing whole class analysis.
         */
        class ActualTask {
            final /* synthetic */ LongTask this$1;

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String _filename, String _annotation, Image _image) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        i = 0;
                        while (i < 50) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + 100 + "%.");
                            ++i;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), _filename, null, null, _image);
                        i = 50;
                        while (i < 101) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++i;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), e);
                        i = 50;
                        ** while (i < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, i);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++i;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String _filename, String _annotation, String _txt, boolean _isText) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        i = 0;
                        while (i < 50) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++i;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), _filename, _txt, null, null);
                        i = 50;
                        while (i < 101) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++i;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), e);
                        i = 50;
                        ** while (i < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, i);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++i;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String _filename, String _annotation, byte[] _data) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        i = 0;
                        while (i < 50) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++i;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), _filename, null, _data, null);
                        i = 50;
                        while (i < 101) {
                            LongTask.access$0(var1_1, i);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++i;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), e);
                        i = 50;
                        ** while (i < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, i);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++i;
                        continue;
                    }
                }
            }
        }
    }

    private class ModifiableJOptionPane
    extends JOptionPane {
        private boolean resizable;

        public ModifiableJOptionPane(Object message, int messageType, int optionType, Icon icon) {
            super(message, messageType, optionType, icon);
        }

        @Override
        public JDialog createDialog(Component parentComp, String title) throws HeadlessException {
            JDialog dialog = super.createDialog(parentComp, title);
            dialog.setResizable(this.isResizable());
            return dialog;
        }

        @Override
        public JInternalFrame createInternalFrame(Component parentComp, String title) {
            JInternalFrame frame = super.createInternalFrame(parentComp, title);
            frame.setResizable(this.isResizable());
            return frame;
        }

        public void setResizable(boolean b) {
            this.resizable = b;
        }

        public boolean isResizable() {
            return this.resizable;
        }
    }

    class ProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JLabel msg;
        private JLabel note;

        public ProgressDialog() {
            super(JOptionPane.getFrameForComponent(MoodleConnection.this.getParentComponent()), "Progress");
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.msg = new JLabel("Monitoring the Delivery");
            this.note = new JLabel("Initializing progress...");
            JPanel panel = new JPanel(new GridLayout(3, 0));
            panel.add(this.msg);
            panel.add(this.note);
            panel.add(this.progressBar);
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(panel);
            this.setSize(380, 120);
            this.setLocation(300, 300);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressDialog.this.dispose();
                    MoodleConnection.this.progressMonitor.dispose();
                    MoodleConnection.this.progressMonitor = null;
                }
            });
        }

        public void setProgress(int value) {
            this.progressBar.setValue(value);
        }

        public void setNote(String _note) {
            this.note.setText(_note);
        }

        public void showProgressDialog(boolean _value) {
            this.setVisible(_value);
        }

        public void setBarIndeterminate(boolean _value) {
            this.progressBar.setIndeterminate(_value);
        }

        public void setBarString(String _value) {
            this.progressBar.setString(_value);
        }
    }

    private class ReadPanel
    extends JPanel {
        String filesLabel = "List of files saved with this lab";
        String loadFile = "Moodle - Load from EJSApp File Browser";
        JLabel filesJLabel = new JLabel(this.filesLabel);
        DefaultListModel<String> listModel = new DefaultListModel();
        JList<String> list = new JList<String>(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JPanel topLabelPanel = new JPanel(new GridLayout(0, 1));
            topLabelPanel.add(this.filesJLabel);
            JScrollPane scrollPanel = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPanel, "Center");
            this.add((Component)topLabelPanel, "North");
        }

        String chooseFile(String filesList) {
            String selectedFile = "";
            this.listModel.clear();
            ModifiableJOptionPane myModJOptPane = new ModifiableJOptionPane(this, -1, 2, moodleIcon);
            myModJOptPane.setResizable(true);
            if (filesList != null) {
                String[] filesListArr = filesList.split(";");
                String[] urlListArr = new String[(filesListArr.length + 1) / 2];
                int i = 0;
                while (i <= (filesListArr.length - 1) / 2) {
                    this.listModel.add(i, filesListArr[2 * i]);
                    urlListArr[i] = filesListArr[2 * i + 1];
                    ++i;
                }
                JDialog myDialog = myModJOptPane.createDialog(MoodleConnection.this.getParentComponent(), this.loadFile);
                myDialog.setResizable(true);
                myDialog.setContentPane(myModJOptPane);
                myDialog.setVisible(true);
                Object choice = myModJOptPane.getValue();
                Integer acceptOpt = 0;
                int selectedIndex = this.list.getSelectedIndex();
                if (choice == acceptOpt && selectedIndex >= 0) {
                    selectedFile = urlListArr[selectedIndex];
                }
            } else {
                JDialog myDialog = myModJOptPane.createDialog(MoodleConnection.this.getParentComponent(), this.loadFile);
                myDialog.setResizable(true);
                myDialog.setContentPane(myModJOptPane);
                myDialog.setVisible(true);
            }
            return selectedFile;
        }
    }

    private class SavePanel
    extends JPanel {
        String saveFile = "Moodle - Save to EJSApp File Browser";
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JPanel leftPanel;
        JPanel rightPanel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(15);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(15);
            this.leftPanel = new JPanel(new GridLayout(0, 1));
            this.leftPanel.add(this.nameLabel);
            this.rightPanel = new JPanel(new GridLayout(0, 1));
            this.rightPanel.add(this.nameField);
            this.setLayout(new BorderLayout());
            this.add((Component)this.leftPanel, "West");
            this.add((Component)this.rightPanel, "Center");
        }

        boolean showSaveOptions(String _name, String _ann) {
            if (_name != null) {
                this.nameField.setText(_name);
            }
            if (_ann != null) {
                this.annotationField.setText(_ann);
            }
            ModifiableJOptionPane myModJOptPane = new ModifiableJOptionPane(this, -1, 2, moodleIcon);
            myModJOptPane.setResizable(true);
            JDialog myDialog = myModJOptPane.createDialog(MoodleConnection.this.getParentComponent(), this.saveFile);
            myDialog.setResizable(true);
            myDialog.setContentPane(myModJOptPane);
            myDialog.setVisible(true);
            Object choice = myModJOptPane.getValue();
            Integer acceptOpt = 0;
            return choice == acceptOpt;
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (MoodleConnection.this.task.done()) {
                if (MoodleConnection.this.task.getStatus()) {
                    MoodleConnection.this.progressMonitor.setProgress(100);
                    MoodleConnection.this.progressMonitor.setNote("Completed 100% out of 100%.");
                    MoodleConnection.this.progressMonitor.setBarString("Successful Delivery. Refresh your EJSApp File Browser block");
                } else {
                    MoodleConnection.this.progressMonitor.setBarString("Sending with problems. Try again!!");
                    MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                }
                MoodleConnection.this.task.stop();
                Toolkit.getDefaultToolkit().beep();
                MoodleConnection.this.timer.stop();
            } else {
                int actual = MoodleConnection.this.task.getCurrent();
                if (actual == MoodleConnection.this.previous) {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(true);
                    MoodleConnection.this.progressMonitor.setBarString("Sending file... Please wait");
                } else {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(false);
                    MoodleConnection.this.progressMonitor.setBarString("Progress");
                }
                MoodleConnection.this.previous = actual;
                MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                MoodleConnection.this.progressMonitor.setProgress(actual);
            }
        }
    }
}

