/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.colos.ejs.library.DelayedAction;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.MultipleView;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;

public abstract class Animation
implements Runnable {
    private static final ThreadGroup sEJSThreadGroup = new ThreadGroup("EJS thread group");
    public static int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    public static final int MINIMUM_DELAY = 10;
    private volatile Thread animationThread = null;
    private volatile boolean mustUpdateWhenIdle = false;
    private List<DelayedAction> methodList = new ArrayList<DelayedAction>();
    private Set<String> variablesToApply = new HashSet<String>();
    private volatile boolean invokingDelayedActions = false;
    private boolean autoplay = false;
    protected volatile boolean isPlaying = false;
    protected boolean abortSPDLoop = false;
    protected boolean updateView = true;
    private int stepsPerDisplay = 1;
    private long delay = 10L;
    protected String resetFile = null;
    protected boolean hasEnded = false;
    protected Model model = null;
    protected View view = null;
    protected Animation master = null;
    protected ArrayList<Model> slaveList = new ArrayList();
    private double initialRealTime = Double.NaN;

    public static ThreadGroup getThreadGroup() {
        return sEJSThreadGroup;
    }

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model _aModel) {
        this.model = _aModel;
        LauncherApplet applet = this.model._getApplet();
        if (applet != null) {
            String initFile = applet.getParameter("initialStateFromURL");
            if (initFile != null) {
                this.resetFile = initFile.trim();
                if (!this.resetFile.startsWith("http://")) {
                    if (this.resetFile.startsWith("./")) {
                        this.resetFile = this.resetFile.substring(2);
                    }
                    this.resetFile = applet.getCodeBase() + this.resetFile;
                }
                this.resetFile = "url:" + this.resetFile;
            } else {
                initFile = applet.getParameter("initialState");
                if (initFile != null) {
                    this.resetFile = initFile.trim();
                }
            }
        }
    }

    public final View getView() {
        if (this.view instanceof MultipleView) {
            return ((MultipleView)this.view).getFirstView();
        }
        return this.view;
    }

    public final void setView(View _aView) {
        this.view = _aView;
    }

    public final void setFPS(int _fps) {
        this.delay = _fps <= 1 ? 1000L : (_fps >= MAXIMUM_FPS ? 10L : Math.max((long)(1000.0 / (double)_fps), 10L));
    }

    public final void setDelay(int _aDelay) {
        this.delay = Math.max((long)_aDelay, 0L);
    }

    public final int getDelay() {
        return (int)this.delay;
    }

    public final void setStepsPerDisplay(int _steps) {
        if (_steps >= 1) {
            this.stepsPerDisplay = _steps;
        }
    }

    public final void setUpdateView(boolean _update) {
        this.updateView = _update;
    }

    public final void setAutoplay(boolean _play) {
        this.autoplay = _play;
    }

    public final boolean isPlaying() {
        return this.isPlaying && this.animationThread != null;
    }

    public final boolean isPaused() {
        return !this.isPlaying();
    }

    public void resetRealTime() {
        this.initialRealTime = 1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis();
    }

    public synchronized void play() {
        if (this.master != null) {
            this.getTopMaster().play();
            return;
        }
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = this.model._isApplet() ? new Thread(this) : new Thread(sEJSThreadGroup, this);
        this.animationThread.setPriority(1);
        this.animationThread.setDaemon(true);
        this.initialRealTime = 1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis();
        this.animationThread.start();
        this.isPlaying = true;
        for (Model slave : this.slaveList) {
            slave._getSimulation().isPlaying = true;
        }
    }

    public synchronized void pause() {
        if (this.master != null) {
            this.getTopMaster().pause();
            return;
        }
        if (this.animationThread == null) {
            return;
        }
        Thread tempThread = this.animationThread;
        this.animationThread = null;
        this.isPlaying = false;
        this.abortSPDLoop = true;
        for (Model slave : this.slaveList) {
            slave._getSimulation().isPlaying = false;
            slave._getSimulation().abortSPDLoop = true;
        }
        if (Thread.currentThread() == tempThread) {
            return;
        }
        try {
            tempThread.interrupt();
            tempThread.join(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.animationThread == Thread.currentThread()) {
            long currentTime = System.currentTimeMillis();
            this.step();
            for (Model slave : this.slaveList) {
                slave._getSimulation().step();
            }
            if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
                this.model._automaticResetSolvers();
                this.update();
            } else if (this.mustUpdateWhenIdle) {
                this.update();
            }
            long sleepTime = Double.isNaN(this.initialRealTime) ? this.delay - (System.currentTimeMillis() - currentTime) : (long)(1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis() - this.initialRealTime);
            if (sleepTime < 10L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
            this.model._automaticResetSolvers();
            this.update();
        } else if (this.mustUpdateWhenIdle) {
            this.update();
        }
    }

    public void onExit() {
        this.animationThread = null;
        this.isPlaying = false;
        this.abortSPDLoop = true;
        this.checkMethodsInvokedByView();
        for (ControlElement element : this.view.getElements()) {
            if (!(element instanceof ControlWindow)) continue;
            ControlWindow.removeFromWindowList((ControlWindow)element);
        }
        if (this.model._isApplet()) {
            this.view.onExit();
            this.model._freeMemory();
        } else {
            Thread onExitThread = new Thread(sEJSThreadGroup, new Runnable(){

                @Override
                public void run() {
                    Animation.this.view.onExit();
                    Animation.this.model._freeMemory();
                }
            });
            onExitThread.setPriority(5);
            onExitThread.setDaemon(true);
            onExitThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract void userDefinedReset();

    protected abstract void userDefinedViewUpdate();

    protected abstract void resetDescriptionPages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.resetDescriptionPages();
        this.pause();
        if (this.model != null) {
            this.model._resetModel();
        }
        if (this.view != null) {
            this.view.setUpdateSimulation(false);
            this.view.reset();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model._initializeModel();
            this.model._updateModel();
            this.userDefinedReset();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.view.finalUpdate();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
            this.view.setUpdateSimulation(true);
        }
        System.gc();
        ArrayList<Model> arrayList = this.slaveList;
        synchronized (arrayList) {
            this.killAllSimulations();
        }
        if (this.autoplay) {
            this.play();
        }
    }

    public void initialize() {
        if (this.view != null) {
            this.view.read();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model._initializeModel();
            this.model._updateModel();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.view.finalUpdate();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
        }
    }

    public void apply() {
        this.view.read();
        this.update();
    }

    public final void applyAll() {
        this.view.read();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String _variable) {
        if (this.invokingDelayedActions || this.isPaused()) {
            this.view.read(_variable);
            this.model._automaticResetSolvers();
        } else {
            this.view.blockVariable(_variable);
            Set<String> set = this.variablesToApply;
            synchronized (set) {
                this.variablesToApply.add(_variable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyVariablesWhenIdle() {
        HashSet<String> copyList;
        Set<String> set = this.variablesToApply;
        synchronized (set) {
            block5: {
                if (!this.variablesToApply.isEmpty()) break block5;
                return false;
            }
            copyList = new HashSet<String>(this.variablesToApply);
            this.variablesToApply.clear();
        }
        this.invokingDelayedActions = true;
        for (String variable : copyList) {
            this.view.read(variable);
        }
        this.invokingDelayedActions = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMethodsInvokedByView() {
        ArrayList<DelayedAction> copyList;
        List<DelayedAction> list = this.methodList;
        synchronized (list) {
            block5: {
                if (!this.methodList.isEmpty()) break block5;
                return false;
            }
            copyList = new ArrayList<DelayedAction>(this.methodList);
            this.methodList.clear();
        }
        this.invokingDelayedActions = true;
        for (DelayedAction action : copyList) {
            action.performAction();
        }
        this.invokingDelayedActions = false;
        return true;
    }

    public void update() {
        if (this.model != null) {
            this.model._updateModel();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
        this.mustUpdateWhenIdle = false;
        if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
            this.model._automaticResetSolvers();
            if (this.model != null) {
                this.model._updateModel();
            }
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
        if (this.updateView) {
            this.view.finalUpdate();
        }
    }

    public boolean hasEnded() {
        return this.hasEnded;
    }

    public void setEnded() {
        this.hasEnded = true;
    }

    public final void updateWhenIdle() {
        if (this.invokingDelayedActions || this.isPaused()) {
            this.update();
        } else {
            this.mustUpdateWhenIdle = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeMethodWhenIdle(DelayedAction _action) {
        if (this.invokingDelayedActions || this.isPaused()) {
            _action.performAction();
            this.model._automaticResetSolvers();
        } else {
            List<DelayedAction> list = this.methodList;
            synchronized (list) {
                this.methodList.add(_action);
            }
        }
    }

    public void step() {
        this.abortSPDLoop = false;
        if (this.stepsPerDisplay > 1) {
            int i = 1;
            while (i < this.stepsPerDisplay) {
                if (this.abortSPDLoop) {
                    this.update();
                    if (this.updateView) {
                        this.userDefinedViewUpdate();
                    }
                    return;
                }
                this.model._stepModel();
                this.model._updateModel();
                this.view.collectData();
                ++i;
            }
        }
        this.model._stepModel();
        this.update();
        if (this.updateView) {
            this.userDefinedViewUpdate();
        }
    }

    public void updateAfterModelAction() {
        if (this.master != null) {
            this.getTopMaster().updateAfterModelAction();
            return;
        }
        this.update();
        for (Model slave : this.slaveList) {
            slave._getSimulation().update();
        }
    }

    public final Model runSimulation() {
        return this.runSimulation(null);
    }

    public final Model runSimulation(String _classname) {
        try {
            Animation top;
            Class<?> theClass = _classname == null ? this.getModel().getClass() : Class.forName(_classname);
            Model simModel = (Model)theClass.newInstance();
            simModel._getSimulation().master = top = this.getTopMaster();
            simModel._getSimulation().isPlaying = this.isPlaying;
            simModel._getSimulation().update();
            top.slaveList.add(simModel);
            return simModel;
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            return null;
        }
    }

    public final void freeSimulation(Model _simulationModel) {
        if (_simulationModel == null) {
            return;
        }
        try {
            Animation top = this.getTopMaster();
            top.slaveList.remove(_simulationModel);
            _simulationModel._getSimulation().master = null;
            if (_simulationModel._getView() instanceof EjsControl) {
                ((EjsControl)((Object)_simulationModel._getView())).undoReparenting();
            }
            if (top.isPlaying) {
                _simulationModel._getSimulation().play();
            } else {
                _simulationModel._getSimulation().isPlaying = false;
            }
            _simulationModel._getSimulation().update();
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
        }
    }

    public final void killSimulation(Model _simulationModel) {
        if (_simulationModel == null) {
            return;
        }
        this.freeSimulation(_simulationModel);
        _simulationModel._getSimulation().pause();
        if (_simulationModel._getView() instanceof EjsControl) {
            ((EjsControl)((Object)_simulationModel._getView())).dispose();
        }
    }

    public final synchronized void killAllSimulations() {
        ArrayList<Model> list = this.slaveList;
        this.slaveList = new ArrayList();
        for (Model simModel : list) {
            simModel._getSimulation().pause();
            simModel._getSimulation().master = null;
            if (!(simModel._getView() instanceof EjsControl)) continue;
            ((EjsControl)((Object)simModel._getView())).undoReparenting();
            ((EjsControl)((Object)simModel._getView())).dispose();
        }
    }

    public final Model getTopSimulation() {
        return this.getTopMaster().getModel();
    }

    private final Animation getTopMaster() {
        if (this.master == null) {
            return this;
        }
        Animation topMaster = this.master;
        while (topMaster.master != null) {
            topMaster = topMaster.master;
        }
        return topMaster;
    }
}

