/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.wavepacket;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlPoligon;
import org.colos.ejs.library.control.displayejs.ControlText;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.waves.wavepacket.wavepacket;
import users.ehu.jma.waves.wavepacket.wavepacketSimulation;

class wavepacketView
extends EjsControl
implements View {
    private wavepacketSimulation _simulation = null;
    private wavepacket _model = null;
    public Component Main;
    public PlottingPanel2D Plot;
    public InteractiveText timeLabel;
    public InteractivePoligon Wave;
    public JPanel Bottom;
    public JPanel Controls;
    public JTextField kMin;
    public JTextField kMax;
    public JTextField numHarmonics;
    public JTextField aValue;
    public JTextField bValue;
    public JTextField Amplitude;
    public JTextField tMin;
    public JTextField tMax;
    public JTextField dT;
    public JTextField xMin;
    public JTextField xMax;
    public JTextField numPoints;
    public JCheckBox Repeat;
    public JCheckBox ShowTime;
    public JButton startButton;
    public JButton stepButton;
    public JButton initButton;
    public JButton resetButton;

    public wavepacketView(wavepacketSimulation wavepacketSimulation2, String string, Frame frame) {
        super(wavepacketSimulation2, string, frame);
        this._simulation = wavepacketSimulation2;
        this._model = (wavepacket)wavepacketSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("nMaxPoints", "apply(\"nMaxPoints\")");
        this.addListener("nPoints", "apply(\"nPoints\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("k1", "apply(\"k1\")");
        this.addListener("k2", "apply(\"k2\")");
        this.addListener("nHarmonics", "apply(\"nHarmonics\")");
        this.addListener("a", "apply(\"a\")");
        this.addListener("b", "apply(\"b\")");
        this.addListener("A", "apply(\"A\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("tmin", "apply(\"tmin\")");
        this.addListener("tmax", "apply(\"tmax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("time", "apply(\"time\")");
        this.addListener("playImage", "apply(\"playImage\")");
        this.addListener("pauseImage", "apply(\"pauseImage\")");
        this.addListener("startImage", "apply(\"startImage\")");
        this.addListener("repeat", "apply(\"repeat\")");
        this.addListener("showTime", "apply(\"showTime\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("nMaxPoints".equals(string)) {
            this._model.nMaxPoints = this.getInt("nMaxPoints");
        }
        if ("nPoints".equals(string)) {
            this._model.nPoints = this.getInt("nPoints");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            dArray = (double[])this.getValue("x").getObject();
            n2 = dArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = dArray[n];
            }
        }
        if ("y".equals(string)) {
            dArray = (double[])this.getValue("y").getObject();
            n2 = dArray.length;
            if (n2 > this._model.y.length) {
                n2 = this._model.y.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y[n] = dArray[n];
            }
        }
        if ("k1".equals(string)) {
            this._model.k1 = this.getDouble("k1");
        }
        if ("k2".equals(string)) {
            this._model.k2 = this.getDouble("k2");
        }
        if ("nHarmonics".equals(string)) {
            this._model.nHarmonics = this.getInt("nHarmonics");
        }
        if ("a".equals(string)) {
            this._model.a = this.getDouble("a");
        }
        if ("b".equals(string)) {
            this._model.b = this.getDouble("b");
        }
        if ("A".equals(string)) {
            this._model.A = this.getDouble("A");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("tmin".equals(string)) {
            this._model.tmin = this.getDouble("tmin");
        }
        if ("tmax".equals(string)) {
            this._model.tmax = this.getDouble("tmax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("time".equals(string)) {
            this._model.time = this.getString("time");
        }
        if ("playImage".equals(string)) {
            this._model.playImage = this.getString("playImage");
        }
        if ("pauseImage".equals(string)) {
            this._model.pauseImage = this.getString("pauseImage");
        }
        if ("startImage".equals(string)) {
            this._model.startImage = this.getString("startImage");
        }
        if ("repeat".equals(string)) {
            this._model.repeat = this.getBoolean("repeat");
        }
        if ("showTime".equals(string)) {
            this._model.showTime = this.getBoolean("showTime");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("nMaxPoints", this._model.nMaxPoints);
        this.setValue("nPoints", this._model.nPoints);
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("k1", this._model.k1);
        this.setValue("k2", this._model.k2);
        this.setValue("nHarmonics", this._model.nHarmonics);
        this.setValue("a", this._model.a);
        this.setValue("b", this._model.b);
        this.setValue("A", this._model.A);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("tmin", this._model.tmin);
        this.setValue("tmax", this._model.tmax);
        this.setValue("dt", this._model.dt);
        this.setValue("ymax", this._model.ymax);
        this.setValue("time", this._model.time);
        this.setValue("playImage", this._model.playImage);
        this.setValue("pauseImage", this._model.pauseImage);
        this.setValue("startImage", this._model.startImage);
        this.setValue("repeat", this._model.repeat);
        this.setValue("showTime", this._model.showTime);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Wave packet")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.Main.size", "1054,345")).getObject();
        this.Plot = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Plot").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Plot_minimumY()%").setProperty("maximumY", "%_model._method_for_Plot_maximumY()%").setProperty("title", this._simulation.translateString("View.Plot.title", "Wave packet")).setProperty("titleX", this._simulation.translateString("View.Plot.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.Plot.titleY", "u(t,x)")).getObject();
        this.timeLabel = (InteractiveText)this.addElement(new ControlText(), "timeLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Plot").setProperty("x", "xmax").setProperty("y", "%_model._method_for_timeLabel_y()%").setProperty("visible", "showTime").setProperty("enabled", "true").setProperty("text", this._simulation.translateString("View.timeLabel.text", "%time%")).setProperty("elementposition", "SOUTH_EAST").setProperty("color", "blue").getObject();
        this.Wave = (InteractivePoligon)this.addElement(new ControlPoligon(), "Wave").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Plot").setProperty("maxpoints", "nPoints").setProperty("x", "x").setProperty("y", "y").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red").getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "grid:2,9,0,0").getObject();
        this.kMin = (JTextField)this.addElement(new ControlNumberField(), "kMin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "k1").setProperty("format", this._simulation.translateString("View.kMin.format", "k1 = 0.###")).setProperty("action", "_model._method_for_kMin_action()").setProperty("tooltip", this._simulation.translateString("View.kMin.tooltip", "Minimum wave number")).getObject();
        this.kMax = (JTextField)this.addElement(new ControlNumberField(), "kMax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "k2").setProperty("format", this._simulation.translateString("View.kMax.format", "k2 = 0.###")).setProperty("action", "_model._method_for_kMax_action()").setProperty("tooltip", this._simulation.translateString("View.kMax.tooltip", "Maximum wave number")).getObject();
        this.numHarmonics = (JTextField)this.addElement(new ControlNumberField(), "numHarmonics").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "nHarmonics").setProperty("format", this._simulation.translateString("View.numHarmonics.format", "N = 0")).setProperty("action", "_model._method_for_numHarmonics_action()").setProperty("tooltip", this._simulation.translateString("View.numHarmonics.tooltip", "Number of harmonic waves")).getObject();
        this.aValue = (JTextField)this.addElement(new ControlNumberField(), "aValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "a").setProperty("format", this._simulation.translateString("View.aValue.format", "a = 0.###")).setProperty("action", "_model._method_for_aValue_action()").setProperty("tooltip", this._simulation.translateString("View.aValue.tooltip", "a coefficient in the dispersion relation omega = a k^b")).getObject();
        this.bValue = (JTextField)this.addElement(new ControlNumberField(), "bValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "b").setProperty("format", this._simulation.translateString("View.bValue.format", "b = 0.###")).setProperty("action", "_model._method_for_bValue_action()").setProperty("tooltip", this._simulation.translateString("View.bValue.tooltip", "b exponent in the dispersion relation omega = a k^b")).getObject();
        this.Amplitude = (JTextField)this.addElement(new ControlNumberField(), "Amplitude").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "A").setProperty("format", this._simulation.translateString("View.Amplitude.format", "A = 0.###")).setProperty("action", "_model._method_for_Amplitude_action()").setProperty("tooltip", this._simulation.translateString("View.Amplitude.tooltip", "Amplitude")).getObject();
        this.tMin = (JTextField)this.addElement(new ControlNumberField(), "tMin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "tmin").setProperty("format", this._simulation.translateString("View.tMin.format", "t1 = 0.###")).setProperty("action", "_model._method_for_tMin_action()").setProperty("tooltip", this._simulation.translateString("View.tMin.tooltip", "Initial time")).getObject();
        this.tMax = (JTextField)this.addElement(new ControlNumberField(), "tMax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "tmax").setProperty("format", this._simulation.translateString("View.tMax.format", "t2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.tMax.tooltip", "Last time")).getObject();
        this.dT = (JTextField)this.addElement(new ControlNumberField(), "dT").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dT.format", "$\\Delta$t = 0.#######")).setProperty("tooltip", this._simulation.translateString("View.dT.tooltip", "Animation step")).getObject();
        this.xMin = (JTextField)this.addElement(new ControlNumberField(), "xMin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "xmin").setProperty("format", this._simulation.translateString("View.xMin.format", "x1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMin.tooltip", "Minimum x")).getObject();
        this.xMax = (JTextField)this.addElement(new ControlNumberField(), "xMax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "xmax").setProperty("format", this._simulation.translateString("View.xMax.format", "x2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMax.tooltip", "Maximum x")).getObject();
        this.numPoints = (JTextField)this.addElement(new ControlNumberField(), "numPoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "nPoints").setProperty("format", this._simulation.translateString("View.numPoints.format", "0 points")).setProperty("tooltip", this._simulation.translateString("View.numPoints.tooltip", "Number of points")).getObject();
        this.Repeat = (JCheckBox)this.addElement(new ControlCheckBox(), "Repeat").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("variable", "repeat").setProperty("text", this._simulation.translateString("View.Repeat.text", "Repeat")).setProperty("mnemonic", this._simulation.translateString("View.Repeat.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.Repeat.tooltip", "Start again when t2 is reached?")).getObject();
        this.ShowTime = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowTime").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "showTime").setProperty("text", this._simulation.translateString("View.ShowTime.text", "Time")).setProperty("mnemonic", this._simulation.translateString("View.ShowTime.mnemonic", "d")).setProperty("tooltip", this._simulation.translateString("View.ShowTime.tooltip", "Show time values?")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.initButton = (JButton)this.addElement(new ControlButton(), "initButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("mnemonic", this._simulation.translateString("View.initButton.mnemonic", "i")).setProperty("action", "_model._method_for_initButton_action()").setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Wave packet")).setProperty("visible", "true");
        this.getElement("Plot").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Plot.title", "Wave packet")).setProperty("titleY", this._simulation.translateString("View.Plot.titleY", "u(t,x)"));
        this.getElement("timeLabel").setProperty("enabled", "true").setProperty("elementposition", "SOUTH_EAST").setProperty("color", "blue");
        this.getElement("Wave").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red");
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("kMin").setProperty("format", this._simulation.translateString("View.kMin.format", "k1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.kMin.tooltip", "Minimum wave number"));
        this.getElement("kMax").setProperty("format", this._simulation.translateString("View.kMax.format", "k2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.kMax.tooltip", "Maximum wave number"));
        this.getElement("numHarmonics").setProperty("format", this._simulation.translateString("View.numHarmonics.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.numHarmonics.tooltip", "Number of harmonic waves"));
        this.getElement("aValue").setProperty("format", this._simulation.translateString("View.aValue.format", "a = 0.###")).setProperty("tooltip", this._simulation.translateString("View.aValue.tooltip", "a coefficient in the dispersion relation omega = a k^b"));
        this.getElement("bValue").setProperty("format", this._simulation.translateString("View.bValue.format", "b = 0.###")).setProperty("tooltip", this._simulation.translateString("View.bValue.tooltip", "b exponent in the dispersion relation omega = a k^b"));
        this.getElement("Amplitude").setProperty("format", this._simulation.translateString("View.Amplitude.format", "A = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Amplitude.tooltip", "Amplitude"));
        this.getElement("tMin").setProperty("format", this._simulation.translateString("View.tMin.format", "t1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.tMin.tooltip", "Initial time"));
        this.getElement("tMax").setProperty("format", this._simulation.translateString("View.tMax.format", "t2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.tMax.tooltip", "Last time"));
        this.getElement("dT").setProperty("format", this._simulation.translateString("View.dT.format", "$\\Delta$t = 0.#######")).setProperty("tooltip", this._simulation.translateString("View.dT.tooltip", "Animation step"));
        this.getElement("xMin").setProperty("format", this._simulation.translateString("View.xMin.format", "x1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMin.tooltip", "Minimum x"));
        this.getElement("xMax").setProperty("format", this._simulation.translateString("View.xMax.format", "x2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMax.tooltip", "Maximum x"));
        this.getElement("numPoints").setProperty("format", this._simulation.translateString("View.numPoints.format", "0 points")).setProperty("tooltip", this._simulation.translateString("View.numPoints.tooltip", "Number of points"));
        this.getElement("Repeat").setProperty("text", this._simulation.translateString("View.Repeat.text", "Repeat")).setProperty("mnemonic", this._simulation.translateString("View.Repeat.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.Repeat.tooltip", "Start again when t2 is reached?"));
        this.getElement("ShowTime").setProperty("text", this._simulation.translateString("View.ShowTime.text", "Time")).setProperty("mnemonic", this._simulation.translateString("View.ShowTime.mnemonic", "d")).setProperty("tooltip", this._simulation.translateString("View.ShowTime.tooltip", "Show time values?"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("initButton").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("mnemonic", this._simulation.translateString("View.initButton.mnemonic", "i")).setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

