/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.wavepacket;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.wavepacket.wavepacketSimulation;
import users.ehu.jma.waves.wavepacket.wavepacketView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class wavepacket
extends AbstractModel {
    public wavepacketSimulation _simulation = null;
    public wavepacketView _view = null;
    public wavepacket _model = this;
    public int nMaxPoints = 2000;
    public int nPoints = 1000;
    public double t = 0.0;
    public double[] x;
    public double[] y;
    public double k1 = 5.0;
    public double k2 = 10.0;
    public int nHarmonics = 100;
    public double a = 1.0;
    public double b = 1.0;
    public double A = 1.0;
    public double xmin = -5.0;
    public double xmax = 50.0;
    public double tmin = 0.0;
    public double tmax = 50.0;
    public double dt = 0.1;
    public double ymax = 0.0;
    public String time = "time";
    public String playImage = "images/play.gif";
    public String pauseImage = "images/pause.gif";
    public String startImage = "images/play.gif";
    public boolean repeat = true;
    public boolean showTime = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/wavepacket.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        wavepacket wavepacket2 = new wavepacket(stringArray);
    }

    public wavepacket() {
        this(null, null, null, null, null, false);
    }

    public wavepacket(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public wavepacket(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new wavepacketSimulation(this, string, frame, uRL, bl);
        this._view = (wavepacketView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = this.tmin;
    }

    public void _evolution1() {
        if (this.t + 1.0E-5 >= this.tmax) {
            if (this.repeat) {
                this.t = this.tmin;
            } else {
                this._pause();
            }
        } else {
            this.t += this.dt;
        }
    }

    public void _constraints1() {
        if (this.nPoints > this.nMaxPoints) {
            this.nPoints = this.nMaxPoints;
        } else if (this.nPoints < 2) {
            this.nPoints = 2;
        }
        if (this.nHarmonics < 2) {
            this.nHarmonics = 2;
        }
    }

    public void _constraints2() {
        double d = (this.xmax - this.xmin) / (double)(this.nPoints - 1);
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = this.xmin + d * (double)i;
        }
    }

    public void _constraints3() {
        double d = (this.k2 - this.k1) / (double)(this.nHarmonics - 1);
        for (int i = 0; i < this.nPoints; ++i) {
            double d2 = this.x[i];
            double d3 = 0.0;
            for (int j = 0; j < this.nHarmonics; ++j) {
                double d4 = this.k1 + d * (double)j;
                d3 += Math.cos(d4 * d2 - this.a * Math.pow(d4, this.b) * this.t);
            }
            this.y[i] = this.A * d3 / (double)this.nHarmonics;
        }
    }

    public void _constraints4() {
        this.ymax = this.A;
        this.time = this._format(this.t, "t = 0.00");
    }

    public void startstop() {
        if (this._isPlaying()) {
            this.startImage = this.playImage;
            this._pause();
        } else {
            this.startImage = this.pauseImage;
            this._play();
        }
    }

    public double _method_for_Plot_minimumY() {
        return -this.ymax;
    }

    public double _method_for_Plot_maximumY() {
        return this.ymax + 0.001;
    }

    public double _method_for_timeLabel_y() {
        return -this.ymax;
    }

    public void _method_for_kMin_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_kMax_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_numHarmonics_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_aValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_bValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Amplitude_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_tMin_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_initButton_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.nMaxPoints = 2000;
        this.nPoints = 1000;
        this.t = 0.0;
        this.x = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y[n] = 0.0;
        }
        this.k1 = 5.0;
        this.k2 = 10.0;
        this.nHarmonics = 100;
        this.a = 1.0;
        this.b = 1.0;
        this.A = 1.0;
        this.xmin = -5.0;
        this.xmax = 50.0;
        this.tmin = 0.0;
        this.tmax = 50.0;
        this.dt = 0.1;
        this.ymax = 0.0;
        this.time = "time";
        this.playImage = "images/play.gif";
        this.pauseImage = "images/pause.gif";
        this.startImage = "images/play.gif";
        this.repeat = true;
        this.showTime = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        System.gc();
    }
}

