/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.waveguide;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.drawables.ControlZInterpolatedPlot;
import org.colos.ejs.library.control.drawables.Plot2DWrapper;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.waves.waveguide.waveguide;
import users.ehu.jma.waves.waveguide.waveguideSimulation;

class waveguideView
extends EjsControl
implements View {
    private waveguideSimulation _simulation = null;
    private waveguide _model = null;
    public Component Main;
    public JPanel Controls;
    public JPanel Modes;
    public JSlider Mode;
    public JPanel Parameters;
    public JTextField vvalue;
    public JTextField step;
    public JCheckBox showZero;
    public JCheckBox showNodes;
    public JLabel BelowLabel;
    public JRadioButton ShowWave;
    public JRadioButton ShowIntensity;
    public JRadioButton ShowAverage;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JPanel Display;
    public JSlider Xrange;
    public JPanel Guides;
    public DrawingPanel2D Amplitudes;
    public InteractiveArrow zero0;
    public InteractiveArrow zero1;
    public InteractiveArrow zero2;
    public InteractiveArrow zero3;
    public InteractiveArrow zero4;
    public InteractiveArrow zero5;
    public InteractiveArrow zero6;
    public InteractiveArrow zero7;
    public InteractiveArrow zero8;
    public InteractiveArrow node1;
    public InteractiveArrow node2;
    public InteractiveArrow node3;
    public InteractiveArrow node4;
    public InteractivePoligon amp0;
    public InteractivePoligon amp1;
    public InteractivePoligon amp2;
    public InteractivePoligon amp3;
    public InteractivePoligon amp4;
    public InteractivePoligon amp5;
    public InteractivePoligon amp6;
    public InteractivePoligon amp7;
    public InteractivePoligon amp8;
    public InteractiveArrow upperWall1;
    public InteractiveArrow lowerWall1;
    public DrawingPanel2D Values;
    public Plot2DWrapper Colors;
    public InteractiveArrow node1b;
    public InteractiveArrow node2b;
    public InteractiveArrow node3b;
    public InteractiveArrow node4b;
    public InteractiveArrow upperWall2;
    public InteractiveArrow lowerWall2;

    public waveguideView(waveguideSimulation waveguideSimulation2, String string, Frame frame) {
        super(waveguideSimulation2, string, frame);
        this._simulation = waveguideSimulation2;
        this._model = (waveguide)waveguideSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("A", "apply(\"A\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("n", "apply(\"n\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("nLines", "apply(\"nLines\")");
        this.addListener("showZero", "apply(\"showZero\")");
        this.addListener("showNodes", "apply(\"showNodes\")");
        this.addListener("nx", "apply(\"nx\")");
        this.addListener("ny", "apply(\"ny\")");
        this.addListener("space", "apply(\"space\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("playImage", "apply(\"playImage\")");
        this.addListener("pauseImage", "apply(\"pauseImage\")");
        this.addListener("startImage", "apply(\"startImage\")");
        this.addListener("Imin", "apply(\"Imin\")");
        this.addListener("Imax", "apply(\"Imax\")");
        this.addListener("wave", "apply(\"wave\")");
        this.addListener("intensity", "apply(\"intensity\")");
        this.addListener("average", "apply(\"average\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("A".equals(string)) {
            this._model.A = this.getDouble("A");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("nLines".equals(string)) {
            this._model.nLines = this.getInt("nLines");
        }
        if ("showZero".equals(string)) {
            this._model.showZero = this.getBoolean("showZero");
        }
        if ("showNodes".equals(string)) {
            this._model.showNodes = this.getBoolean("showNodes");
        }
        if ("nx".equals(string)) {
            this._model.nx = this.getInt("nx");
        }
        if ("ny".equals(string)) {
            this._model.ny = this.getInt("ny");
        }
        if ("space".equals(string)) {
            double[][] dArray = (double[][])this.getValue("space").getObject();
            int n = dArray.length;
            if (n > this._model.space.length) {
                n = this._model.space.length;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = dArray[i].length;
                if (n2 > this._model.space[i].length) {
                    n2 = this._model.space[i].length;
                }
                for (int j = 0; j < n2; ++j) {
                    this._model.space[i][j] = dArray[i][j];
                }
            }
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("playImage".equals(string)) {
            this._model.playImage = this.getString("playImage");
        }
        if ("pauseImage".equals(string)) {
            this._model.pauseImage = this.getString("pauseImage");
        }
        if ("startImage".equals(string)) {
            this._model.startImage = this.getString("startImage");
        }
        if ("Imin".equals(string)) {
            this._model.Imin = this.getDouble("Imin");
        }
        if ("Imax".equals(string)) {
            this._model.Imax = this.getDouble("Imax");
        }
        if ("wave".equals(string)) {
            this._model.wave = this.getBoolean("wave");
        }
        if ("intensity".equals(string)) {
            this._model.intensity = this.getBoolean("intensity");
        }
        if ("average".equals(string)) {
            this._model.average = this.getBoolean("average");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("A", this._model.A);
        this.setValue("k", this._model.k);
        this.setValue("omega", this._model.omega);
        this.setValue("t", this._model.t);
        this.setValue("n", this._model.n);
        this.setValue("v", this._model.v);
        this.setValue("nLines", this._model.nLines);
        this.setValue("showZero", this._model.showZero);
        this.setValue("showNodes", this._model.showNodes);
        this.setValue("nx", this._model.nx);
        this.setValue("ny", this._model.ny);
        this.setValue("space", this._model.space);
        this.setValue("dt", this._model.dt);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("playImage", this._model.playImage);
        this.setValue("pauseImage", this._model.pauseImage);
        this.setValue("startImage", this._model.startImage);
        this.setValue("Imin", this._model.Imin);
        this.setValue("Imax", this._model.Imax);
        this.setValue("wave", this._model.wave);
        this.setValue("intensity", this._model.intensity);
        this.setValue("average", this._model.average);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Waveguide")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "640,480")).getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Modes = (JPanel)this.addElement(new ControlPanel(), "Modes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "border").getObject();
        this.Mode = (JSlider)this.addElement(new ControlSlider(), "Mode").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Modes").setProperty("variable", "n").setProperty("minimum", "1").setProperty("maximum", "5").setProperty("format", this._simulation.translateString("View.Mode.format", "Mode '#'0")).setProperty("orientation", "VERTICAL").setProperty("ticks", "5").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Mode.tooltip", "Mode")).getObject();
        this.Parameters = (JPanel)this.addElement(new ControlPanel(), "Parameters").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Controls").setProperty("layout", "grid:11,1,0,0").getObject();
        this.vvalue = (JTextField)this.addElement(new ControlNumberField(), "vvalue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "v").setProperty("format", this._simulation.translateString("View.vvalue.format", "v = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vvalue.tooltip", "Horizontal phase velocity")).getObject();
        this.step = (JTextField)this.addElement(new ControlNumberField(), "step").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.step.format", "$\\Delta$t = 0.######")).setProperty("tooltip", this._simulation.translateString("View.step.tooltip", "Animation step")).getObject();
        this.showZero = (JCheckBox)this.addElement(new ControlCheckBox(), "showZero").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "showZero").setProperty("text", this._simulation.translateString("View.showZero.text", "0")).setProperty("mnemonic", this._simulation.translateString("View.showZero.mnemonic", "0")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.showZero.tooltip", "Show 0 values?")).getObject();
        this.showNodes = (JCheckBox)this.addElement(new ControlCheckBox(), "showNodes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "showNodes").setProperty("text", this._simulation.translateString("View.showNodes.text", "Nodes")).setProperty("mnemonic", this._simulation.translateString("View.showNodes.mnemonic", "n")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.showNodes.tooltip", "Show nodes?")).getObject();
        this.BelowLabel = (JLabel)this.addElement(new ControlLabel(), "BelowLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("text", this._simulation.translateString("View.BelowLabel.text", "Below:")).setProperty("tooltip", this._simulation.translateString("View.BelowLabel.tooltip", "Choose below the contour-plot meaning")).getObject();
        this.ShowWave = (JRadioButton)this.addElement(new ControlRadioButton(), "ShowWave").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "wave").setProperty("text", this._simulation.translateString("View.ShowWave.text", "u(t,x)")).setProperty("mnemonic", this._simulation.translateString("View.ShowWave.mnemonic", "u")).setProperty("tooltip", this._simulation.translateString("View.ShowWave.tooltip", "Show wave values")).getObject();
        this.ShowIntensity = (JRadioButton)this.addElement(new ControlRadioButton(), "ShowIntensity").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "intensity").setProperty("text", this._simulation.translateString("View.ShowIntensity.text", "I(t,x)")).setProperty("mnemonic", this._simulation.translateString("View.ShowIntensity.mnemonic", "i")).setProperty("tooltip", this._simulation.translateString("View.ShowIntensity.tooltip", "Show instantaneous intensity")).getObject();
        this.ShowAverage = (JRadioButton)this.addElement(new ControlRadioButton(), "ShowAverage").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "average").setProperty("text", this._simulation.translateString("View.ShowAverage.text", "<I>")).setProperty("tooltip", this._simulation.translateString("View.ShowAverage.tooltip", "Show average intensity at each point")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Parameters").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Display = (JPanel)this.addElement(new ControlPanel(), "Display").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Xrange = (JSlider)this.addElement(new ControlSlider(), "Xrange").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Display").setProperty("variable", "xmax").setProperty("minimum", "1.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Xrange.format", "xmax = 0.##")).setProperty("ticks", "10").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Xrange.tooltip", "Length of x axis on display")).getObject();
        this.Guides = (JPanel)this.addElement(new ControlPanel(), "Guides").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Display").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Amplitudes = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Amplitudes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Guides").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Amplitudes_minimumX()%").setProperty("maximumX", "%_model._method_for_Amplitudes_maximumX()%").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("background", "white").getObject();
        this.zero0 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero0_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero1 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero1_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero2 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero2_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero3 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero3_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero4 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero4").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero4_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero5 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero5").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero5_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero6 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero6").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero6_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero7 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero7").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero7_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.zero8 = (InteractiveArrow)this.addElement(new ControlArrow(), "zero8").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "%_model._method_for_zero8_x()%").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("visible", "showZero").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.node1 = (InteractiveArrow)this.addElement(new ControlArrow(), "node1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("y", "%_model._method_for_node1_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node1_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.node2 = (InteractiveArrow)this.addElement(new ControlArrow(), "node2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("y", "%_model._method_for_node2_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node2_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.node3 = (InteractiveArrow)this.addElement(new ControlArrow(), "node3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("y", "%_model._method_for_node3_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node3_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.node4 = (InteractiveArrow)this.addElement(new ControlArrow(), "node4").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("y", "%_model._method_for_node4_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node4_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.amp0 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "0.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*0.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp1 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "1.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*1.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp2 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "2.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*2.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp3 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "3.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*3.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp4 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp4").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "4.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*4.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp5 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp5").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "5.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*5.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp6 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp6").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "6.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*6.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp7 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp7").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "7.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*7.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.amp8 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "amp8").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("points", "ny").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "8.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*8.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.upperWall1 = (InteractiveArrow)this.addElement(new ControlArrow(), "upperWall1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "0.0").setProperty("y", "1.0").setProperty("sizex", "xmax").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3").getObject();
        this.lowerWall1 = (InteractiveArrow)this.addElement(new ControlArrow(), "lowerWall1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Amplitudes").setProperty("x", "0.0").setProperty("y", "0.0").setProperty("sizex", "xmax").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3").getObject();
        this.Values = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Guides").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Values_minimumX()%").setProperty("maximumX", "%_model._method_for_Values_maximumX()%").setProperty("minimumY", "-0.1").setProperty("maximumY", "1.1").setProperty("background", "white").getObject();
        this.Colors = (Plot2DWrapper)this.addElement(new ControlZInterpolatedPlot(), "Colors").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("z", "space").setProperty("autoscaleZ", "false").setProperty("minimumZ", "Imin").setProperty("maximumZ", "Imax").setProperty("minimumX", "0").setProperty("maximumX", "xmax").setProperty("minimumY", "0").setProperty("maximumY", "1").setProperty("colormode", "GRAYSCALE").setProperty("showgrid", "false").getObject();
        this.node1b = (InteractiveArrow)this.addElement(new ControlArrow(), "node1b").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("y", "%_model._method_for_node1b_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node1b_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.node2b = (InteractiveArrow)this.addElement(new ControlArrow(), "node2b").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("y", "%_model._method_for_node2b_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node2b_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.createControl50();
    }

    private void createControl50() {
        this.node3b = (InteractiveArrow)this.addElement(new ControlArrow(), "node3b").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("y", "%_model._method_for_node3b_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node3b_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.node4b = (InteractiveArrow)this.addElement(new ControlArrow(), "node4b").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("y", "%_model._method_for_node4b_y()%").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_node4b_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.upperWall2 = (InteractiveArrow)this.addElement(new ControlArrow(), "upperWall2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("x", "0.0").setProperty("y", "1.0").setProperty("sizex", "xmax").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3").getObject();
        this.lowerWall2 = (InteractiveArrow)this.addElement(new ControlArrow(), "lowerWall2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("x", "0.0").setProperty("y", "0.0").setProperty("sizex", "xmax").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Waveguide")).setProperty("visible", "true");
        this.getElement("Controls");
        this.getElement("Modes");
        this.getElement("Mode").setProperty("minimum", "1").setProperty("maximum", "5").setProperty("format", this._simulation.translateString("View.Mode.format", "Mode '#'0")).setProperty("orientation", "VERTICAL").setProperty("ticks", "5").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Mode.tooltip", "Mode"));
        this.getElement("Parameters");
        this.getElement("vvalue").setProperty("format", this._simulation.translateString("View.vvalue.format", "v = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vvalue.tooltip", "Horizontal phase velocity"));
        this.getElement("step").setProperty("format", this._simulation.translateString("View.step.format", "$\\Delta$t = 0.######")).setProperty("tooltip", this._simulation.translateString("View.step.tooltip", "Animation step"));
        this.getElement("showZero").setProperty("text", this._simulation.translateString("View.showZero.text", "0")).setProperty("mnemonic", this._simulation.translateString("View.showZero.mnemonic", "0")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.showZero.tooltip", "Show 0 values?"));
        this.getElement("showNodes").setProperty("text", this._simulation.translateString("View.showNodes.text", "Nodes")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.showNodes.tooltip", "Show nodes?"));
        this.getElement("BelowLabel").setProperty("text", this._simulation.translateString("View.BelowLabel.text", "Below:")).setProperty("tooltip", this._simulation.translateString("View.BelowLabel.tooltip", "Choose below the contour-plot meaning"));
        this.getElement("ShowWave").setProperty("text", this._simulation.translateString("View.ShowWave.text", "u(t,x)")).setProperty("mnemonic", this._simulation.translateString("View.ShowWave.mnemonic", "u")).setProperty("tooltip", this._simulation.translateString("View.ShowWave.tooltip", "Show wave values"));
        this.getElement("ShowIntensity").setProperty("text", this._simulation.translateString("View.ShowIntensity.text", "I(t,x)")).setProperty("mnemonic", this._simulation.translateString("View.ShowIntensity.mnemonic", "i")).setProperty("tooltip", this._simulation.translateString("View.ShowIntensity.tooltip", "Show instantaneous intensity"));
        this.getElement("ShowAverage").setProperty("text", this._simulation.translateString("View.ShowAverage.text", "<I>")).setProperty("tooltip", this._simulation.translateString("View.ShowAverage.tooltip", "Show average intensity at each point"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Display");
        this.getElement("Xrange").setProperty("minimum", "1.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Xrange.format", "xmax = 0.##")).setProperty("ticks", "10").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Xrange.tooltip", "Length of x axis on display"));
        this.getElement("Guides");
        this.getElement("Amplitudes").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("background", "white");
        this.getElement("zero0").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero1").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero2").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero3").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero4").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero5").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero6").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero7").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("zero8").setProperty("sizex", "0.0").setProperty("sizey", "1.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("node1").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node2").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node3").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node4").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("amp0").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "0.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*0.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp1").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "1.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*1.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp2").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "2.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*2.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp3").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "3.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*3.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp4").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "4.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*4.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp5").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "5.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*5.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp6").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "6.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*6.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp7").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "7.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*7.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("amp8").setProperty("min", "0.0").setProperty("max", "1.0").setProperty("variable", "s").setProperty("functionx", "8.0*xmax/8.0+A*Math.sin(n*Math.PI*s)*Math.cos(k*8.0*xmax/8.0-omega*t)").setProperty("functiony", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("upperWall1").setProperty("x", "0.0").setProperty("y", "1.0").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3");
        this.getElement("lowerWall1").setProperty("x", "0.0").setProperty("y", "0.0").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3");
        this.getElement("Values").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumY", "-0.1").setProperty("maximumY", "1.1").setProperty("background", "white");
        this.getElement("Colors").setProperty("autoscaleZ", "false").setProperty("minimumX", "0").setProperty("minimumY", "0").setProperty("maximumY", "1").setProperty("colormode", "GRAYSCALE").setProperty("showgrid", "false");
        this.getElement("node1b").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node2b").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node3b").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("node4b").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("upperWall2").setProperty("x", "0.0").setProperty("y", "1.0").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3");
        this.getElement("lowerWall2").setProperty("x", "0.0").setProperty("y", "0.0").setProperty("sizey", "0.0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("stroke", "3");
        super.reset();
    }
}

