/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.waveguide;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.waveguide.waveguideSimulation;
import users.ehu.jma.waves.waveguide.waveguideView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class waveguide
extends AbstractModel {
    public waveguideSimulation _simulation = null;
    public waveguideView _view = null;
    public waveguide _model = this;
    public double A = 0.025;
    public double k = 1.0;
    public double omega = Math.PI * 2;
    public double t = 0.0;
    public int n = 1;
    public double v = 1.0;
    public int nLines = 9;
    public boolean showZero = false;
    public boolean showNodes = false;
    public int nx = 180;
    public int ny = 60;
    public double[][] space;
    public double dt = 0.01;
    public double xmin = 0.0;
    public double xmax = 1.0;
    public String playImage = "images/play.gif";
    public String pauseImage = "images/pause.gif";
    public String startImage = "images/pause.gif";
    public double Imin = 0.0;
    public double Imax = 1.0;
    public boolean wave = false;
    public boolean intensity = false;
    public boolean average = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/waveguide.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        waveguide waveguide2 = new waveguide(stringArray);
    }

    public waveguide() {
        this(null, null, null, null, null, false);
    }

    public waveguide(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public waveguide(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new waveguideSimulation(this, string, frame, uRL, bl);
        this._view = (waveguideView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.n < 1) {
            this.n = 1;
        }
        this.A = this.xmax / 20.0;
        this.Imin = this.intensity || this.average ? 0.0 : -1.0;
    }

    public void _constraints2() {
        this.k = this.omega / this.v;
    }

    public void _constraints3() {
        double d = this.xmax / (double)(this.nx - 1);
        double d2 = 1.0 / (double)(this.ny - 1);
        for (int i = 0; i < this.nx; ++i) {
            double d3 = (double)i * d;
            for (int j = 0; j < this.ny; ++j) {
                double d4;
                double d5 = d4 = this.wave || this.intensity || this.average ? Math.sin((double)this.n * Math.PI * (double)j * d2) : 0.0;
                if (this.wave || this.intensity) {
                    d4 *= Math.cos(this.k * d3 - this.omega * this.t);
                }
                this.space[i][j] = this.intensity || this.average ? d4 * d4 : d4;
            }
        }
    }

    public void startstop() {
        if (this._isPlaying()) {
            this.startImage = this.playImage;
            this._pause();
        } else {
            this.startImage = this.pauseImage;
            this._play();
        }
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Amplitudes_minimumX() {
        return -1.5 * this.A;
    }

    public double _method_for_Amplitudes_maximumX() {
        return this.xmax + 1.5 * this.A;
    }

    public double _method_for_zero0_x() {
        return 0.0 * this.xmax / 8.0;
    }

    public double _method_for_zero1_x() {
        return 1.0 * this.xmax / 8.0;
    }

    public double _method_for_zero2_x() {
        return 2.0 * this.xmax / 8.0;
    }

    public double _method_for_zero3_x() {
        return 3.0 * this.xmax / 8.0;
    }

    public double _method_for_zero4_x() {
        return 4.0 * this.xmax / 8.0;
    }

    public double _method_for_zero5_x() {
        return 5.0 * this.xmax / 8.0;
    }

    public double _method_for_zero6_x() {
        return 6.0 * this.xmax / 8.0;
    }

    public double _method_for_zero7_x() {
        return 7.0 * this.xmax / 8.0;
    }

    public double _method_for_zero8_x() {
        return 8.0 * this.xmax / 8.0;
    }

    public double _method_for_node1_y() {
        return 1.0 / (double)this.n;
    }

    public boolean _method_for_node1_visible() {
        return this.showNodes && this.n > 1;
    }

    public double _method_for_node2_y() {
        return 2.0 / (double)this.n;
    }

    public boolean _method_for_node2_visible() {
        return this.showNodes && this.n > 2;
    }

    public double _method_for_node3_y() {
        return 3.0 / (double)this.n;
    }

    public boolean _method_for_node3_visible() {
        return this.showNodes && this.n > 3;
    }

    public double _method_for_node4_y() {
        return 4.0 / (double)this.n;
    }

    public boolean _method_for_node4_visible() {
        return this.showNodes && this.n > 4;
    }

    public double _method_for_Values_minimumX() {
        return -1.5 * this.A;
    }

    public double _method_for_Values_maximumX() {
        return this.xmax + 1.5 * this.A;
    }

    public double _method_for_node1b_y() {
        return 1.0 / (double)this.n;
    }

    public boolean _method_for_node1b_visible() {
        return this.showNodes && this.n > 1 && (this.wave || this.intensity || this.average);
    }

    public double _method_for_node2b_y() {
        return 2.0 / (double)this.n;
    }

    public boolean _method_for_node2b_visible() {
        return this.showNodes && this.n > 2 && (this.wave || this.intensity || this.average);
    }

    public double _method_for_node3b_y() {
        return 3.0 / (double)this.n;
    }

    public boolean _method_for_node3b_visible() {
        return this.showNodes && this.n > 3 && (this.wave || this.intensity || this.average);
    }

    public double _method_for_node4b_y() {
        return 4.0 / (double)this.n;
    }

    public boolean _method_for_node4b_visible() {
        return this.showNodes && this.n > 4 && (this.wave || this.intensity || this.average);
    }

    @Override
    public synchronized void reset() {
        this.A = 0.025;
        this.k = 1.0;
        this.omega = Math.PI * 2;
        this.t = 0.0;
        this.n = 1;
        this.v = 1.0;
        this.nLines = 9;
        this.showZero = false;
        this.showNodes = false;
        this.nx = 180;
        this.ny = 60;
        this.space = new double[this.nx][this.ny];
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.space[i][j] = 0.0;
            }
        }
        this.dt = 0.01;
        this.xmin = 0.0;
        this.xmax = 1.0;
        this.playImage = "images/play.gif";
        this.pauseImage = "images/pause.gif";
        this.startImage = "images/pause.gif";
        this.Imin = 0.0;
        this.Imax = 1.0;
        this.wave = false;
        this.intensity = false;
        this.average = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.space = null;
        System.gc();
    }
}

