/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.wave_phasors;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.wave_phasors.wave_phasorsSimulation;
import users.ehu.jma.waves.wave_phasors.wave_phasorsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class wave_phasors
extends AbstractModel {
    public wave_phasorsSimulation _simulation = null;
    public wave_phasorsView _view = null;
    public wave_phasors _model = this;
    public double A = 30.0;
    public double PI2 = Math.PI * 2;
    public double lambda = 0.0;
    public double T = 4.0;
    public double v = 15.0;
    public double t = 0.0;
    public double xmin = -25.0;
    public double xmax = 225.0;
    public double ymin = -25.0;
    public double ymax = 25.0;
    public double zmin = -25.0;
    public double zmax = 25.0;
    public double dt = 0.1;
    public double x1 = -50.0;
    public double x2 = 250.0;
    public int points = 200;
    public double alpha = -1.15;
    public double beta = 0.25;
    public boolean equilibrium = true;
    public int nMax = 64;
    public int N = 16;
    public double[] phx;
    public double[] phy;
    public double[] phz;
    public int nTraj = 50;
    public boolean complex = false;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/wave_phasors.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        wave_phasors wave_phasors2 = new wave_phasors(stringArray);
    }

    public wave_phasors() {
        this(null, null, null, null, null, false);
    }

    public wave_phasors(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public wave_phasors(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new wave_phasorsSimulation(this, string, frame, uRL, bl);
        this._view = (wave_phasorsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.setZero();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.N < 0) {
            this.N = 0;
        } else if (this.N > this.nMax) {
            this.N = this.nMax;
        }
    }

    public void _constraints2() {
        for (int i = 0; i < this.N; ++i) {
            double d = this.PI2 * (this.phx[i] / this.lambda - this.t / this.T);
            this.phy[i] = this.A * Math.cos(d);
            this.phz[i] = this.A * Math.sin(d);
        }
    }

    public void setZero() {
        this.t = 0.0;
        this.lambda = this.v * this.T;
        for (int i = 0; i < this.N; ++i) {
            this.phx[i] = this.N > 1 ? this.x1 + (this.x2 - this.x1) / (double)(this.N - 1) * (double)i : 0.5 * (this.x1 + this.x2);
        }
        this._view.resetTraces();
    }

    public int _method_for_complexWave_points() {
        return 2 * this.points;
    }

    public boolean _method_for_Fasoreak_visible() {
        return this.N > 0;
    }

    public boolean _method_for_Projections_visible() {
        return this.N > 0;
    }

    public boolean _method_for_Points_visible() {
        return this.N > 0;
    }

    public boolean _method_for_Trajectories_active() {
        return this.nTraj > 0;
    }

    public boolean _method_for_Trajectories_visible() {
        return this.N > 0 && this.nTraj > 0;
    }

    public boolean _method_for_Trajectories2_active() {
        return this.nTraj > 0;
    }

    public boolean _method_for_Trajectories2_visible() {
        return this.N > 0 && this.nTraj > 0;
    }

    public void _method_for_A_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_T_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_v_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public int _method_for_N_ticks() {
        return this.nMax + 1;
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_nTraj_enabled() {
        return this.N > 0;
    }

    public void _method_for_nTraj_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.A = 30.0;
        this.PI2 = Math.PI * 2;
        this.lambda = 0.0;
        this.T = 4.0;
        this.v = 15.0;
        this.t = 0.0;
        this.xmin = -25.0;
        this.xmax = 225.0;
        this.ymin = -25.0;
        this.ymax = 25.0;
        this.zmin = -25.0;
        this.zmax = 25.0;
        this.dt = 0.1;
        this.x1 = -50.0;
        this.x2 = 250.0;
        this.points = 200;
        this.alpha = -1.15;
        this.beta = 0.25;
        this.equilibrium = true;
        this.nMax = 64;
        this.N = 16;
        this.phx = new double[this.nMax];
        for (n = 0; n < this.nMax; ++n) {
            this.phx[n] = 0.0;
        }
        this.phy = new double[this.nMax];
        for (n = 0; n < this.nMax; ++n) {
            this.phy[n] = 0.0;
        }
        this.phz = new double[this.nMax];
        for (n = 0; n < this.nMax; ++n) {
            this.phz[n] = 0.0;
        }
        this.nTraj = 50;
        this.complex = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.phx = null;
        this.phy = null;
        this.phz = null;
        System.gc();
    }
}

