/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.transverse;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlDrawingPanel3D;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlBar;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import users.ehu.jma.waves.transverse.transverse;
import users.ehu.jma.waves.transverse.transverseSimulation;

class transverseView
extends EjsControl
implements View {
    private transverseSimulation _simulation = null;
    private transverse _model = null;
    public Component Main;
    public DrawingPanel3D d3;
    public InteractivePoligon string;
    public InteractivePoligon wave;
    public InteractiveArrow displacement;
    public InteractiveTrace traject;
    public JPanel controls;
    public JPanel values;
    public JSlider ay;
    public JSlider az;
    public JSlider T;
    public JSlider v;
    public JSlider delta;
    public JPanel buttons;
    public JCheckBox equilibrium;
    public JCheckBox displacementOn;
    public JCheckBox traj;
    public JProgressBar lambda;
    public JPanel panel;
    public JButton startButton;
    public JButton resetButton;
    public JSlider beta;
    public JSlider alpha;

    public transverseView(transverseSimulation transverseSimulation2, String string, Frame frame) {
        super(transverseSimulation2, string, frame);
        this._simulation = transverseSimulation2;
        this._model = (transverse)transverseSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("Ay", "apply(\"Ay\")");
        this.addListener("Az", "apply(\"Az\")");
        this.addListener("PI2", "apply(\"PI2\")");
        this.addListener("lambda", "apply(\"lambda\")");
        this.addListener("T", "apply(\"T\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("delta", "apply(\"delta\")");
        this.addListener("phase", "apply(\"phase\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("zmin", "apply(\"zmin\")");
        this.addListener("zmax", "apply(\"zmax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("points", "apply(\"points\")");
        this.addListener("alpha", "apply(\"alpha\")");
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("displacement", "apply(\"displacement\")");
        this.addListener("trajectory", "apply(\"trajectory\")");
        this.addListener("xp", "apply(\"xp\")");
        this.addListener("equilibrium", "apply(\"equilibrium\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("Ay".equals(string)) {
            this._model.Ay = this.getDouble("Ay");
        }
        if ("Az".equals(string)) {
            this._model.Az = this.getDouble("Az");
        }
        if ("PI2".equals(string)) {
            this._model.PI2 = this.getDouble("PI2");
        }
        if ("lambda".equals(string)) {
            this._model.lambda = this.getDouble("lambda");
        }
        if ("T".equals(string)) {
            this._model.T = this.getDouble("T");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("delta".equals(string)) {
            this._model.delta = this.getDouble("delta");
        }
        if ("phase".equals(string)) {
            this._model.phase = this.getDouble("phase");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("zmin".equals(string)) {
            this._model.zmin = this.getDouble("zmin");
        }
        if ("zmax".equals(string)) {
            this._model.zmax = this.getDouble("zmax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("points".equals(string)) {
            this._model.points = this.getDouble("points");
        }
        if ("alpha".equals(string)) {
            this._model.alpha = this.getDouble("alpha");
        }
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("displacement".equals(string)) {
            this._model.displacement = this.getBoolean("displacement");
        }
        if ("trajectory".equals(string)) {
            this._model.trajectory = this.getBoolean("trajectory");
        }
        if ("xp".equals(string)) {
            this._model.xp = this.getDouble("xp");
        }
        if ("equilibrium".equals(string)) {
            this._model.equilibrium = this.getBoolean("equilibrium");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("Ay", this._model.Ay);
        this.setValue("Az", this._model.Az);
        this.setValue("PI2", this._model.PI2);
        this.setValue("lambda", this._model.lambda);
        this.setValue("T", this._model.T);
        this.setValue("v", this._model.v);
        this.setValue("t", this._model.t);
        this.setValue("delta", this._model.delta);
        this.setValue("phase", this._model.phase);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("zmin", this._model.zmin);
        this.setValue("zmax", this._model.zmax);
        this.setValue("dt", this._model.dt);
        this.setValue("x1", this._model.x1);
        this.setValue("x2", this._model.x2);
        this.setValue("points", this._model.points);
        this.setValue("alpha", this._model.alpha);
        this.setValue("beta", this._model.beta);
        this.setValue("displacement", this._model.displacement);
        this.setValue("trajectory", this._model.trajectory);
        this.setValue("xp", this._model.xp);
        this.setValue("equilibrium", this._model.equilibrium);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Transverse wave")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "640,400")).getObject();
        this.d3 = (DrawingPanel3D)this.addElement(new ControlDrawingPanel3D(), "d3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("minimumZ", "zmin").setProperty("maximumZ", "zmax").setProperty("displayMode", "PERSPECTIVE").setProperty("square", "true").setProperty("alpha", "alpha").setProperty("beta", "beta").setProperty("zoom", "2.5").setProperty("panx", "2").setProperty("pany", "-4").setProperty("decoration", "AXES").setProperty("tooltip", this._simulation.translateString("View.d3.tooltip", "Use the mouse to change position, point of view and zoom")).getObject();
        this.string = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "string").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "d3").setProperty("points", "2").setProperty("min", "x1").setProperty("max", "x2").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "0").setProperty("functionz", "0").setProperty("color", "lightGray").setProperty("stroke", "2").setProperty("visible", "equilibrium").setProperty("enabled", "false").getObject();
        this.wave = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "wave").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "d3").setProperty("min", "x1").setProperty("max", "x2").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "Ay*cos(PI2*(s/lambda-t/T))").setProperty("functionz", "Az*cos(PI2*(s/lambda-t/T)+delta)").setProperty("javaSyntax", "false").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.displacement = (InteractiveArrow)this.addElement(new ControlArrow(), "displacement").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "d3").setProperty("x", "xp").setProperty("y", "0").setProperty("z", "0").setProperty("sizey", "%_model._method_for_displacement_sizey()%").setProperty("sizez", "%_model._method_for_displacement_sizez()%").setProperty("visible", "displacement").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red").getObject();
        this.traject = (InteractiveTrace)this.addElement(new ControlTrace(), "traject").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "d3").setProperty("x", "xp").setProperty("y", "%_model._method_for_traject_y()%").setProperty("z", "%_model._method_for_traject_z()%").setProperty("maxpoints", "100").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "trajectory").setProperty("enabled", "false").setProperty("color", "0,128,0,255").getObject();
        this.controls = (JPanel)this.addElement(new ControlPanel(), "controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border:0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.values = (JPanel)this.addElement(new ControlPanel(), "values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "controls").setProperty("layout", "hbox").getObject();
        this.ay = (JSlider)this.addElement(new ControlSlider(), "ay").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "values").setProperty("variable", "Ay").setProperty("value", "30.0").setProperty("minimum", "0.0").setProperty("maximum", "50.0").setProperty("format", this._simulation.translateString("View.ay.format", "Ay = 0")).setProperty("ticks", "6").setProperty("closest", "true").setProperty("action", "_model._method_for_ay_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.ay.tooltip", "Amplitude in the Y direction")).getObject();
        this.az = (JSlider)this.addElement(new ControlSlider(), "az").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "values").setProperty("variable", "Az").setProperty("value", "0.0").setProperty("minimum", "0.0").setProperty("maximum", "50").setProperty("format", this._simulation.translateString("View.az.format", "Az = 0")).setProperty("ticks", "6").setProperty("closest", "true").setProperty("action", "_model._method_for_az_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.az.tooltip", "Amplitude in the Z direction")).getObject();
        this.T = (JSlider)this.addElement(new ControlSlider(), "T").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "values").setProperty("variable", "T").setProperty("value", "4").setProperty("minimum", "0.0").setProperty("maximum", "20").setProperty("format", this._simulation.translateString("View.T.format", "T = 0")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("action", "_model._method_for_T_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.T.tooltip", "Wave period")).getObject();
        this.v = (JSlider)this.addElement(new ControlSlider(), "v").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "values").setProperty("variable", "v").setProperty("value", "15").setProperty("minimum", "10").setProperty("maximum", "50").setProperty("format", this._simulation.translateString("View.v.format", "v = 0")).setProperty("ticks", "21").setProperty("action", "_model._method_for_v_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.v.tooltip", "Phase velocity")).getObject();
        this.delta = (JSlider)this.addElement(new ControlSlider(), "delta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "values").setProperty("variable", "phase").setProperty("minimum", "0.0").setProperty("maximum", "360").setProperty("format", this._simulation.translateString("View.delta.format", "$\\delta$ = 0")).setProperty("ticks", "9").setProperty("closest", "true").setProperty("action", "_model._method_for_delta_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.delta.tooltip", "Phase advance of the Z component")).getObject();
        this.buttons = (JPanel)this.addElement(new ControlPanel(), "buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "controls").setProperty("layout", "grid:1,5,0,0").getObject();
        this.equilibrium = (JCheckBox)this.addElement(new ControlCheckBox(), "equilibrium").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttons").setProperty("variable", "equilibrium").setProperty("text", this._simulation.translateString("View.equilibrium.text", "Equilibrium")).setProperty("mnemonic", this._simulation.translateString("View.equilibrium.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.equilibrium.tooltip", "Display equilibrium position")).getObject();
        this.displacementOn = (JCheckBox)this.addElement(new ControlCheckBox(), "displacementOn").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttons").setProperty("variable", "displacement").setProperty("text", this._simulation.translateString("View.displacementOn.text", "Position")).setProperty("mnemonic", this._simulation.translateString("View.displacementOn.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.displacementOn.tooltip", "Display the position vector of one point")).getObject();
        this.traj = (JCheckBox)this.addElement(new ControlCheckBox(), "traj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttons").setProperty("variable", "trajectory").setProperty("text", this._simulation.translateString("View.traj.text", "Trajectory")).setProperty("mnemonic", this._simulation.translateString("View.traj.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.traj.tooltip", "Display the trajectory of one point")).getObject();
        this.lambda = (JProgressBar)this.addElement(new ControlBar(), "lambda").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttons").setProperty("variable", "lambda").setProperty("minimum", "0.0").setProperty("maximum", "100").setProperty("format", this._simulation.translateString("View.lambda.format", "$\\lambda$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.lambda.tooltip", "Wavelength")).getObject();
        this.panel = (JPanel)this.addElement(new ControlPanel(), "panel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttons").setProperty("layout", "GRID:1,2,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "panel").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "panel").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.beta = (JSlider)this.addElement(new ControlSlider(), "beta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "beta").setProperty("minimum", "-3.14").setProperty("maximum", "3.14").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.beta.tooltip", "Change point of view")).getObject();
        this.alpha = (JSlider)this.addElement(new ControlSlider(), "alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Main").setProperty("variable", "alpha").setProperty("minimum", "-3.14").setProperty("maximum", "3.14").setProperty("orientation", "HORIZONTAL").setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "Change point of view")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Transverse wave")).setProperty("visible", "true");
        this.getElement("d3").setProperty("displayMode", "PERSPECTIVE").setProperty("square", "true").setProperty("zoom", "2.5").setProperty("panx", "2").setProperty("pany", "-4").setProperty("decoration", "AXES").setProperty("tooltip", this._simulation.translateString("View.d3.tooltip", "Use the mouse to change position, point of view and zoom"));
        this.getElement("string").setProperty("points", "2").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "0").setProperty("functionz", "0").setProperty("color", "lightGray").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("wave").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "Ay*cos(PI2*(s/lambda-t/T))").setProperty("functionz", "Az*cos(PI2*(s/lambda-t/T)+delta)").setProperty("javaSyntax", "false").setProperty("color", "blue").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("displacement").setProperty("y", "0").setProperty("z", "0").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red");
        this.getElement("traject").setProperty("maxpoints", "100").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "0,128,0,255");
        this.getElement("controls").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("values");
        this.getElement("ay").setProperty("value", "30.0").setProperty("minimum", "0.0").setProperty("maximum", "50.0").setProperty("format", this._simulation.translateString("View.ay.format", "Ay = 0")).setProperty("ticks", "6").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.ay.tooltip", "Amplitude in the Y direction"));
        this.getElement("az").setProperty("value", "0.0").setProperty("minimum", "0.0").setProperty("maximum", "50").setProperty("format", this._simulation.translateString("View.az.format", "Az = 0")).setProperty("ticks", "6").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.az.tooltip", "Amplitude in the Z direction"));
        this.getElement("T").setProperty("value", "4").setProperty("minimum", "0.0").setProperty("maximum", "20").setProperty("format", this._simulation.translateString("View.T.format", "T = 0")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.T.tooltip", "Wave period"));
        this.getElement("v").setProperty("value", "15").setProperty("minimum", "10").setProperty("maximum", "50").setProperty("format", this._simulation.translateString("View.v.format", "v = 0")).setProperty("ticks", "21").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.v.tooltip", "Phase velocity"));
        this.getElement("delta").setProperty("minimum", "0.0").setProperty("maximum", "360").setProperty("format", this._simulation.translateString("View.delta.format", "$\\delta$ = 0")).setProperty("ticks", "9").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.delta.tooltip", "Phase advance of the Z component"));
        this.getElement("buttons");
        this.getElement("equilibrium").setProperty("text", this._simulation.translateString("View.equilibrium.text", "Equilibrium")).setProperty("mnemonic", this._simulation.translateString("View.equilibrium.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.equilibrium.tooltip", "Display equilibrium position"));
        this.getElement("displacementOn").setProperty("text", this._simulation.translateString("View.displacementOn.text", "Position")).setProperty("mnemonic", this._simulation.translateString("View.displacementOn.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.displacementOn.tooltip", "Display the position vector of one point"));
        this.getElement("traj").setProperty("text", this._simulation.translateString("View.traj.text", "Trajectory")).setProperty("tooltip", this._simulation.translateString("View.traj.tooltip", "Display the trajectory of one point"));
        this.getElement("lambda").setProperty("minimum", "0.0").setProperty("maximum", "100").setProperty("format", this._simulation.translateString("View.lambda.format", "$\\lambda$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.lambda.tooltip", "Wavelength"));
        this.getElement("panel");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("beta").setProperty("minimum", "-3.14").setProperty("maximum", "3.14").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.beta.tooltip", "Change point of view"));
        this.getElement("alpha").setProperty("minimum", "-3.14").setProperty("maximum", "3.14").setProperty("orientation", "HORIZONTAL").setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "Change point of view"));
        super.reset();
    }
}

