/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.transverse;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.transverse.transverseSimulation;
import users.ehu.jma.waves.transverse.transverseView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class transverse
extends AbstractModel {
    public transverseSimulation _simulation = null;
    public transverseView _view = null;
    public transverse _model = this;
    public double Ay = 30.0;
    public double Az = 0.0;
    public double PI2 = Math.PI * 2;
    public double lambda = 0.0;
    public double T = 4.0;
    public double v = 15.0;
    public double t = 0.0;
    public double delta = 1.5707963267948966;
    public double phase = 90.0;
    public double xmin = -25.0;
    public double xmax = 225.0;
    public double ymin = -25.0;
    public double ymax = 25.0;
    public double zmin = -25.0;
    public double zmax = 25.0;
    public double dt = 0.1;
    public double x1 = -50.0;
    public double x2 = 250.0;
    public double points = 200.0;
    public double alpha = -1.15;
    public double beta = 0.25;
    public boolean displacement = false;
    public boolean trajectory = false;
    public double xp = 100.0;
    public boolean equilibrium = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/transverse.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        transverse transverse2 = new transverse(stringArray);
    }

    public transverse() {
        this(null, null, null, null, null, false);
    }

    public transverse(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public transverse(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new transverseSimulation(this, string, frame, uRL, bl);
        this._view = (transverseView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.setZero();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void setZero() {
        this.t = 0.0;
        this.delta = this.phase / 180.0 * Math.PI;
        this.lambda = this.v * this.T;
        this._view.getElement("traject").reset();
    }

    public double _method_for_displacement_sizey() {
        return this.Ay * Math.cos(this.PI2 * (this.xp / this.lambda - this.t / this.T));
    }

    public double _method_for_displacement_sizez() {
        return this.Az * Math.cos(this.PI2 * (this.xp / this.lambda - this.t / this.T) + this.delta);
    }

    public double _method_for_traject_y() {
        return this.Ay * Math.cos(this.PI2 * (this.xp / this.lambda - this.t / this.T));
    }

    public double _method_for_traject_z() {
        return this.Az * Math.cos(this.PI2 * (this.xp / this.lambda - this.t / this.T) + this.delta);
    }

    public void _method_for_ay_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_az_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_T_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_v_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_delta_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.Ay = 30.0;
        this.Az = 0.0;
        this.PI2 = Math.PI * 2;
        this.lambda = 0.0;
        this.T = 4.0;
        this.v = 15.0;
        this.t = 0.0;
        this.delta = 1.5707963267948966;
        this.phase = 90.0;
        this.xmin = -25.0;
        this.xmax = 225.0;
        this.ymin = -25.0;
        this.ymax = 25.0;
        this.zmin = -25.0;
        this.zmax = 25.0;
        this.dt = 0.1;
        this.x1 = -50.0;
        this.x2 = 250.0;
        this.points = 200.0;
        this.alpha = -1.15;
        this.beta = 0.25;
        this.displacement = false;
        this.trajectory = false;
        this.xp = 100.0;
        this.equilibrium = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

