/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.synchronous;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.synchronous.synchronousSimulation;
import users.ehu.jma.waves.synchronous.synchronousView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class synchronous
extends AbstractModel {
    public synchronousSimulation _simulation = null;
    public synchronousView _view = null;
    public synchronous _model = this;
    public double lambda = 0.003;
    public double t = 0.0;
    public double dt = 0.001;
    public double d = 1.0;
    public double a = 0.01;
    public int nSources = 3;
    public double y0 = 0.0;
    public int n = 100;
    public double[][] space;
    public double[][] diagram;
    public double v = 1.0;
    public double pi2 = Math.PI * 2;
    public double k = 0.0;
    public double[][] avDiagram;
    public double[][] average;
    public int avMax = 1000;
    public int avN = 50;
    public int avCur = 0;
    public boolean avDone = false;
    public double dx = 1.0;
    public double dy = 0.0;
    public double xmin = -0.6;
    public double xmax = 0.6;
    public double ymin = -0.6;
    public double ymax = 0.6;
    public double dmin = 0.0;
    public double dmax = 0.2;
    public double imax = 4.0;
    public double imax0 = 4.0;
    public int maxSources = 20;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/synchronous.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        synchronous synchronous2 = new synchronous(stringArray);
    }

    public synchronous() {
        this(null, null, null, null, null, false);
    }

    public synchronous(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public synchronous(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new synchronousSimulation(this, string, frame, uRL, bl);
        this._view = (synchronousView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.set_zero();
    }

    public void _evolution1() {
        this.t += this.dt;
        double d = -0.5 * this.d;
        for (int i = 0; i < this.n; ++i) {
            d += this.dx;
            double d2 = -this.d / 2.0;
            for (int j = 0; j < this.n; ++j) {
                d2 += this.dy;
                double d3 = 0.0;
                for (int k = 0; k < this.nSources; ++k) {
                    d3 += Math.cos(this.k * (this.hypot(d2 - (this.y0 + (double)k * this.a), d) - this.v * this.t));
                }
                this.space[i][j] = d3 * d3;
                if (i != this.n - 1) continue;
                double d4 = d3 * d3;
                this.diagram[1][j] = d4;
                this.diagram[0][j] = d4;
                if (this.avN <= 0) continue;
                this.average[this.avCur][j] = d3 * d3;
                if (j == 0 && this.avCur >= this.avN - 1) {
                    this.avDone = true;
                }
                if (this.avDone) {
                    double d5 = 0.0;
                    for (int k = 0; k < this.avN; ++k) {
                        d5 += this.average[k][j];
                    }
                    double d6 = d5 / (double)this.avN * d5 / (double)this.avN;
                    this.avDiagram[1][j] = d6;
                    this.avDiagram[0][j] = d6;
                }
                if (j != this.n - 1) continue;
                this.avCur = (this.avCur + 1) % this.avN;
            }
        }
    }

    public void _constraints1() {
        if (this.nSources < 1) {
            this.nSources = 1;
        } else if (this.nSources > this.maxSources) {
            this.nSources = this.maxSources;
        }
    }

    public void _constraints2() {
        this.dx = this.dy = this.d / (double)(this.n - 1);
        this.k = this.pi2 / this.lambda;
        if (this.imax0 != (double)(this.nSources * this.nSources)) {
            this.imax *= (double)(this.nSources * this.nSources) / this.imax0;
        }
        this.imax0 = this.nSources * this.nSources;
        this.y0 = this.nSources % 2 == 0 ? -((double)(this.nSources / 2) - 0.5) * this.a : (double)(-(this.nSources / 2)) * this.a;
    }

    public void _constraints3() {
        if (this.avN < 0) {
            this.avN = 0;
        } else if (this.avN > this.avMax) {
            this.avN = this.avMax;
        }
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void set_zero() {
        this.avCur = 0;
        this.avDone = false;
        this.t = 0.0;
    }

    public void _method_for_a_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_Lambda_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_Velocity_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_avN_action() {
        this._simulation.disableLoop();
        this.avCur = 0;
        this.avDone = false;
        this._simulation.enableLoop();
    }

    public void _method_for_dt_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Space_minimumX() {
        return -this.d / 2.0;
    }

    public double _method_for_Space_maximumX() {
        return this.d / 2.0;
    }

    public double _method_for_Space_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Space_maximumY() {
        return this.d / 2.0;
    }

    public double _method_for_Interference_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Interference_maximumY() {
        return this.d / 2.0;
    }

    public double _method_for_Averaged_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Averaged_maximumY() {
        return this.d / 2.0;
    }

    @Override
    public synchronized void reset() {
        int n;
        int n2;
        this.lambda = 0.003;
        this.t = 0.0;
        this.dt = 0.001;
        this.d = 1.0;
        this.a = 0.01;
        this.nSources = 3;
        this.y0 = 0.0;
        this.n = 100;
        this.space = new double[this.n][this.n];
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.space[n2][n] = 0.0;
            }
        }
        this.diagram = new double[2][this.n];
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.diagram[n2][n] = 0.0;
            }
        }
        this.v = 1.0;
        this.pi2 = Math.PI * 2;
        this.k = 0.0;
        this.avDiagram = new double[2][this.n];
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.avDiagram[n2][n] = 0.0;
            }
        }
        this.average = new double[this.avMax][this.n];
        for (n2 = 0; n2 < this.avMax; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.average[n2][n] = 0.0;
            }
        }
        this.avMax = 1000;
        this.avN = 50;
        this.avCur = 0;
        this.avDone = false;
        this.dx = 1.0;
        this.dy = 0.0;
        this.xmin = -0.6;
        this.xmax = 0.6;
        this.ymin = -0.6;
        this.ymax = 0.6;
        this.dmin = 0.0;
        this.dmax = 0.2;
        this.imax = 4.0;
        this.imax0 = 4.0;
        this.maxSources = 20;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.space = null;
        this.diagram = null;
        this.avDiagram = null;
        this.average = null;
        System.gc();
    }
}

