/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.strings;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.strings.stringsSimulation;
import users.ehu.jma.waves.strings.stringsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class strings
extends AbstractModel {
    public stringsSimulation _simulation = null;
    public stringsView _view = null;
    public strings _model = this;
    public double t = 0.0;
    public int nmin = 1000;
    public int nmax = 5000;
    public int n = 1000;
    public double pmin = -10.0;
    public double pmax = -7.0;
    public double amp = 2.0;
    public double L = 3.0;
    public double R = 0.0;
    public double c = 5.0;
    public double c2 = 5.0;
    public double c12 = 1.0;
    public double cmax = 1000000.0;
    public double xmin = -10.0;
    public double xmax = 10.0;
    public double ymin = -3.0;
    public double ymax = 3.0;
    public double dt = 0.01;
    public String pulse = "Two maxima";
    public int type = 0;
    public double[] xl;
    public double[] xr;
    public double[] yl;
    public double[] yr;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/strings.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        strings strings2 = new strings(stringArray);
    }

    public strings() {
        this(null, null, null, null, null, false);
    }

    public strings(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public strings(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new stringsSimulation(this, string, frame, uRL, bl);
        this._view = (stringsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.start();
    }

    public void _evolution1() {
        this.t += this.dt;
        this.evaluate();
    }

    public void _constraints1() {
        if (this.n < this.nmin) {
            this.n = this.nmin;
        } else if (this.n > this.nmax) {
            this.n = this.nmax;
        }
        if (this.c <= 0.0) {
            this.c = 1.0;
        }
        if (this.dt <= 0.0) {
            this.dt = 0.01;
        }
        if (this.L < 0.0) {
            this.L = 0.1;
        } else if (this.L > -this.xmin) {
            this.L = -this.xmin;
        }
        this.pmax = this.pmin + this.L;
    }

    public void _constraints2() {
        this.c2 = this.R == 1.0 ? this.cmax : (1.0 + this.R) / (1.0 - this.R) * this.c;
        this.c12 = this.R == -1.0 ? this.cmax : (1.0 - this.R) / (1.0 + this.R);
    }

    public void start() {
        double d = (this.xmax - this.xmin) / (double)(this.n - 1);
        for (int i = 0; i < this.n / 2; ++i) {
            this.xr[i] = d * (double)i;
            this.xl[i] = this.xmin + this.xr[i];
        }
        this.type = this.pulse.equals("Two maxima") ? 0 : (this.pulse.equals("Triangle") ? 1 : (this.pulse.equals("Door") ? 2 : (this.pulse.equals("Square") ? 3 : 4)));
        this.t = 0.0;
        this.evaluate();
    }

    public double twomaxima(double d) {
        d /= this.L;
        double d2 = 0.2;
        double d3 = -(d -= this.pmin / this.L + 0.5) * d * 100.0;
        double d4 = -(d - d2) * (d - d2) * 100.0;
        double d5 = -(d + d2) * (d + d2) * 100.0;
        return this.amp * (Math.exp(d3) + 0.333333333 * Math.exp(d4) + 0.666666667 * Math.exp(d5));
    }

    public double triangle(double d) {
        if (d < this.pmin || d > this.pmax) {
            return 0.0;
        }
        if (d < (this.pmin + this.pmax) / 2.0) {
            return this.amp * (d - this.pmin) / (this.pmax - this.pmin) * 2.0;
        }
        return this.amp * (this.pmax - d) / (this.pmax - this.pmin) * 2.0;
    }

    public double door(double d) {
        return d >= this.pmin && d <= this.pmax ? this.amp : 0.0;
    }

    public double square(double d) {
        if (d < this.pmin || d > this.pmax) {
            return 0.0;
        }
        if (d < (this.pmin + this.pmax) / 2.0) {
            return this.amp;
        }
        return -this.amp;
    }

    public double fe(double d) {
        switch (this.type) {
            case 0: {
                return this.twomaxima(d);
            }
            case 1: {
                return this.triangle(d);
            }
            case 2: {
                return this.door(d);
            }
            case 3: {
                return this.square(d);
            }
        }
        return 0.0;
    }

    public double fi(double d) {
        return this.R * this.fe(-d);
    }

    public double fr(double d) {
        return (1.0 + this.R) * this.fe(this.c12 * d);
    }

    public void evaluate() {
        for (int i = 0; i < this.n / 2; ++i) {
            this.yl[i] = this.fe(this.xl[i] - this.c * this.t) + this.fi(this.xl[i] + this.c * this.t);
            this.yr[i] = this.R == 1.0 ? 2.0 * this.fe(this.xl[this.n / 2 - 1] - this.c * this.t) : this.fr(this.xr[i] - this.c2 * this.t);
        }
    }

    public void _method_for_Drawing_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public int _method_for_Sum_maxpoints() {
        return this.n / 2;
    }

    public int _method_for_Refracted_maxpoints() {
        return this.n / 2;
    }

    public double _method_for_Constraint_y() {
        return this.yr[0];
    }

    public void _method_for_vc_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public double _method_for_c2_variable() {
        return this.c2 > this.cmax / 2.0 ? Double.POSITIVE_INFINITY : this.c2;
    }

    public void _method_for_amp_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_Length_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_Type_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public double _method_for_mom_variable() {
        return this.c12 > this.cmax / 2.0 ? Double.POSITIVE_INFINITY : this.c12 * this.c12;
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_bR_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_bR_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nmin = 1000;
        this.nmax = 5000;
        this.n = 1000;
        this.pmin = -10.0;
        this.pmax = -7.0;
        this.amp = 2.0;
        this.L = 3.0;
        this.R = 0.0;
        this.c = 5.0;
        this.c2 = 5.0;
        this.c12 = 1.0;
        this.cmax = 1000000.0;
        this.xmin = -10.0;
        this.xmax = 10.0;
        this.ymin = -3.0;
        this.ymax = 3.0;
        this.dt = 0.01;
        this.pulse = "Two maxima";
        this.type = 0;
        this.xl = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.xl[n] = 0.0;
        }
        this.xr = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.xr[n] = 0.0;
        }
        this.yl = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.yl[n] = 0.0;
        }
        this.yr = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.yr[n] = 0.0;
        }
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.xl = null;
        this.xr = null;
        this.yl = null;
        this.yr = null;
        System.gc();
    }
}

