/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.standing;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.standing.standingSimulation;
import users.ehu.jma.waves.standing.standingView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class standing
extends AbstractModel {
    public standingSimulation _simulation = null;
    public standingView _view = null;
    public standing _model = this;
    public double t = 0.0;
    public int nMaxPoints = 200;
    public int nMaxModes = 10;
    public int nPoints = 102;
    public int nModes = 5;
    public double A = 0.0;
    public double[] x0;
    public double[] y0;
    public double[] x1;
    public double[] y1;
    public double[] x2;
    public double[] y2;
    public double[] x3;
    public double[] y3;
    public double[] x4;
    public double[] y4;
    public double[] x5;
    public double[] y5;
    public double[] x6;
    public double[] y6;
    public double[] x7;
    public double[] y7;
    public double[] x8;
    public double[] y8;
    public double[] x9;
    public double[] y9;
    public double PI = Math.PI;
    public double xmin = -0.1;
    public double xmax = 1.1;
    public double ymin = -0.6;
    public double ymax = 0.6;
    public double dt = 0.01;
    public int nPoints2 = 100;
    public boolean showStrings = true;
    public double[] ys;
    public boolean showAmplitude = false;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/standing.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/waves/vibrating.gif");
        hashSet.add("users/ehu/jma/waves/equation.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        standing standing2 = new standing(stringArray);
    }

    public standing() {
        this(null, null, null, null, null, false);
    }

    public standing(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public standing(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new standingSimulation(this, string, frame, uRL, bl);
        this._view = (standingView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.setInitial();
    }

    public void _evolution1() {
        this.t += this.dt;
        this.updateAll();
    }

    public void _constraints1() {
        if (this.nModes < 1) {
            this.nModes = 1;
        } else if (this.nModes > this.nMaxModes) {
            this.nModes = this.nMaxModes;
        }
        if (this.nPoints2 < 50) {
            this.nPoints2 = 50;
        } else if (this.nPoints2 + 2 > this.nMaxPoints) {
            this.nPoints2 = this.nMaxPoints - 2;
        }
        this.nPoints = this.nPoints2 + 2;
        if (this.nPoints2 < this.nModes) {
            this.nModes = this.nPoints2;
        }
    }

    public void updateOne(int n, double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.nPoints; ++i) {
            dArray2[i] = this.ys[n - 1] + this.A * Math.sin((double)n * this.PI * dArray[i]) * Math.cos((double)n * this.PI * this.t);
        }
    }

    public void updateAll() {
        switch (this.nModes) {
            case 10: {
                this.updateOne(10, this.x9, this.y9);
            }
            case 9: {
                this.updateOne(9, this.x8, this.y8);
            }
            case 8: {
                this.updateOne(8, this.x7, this.y7);
            }
            case 7: {
                this.updateOne(7, this.x6, this.y6);
            }
            case 6: {
                this.updateOne(6, this.x5, this.y5);
            }
            case 5: {
                this.updateOne(5, this.x4, this.y4);
            }
            case 4: {
                this.updateOne(4, this.x3, this.y3);
            }
            case 3: {
                this.updateOne(3, this.x2, this.y2);
            }
            case 2: {
                this.updateOne(2, this.x1, this.y1);
            }
            case 1: {
                this.updateOne(1, this.x0, this.y0);
            }
        }
    }

    public void setInitial() {
        int n;
        this.t = 0.0;
        this.A = (this.ymax - this.ymin) / (double)(3 * this.nModes);
        for (n = 0; n < this.nPoints; ++n) {
            this.x8[n] = this.x9[n] = (double)n / (double)(this.nPoints - 1);
            this.x7[n] = this.x9[n];
            this.x6[n] = this.x9[n];
            this.x5[n] = this.x9[n];
            this.x4[n] = this.x9[n];
            this.x3[n] = this.x9[n];
            this.x2[n] = this.x9[n];
            this.x1[n] = this.x9[n];
            this.x0[n] = this.x9[n];
        }
        for (n = 0; n < this.nModes; ++n) {
            this.ys[n] = this.ymin + 3.0 * this.A * (double)n + 1.5 * this.A;
        }
        this.updateAll();
    }

    public boolean _method_for_Nmodes_enabled() {
        return this._isPaused();
    }

    public void _method_for_Nmodes_dragaction() {
        this._simulation.disableLoop();
        this.setInitial();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Mode0_visible() {
        return this.nModes > 0;
    }

    public boolean _method_for_Mode1_visible() {
        return this.nModes > 1;
    }

    public boolean _method_for_Mode2_visible() {
        return this.nModes > 2;
    }

    public boolean _method_for_Mode3_visible() {
        return this.nModes > 3;
    }

    public boolean _method_for_Mode4_visible() {
        return this.nModes > 4;
    }

    public boolean _method_for_Mode5_visible() {
        return this.nModes > 5;
    }

    public boolean _method_for_Mode6_visible() {
        return this.nModes > 6;
    }

    public boolean _method_for_Mode7_visible() {
        return this.nModes > 7;
    }

    public boolean _method_for_Mode8_visible() {
        return this.nModes > 8;
    }

    public boolean _method_for_Mode9_visible() {
        return this.nModes > 9;
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nMaxPoints = 200;
        this.nMaxModes = 10;
        this.nPoints = 102;
        this.nModes = 5;
        this.A = 0.0;
        this.x0 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x0[n] = 0.0;
        }
        this.y0 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y0[n] = 0.0;
        }
        this.x1 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x1[n] = 0.0;
        }
        this.y1 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y1[n] = 0.0;
        }
        this.x2 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x2[n] = 0.0;
        }
        this.y2 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y2[n] = 0.0;
        }
        this.x3 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x3[n] = 0.0;
        }
        this.y3 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y3[n] = 0.0;
        }
        this.x4 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x4[n] = 0.0;
        }
        this.y4 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y4[n] = 0.0;
        }
        this.x5 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x5[n] = 0.0;
        }
        this.y5 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y5[n] = 0.0;
        }
        this.x6 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x6[n] = 0.0;
        }
        this.y6 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y6[n] = 0.0;
        }
        this.x7 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x7[n] = 0.0;
        }
        this.y7 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y7[n] = 0.0;
        }
        this.x8 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x8[n] = 0.0;
        }
        this.y8 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y8[n] = 0.0;
        }
        this.x9 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x9[n] = 0.0;
        }
        this.y9 = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y9[n] = 0.0;
        }
        this.PI = Math.PI;
        this.xmin = -0.1;
        this.xmax = 1.1;
        this.ymin = -0.6;
        this.ymax = 0.6;
        this.dt = 0.01;
        this.nPoints2 = 100;
        this.showStrings = true;
        this.ys = new double[this.nMaxModes];
        for (n = 0; n < this.nMaxModes; ++n) {
            this.ys[n] = 0.0;
        }
        this.showAmplitude = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x0 = null;
        this.y0 = null;
        this.x1 = null;
        this.y1 = null;
        this.x2 = null;
        this.y2 = null;
        this.x3 = null;
        this.y3 = null;
        this.x4 = null;
        this.y4 = null;
        this.x5 = null;
        this.y5 = null;
        this.x6 = null;
        this.y6 = null;
        this.x7 = null;
        this.y7 = null;
        this.x8 = null;
        this.y8 = null;
        this.x9 = null;
        this.y9 = null;
        this.ys = null;
        System.gc();
    }
}

