/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.resonance;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlPoligon;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.waves.resonance.resonance;
import users.ehu.jma.waves.resonance.resonanceSimulation;

class resonanceView
extends EjsControl
implements View {
    private resonanceSimulation _simulation = null;
    private resonance _model = null;
    public Component Main;
    public DrawingPanel2D Drawing;
    public InteractiveArrow Rest;
    public InteractivePoligon Amplit;
    public InteractivePoligon Amplit2;
    public InteractivePoligon String;
    public InteractiveArrow End;
    public JSlider Zoom;
    public JPanel Down;
    public JPanel Controls;
    public JTextField Omega;
    public JTextField amp;
    public JTextField N;
    public JTextField dt;
    public JTextField SAmax;
    public JTextField Symax;
    public JCheckBox ShowRest;
    public JCheckBox ShowAmp;
    public JPanel panel;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;

    public resonanceView(resonanceSimulation resonanceSimulation2, String string, Frame frame) {
        super(resonanceSimulation2, string, frame);
        this._simulation = resonanceSimulation2;
        this._model = (resonance)resonanceSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("nmin", "apply(\"nmin\")");
        this.addListener("nmax", "apply(\"nmax\")");
        this.addListener("n", "apply(\"n\")");
        this.addListener("A", "apply(\"A\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("Amax", "apply(\"Amax\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("Ax", "apply(\"Ax\")");
        this.addListener("Pi", "apply(\"Pi\")");
        this.addListener("showAmplitude", "apply(\"showAmplitude\")");
        this.addListener("showRest", "apply(\"showRest\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("nmin".equals(string)) {
            this._model.nmin = this.getInt("nmin");
        }
        if ("nmax".equals(string)) {
            this._model.nmax = this.getInt("nmax");
        }
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("A".equals(string)) {
            this._model.A = this.getDouble("A");
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("Amax".equals(string)) {
            this._model.Amax = this.getDouble("Amax");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x".equals(string)) {
            dArray = (double[])this.getValue("x").getObject();
            n2 = dArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = dArray[n];
            }
        }
        if ("y".equals(string)) {
            dArray = (double[])this.getValue("y").getObject();
            n2 = dArray.length;
            if (n2 > this._model.y.length) {
                n2 = this._model.y.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y[n] = dArray[n];
            }
        }
        if ("Ax".equals(string)) {
            dArray = (double[])this.getValue("Ax").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Ax.length) {
                n2 = this._model.Ax.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Ax[n] = dArray[n];
            }
        }
        if ("Pi".equals(string)) {
            this._model.Pi = this.getDouble("Pi");
        }
        if ("showAmplitude".equals(string)) {
            this._model.showAmplitude = this.getBoolean("showAmplitude");
        }
        if ("showRest".equals(string)) {
            this._model.showRest = this.getBoolean("showRest");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("nmin", this._model.nmin);
        this.setValue("nmax", this._model.nmax);
        this.setValue("n", this._model.n);
        this.setValue("A", this._model.A);
        this.setValue("omega", this._model.omega);
        this.setValue("Amax", this._model.Amax);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("dt", this._model.dt);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("Ax", this._model.Ax);
        this.setValue("Pi", this._model.Pi);
        this.setValue("showAmplitude", this._model.showAmplitude);
        this.setValue("showRest", this._model.showRest);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Resonance in a taut string")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "-1,1").setProperty("size", this._simulation.translateString("View.Main.size", "640,320")).getObject();
        this.Drawing = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Drawing").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Drawing_minimumX()%").setProperty("maximumX", "%_model._method_for_Drawing_maximumX()%").setProperty("minimumY", "%_model._method_for_Drawing_minimumY()%").setProperty("maximumY", "ymax").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("action", "_model._method_for_Drawing_action()").setProperty("square", "false").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to pause the simulation")).getObject();
        this.Rest = (InteractiveArrow)this.addElement(new ControlArrow(), "Rest").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("sizex", "1").setProperty("sizey", "0").setProperty("visible", "showRest").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "200,220,208").getObject();
        this.Amplit = (InteractivePoligon)this.addElement(new ControlPoligon(), "Amplit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("maxpoints", "n").setProperty("x", "x").setProperty("y", "Ax").setProperty("visible", "showAmplitude").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "ORANGE").setProperty("color", "ORANGE").getObject();
        this.Amplit2 = (InteractivePoligon)this.addElement(new ControlPoligon(), "Amplit2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("maxpoints", "n").setProperty("x", "x").setProperty("y", "Ax").setProperty("sizey", "-1").setProperty("visible", "showAmplitude").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "ORANGE").setProperty("color", "ORANGE").getObject();
        this.String = (InteractivePoligon)this.addElement(new ControlPoligon(), "String").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("maxpoints", "n").setProperty("x", "x").setProperty("y", "y").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red").setProperty("stroke", "2").getObject();
        this.End = (InteractiveArrow)this.addElement(new ControlArrow(), "End").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_End_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "BLUE").getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "ymax").setProperty("minimum", "1.0").setProperty("maximum", "20.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,7,0,0").getObject();
        this.Omega = (JTextField)this.addElement(new ControlNumberField(), "Omega").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "omega").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\omega$ = 0.###")).setProperty("action", "_model._method_for_Omega_action()").setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Dimensionless frequency")).getObject();
        this.amp = (JTextField)this.addElement(new ControlNumberField(), "amp").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "A").setProperty("format", this._simulation.translateString("View.amp.format", "A = 0.###")).setProperty("action", "_model._method_for_amp_action()").setProperty("tooltip", this._simulation.translateString("View.amp.tooltip", "Amplitude at the left end")).getObject();
        this.N = (JTextField)this.addElement(new ControlNumberField(), "N").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "n").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("action", "_model._method_for_N_action()").setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of discretization points")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Interval between animation frames")).getObject();
        this.SAmax = (JTextField)this.addElement(new ControlParsedNumberField(), "SAmax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "Amax").setProperty("format", this._simulation.translateString("View.SAmax.format", "Amax = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.SAmax.tooltip", "Maximum oscillation amplitude")).getObject();
        this.Symax = (JTextField)this.addElement(new ControlParsedNumberField(), "Symax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "ymax").setProperty("format", this._simulation.translateString("View.Symax.format", "Ymax = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Symax.tooltip", "Maximum displayed value of y")).getObject();
        this.ShowRest = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowRest").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "showRest").setProperty("text", this._simulation.translateString("View.ShowRest.text", "Equilibrium")).setProperty("mnemonic", this._simulation.translateString("View.ShowRest.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowRest.tooltip", "Show equilibrium position?")).getObject();
        this.ShowAmp = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowAmp").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "showAmplitude").setProperty("text", this._simulation.translateString("View.ShowAmp.text", "Amplitude")).setProperty("mnemonic", this._simulation.translateString("View.ShowAmp.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowAmp.tooltip", "Show oscillation amplitude?")).getObject();
        this.panel = (JPanel)this.addElement(new ControlPanel(), "panel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("layout", "border").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Resonance in a taut string")).setProperty("visible", "true");
        this.getElement("Drawing").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("square", "false").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to pause the simulation"));
        this.getElement("Rest").setProperty("sizex", "1").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "200,220,208");
        this.getElement("Amplit").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "ORANGE").setProperty("color", "ORANGE");
        this.getElement("Amplit2").setProperty("sizey", "-1").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "ORANGE").setProperty("color", "ORANGE");
        this.getElement("String").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red").setProperty("stroke", "2");
        this.getElement("End").setProperty("sizex", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "BLUE");
        this.getElement("Zoom").setProperty("minimum", "1.0").setProperty("maximum", "20.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Omega").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Dimensionless frequency"));
        this.getElement("amp").setProperty("format", this._simulation.translateString("View.amp.format", "A = 0.###")).setProperty("tooltip", this._simulation.translateString("View.amp.tooltip", "Amplitude at the left end"));
        this.getElement("N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of discretization points"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Interval between animation frames"));
        this.getElement("SAmax").setProperty("format", this._simulation.translateString("View.SAmax.format", "Amax = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.SAmax.tooltip", "Maximum oscillation amplitude"));
        this.getElement("Symax").setProperty("format", this._simulation.translateString("View.Symax.format", "Ymax = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Symax.tooltip", "Maximum displayed value of y"));
        this.getElement("ShowRest").setProperty("text", this._simulation.translateString("View.ShowRest.text", "Equilibrium")).setProperty("mnemonic", this._simulation.translateString("View.ShowRest.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowRest.tooltip", "Show equilibrium position?"));
        this.getElement("ShowAmp").setProperty("text", this._simulation.translateString("View.ShowAmp.text", "Amplitude")).setProperty("mnemonic", this._simulation.translateString("View.ShowAmp.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowAmp.tooltip", "Show oscillation amplitude?"));
        this.getElement("panel");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

