/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.resonance;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.resonance.resonanceSimulation;
import users.ehu.jma.waves.resonance.resonanceView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class resonance
extends AbstractModel {
    public resonanceSimulation _simulation = null;
    public resonanceView _view = null;
    public resonance _model = this;
    public double t = 0.0;
    public int nmin = 1000;
    public int nmax = 5000;
    public int n = 1000;
    public double A = 0.2;
    public double omega = 0.5;
    public double Amax;
    public double xmin = 0.0;
    public double xmax = 1.0;
    public double ymin = -3.0;
    public double ymax = 3.0;
    public double dt = 0.05;
    public double[] x;
    public double[] y;
    public double[] Ax;
    public double Pi = Math.PI;
    public boolean showAmplitude = false;
    public boolean showRest = false;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/resonance.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/waves/vibrating.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        resonance resonance2 = new resonance(stringArray);
    }

    public resonance() {
        this(null, null, null, null, null, false);
    }

    public resonance(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public resonance(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new resonanceSimulation(this, string, frame, uRL, bl);
        this._view = (resonanceView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.start();
    }

    public void _evolution1() {
        this.t += this.dt;
        this.evaluate();
    }

    public void _constraints1() {
        if (Math.abs(this.omega - (double)Math.round(this.omega)) < 1.0E-5) {
            this.omega += 1.0E-5;
        } else if (this.omega <= 0.0) {
            this.omega = 0.01;
        }
    }

    public void start() {
        double d = (this.xmax - this.xmin) / (double)(this.n - 1);
        double d2 = this.A / Math.sin(this.omega * this.Pi);
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = this.xmin + d * (double)i;
            this.Ax[i] = d2 * Math.sin(this.omega * this.Pi * (1.0 - this.x[i]));
        }
        this.Amax = Math.abs(d2);
        this.t = 0.0;
        this.evaluate();
    }

    public void evaluate() {
        double d = this.A / Math.sin(this.omega * this.Pi) * Math.cos(this.omega * this.t);
        for (int i = 0; i < this.n; ++i) {
            this.y[i] = d * Math.sin(this.omega * this.Pi * (1.0 - this.x[i]));
        }
    }

    public double _method_for_Drawing_minimumX() {
        return this.xmin - 0.1;
    }

    public double _method_for_Drawing_maximumX() {
        return this.xmax + 0.1;
    }

    public double _method_for_Drawing_minimumY() {
        return -this.ymax;
    }

    public void _method_for_Drawing_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_End_sizey() {
        return this.y[0];
    }

    public void _method_for_Omega_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_amp_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nmin = 1000;
        this.nmax = 5000;
        this.n = 1000;
        this.A = 0.2;
        this.omega = 0.5;
        this.xmin = 0.0;
        this.xmax = 1.0;
        this.ymin = -3.0;
        this.ymax = 3.0;
        this.dt = 0.05;
        this.x = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.y[n] = 0.0;
        }
        this.Ax = new double[this.nmax];
        this.Pi = Math.PI;
        this.showAmplitude = false;
        this.showRest = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.Ax = null;
        System.gc();
    }
}

