/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.interference;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.interference.interferenceSimulation;
import users.ehu.jma.waves.interference.interferenceView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class interference
extends AbstractModel {
    public interferenceSimulation _simulation = null;
    public interferenceView _view = null;
    public interference _model = this;
    public double lambda1 = 0.1;
    public double lambda2 = 0.1;
    public double t = 0.0;
    public double dt = 0.02;
    public double d = 1.0;
    public double a = 0.3;
    public double a2 = 0.0;
    public int n = 100;
    public double[][] space;
    public double[][] diagram;
    public double phase = 0.0;
    public double f = 0.0;
    public double v = 1.0;
    public double pi2 = Math.PI * 2;
    public double k1 = 0.0;
    public double k2 = 0.0;
    public int random = 0;
    public double am1 = 1.0;
    public double am2 = 1.0;
    public int iter = 0;
    public double[][] avDiagram;
    public double[][] average;
    public int avMax = 100;
    public int avN = 10;
    public int avCur = 0;
    public boolean avDone = false;
    public double dx = 1.0;
    public double dy = 0.0;
    public double xmin = -0.1;
    public double xmax = 1.1;
    public double ymin = -0.6;
    public double ymax = 0.6;
    public double dmin = 0.0;
    public double dmax = 0.2;
    public double r1 = 0.0;
    public double r2 = 0.0;
    public double r = 0.05;
    public double imax = 4.0;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/interference.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        interference interference2 = new interference(stringArray);
    }

    public interference() {
        this(null, null, null, null, null, false);
    }

    public interference(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public interference(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new interferenceSimulation(this, string, frame, uRL, bl);
        this._view = (interferenceView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this._view.getElement("omega1").setProperty("format", "\u03bb1 = 0.######");
        this._view.getElement("omega2").setProperty("format", "\u03bb2 = 0.######");
        this._view.getElement("phase").setProperty("format", "\u0394\u03c6 = 0.##");
        this._view.getElement("dt").setProperty("format", "\u0394t = 0.######");
    }

    public void _evolution1() {
        this.t += this.dt;
        ++this.iter;
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d += this.dx;
            double d2 = -this.d / 2.0;
            for (int j = 0; j < this.n; ++j) {
                double d3 = this.am1 * Math.cos(this.k1 * (this.hypot((d2 += this.dy) - this.a2, d) - this.v * this.t)) + this.am2 * Math.cos(this.k2 * (this.hypot(d2 + this.a2, d) - this.v * this.t) + this.f);
                this.space[i][j] = d3 * d3;
                if (i != this.n - 1) continue;
                double d4 = d3 * d3;
                this.diagram[1][j] = d4;
                this.diagram[0][j] = d4;
                if (this.avN <= 0) continue;
                this.average[this.avCur][j] = d3 * d3;
                if (j == 0 && this.avCur >= this.avN - 1) {
                    this.avDone = true;
                }
                if (this.avDone) {
                    double d5 = 0.0;
                    for (int k = 0; k < this.avN; ++k) {
                        d5 += this.average[k][j];
                    }
                    double d6 = d5 / (double)this.avN * d5 / (double)this.avN;
                    this.avDiagram[1][j] = d6;
                    this.avDiagram[0][j] = d6;
                }
                if (j != this.n - 1) continue;
                this.avCur = (this.avCur + 1) % this.avN;
            }
        }
    }

    public void _constraints1() {
        this.a2 = 0.5 * this.a;
        this.dx = this.dy = this.d / (double)(this.n - 1);
        this.k1 = this.pi2 / this.lambda1;
        this.k2 = this.pi2 / this.lambda2;
    }

    public void _constraints2() {
        if (this.random > 0 && this.iter % this.random == 0) {
            this.f = this.pi2 * Math.random();
        }
    }

    public void _constraints3() {
        this.r1 = this.r < 0.0 ? -this.r : this.r * this.am1 * Math.cos(this.k1 * this.v * this.t);
        this.r2 = this.r < 0.0 ? -this.r : this.r * this.am2 * Math.cos(this.k2 * this.v * this.t - this.f);
    }

    public void _constraints4() {
        if (this.avN < 0) {
            this.avN = 0;
        } else if (this.avN > this.avMax) {
            this.avN = this.avMax;
        }
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void set_zero() {
        this.avCur = 0;
        this.avDone = false;
        this.t = 0.0;
    }

    public void _method_for_am1_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_am2_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_omega1_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_omega2_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_Velocity_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_phase_action() {
        this._simulation.disableLoop();
        this.f = Math.toRadians(this.phase);
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_a_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_random_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_avN_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_dt_action() {
        this._simulation.disableLoop();
        this.set_zero();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Space_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Space_maximumY() {
        return this.d / 2.0;
    }

    public double _method_for_Source2_y() {
        return -this.a2;
    }

    public double _method_for_Interference_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Interference_maximumY() {
        return this.d / 2.0;
    }

    public double _method_for_Averaged_minimumY() {
        return -this.d / 2.0;
    }

    public double _method_for_Averaged_maximumY() {
        return this.d / 2.0;
    }

    @Override
    public synchronized void reset() {
        int n;
        int n2;
        this.lambda1 = 0.1;
        this.lambda2 = 0.1;
        this.t = 0.0;
        this.dt = 0.02;
        this.d = 1.0;
        this.a = 0.3;
        this.a2 = 0.0;
        this.n = 100;
        this.space = new double[this.n][this.n];
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.space[n2][n] = 0.0;
            }
        }
        this.diagram = new double[2][this.n];
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.diagram[n2][n] = 0.0;
            }
        }
        this.phase = 0.0;
        this.f = 0.0;
        this.v = 1.0;
        this.pi2 = Math.PI * 2;
        this.k1 = 0.0;
        this.k2 = 0.0;
        this.random = 0;
        this.am1 = 1.0;
        this.am2 = 1.0;
        this.iter = 0;
        this.avDiagram = new double[2][this.n];
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.avDiagram[n2][n] = 0.0;
            }
        }
        this.average = new double[this.avMax][this.n];
        for (n2 = 0; n2 < this.avMax; ++n2) {
            for (n = 0; n < this.n; ++n) {
                this.average[n2][n] = 0.0;
            }
        }
        this.avMax = 100;
        this.avN = 10;
        this.avCur = 0;
        this.avDone = false;
        this.dx = 1.0;
        this.dy = 0.0;
        this.xmin = -0.1;
        this.xmax = 1.1;
        this.ymin = -0.6;
        this.ymax = 0.6;
        this.dmin = 0.0;
        this.dmax = 0.2;
        this.r1 = 0.0;
        this.r2 = 0.0;
        this.r = 0.05;
        this.imax = 4.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
    }

    @Override
    public void _freeMemory() {
        this.space = null;
        this.diagram = null;
        this.avDiagram = null;
        this.average = null;
        System.gc();
    }
}

