/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.group_velocity;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlPoligon;
import org.colos.ejs.library.control.displayejs.ControlText;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.waves.group_velocity.group_velocity;
import users.ehu.jma.waves.group_velocity.group_velocitySimulation;

class group_velocityView
extends EjsControl
implements View {
    private group_velocitySimulation _simulation = null;
    private group_velocity _model = null;
    public Component Main;
    public PlottingPanel2D Plot;
    public InteractiveText timeLabel;
    public InteractivePoligon Wave;
    public JPanel Bottom;
    public JPanel Controls;
    public JTextField Amplitude1;
    public JTextField kMin;
    public JTextField Omega1;
    public JTextField dT;
    public JTextField xMin;
    public JTextField xMax;
    public JTextField numPoints;
    public JTextField Amplitude2;
    public JTextField kMax;
    public JTextField Omega2;
    public JCheckBox ShowTime;
    public JPanel Options;
    public JButton startButton;
    public JButton initButton;
    public JButton resetButton;

    public group_velocityView(group_velocitySimulation group_velocitySimulation2, String string, Frame frame) {
        super(group_velocitySimulation2, string, frame);
        this._simulation = group_velocitySimulation2;
        this._model = (group_velocity)group_velocitySimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("nMaxPoints", "apply(\"nMaxPoints\")");
        this.addListener("nPoints", "apply(\"nPoints\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("A1", "apply(\"A1\")");
        this.addListener("A2", "apply(\"A2\")");
        this.addListener("k1", "apply(\"k1\")");
        this.addListener("k2", "apply(\"k2\")");
        this.addListener("omega1", "apply(\"omega1\")");
        this.addListener("omega2", "apply(\"omega2\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("time", "apply(\"time\")");
        this.addListener("showTime", "apply(\"showTime\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("nMaxPoints".equals(string)) {
            this._model.nMaxPoints = this.getInt("nMaxPoints");
        }
        if ("nPoints".equals(string)) {
            this._model.nPoints = this.getInt("nPoints");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            dArray = (double[])this.getValue("x").getObject();
            n2 = dArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = dArray[n];
            }
        }
        if ("y".equals(string)) {
            dArray = (double[])this.getValue("y").getObject();
            n2 = dArray.length;
            if (n2 > this._model.y.length) {
                n2 = this._model.y.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y[n] = dArray[n];
            }
        }
        if ("A1".equals(string)) {
            this._model.A1 = this.getDouble("A1");
        }
        if ("A2".equals(string)) {
            this._model.A2 = this.getDouble("A2");
        }
        if ("k1".equals(string)) {
            this._model.k1 = this.getDouble("k1");
        }
        if ("k2".equals(string)) {
            this._model.k2 = this.getDouble("k2");
        }
        if ("omega1".equals(string)) {
            this._model.omega1 = this.getDouble("omega1");
        }
        if ("omega2".equals(string)) {
            this._model.omega2 = this.getDouble("omega2");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("time".equals(string)) {
            this._model.time = this.getString("time");
        }
        if ("showTime".equals(string)) {
            this._model.showTime = this.getBoolean("showTime");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("nMaxPoints", this._model.nMaxPoints);
        this.setValue("nPoints", this._model.nPoints);
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("A1", this._model.A1);
        this.setValue("A2", this._model.A2);
        this.setValue("k1", this._model.k1);
        this.setValue("k2", this._model.k2);
        this.setValue("omega1", this._model.omega1);
        this.setValue("omega2", this._model.omega2);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("dt", this._model.dt);
        this.setValue("ymax", this._model.ymax);
        this.setValue("time", this._model.time);
        this.setValue("showTime", this._model.showTime);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Group velocity")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.Main.size", "640,360")).getObject();
        this.Plot = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Plot").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Plot_minimumY()%").setProperty("maximumY", "%_model._method_for_Plot_maximumY()%").setProperty("title", this._simulation.translateString("View.Plot.title", "Wave packet")).setProperty("titleX", this._simulation.translateString("View.Plot.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.Plot.titleY", "u(t,x)")).getObject();
        this.timeLabel = (InteractiveText)this.addElement(new ControlText(), "timeLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Plot").setProperty("x", "xmax").setProperty("y", "%_model._method_for_timeLabel_y()%").setProperty("visible", "showTime").setProperty("enabled", "true").setProperty("text", this._simulation.translateString("View.timeLabel.text", "%time%")).setProperty("elementposition", "SOUTH_EAST").setProperty("color", "blue").getObject();
        this.Wave = (InteractivePoligon)this.addElement(new ControlPoligon(), "Wave").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Plot").setProperty("maxpoints", "nPoints").setProperty("x", "x").setProperty("y", "y").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red").getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "grid:2,8,0,0").getObject();
        this.Amplitude1 = (JTextField)this.addElement(new ControlNumberField(), "Amplitude1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "A1").setProperty("format", this._simulation.translateString("View.Amplitude1.format", "A1 = 0.###")).setProperty("action", "_model._method_for_Amplitude1_action()").setProperty("tooltip", this._simulation.translateString("View.Amplitude1.tooltip", "First amplitude")).getObject();
        this.kMin = (JTextField)this.addElement(new ControlNumberField(), "kMin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "k1").setProperty("format", this._simulation.translateString("View.kMin.format", "k1 = 0.###")).setProperty("action", "_model._method_for_kMin_action()").setProperty("tooltip", this._simulation.translateString("View.kMin.tooltip", "First wave number")).getObject();
        this.Omega1 = (JTextField)this.addElement(new ControlNumberField(), "Omega1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "omega1").setProperty("format", this._simulation.translateString("View.Omega1.format", "$\\omega$1 = 0.###")).setProperty("action", "_model._method_for_Omega1_action()").setProperty("tooltip", this._simulation.translateString("View.Omega1.tooltip", "First frequency")).getObject();
        this.dT = (JTextField)this.addElement(new ControlNumberField(), "dT").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dT.format", "$\\delta$t = 0.#######")).setProperty("tooltip", this._simulation.translateString("View.dT.tooltip", "Animation step")).getObject();
        this.xMin = (JTextField)this.addElement(new ControlNumberField(), "xMin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "xmin").setProperty("format", this._simulation.translateString("View.xMin.format", "x1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMin.tooltip", "Minimum x")).getObject();
        this.xMax = (JTextField)this.addElement(new ControlNumberField(), "xMax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "xmax").setProperty("format", this._simulation.translateString("View.xMax.format", "x2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMax.tooltip", "Maximum x")).getObject();
        this.numPoints = (JTextField)this.addElement(new ControlNumberField(), "numPoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "nPoints").setProperty("format", this._simulation.translateString("View.numPoints.format", "0 points")).setProperty("tooltip", this._simulation.translateString("View.numPoints.tooltip", "Number of points")).getObject();
        this.Amplitude2 = (JTextField)this.addElement(new ControlNumberField(), "Amplitude2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "A2").setProperty("format", this._simulation.translateString("View.Amplitude2.format", "A2 = 0.###")).setProperty("action", "_model._method_for_Amplitude2_action()").setProperty("tooltip", this._simulation.translateString("View.Amplitude2.tooltip", "Second amplitude")).getObject();
        this.kMax = (JTextField)this.addElement(new ControlNumberField(), "kMax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "k2").setProperty("format", this._simulation.translateString("View.kMax.format", "k2 = 0.###")).setProperty("action", "_model._method_for_kMax_action()").setProperty("tooltip", this._simulation.translateString("View.kMax.tooltip", "Second wave number")).getObject();
        this.Omega2 = (JTextField)this.addElement(new ControlNumberField(), "Omega2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "omega2").setProperty("format", this._simulation.translateString("View.Omega2.format", "$\\omega$2 = 0.###")).setProperty("action", "_model._method_for_Omega2_action()").setProperty("tooltip", this._simulation.translateString("View.Omega2.tooltip", "Second frequency")).getObject();
        this.ShowTime = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowTime").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "showTime").setProperty("text", this._simulation.translateString("View.ShowTime.text", "Show Time")).setProperty("selectedimage", this._simulation.translateString("View.ShowTime.selectedimage", "images/time.gif")).setProperty("mnemonic", this._simulation.translateString("View.ShowTime.mnemonic", "d")).setProperty("tooltip", this._simulation.translateString("View.ShowTime.tooltip", "Show time values?")).getObject();
        this.Options = (JPanel)this.addElement(new ControlPanel(), "Options").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("layout", "grid:1,2,0,0").setProperty("tooltip", this._simulation.translateString("View.Options.tooltip", "Other options")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Options").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.initButton = (JButton)this.addElement(new ControlButton(), "initButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Options").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("action", "_model._method_for_initButton_action()").setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0 and select the initial conditions")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Options").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Group velocity")).setProperty("visible", "true");
        this.getElement("Plot").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Plot.title", "Wave packet")).setProperty("titleY", this._simulation.translateString("View.Plot.titleY", "u(t,x)"));
        this.getElement("timeLabel").setProperty("enabled", "true").setProperty("elementposition", "SOUTH_EAST").setProperty("color", "blue");
        this.getElement("Wave").setProperty("enabled", "false").setProperty("enabledSecondary", "false").setProperty("closed", "false").setProperty("secondaryColor", "red").setProperty("color", "red");
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Amplitude1").setProperty("format", this._simulation.translateString("View.Amplitude1.format", "A1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Amplitude1.tooltip", "First amplitude"));
        this.getElement("kMin").setProperty("format", this._simulation.translateString("View.kMin.format", "k1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.kMin.tooltip", "First wave number"));
        this.getElement("Omega1").setProperty("format", this._simulation.translateString("View.Omega1.format", "$\\omega$1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Omega1.tooltip", "First frequency"));
        this.getElement("dT").setProperty("format", this._simulation.translateString("View.dT.format", "$\\delta$t = 0.#######")).setProperty("tooltip", this._simulation.translateString("View.dT.tooltip", "Animation step"));
        this.getElement("xMin").setProperty("format", this._simulation.translateString("View.xMin.format", "x1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMin.tooltip", "Minimum x"));
        this.getElement("xMax").setProperty("format", this._simulation.translateString("View.xMax.format", "x2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.xMax.tooltip", "Maximum x"));
        this.getElement("numPoints").setProperty("format", this._simulation.translateString("View.numPoints.format", "0 points")).setProperty("tooltip", this._simulation.translateString("View.numPoints.tooltip", "Number of points"));
        this.getElement("Amplitude2").setProperty("format", this._simulation.translateString("View.Amplitude2.format", "A2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Amplitude2.tooltip", "Second amplitude"));
        this.getElement("kMax").setProperty("format", this._simulation.translateString("View.kMax.format", "k2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.kMax.tooltip", "Second wave number"));
        this.getElement("Omega2").setProperty("format", this._simulation.translateString("View.Omega2.format", "$\\omega$2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Omega2.tooltip", "Second frequency"));
        this.getElement("ShowTime").setProperty("text", this._simulation.translateString("View.ShowTime.text", "Show Time")).setProperty("selectedimage", this._simulation.translateString("View.ShowTime.selectedimage", "images/time.gif")).setProperty("mnemonic", this._simulation.translateString("View.ShowTime.mnemonic", "d")).setProperty("tooltip", this._simulation.translateString("View.ShowTime.tooltip", "Show time values?"));
        this.getElement("Options").setProperty("tooltip", this._simulation.translateString("View.Options.tooltip", "Other options"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("initButton").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0 and select the initial conditions"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

