/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.group_velocity;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.group_velocity.group_velocitySimulation;
import users.ehu.jma.waves.group_velocity.group_velocityView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class group_velocity
extends AbstractModel {
    public group_velocitySimulation _simulation = null;
    public group_velocityView _view = null;
    public group_velocity _model = this;
    public int nMaxPoints = 2000;
    public int nPoints = 1000;
    public double t = 0.0;
    public double[] x;
    public double[] y;
    public double A1 = 1.0;
    public double A2 = 1.0;
    public double k1 = 5.0;
    public double k2 = 5.5;
    public double omega1 = 5.0;
    public double omega2 = 5.5;
    public double xmin = -5.0;
    public double xmax = 50.0;
    public double dt = 0.1;
    public double ymax = 0.0;
    public String time = "time";
    public boolean showTime = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/group_velocity.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("images/time.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        group_velocity group_velocity2 = new group_velocity(stringArray);
    }

    public group_velocity() {
        this(null, null, null, null, null, false);
    }

    public group_velocity(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public group_velocity(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new group_velocitySimulation(this, string, frame, uRL, bl);
        this._view = (group_velocityView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.nPoints > this.nMaxPoints) {
            this.nPoints = this.nMaxPoints;
        } else if (this.nPoints < 2) {
            this.nPoints = 2;
        }
    }

    public void _constraints2() {
        double d = (this.xmax - this.xmin) / (double)(this.nPoints - 1);
        for (int i = 0; i < this.nPoints; ++i) {
            this.x[i] = this.xmin + d * (double)i;
        }
    }

    public void _constraints3() {
        for (int i = 0; i < this.nPoints; ++i) {
            double d = this.x[i];
            this.y[i] = this.A1 * Math.cos(this.k1 * d - this.omega1 * this.t) + this.A2 * Math.cos(this.k2 * d - this.omega2 * this.t);
        }
    }

    public void _constraints4() {
        this.ymax = this.A1 + this.A2;
        this.time = this._format(this.t, "t = 0.00");
    }

    public double _method_for_Plot_minimumY() {
        return -this.ymax;
    }

    public double _method_for_Plot_maximumY() {
        return this.ymax + 0.001;
    }

    public double _method_for_timeLabel_y() {
        return -this.ymax;
    }

    public void _method_for_Amplitude1_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_kMin_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Omega1_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Amplitude2_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_kMax_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Omega2_action() {
        this._simulation.disableLoop();
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_initButton_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.nMaxPoints = 2000;
        this.nPoints = 1000;
        this.t = 0.0;
        this.x = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.nMaxPoints];
        for (n = 0; n < this.nMaxPoints; ++n) {
            this.y[n] = 0.0;
        }
        this.A1 = 1.0;
        this.A2 = 1.0;
        this.k1 = 5.0;
        this.k2 = 5.5;
        this.omega1 = 5.0;
        this.omega2 = 5.5;
        this.xmin = -5.0;
        this.xmax = 50.0;
        this.dt = 0.1;
        this.ymax = 0.0;
        this.time = "time";
        this.showTime = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        System.gc();
    }
}

