/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.emwave;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.emwave.emwaveSimulation;
import users.ehu.jma.waves.emwave.emwaveView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class emwave
extends AbstractModel {
    public emwaveSimulation _simulation = null;
    public emwaveView _view = null;
    public emwave _model = this;
    public double t = 0.0;
    public double Ey = 10.0;
    public double Ez = 10.0;
    public double delta = 0.0;
    public double lambda = 10.0;
    public double k = Math.PI * 2 / this.lambda;
    public int N = 150;
    public double[] vEy;
    public double[] vEz;
    public double[] vBz;
    public double[] vBy;
    public double[] xPos;
    public double x1 = 0.0;
    public double x2 = 40.0;
    public double dx = 0.0;
    public boolean showEy = false;
    public boolean showEz = false;
    public boolean showE = true;
    public boolean showBz = false;
    public boolean showBy = false;
    public boolean showB = false;
    public double alpha = 1.2;
    public double beta = 0.5;
    public double xmin = -2.0;
    public double xmax = 42.0;
    public double ymax = 7.0;
    public double dt = 0.1;
    public double deltaDegrees = 0.0;
    public double xp = this.x2 / 2.0;
    public double yp = 0.0;
    public double zp = 0.0;
    public int Npoint = 1000;
    public boolean showField = false;
    public boolean showTraj = false;
    public int point = 0;
    public double xc = 35.0;
    public double yc = 0.0;
    public double zc = 12.0;
    public double dxc = 5.0;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/emwave.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        emwave emwave2 = new emwave(stringArray);
    }

    public emwave() {
        this(null, null, null, null, null, false);
    }

    public emwave(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public emwave(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new emwaveSimulation(this, string, frame, uRL, bl);
        this._view = (emwaveView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.dx = (this.x2 - this.x1) / (double)(this.N - 1);
        for (int i = 0; i < this.N; ++i) {
            this.xPos[i] = this.dx * (double)i;
        }
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        for (int i = 0; i < this.N; ++i) {
            this.vEy[i] = this.vBz[i] = this.Ey * Math.cos(this.k * (this.dx * (double)i - this.t));
            this.vEz[i] = this.Ez * Math.cos(this.k * (this.dx * (double)i - this.t) + this.delta);
            this.vBy[i] = -this.vEz[i];
        }
    }

    public void _constraints2() {
        if (this.xp > this.x2) {
            this.xp = this.x2;
        } else if (this.xp < this.x1) {
            this.xp = this.x1;
        }
        this.point = (int)((this.xp - this.x1) / this.dx);
        if (this.point < 0) {
            this.point = 0;
        } else if (this.point >= this.N) {
            this.point = this.N;
        }
        this.xp = this.x1 + (double)this.point * this.dx;
        this.zp = 0.0;
        this.yp = 0.0;
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public double _method_for_Panel3D_minimumY() {
        return -this.ymax;
    }

    public double _method_for_Panel3D_minimumZ() {
        return -this.ymax;
    }

    public double _method_for_Field_sizey() {
        return this.vEy[this.point];
    }

    public double _method_for_Field_sizez() {
        return this.vEz[this.point];
    }

    public void _method_for_Field_dragaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_Trajectory_y() {
        return this.vEy[this.point];
    }

    public double _method_for_Trajectory_z() {
        return this.vEz[this.point];
    }

    public double _method_for_Labelc_x() {
        return this.xc + 0.5 * this.dxc;
    }

    public double _method_for_Labelc_z() {
        return this.zc + 1.0;
    }

    public void _method_for_Ey_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Ez_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Phase_action() {
        this._simulation.disableLoop();
        this.delta = this.deltaDegrees * Math.PI / 180.0;
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Lambda_action() {
        this._simulation.disableLoop();
        this.k = Math.PI * 2 / this.lambda;
        this._simulation.enableLoop();
    }

    public void _method_for_xp_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_TrajectoryOn_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.Ey = 10.0;
        this.Ez = 10.0;
        this.delta = 0.0;
        this.lambda = 10.0;
        this.k = Math.PI * 2 / this.lambda;
        this.N = 150;
        this.vEy = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            this.vEy[n] = 0.0;
        }
        this.vEz = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            this.vEz[n] = 0.0;
        }
        this.vBz = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            this.vBz[n] = 0.0;
        }
        this.vBy = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            this.vBy[n] = 0.0;
        }
        this.xPos = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            this.xPos[n] = 0.0;
        }
        this.x1 = 0.0;
        this.x2 = 40.0;
        this.dx = 0.0;
        this.showEy = false;
        this.showEz = false;
        this.showE = true;
        this.showBz = false;
        this.showBy = false;
        this.showB = false;
        this.alpha = 1.2;
        this.beta = 0.5;
        this.xmin = -2.0;
        this.xmax = 42.0;
        this.ymax = 7.0;
        this.dt = 0.1;
        this.deltaDegrees = 0.0;
        this.xp = this.x2 / 2.0;
        this.yp = 0.0;
        this.zp = 0.0;
        this.Npoint = 1000;
        this.showField = false;
        this.showTraj = false;
        this.point = 0;
        this.xc = 35.0;
        this.yc = 0.0;
        this.zc = 12.0;
        this.dxc = 5.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.vEy = null;
        this.vEz = null;
        this.vBz = null;
        this.vBy = null;
        this.xPos = null;
        System.gc();
    }
}

