/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.doppler;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlArrowSet;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.waves.doppler.doppler;
import users.ehu.jma.waves.doppler.dopplerSimulation;

class dopplerView
extends EjsControl
implements View {
    private dopplerSimulation _simulation = null;
    private doppler _model = null;
    public Component Main;
    public JPanel Top;
    public JPanel Up;
    public DrawingPanel2D Space;
    public ElementSet Waves;
    public InteractiveParticle Source;
    public InteractiveParticle Detector;
    public JPanel Down;
    public PlottingPanel2D Times;
    public ElementSet EmissionTimes;
    public ElementSet DetectionTimes;
    public InteractiveArrow Time;
    public JPanel Bottom;
    public JPanel Cursors;
    public JTextField c;
    public JTextField v;
    public JTextField T;
    public JTextField x;
    public JTextField y;
    public JTextField ux;
    public JTextField uy;
    public JPanel Buttons;
    public JTextField Vx;
    public JTextField Vy;
    public JTextField dt;
    public JButton startButton;
    public JButton stepButton;
    public JButton initButton;
    public JButton resetButton;

    public dopplerView(dopplerSimulation dopplerSimulation2, String string, Frame frame) {
        super(dopplerSimulation2, string, frame);
        this._simulation = dopplerSimulation2;
        this._model = (doppler)dopplerSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("n", "apply(\"n\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("y0", "apply(\"y0\")");
        this.addListener("d", "apply(\"d\")");
        this.addListener("vd", "apply(\"vd\")");
        this.addListener("c", "apply(\"c\")");
        this.addListener("T", "apply(\"T\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("Vx", "apply(\"Vx\")");
        this.addListener("Vy", "apply(\"Vy\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("ux", "apply(\"ux\")");
        this.addListener("uy", "apply(\"uy\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("nDetected", "apply(\"nDetected\")");
        this.addListener("nEmitted", "apply(\"nEmitted\")");
        this.addListener("tDetected", "apply(\"tDetected\")");
        this.addListener("tEmitted", "apply(\"tEmitted\")");
        this.addListener("bDetected", "apply(\"bDetected\")");
        this.addListener("yaxis", "apply(\"yaxis\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        Object[] objectArray;
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("x0".equals(string)) {
            objectArray = (double[])this.getValue("x0").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.x0.length) {
                n2 = this._model.x0.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x0[n] = objectArray[n];
            }
        }
        if ("y0".equals(string)) {
            objectArray = (double[])this.getValue("y0").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.y0.length) {
                n2 = this._model.y0.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y0[n] = objectArray[n];
            }
        }
        if ("d".equals(string)) {
            objectArray = (double[])this.getValue("d").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.d.length) {
                n2 = this._model.d.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.d[n] = objectArray[n];
            }
        }
        if ("vd".equals(string)) {
            objectArray = (double[])this.getValue("vd").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.vd.length) {
                n2 = this._model.vd.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.vd[n] = objectArray[n];
            }
        }
        if ("c".equals(string)) {
            this._model.c = this.getDouble("c");
        }
        if ("T".equals(string)) {
            this._model.T = this.getDouble("T");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("Vx".equals(string)) {
            this._model.Vx = this.getDouble("Vx");
        }
        if ("Vy".equals(string)) {
            this._model.Vy = this.getDouble("Vy");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("ux".equals(string)) {
            this._model.ux = this.getDouble("ux");
        }
        if ("uy".equals(string)) {
            this._model.uy = this.getDouble("uy");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("nDetected".equals(string)) {
            this._model.nDetected = this.getInt("nDetected");
        }
        if ("nEmitted".equals(string)) {
            this._model.nEmitted = this.getInt("nEmitted");
        }
        if ("tDetected".equals(string)) {
            objectArray = (double[])this.getValue("tDetected").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.tDetected.length) {
                n2 = this._model.tDetected.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.tDetected[n] = objectArray[n];
            }
        }
        if ("tEmitted".equals(string)) {
            objectArray = (double[])this.getValue("tEmitted").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.tEmitted.length) {
                n2 = this._model.tEmitted.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.tEmitted[n] = objectArray[n];
            }
        }
        if ("bDetected".equals(string)) {
            objectArray = (boolean[])this.getValue("bDetected").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.bDetected.length) {
                n2 = this._model.bDetected.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.bDetected[n] = objectArray[n];
            }
        }
        if ("yaxis".equals(string)) {
            this._model.yaxis = this.getString("yaxis");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("n", this._model.n);
        this.setValue("x0", this._model.x0);
        this.setValue("y0", this._model.y0);
        this.setValue("d", this._model.d);
        this.setValue("vd", this._model.vd);
        this.setValue("c", this._model.c);
        this.setValue("T", this._model.T);
        this.setValue("v", this._model.v);
        this.setValue("Vx", this._model.Vx);
        this.setValue("Vy", this._model.Vy);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("ux", this._model.ux);
        this.setValue("uy", this._model.uy);
        this.setValue("t", this._model.t);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("dt", this._model.dt);
        this.setValue("nDetected", this._model.nDetected);
        this.setValue("nEmitted", this._model.nEmitted);
        this.setValue("tDetected", this._model.tDetected);
        this.setValue("tEmitted", this._model.tEmitted);
        this.setValue("bDetected", this._model.bDetected);
        this.setValue("yaxis", this._model.yaxis);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Doppler effect")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "640,480")).getObject();
        this.Top = (JPanel)this.addElement(new ControlPanel(), "Top").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "vbox").getObject();
        this.Up = (JPanel)this.addElement(new ControlPanel(), "Up").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Top").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.Up.size", "0,400")).getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Up").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to move the detector")).getObject();
        this.Waves = (ElementSet)this.addElement(new ControlParticleSet(), "Waves").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("elementnumber", "n").setProperty("x", "x0").setProperty("y", "y0").setProperty("sizex", "d").setProperty("sizey", "d").setProperty("enabled", "false").setProperty("style", "CIRCLE").setProperty("secondaryColor", "blue").setProperty("color", "NULL").getObject();
        this.Source = (InteractiveParticle)this.addElement(new ControlParticle(), "Source").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_Source_x()%").setProperty("y", "0").setProperty("sizex", "200").setProperty("sizey", "200").setProperty("enabled", "false").setProperty("secondaryColor", "red").setProperty("color", "red").getObject();
        this.Detector = (InteractiveParticle)this.addElement(new ControlParticle(), "Detector").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", "300").setProperty("sizey", "300").setProperty("enabled", "true").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Top").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.Down.size", "0,200")).getObject();
        this.Times = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Times").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-1.25").setProperty("maximumY", "1.25").setProperty("title", this._simulation.translateString("View.Times.title", "Emissions and detections")).setProperty("axesType", "Cartesian2").setProperty("titleX", this._simulation.translateString("View.Times.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Times.titleY", "%yaxis%")).setProperty("majorTicksY", "false").setProperty("xFormat", this._simulation.translateString("View.Times.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Times.yFormat", "%yaxis%")).setProperty("background", "240,240,240,255").setProperty("tooltip", this._simulation.translateString("View.Times.tooltip", "Times at which emissions and detections happen")).getObject();
        this.EmissionTimes = (ElementSet)this.addElement(new ControlArrowSet(), "EmissionTimes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("elementnumber", "n").setProperty("x", "tEmitted").setProperty("y", "-1.0").setProperty("sizex", "0").setProperty("sizey", ".75").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3").getObject();
        this.DetectionTimes = (ElementSet)this.addElement(new ControlArrowSet(), "DetectionTimes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("elementnumber", "n").setProperty("x", "tDetected").setProperty("y", ".25").setProperty("sizex", "0").setProperty("sizey", ".75").setProperty("visible", "bDetected").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").setProperty("stroke", "3").getObject();
        this.Time = (InteractiveArrow)this.addElement(new ControlArrow(), "Time").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "t").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("color", "blue").getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Cursors = (JPanel)this.addElement(new ControlPanel(), "Cursors").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Bottom").setProperty("layout", "grid:1,7,0,0").getObject();
        this.c = (JTextField)this.addElement(new ControlNumberField(), "c").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "c").setProperty("format", this._simulation.translateString("View.c.format", "c = 0.##")).setProperty("action", "_model._method_for_c_action()").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.c.tooltip", "Sound speed")).getObject();
        this.v = (JTextField)this.addElement(new ControlNumberField(), "v").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "v").setProperty("format", this._simulation.translateString("View.v.format", "v = 0.##")).setProperty("action", "_model._method_for_v_action()").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.v.tooltip", "Source velocity")).getObject();
        this.T = (JTextField)this.addElement(new ControlNumberField(), "T").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "T").setProperty("format", this._simulation.translateString("View.T.format", "T = 0.##")).setProperty("tooltip", this._simulation.translateString("View.T.tooltip", "Period (in the source system)")).getObject();
        this.x = (JTextField)this.addElement(new ControlNumberField(), "x").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "x").setProperty("format", this._simulation.translateString("View.x.format", "x = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.x.tooltip", "x coordinate of the detector")).getObject();
        this.y = (JTextField)this.addElement(new ControlNumberField(), "y").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "y").setProperty("format", this._simulation.translateString("View.y.format", "y = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.y.tooltip", "y coordinate of the detector")).getObject();
        this.ux = (JTextField)this.addElement(new ControlNumberField(), "ux").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "ux").setProperty("format", this._simulation.translateString("View.ux.format", "dx/dt = 0.##")).setProperty("action", "_model._method_for_ux_action()").setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.ux.tooltip", "x component of the detector velocity")).getObject();
        this.uy = (JTextField)this.addElement(new ControlNumberField(), "uy").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Cursors").setProperty("variable", "uy").setProperty("format", this._simulation.translateString("View.uy.format", "dy/dt = 0.##")).setProperty("action", "_model._method_for_uy_action()").setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.uy.tooltip", "y component of the detector velocity")).getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "grid:1,6,0,0").getObject();
        this.Vx = (JTextField)this.addElement(new ControlNumberField(), "Vx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "Vx").setProperty("format", this._simulation.translateString("View.Vx.format", "Vx = 0.##")).setProperty("action", "_model._method_for_Vx_action()").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Vx.tooltip", "x component of the wind velocity")).getObject();
        this.Vy = (JTextField)this.addElement(new ControlNumberField(), "Vy").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "Vy").setProperty("format", this._simulation.translateString("View.Vy.format", "Vy = 0.##")).setProperty("action", "_model._method_for_Vy_action()").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Vy.tooltip", "y component of the wind velocity")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step length")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.initButton = (JButton)this.addElement(new ControlButton(), "initButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("mnemonic", this._simulation.translateString("View.initButton.mnemonic", "i")).setProperty("action", "_model._method_for_initButton_action()").setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0 and select initial conditions")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Doppler effect")).setProperty("visible", "true");
        this.getElement("Top");
        this.getElement("Up").setProperty("size", this._simulation.translateString("View.Up.size", "0,400"));
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to move the detector"));
        this.getElement("Waves").setProperty("enabled", "false").setProperty("style", "CIRCLE").setProperty("secondaryColor", "blue").setProperty("color", "NULL");
        this.getElement("Source").setProperty("y", "0").setProperty("sizex", "200").setProperty("sizey", "200").setProperty("enabled", "false").setProperty("secondaryColor", "red").setProperty("color", "red");
        this.getElement("Detector").setProperty("sizex", "300").setProperty("sizey", "300").setProperty("enabled", "true").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255");
        this.getElement("Down").setProperty("size", this._simulation.translateString("View.Down.size", "0,200"));
        this.getElement("Times").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-1.25").setProperty("maximumY", "1.25").setProperty("title", this._simulation.translateString("View.Times.title", "Emissions and detections")).setProperty("axesType", "Cartesian2").setProperty("majorTicksY", "false").setProperty("xFormat", this._simulation.translateString("View.Times.xFormat", "t = 0.###")).setProperty("background", "240,240,240,255").setProperty("tooltip", this._simulation.translateString("View.Times.tooltip", "Times at which emissions and detections happen"));
        this.getElement("EmissionTimes").setProperty("y", "-1.0").setProperty("sizex", "0").setProperty("sizey", ".75").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3");
        this.getElement("DetectionTimes").setProperty("y", ".25").setProperty("sizex", "0").setProperty("sizey", ".75").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").setProperty("stroke", "3");
        this.getElement("Time").setProperty("x", "0").setProperty("y", "0").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("color", "blue");
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Cursors");
        this.getElement("c").setProperty("format", this._simulation.translateString("View.c.format", "c = 0.##")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.c.tooltip", "Sound speed"));
        this.getElement("v").setProperty("format", this._simulation.translateString("View.v.format", "v = 0.##")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.v.tooltip", "Source velocity"));
        this.getElement("T").setProperty("format", this._simulation.translateString("View.T.format", "T = 0.##")).setProperty("tooltip", this._simulation.translateString("View.T.tooltip", "Period (in the source system)"));
        this.getElement("x").setProperty("format", this._simulation.translateString("View.x.format", "x = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.x.tooltip", "x coordinate of the detector"));
        this.getElement("y").setProperty("format", this._simulation.translateString("View.y.format", "y = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.y.tooltip", "y coordinate of the detector"));
        this.getElement("ux").setProperty("format", this._simulation.translateString("View.ux.format", "dx/dt = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.ux.tooltip", "x component of the detector velocity"));
        this.getElement("uy").setProperty("format", this._simulation.translateString("View.uy.format", "dy/dt = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.uy.tooltip", "y component of the detector velocity"));
        this.getElement("Buttons");
        this.getElement("Vx").setProperty("format", this._simulation.translateString("View.Vx.format", "Vx = 0.##")).setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Vx.tooltip", "x component of the wind velocity"));
        this.getElement("Vy").setProperty("format", this._simulation.translateString("View.Vy.format", "Vy = 0.##")).setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Vy.tooltip", "y component of the wind velocity"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step length"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("initButton").setProperty("image", this._simulation.translateString("View.initButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("mnemonic", this._simulation.translateString("View.initButton.mnemonic", "i")).setProperty("tooltip", this._simulation.translateString("View.initButton.tooltip", "Set t = 0 and select initial conditions"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

