/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.doppler;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Euler;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.doppler.dopplerSimulation;
import users.ehu.jma.waves.doppler.dopplerView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class doppler
extends AbstractModel {
    public dopplerSimulation _simulation = null;
    public dopplerView _view = null;
    public doppler _model = this;
    public int n = 50;
    public double[] x0;
    public double[] y0;
    public double[] d;
    public double[] vd;
    public double c = 340.0;
    public double T = 2.0;
    public double v = 170.0;
    public double Vx = 0.0;
    public double Vy = 0.0;
    public double x = 6000.0;
    public double y = 0.0;
    public double ux = 0.0;
    public double uy = 0.0;
    public double t = 0.0;
    public double xmin = -2000.0;
    public double xmax = 15000.0;
    public double ymin = -5000.0;
    public double ymax = 5000.0;
    public double dt = 0.1;
    public int nDetected = 0;
    public int nEmitted = 50;
    public double[] tDetected;
    public double[] tEmitted;
    public boolean[] bDetected;
    public String yaxis = "y";
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/doppler.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        doppler doppler2 = new doppler(stringArray);
    }

    public doppler() {
        this(null, null, null, null, null, false);
    }

    public doppler(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public doppler(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new dopplerSimulation(this, string, frame, uRL, bl);
        this._view = (dopplerView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.nDetected = 0;
        this.nEmitted = 1;
        for (int i = 0; i < this.n; ++i) {
            this.tDetected[i] = 0.0;
            this.tEmitted[i] = 0.0;
            this.vd[i] = 0.0;
            this.d[i] = 0.0;
            this.y0[i] = 0.0;
            this.x0[i] = 0.0;
            this.bDetected[i] = false;
        }
        this.vd[0] = 2.0 * this.c;
    }

    public void _constraints1() {
        if (this.c < 0.0) {
            this.c = -this.c;
        }
        while (this.hypot(this.Vx, this.Vy) >= this.c) {
            this.Vx *= 0.5;
            this.Vy *= 0.5;
        }
    }

    public void _constraints2() {
        for (int i = 0; i < this.n; ++i) {
            if ((double)i * this.T - 0.5 * this.dt < this.t) {
                double d = (double)i * this.T;
                this.x0[i] = this.Vx * (this.t - d) + this.v * d;
                this.y0[i] = this.Vy * (this.t - d);
                this.d[i] = 2.0 * this.c * (this.t - d);
                this.nEmitted = i;
                this.tEmitted[this.nEmitted] = d;
                continue;
            }
            this.x0[i] = this.v * this.t;
        }
    }

    public void _constraints3() {
        if (this.nDetected >= this.n) {
            this._pause();
        }
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public double _method_for_Source_x() {
        return this.v * this.t;
    }

    public void _method_for_c_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_v_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ux_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_uy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Vx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Vy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_initButton_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.n = 50;
        this.x0 = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x0[n] = 0.0;
        }
        this.y0 = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.y0[n] = 0.0;
        }
        this.d = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.d[n] = 0.0;
        }
        this.vd = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.vd[n] = 0.0;
        }
        this.c = 340.0;
        this.T = 2.0;
        this.v = 170.0;
        this.Vx = 0.0;
        this.Vy = 0.0;
        this.x = 6000.0;
        this.y = 0.0;
        this.ux = 0.0;
        this.uy = 0.0;
        this.t = 0.0;
        this.xmin = -2000.0;
        this.xmax = 15000.0;
        this.ymin = -5000.0;
        this.ymax = 5000.0;
        this.dt = 0.1;
        this.nDetected = 0;
        this.nEmitted = 50;
        this.tDetected = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.tDetected[n] = 0.0;
        }
        this.tEmitted = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.tEmitted[n] = 0.0;
        }
        this.bDetected = new boolean[this.n];
        for (n = 0; n < this.n; ++n) {
            this.bDetected[n] = false;
        }
        this.yaxis = "y";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.x0 = null;
        this.y0 = null;
        this.d = null;
        this.vd = null;
        this.tDetected = null;
        this.tEmitted = null;
        this.bDetected = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _y;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = doppler.this.x;
            this.__state[n++] = doppler.this.y;
            this.__state[n++] = doppler.this.t;
            this.__solver = new ODEBisectionEventSolver(this, Euler.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(doppler.this.dt);
        }

        void step() {
            if (doppler.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(doppler.this.dt);
            }
            int n = 0;
            this.__state[n++] = doppler.this.x;
            this.__state[n++] = doppler.this.y;
            this.__state[n++] = doppler.this.t;
            this.__solver.step();
            n = 0;
            doppler.this.x = this.__state[n++];
            doppler.this.y = this.__state[n++];
            doppler.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._y, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._y, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return doppler.this.ux;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return doppler.this.uy;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Detection";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3) {
                double d4 = 0.001;
                if (doppler.this.nDetected > doppler.this.nEmitted) {
                    return d4;
                }
                double d5 = doppler.this.hypot(d - doppler.this.x0[doppler.this.nDetected], d2 - doppler.this.y0[doppler.this.nDetected]) - doppler.this.c * (d3 - (double)doppler.this.nDetected * doppler.this.T);
                if (d5 < d4) {
                    d4 = d5;
                }
                return d4;
            }

            public boolean action() {
                int n = 0;
                doppler.this.x = _ODE_evolution1.this.__state[n++];
                doppler.this.y = _ODE_evolution1.this.__state[n++];
                doppler.this.t = _ODE_evolution1.this.__state[n++];
                doppler.this.bDetected[doppler.this.nDetected] = true;
                doppler.this.tDetected[doppler.this.nDetected++] = doppler.this.t;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = doppler.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = doppler.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = doppler.this.t;
                return true;
            }
        }
    }
}

