/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.brewster;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.display3d.ControlDrawingPanel3D;
import org.colos.ejs.library.control.display3d.ControlElement3DArrow;
import org.colos.ejs.library.control.display3d.ControlElement3DPlane;
import org.colos.ejs.library.control.display3d.ControlElement3DText;
import org.colos.ejs.library.control.display3d.ControlSegmentSet3D;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.ElementArrow;
import org.opensourcephysics.display3d.core.ElementPlane;
import org.opensourcephysics.display3d.core.ElementText;
import org.opensourcephysics.display3d.core.Group;
import users.ehu.jma.waves.brewster.brewster;
import users.ehu.jma.waves.brewster.brewsterSimulation;

class brewsterView
extends EjsControl
implements View {
    private brewsterSimulation _simulation = null;
    private brewster _model = null;
    public Component Main;
    public JPanel Figure;
    public JSlider Alpha;
    public JSlider Beta;
    public DrawingPanel3D Space;
    public ElementArrow Xaxis;
    public ElementArrow Yaxis;
    public ElementArrow Zaxis;
    public ElementText Xlabel;
    public ElementText Ylabel;
    public ElementText Zlabel;
    public Group Eipar;
    public Group Eiper;
    public Group Ei;
    public ElementArrow Iray;
    public Group Efpar;
    public Group Efper;
    public Group Ef;
    public ElementArrow Fray;
    public Group Erpar;
    public Group Erper;
    public Group Er;
    public ElementArrow Rray;
    public ElementPlane IncidencePlane;
    public ElementPlane Boundary;
    public JPanel Left;
    public JSlider Incidence;
    public JTextField Refraction;
    public JPanel Bottom;
    public JPanel Sliders;
    public JSlider n2n1;
    public JSlider Eparallel;
    public JSlider Eperpendicular;
    public JSlider Phase;
    public JSlider Lambda;
    public JSlider dt;
    public JPanel Controls;
    public JPanel Fields;
    public JCheckBox sE;
    public JCheckBox ShowSurface;
    public JCheckBox ShowIncidence;
    public JCheckBox ShowAxes;
    public JTextField Nvalue;
    public JPanel Right;
    public JPanel Buttons;
    public JButton startButton;
    public JButton resetButton;

    public brewsterView(brewsterSimulation brewsterSimulation2, String string, Frame frame) {
        super(brewsterSimulation2, string, frame);
        this._simulation = brewsterSimulation2;
        this._model = (brewster)brewsterSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("Epar", "apply(\"Epar\")");
        this.addListener("Eper", "apply(\"Eper\")");
        this.addListener("delta", "apply(\"delta\")");
        this.addListener("lambda", "apply(\"lambda\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("thetai", "apply(\"thetai\")");
        this.addListener("thetar", "apply(\"thetar\")");
        this.addListener("n2", "apply(\"n2\")");
        this.addListener("Nmax", "apply(\"Nmax\")");
        this.addListener("N", "apply(\"N\")");
        this.addListener("Eix", "apply(\"Eix\")");
        this.addListener("Eiy", "apply(\"Eiy\")");
        this.addListener("Eiz", "apply(\"Eiz\")");
        this.addListener("Efx", "apply(\"Efx\")");
        this.addListener("Efy", "apply(\"Efy\")");
        this.addListener("Efz", "apply(\"Efz\")");
        this.addListener("Erx", "apply(\"Erx\")");
        this.addListener("Ery", "apply(\"Ery\")");
        this.addListener("Erz", "apply(\"Erz\")");
        this.addListener("yi", "apply(\"yi\")");
        this.addListener("zi", "apply(\"zi\")");
        this.addListener("yf", "apply(\"yf\")");
        this.addListener("zf", "apply(\"zf\")");
        this.addListener("yr", "apply(\"yr\")");
        this.addListener("zr", "apply(\"zr\")");
        this.addListener("length", "apply(\"length\")");
        this.addListener("showE", "apply(\"showE\")");
        this.addListener("totalReflection", "apply(\"totalReflection\")");
        this.addListener("alpha", "apply(\"alpha\")");
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("deltaDegrees", "apply(\"deltaDegrees\")");
        this.addListener("thetaiDegrees", "apply(\"thetaiDegrees\")");
        this.addListener("thetarDegrees", "apply(\"thetarDegrees\")");
        this.addListener("csi", "apply(\"csi\")");
        this.addListener("sni", "apply(\"sni\")");
        this.addListener("csr", "apply(\"csr\")");
        this.addListener("snr", "apply(\"snr\")");
        this.addListener("showSurface", "apply(\"showSurface\")");
        this.addListener("showIncidence", "apply(\"showIncidence\")");
        this.addListener("showAxes", "apply(\"showAxes\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("Epar".equals(string)) {
            this._model.Epar = this.getDouble("Epar");
        }
        if ("Eper".equals(string)) {
            this._model.Eper = this.getDouble("Eper");
        }
        if ("delta".equals(string)) {
            this._model.delta = this.getDouble("delta");
        }
        if ("lambda".equals(string)) {
            this._model.lambda = this.getDouble("lambda");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("thetai".equals(string)) {
            this._model.thetai = this.getDouble("thetai");
        }
        if ("thetar".equals(string)) {
            this._model.thetar = this.getDouble("thetar");
        }
        if ("n2".equals(string)) {
            this._model.n2 = this.getDouble("n2");
        }
        if ("Nmax".equals(string)) {
            this._model.Nmax = this.getInt("Nmax");
        }
        if ("N".equals(string)) {
            this._model.N = this.getInt("N");
        }
        if ("Eix".equals(string)) {
            dArray = (double[])this.getValue("Eix").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Eix.length) {
                n2 = this._model.Eix.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Eix[n] = dArray[n];
            }
        }
        if ("Eiy".equals(string)) {
            dArray = (double[])this.getValue("Eiy").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Eiy.length) {
                n2 = this._model.Eiy.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Eiy[n] = dArray[n];
            }
        }
        if ("Eiz".equals(string)) {
            dArray = (double[])this.getValue("Eiz").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Eiz.length) {
                n2 = this._model.Eiz.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Eiz[n] = dArray[n];
            }
        }
        if ("Efx".equals(string)) {
            dArray = (double[])this.getValue("Efx").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Efx.length) {
                n2 = this._model.Efx.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Efx[n] = dArray[n];
            }
        }
        if ("Efy".equals(string)) {
            dArray = (double[])this.getValue("Efy").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Efy.length) {
                n2 = this._model.Efy.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Efy[n] = dArray[n];
            }
        }
        if ("Efz".equals(string)) {
            dArray = (double[])this.getValue("Efz").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Efz.length) {
                n2 = this._model.Efz.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Efz[n] = dArray[n];
            }
        }
        if ("Erx".equals(string)) {
            dArray = (double[])this.getValue("Erx").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Erx.length) {
                n2 = this._model.Erx.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Erx[n] = dArray[n];
            }
        }
        if ("Ery".equals(string)) {
            dArray = (double[])this.getValue("Ery").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Ery.length) {
                n2 = this._model.Ery.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Ery[n] = dArray[n];
            }
        }
        if ("Erz".equals(string)) {
            dArray = (double[])this.getValue("Erz").getObject();
            n2 = dArray.length;
            if (n2 > this._model.Erz.length) {
                n2 = this._model.Erz.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.Erz[n] = dArray[n];
            }
        }
        if ("yi".equals(string)) {
            dArray = (double[])this.getValue("yi").getObject();
            n2 = dArray.length;
            if (n2 > this._model.yi.length) {
                n2 = this._model.yi.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.yi[n] = dArray[n];
            }
        }
        if ("zi".equals(string)) {
            dArray = (double[])this.getValue("zi").getObject();
            n2 = dArray.length;
            if (n2 > this._model.zi.length) {
                n2 = this._model.zi.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.zi[n] = dArray[n];
            }
        }
        if ("yf".equals(string)) {
            dArray = (double[])this.getValue("yf").getObject();
            n2 = dArray.length;
            if (n2 > this._model.yf.length) {
                n2 = this._model.yf.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.yf[n] = dArray[n];
            }
        }
        if ("zf".equals(string)) {
            dArray = (double[])this.getValue("zf").getObject();
            n2 = dArray.length;
            if (n2 > this._model.zf.length) {
                n2 = this._model.zf.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.zf[n] = dArray[n];
            }
        }
        if ("yr".equals(string)) {
            dArray = (double[])this.getValue("yr").getObject();
            n2 = dArray.length;
            if (n2 > this._model.yr.length) {
                n2 = this._model.yr.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.yr[n] = dArray[n];
            }
        }
        if ("zr".equals(string)) {
            dArray = (double[])this.getValue("zr").getObject();
            n2 = dArray.length;
            if (n2 > this._model.zr.length) {
                n2 = this._model.zr.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.zr[n] = dArray[n];
            }
        }
        if ("length".equals(string)) {
            this._model.length = this.getDouble("length");
        }
        if ("showE".equals(string)) {
            this._model.showE = this.getBoolean("showE");
        }
        if ("totalReflection".equals(string)) {
            this._model.totalReflection = this.getBoolean("totalReflection");
        }
        if ("alpha".equals(string)) {
            this._model.alpha = this.getDouble("alpha");
        }
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("deltaDegrees".equals(string)) {
            this._model.deltaDegrees = this.getDouble("deltaDegrees");
        }
        if ("thetaiDegrees".equals(string)) {
            this._model.thetaiDegrees = this.getDouble("thetaiDegrees");
        }
        if ("thetarDegrees".equals(string)) {
            this._model.thetarDegrees = this.getDouble("thetarDegrees");
        }
        if ("csi".equals(string)) {
            this._model.csi = this.getDouble("csi");
        }
        if ("sni".equals(string)) {
            this._model.sni = this.getDouble("sni");
        }
        if ("csr".equals(string)) {
            this._model.csr = this.getDouble("csr");
        }
        if ("snr".equals(string)) {
            this._model.snr = this.getDouble("snr");
        }
        if ("showSurface".equals(string)) {
            this._model.showSurface = this.getBoolean("showSurface");
        }
        if ("showIncidence".equals(string)) {
            this._model.showIncidence = this.getBoolean("showIncidence");
        }
        if ("showAxes".equals(string)) {
            this._model.showAxes = this.getBoolean("showAxes");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("Epar", this._model.Epar);
        this.setValue("Eper", this._model.Eper);
        this.setValue("delta", this._model.delta);
        this.setValue("lambda", this._model.lambda);
        this.setValue("k", this._model.k);
        this.setValue("thetai", this._model.thetai);
        this.setValue("thetar", this._model.thetar);
        this.setValue("n2", this._model.n2);
        this.setValue("Nmax", this._model.Nmax);
        this.setValue("N", this._model.N);
        this.setValue("Eix", this._model.Eix);
        this.setValue("Eiy", this._model.Eiy);
        this.setValue("Eiz", this._model.Eiz);
        this.setValue("Efx", this._model.Efx);
        this.setValue("Efy", this._model.Efy);
        this.setValue("Efz", this._model.Efz);
        this.setValue("Erx", this._model.Erx);
        this.setValue("Ery", this._model.Ery);
        this.setValue("Erz", this._model.Erz);
        this.setValue("yi", this._model.yi);
        this.setValue("zi", this._model.zi);
        this.setValue("yf", this._model.yf);
        this.setValue("zf", this._model.zf);
        this.setValue("yr", this._model.yr);
        this.setValue("zr", this._model.zr);
        this.setValue("length", this._model.length);
        this.setValue("showE", this._model.showE);
        this.setValue("totalReflection", this._model.totalReflection);
        this.setValue("alpha", this._model.alpha);
        this.setValue("beta", this._model.beta);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymax", this._model.ymax);
        this.setValue("dt", this._model.dt);
        this.setValue("deltaDegrees", this._model.deltaDegrees);
        this.setValue("thetaiDegrees", this._model.thetaiDegrees);
        this.setValue("thetarDegrees", this._model.thetarDegrees);
        this.setValue("csi", this._model.csi);
        this.setValue("sni", this._model.sni);
        this.setValue("csr", this._model.csr);
        this.setValue("snr", this._model.snr);
        this.setValue("showSurface", this._model.showSurface);
        this.setValue("showIncidence", this._model.showIncidence);
        this.setValue("showAxes", this._model.showAxes);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Reflection and refraction of electromagnetic waves")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "4,0").setProperty("size", this._simulation.translateString("View.Main.size", "640,540")).getObject();
        this.Figure = (JPanel)this.addElement(new ControlPanel(), "Figure").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Alpha = (JSlider)this.addElement(new ControlSlider(), "Alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Figure").setProperty("variable", "alpha").setProperty("value", "6.283185307154326E-5").setProperty("minimum", "%_model._method_for_Alpha_minimum()%").setProperty("maximum", "%_model._method_for_Alpha_maximum()%").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Viewpoint")).getObject();
        this.Beta = (JSlider)this.addElement(new ControlSlider(), "Beta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Figure").setProperty("variable", "beta").setProperty("minimum", "%_model._method_for_Beta_minimum()%").setProperty("maximum", "%_model._method_for_Beta_maximum()%").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Viewpoint")).getObject();
        this.Space = (DrawingPanel3D)this.addElement(new ControlDrawingPanel3D(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Figure").setProperty("minimumX", "%_model._method_for_Space_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Space_minimumY()%").setProperty("maximumY", "ymax").setProperty("minimumZ", "%_model._method_for_Space_minimumZ()%").setProperty("maximumZ", "ymax").setProperty("projectionMode", "PERSPECTIVE").setProperty("cameraAzimuth", "alpha").setProperty("cameraAltitude", "beta").setProperty("cameraFocusX", "0.0").setProperty("cameraFocusY", "0.0").setProperty("cameraFocusZ", "0.0").setProperty("cameraRotation", "0.0").setProperty("cameraDistanceToScreen", "150.0").setProperty("decorationType", "NONE").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to change the viewpoint")).getObject();
        this.Xaxis = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Xaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "%_model._method_for_Xaxis_sizeX()%").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("visible", "showAxes").setProperty("lineWidth", "2").setProperty("resolution", "10,1,1").getObject();
        this.Yaxis = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Yaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "0").setProperty("sizeY", "%_model._method_for_Yaxis_sizeY()%").setProperty("sizeZ", "0").setProperty("visible", "showAxes").setProperty("lineWidth", "2").setProperty("resolution", "1,10,1").getObject();
        this.Zaxis = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Zaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("sizeZ", "%_model._method_for_Zaxis_sizeZ()%").setProperty("visible", "showAxes").setProperty("lineWidth", "2").setProperty("resolution", "1,1,10").getObject();
        this.Xlabel = (ElementText)this.addElement(new ControlElement3DText(), "Xlabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_Xlabel_x()%").setProperty("visible", "showAxes").setProperty("text", this._simulation.translateString("View.Xlabel.text", "X")).getObject();
        this.Ylabel = (ElementText)this.addElement(new ControlElement3DText(), "Ylabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("y", "%_model._method_for_Ylabel_y()%").setProperty("visible", "showAxes").setProperty("text", this._simulation.translateString("View.Ylabel.text", "Y")).getObject();
        this.Zlabel = (ElementText)this.addElement(new ControlElement3DText(), "Zlabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("z", "%_model._method_for_Zlabel_z()%").setProperty("visible", "showAxes").setProperty("text", this._simulation.translateString("View.Zlabel.text", "Z")).getObject();
        this.Eipar = (Group)this.addElement(new ControlSegmentSet3D(), "Eipar").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yi").setProperty("z", "zi").setProperty("sizeX", "0").setProperty("sizeY", "Eiy").setProperty("sizeZ", "Eiz").setProperty("visible", "%_model._method_for_Eipar_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10").getObject();
        this.Eiper = (Group)this.addElement(new ControlSegmentSet3D(), "Eiper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yi").setProperty("z", "zi").setProperty("sizeX", "Eix").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("visible", "%_model._method_for_Eiper_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10").getObject();
        this.Ei = (Group)this.addElement(new ControlSegmentSet3D(), "Ei").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yi").setProperty("z", "zi").setProperty("sizeX", "Eix").setProperty("sizeY", "Eiy").setProperty("sizeZ", "Eiz").setProperty("visible", "showE").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10").getObject();
        this.Iray = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Iray").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("y", "%_model._method_for_Iray_y()%").setProperty("z", "%_model._method_for_Iray_z()%").setProperty("sizeX", "0").setProperty("sizeY", "%_model._method_for_Iray_sizeY()%").setProperty("sizeZ", "%_model._method_for_Iray_sizeZ()%").setProperty("enabledPosition", "false").setProperty("lineColor", "128,0,0,255").setProperty("fillColor", "128,0,0,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10").getObject();
        this.Efpar = (Group)this.addElement(new ControlSegmentSet3D(), "Efpar").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yf").setProperty("z", "zf").setProperty("sizeX", "0").setProperty("sizeY", "Efy").setProperty("sizeZ", "Efz").setProperty("visible", "%_model._method_for_Efpar_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10").getObject();
        this.Efper = (Group)this.addElement(new ControlSegmentSet3D(), "Efper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yf").setProperty("z", "zf").setProperty("sizeX", "Efx").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("visible", "%_model._method_for_Efper_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10").getObject();
        this.Ef = (Group)this.addElement(new ControlSegmentSet3D(), "Ef").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yf").setProperty("z", "zf").setProperty("sizeX", "Efx").setProperty("sizeY", "Efy").setProperty("sizeZ", "Efz").setProperty("visible", "showE").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10").getObject();
        this.Fray = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Fray").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "0").setProperty("sizeY", "%_model._method_for_Fray_sizeY()%").setProperty("sizeZ", "%_model._method_for_Fray_sizeZ()%").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("fillColor", "0,128,0,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10").getObject();
        this.Erpar = (Group)this.addElement(new ControlSegmentSet3D(), "Erpar").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yr").setProperty("z", "zr").setProperty("sizeX", "0").setProperty("sizeY", "Ery").setProperty("sizeZ", "Erz").setProperty("visible", "%_model._method_for_Erpar_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10").getObject();
        this.Erper = (Group)this.addElement(new ControlSegmentSet3D(), "Erper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yr").setProperty("z", "zr").setProperty("sizeX", "Erx").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("visible", "%_model._method_for_Erper_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10").getObject();
        this.Er = (Group)this.addElement(new ControlSegmentSet3D(), "Er").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("numberOfElements", "N").setProperty("x", "0").setProperty("y", "yr").setProperty("z", "zr").setProperty("sizeX", "Erx").setProperty("sizeY", "Ery").setProperty("sizeZ", "Erz").setProperty("visible", "%_model._method_for_Er_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10").getObject();
        this.Rray = (ElementArrow)this.addElement(new ControlElement3DArrow(), "Rray").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "0").setProperty("sizeY", "%_model._method_for_Rray_sizeY()%").setProperty("sizeZ", "%_model._method_for_Rray_sizeZ()%").setProperty("visible", "%_model._method_for_Rray_visible()%").setProperty("enabledPosition", "false").setProperty("lineColor", "0,0,128,255").setProperty("fillColor", "0,0,128,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10").getObject();
        this.IncidencePlane = (ElementPlane)this.addElement(new ControlElement3DPlane(), "IncidencePlane").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "%_model._method_for_IncidencePlane_sizeX()%").setProperty("sizeY", "%_model._method_for_IncidencePlane_sizeY()%").setProperty("sizeZ", "%_model._method_for_IncidencePlane_sizeZ()%").setProperty("transformation", "1.5707963267948966192313216916398,0.0,1.0,0.0").setProperty("visible", "showIncidence").setProperty("enabledPosition", "false").setProperty("fillColor", "255,192,255,128").setProperty("resolution", "10,10,1").getObject();
        this.Boundary = (ElementPlane)this.addElement(new ControlElement3DPlane(), "Boundary").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("sizeX", "%_model._method_for_Boundary_sizeX()%").setProperty("sizeY", "%_model._method_for_Boundary_sizeY()%").setProperty("sizeZ", "0").setProperty("visible", "showSurface").setProperty("enabledPosition", "false").setProperty("fillColor", "orange").setProperty("resolution", "10,10,1").getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.Left.size", "80,15")).getObject();
        this.Incidence = (JSlider)this.addElement(new ControlSlider(), "Incidence").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("variable", "thetaiDegrees").setProperty("minimum", "90.0").setProperty("maximum", "0.0").setProperty("format", this._simulation.translateString("View.Incidence.format", "$\\theta$1 = 0.##")).setProperty("orientation", "VERTICAL").setProperty("ticks", "91").setProperty("closest", "true").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Incidence.tooltip", "Incidence angle")).getObject();
        this.Refraction = (JTextField)this.addElement(new ControlNumberField(), "Refraction").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Left").setProperty("variable", "thetarDegrees").setProperty("format", this._simulation.translateString("View.Refraction.format", "$\\theta$2 = 0.##")).setProperty("editable", "false").setProperty("size", this._simulation.translateString("View.Refraction.size", "60,20")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Refraction.tooltip", "Refraction angle")).getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border:0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Sliders = (JPanel)this.addElement(new ControlPanel(), "Sliders").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Bottom").setProperty("layout", "grid:1,6,0,0").getObject();
        this.n2n1 = (JSlider)this.addElement(new ControlSlider(), "n2n1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "n2").setProperty("value", "1.4999580000000001").setProperty("minimum", "0.1").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.n2n1.format", "n2/n1 = 0.##")).setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.n2n1.tooltip", "Quotient of refraction indexes")).getObject();
        this.Eparallel = (JSlider)this.addElement(new ControlSlider(), "Eparallel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "Epar").setProperty("minimum", "0.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Eparallel.format", "Epar = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Eparallel.tooltip", "Amplitude of the parallel electric field")).getObject();
        this.Eperpendicular = (JSlider)this.addElement(new ControlSlider(), "Eperpendicular").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "Eper").setProperty("minimum", "0.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Eperpendicular.format", "Eper = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("action", "_model._method_for_Eperpendicular_action()").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Eperpendicular.tooltip", "Amplitude of the perpendicular electric field")).getObject();
        this.Phase = (JSlider)this.addElement(new ControlSlider(), "Phase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "deltaDegrees").setProperty("minimum", "0.0").setProperty("maximum", "360.1").setProperty("format", this._simulation.translateString("View.Phase.format", "$\\delta$ = 0")).setProperty("ticks", "13").setProperty("closest", "true").setProperty("action", "_model._method_for_Phase_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.Phase.tooltip", "Phase difference of field components (in degrees)")).getObject();
        this.Lambda = (JSlider)this.addElement(new ControlSlider(), "Lambda").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "lambda").setProperty("minimum", "0.0").setProperty("maximum", "20.0").setProperty("format", this._simulation.translateString("View.Lambda.format", "$\\lambda$ = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("action", "_model._method_for_Lambda_action()").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.Lambda.tooltip", "Wavelength")).getObject();
        this.dt = (JSlider)this.addElement(new ControlSlider(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Sliders").setProperty("variable", "dt").setProperty("minimum", "0.1").setProperty("maximum", "1.0").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("ticks", "10").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation-step")).getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border:0,0").getObject();
        this.Fields = (JPanel)this.addElement(new ControlPanel(), "Fields").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Controls").setProperty("layout", "grid:1,6,0,0").getObject();
        this.sE = (JCheckBox)this.addElement(new ControlCheckBox(), "sE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Fields").setProperty("variable", "showE").setProperty("text", this._simulation.translateString("View.sE.text", "Total E")).setProperty("mnemonic", this._simulation.translateString("View.sE.mnemonic", "e")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.sE.tooltip", "Show total electric field insted of its components")).getObject();
        this.ShowSurface = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowSurface").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Fields").setProperty("variable", "showSurface").setProperty("text", this._simulation.translateString("View.ShowSurface.text", "Surface")).setProperty("mnemonic", this._simulation.translateString("View.ShowSurface.mnemonic", "s")).setProperty("foreground", "orange").setProperty("tooltip", this._simulation.translateString("View.ShowSurface.tooltip", "Show surface between both media")).getObject();
        this.ShowIncidence = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowIncidence").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Fields").setProperty("variable", "showIncidence").setProperty("text", this._simulation.translateString("View.ShowIncidence.text", "Incidence")).setProperty("mnemonic", this._simulation.translateString("View.ShowIncidence.mnemonic", "i")).setProperty("foreground", "255,128,255,255").setProperty("tooltip", this._simulation.translateString("View.ShowIncidence.tooltip", "Show plane of incidence")).getObject();
        this.ShowAxes = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowAxes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Fields").setProperty("variable", "showAxes").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.ShowAxes.text", "Axes")).setProperty("mnemonic", this._simulation.translateString("View.ShowAxes.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowAxes.tooltip", "Show coordinate axes")).getObject();
        this.Nvalue = (JTextField)this.addElement(new ControlNumberField(), "Nvalue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Fields").setProperty("variable", "N").setProperty("format", this._simulation.translateString("View.Nvalue.format", "N = 0")).setProperty("size", this._simulation.translateString("View.Nvalue.size", "60,0")).setProperty("tooltip", this._simulation.translateString("View.Nvalue.tooltip", "Number of vectors")).getObject();
        this.Right = (JPanel)this.addElement(new ControlPanel(), "Right").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "grid:1,2,0,0").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Right").setProperty("layout", "grid:1,2,2,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Reflection and refraction of electromagnetic waves")).setProperty("visible", "true");
        this.getElement("Figure");
        this.getElement("Alpha").setProperty("value", "6.283185307154326E-5").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Viewpoint"));
        this.getElement("Beta").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Viewpoint"));
        this.getElement("Space").setProperty("projectionMode", "PERSPECTIVE").setProperty("cameraFocusX", "0.0").setProperty("cameraFocusY", "0.0").setProperty("cameraFocusZ", "0.0").setProperty("cameraRotation", "0.0").setProperty("cameraDistanceToScreen", "150.0").setProperty("decorationType", "NONE").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to change the viewpoint"));
        this.getElement("Xaxis").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("lineWidth", "2").setProperty("resolution", "10,1,1");
        this.getElement("Yaxis").setProperty("sizeX", "0").setProperty("sizeZ", "0").setProperty("lineWidth", "2").setProperty("resolution", "1,10,1");
        this.getElement("Zaxis").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("lineWidth", "2").setProperty("resolution", "1,1,10");
        this.getElement("Xlabel").setProperty("text", this._simulation.translateString("View.Xlabel.text", "X"));
        this.getElement("Ylabel").setProperty("text", this._simulation.translateString("View.Ylabel.text", "Y"));
        this.getElement("Zlabel").setProperty("text", this._simulation.translateString("View.Zlabel.text", "Z"));
        this.getElement("Eipar").setProperty("x", "0").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10");
        this.getElement("Eiper").setProperty("x", "0").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10");
        this.getElement("Ei").setProperty("x", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "red").setProperty("resolution", "10,10,10");
        this.getElement("Iray").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "128,0,0,255").setProperty("fillColor", "128,0,0,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10");
        this.getElement("Efpar").setProperty("x", "0").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10");
        this.getElement("Efper").setProperty("x", "0").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10");
        this.getElement("Ef").setProperty("x", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("resolution", "10,10,10");
        this.getElement("Fray").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "0,128,0,255").setProperty("fillColor", "0,128,0,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10");
        this.getElement("Erpar").setProperty("x", "0").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10");
        this.getElement("Erper").setProperty("x", "0").setProperty("sizeY", "0").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10");
        this.getElement("Er").setProperty("x", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "blue").setProperty("resolution", "10,10,10");
        this.getElement("Rray").setProperty("sizeX", "0").setProperty("enabledPosition", "false").setProperty("lineColor", "0,0,128,255").setProperty("fillColor", "0,0,128,255").setProperty("lineWidth", "2").setProperty("resolution", "10,10,10");
        this.getElement("IncidencePlane").setProperty("transformation", "1.5707963267948966192313216916398,0.0,1.0,0.0").setProperty("enabledPosition", "false").setProperty("fillColor", "255,192,255,128").setProperty("resolution", "10,10,1");
        this.getElement("Boundary").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("fillColor", "orange").setProperty("resolution", "10,10,1");
        this.getElement("Left").setProperty("size", this._simulation.translateString("View.Left.size", "80,15"));
        this.getElement("Incidence").setProperty("minimum", "90.0").setProperty("maximum", "0.0").setProperty("format", this._simulation.translateString("View.Incidence.format", "$\\theta$1 = 0.##")).setProperty("orientation", "VERTICAL").setProperty("ticks", "91").setProperty("closest", "true").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Incidence.tooltip", "Incidence angle"));
        this.getElement("Refraction").setProperty("format", this._simulation.translateString("View.Refraction.format", "$\\theta$2 = 0.##")).setProperty("editable", "false").setProperty("size", this._simulation.translateString("View.Refraction.size", "60,20")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Refraction.tooltip", "Refraction angle"));
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Sliders");
        this.getElement("n2n1").setProperty("value", "1.4999580000000001").setProperty("minimum", "0.1").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.n2n1.format", "n2/n1 = 0.##")).setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.n2n1.tooltip", "Quotient of refraction indexes"));
        this.getElement("Eparallel").setProperty("minimum", "0.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Eparallel.format", "Epar = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Eparallel.tooltip", "Amplitude of the parallel electric field"));
        this.getElement("Eperpendicular").setProperty("minimum", "0.0").setProperty("maximum", "10.0").setProperty("format", this._simulation.translateString("View.Eperpendicular.format", "Eper = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Eperpendicular.tooltip", "Amplitude of the perpendicular electric field"));
        this.getElement("Phase").setProperty("minimum", "0.0").setProperty("maximum", "360.1").setProperty("format", this._simulation.translateString("View.Phase.format", "$\\delta$ = 0")).setProperty("ticks", "13").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.Phase.tooltip", "Phase difference of field components (in degrees)"));
        this.getElement("Lambda").setProperty("minimum", "0.0").setProperty("maximum", "20.0").setProperty("format", this._simulation.translateString("View.Lambda.format", "$\\lambda$ = 0.##")).setProperty("ticks", "11").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.Lambda.tooltip", "Wavelength"));
        this.getElement("dt").setProperty("minimum", "0.1").setProperty("maximum", "1.0").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("ticks", "10").setProperty("closest", "true").setProperty("foreground", "black").setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation-step"));
        this.getElement("Controls");
        this.getElement("Fields");
        this.getElement("sE").setProperty("text", this._simulation.translateString("View.sE.text", "Total E")).setProperty("mnemonic", this._simulation.translateString("View.sE.mnemonic", "e")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.sE.tooltip", "Show total electric field insted of its components"));
        this.getElement("ShowSurface").setProperty("text", this._simulation.translateString("View.ShowSurface.text", "Surface")).setProperty("mnemonic", this._simulation.translateString("View.ShowSurface.mnemonic", "s")).setProperty("foreground", "orange").setProperty("tooltip", this._simulation.translateString("View.ShowSurface.tooltip", "Show surface between both media"));
        this.getElement("ShowIncidence").setProperty("text", this._simulation.translateString("View.ShowIncidence.text", "Incidence")).setProperty("mnemonic", this._simulation.translateString("View.ShowIncidence.mnemonic", "i")).setProperty("foreground", "255,128,255,255").setProperty("tooltip", this._simulation.translateString("View.ShowIncidence.tooltip", "Show plane of incidence"));
        this.getElement("ShowAxes").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.ShowAxes.text", "Axes")).setProperty("mnemonic", this._simulation.translateString("View.ShowAxes.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowAxes.tooltip", "Show coordinate axes"));
        this.getElement("Nvalue").setProperty("format", this._simulation.translateString("View.Nvalue.format", "N = 0")).setProperty("size", this._simulation.translateString("View.Nvalue.size", "60,0")).setProperty("tooltip", this._simulation.translateString("View.Nvalue.tooltip", "Number of vectors"));
        this.getElement("Right");
        this.getElement("Buttons");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

