/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.waves.brewster;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.waves.brewster.brewsterSimulation;
import users.ehu.jma.waves.brewster.brewsterView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class brewster
extends AbstractModel {
    public brewsterSimulation _simulation = null;
    public brewsterView _view = null;
    public brewster _model = this;
    public double t = 0.0;
    public double Epar = 10.0;
    public double Eper = 10.0;
    public double delta = 0.0;
    public double lambda = 10.0;
    public double k = Math.PI * 2 / this.lambda;
    public double thetai = 0.0;
    public double thetar = 0.0;
    public double n2 = 1.4999580000000001;
    public int Nmax = 150;
    public int N = 75;
    public double[] Eix;
    public double[] Eiy;
    public double[] Eiz;
    public double[] Efx;
    public double[] Efy;
    public double[] Efz;
    public double[] Erx;
    public double[] Ery;
    public double[] Erz;
    public double[] yi;
    public double[] zi;
    public double[] yf;
    public double[] zf;
    public double[] yr;
    public double[] zr;
    public double length = 20.0;
    public boolean showE = false;
    public boolean totalReflection = false;
    public double alpha = 6.283185307154326E-5;
    public double beta = 0.0;
    public double xmin = -20.0;
    public double xmax = 20.0;
    public double ymax = 20.0;
    public double dt = 0.1;
    public double deltaDegrees = 0.0;
    public double thetaiDegrees = 45.0045;
    public double thetarDegrees = 0.0;
    public double csi = 0.0;
    public double sni = 0.0;
    public double csr = 0.0;
    public double snr = 0.0;
    public boolean showSurface = true;
    public boolean showIncidence = false;
    public boolean showAxes = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/waves/brewster.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/waves/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        brewster brewster2 = new brewster(stringArray);
    }

    public brewster() {
        this(null, null, null, null, null, false);
    }

    public brewster(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public brewster(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new brewsterSimulation(this, string, frame, uRL, bl);
        this._view = (brewsterView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.N < 2) {
            this.N = 2;
        } else if (this.N > this.Nmax) {
            this.N = this.Nmax;
        }
    }

    public void _constraints2() {
        this.thetai = Math.toRadians(this.thetaiDegrees);
        this.csi = Math.cos(this.thetai);
        this.sni = Math.sin(this.thetai);
        this.snr = Math.sin(this.thetai) / this.n2;
        if (this.snr > 1.0) {
            this.snr = 1.0;
            this.totalReflection = true;
        } else {
            this.totalReflection = false;
        }
        this.thetar = Math.asin(this.snr);
        this.csr = Math.cos(this.thetar);
        this.thetarDegrees = Math.toDegrees(this.thetar);
    }

    public void _constraints3() {
        double d = this.length / (double)this.N;
        double d2 = -this.length;
        int n = 0;
        while (n < this.N) {
            double d3;
            this.yi[n] = d2 * this.sni;
            this.zi[n] = -d2 * this.csi;
            double d4 = this.Epar * Math.cos(this.k * (d2 - this.t));
            this.Eix[n] = d3 = this.Eper * Math.cos(this.k * (d2 - this.t) + this.delta);
            this.Eiy[n] = d4 * this.csi;
            this.Eiz[n] = d4 * this.sni;
            ++n;
            d2 += d;
        }
    }

    public void _constraints4() {
        if (this.totalReflection) {
            double d;
            double d2 = d = this.length / (double)this.N;
            double d3 = -this.n2 * this.n2 * this.csi;
            double d4 = Math.sqrt(this.sni * this.sni - this.n2 * this.n2);
            double d5 = this.csi;
            double d6 = Math.atan2(-2.0 * d3 * d4, d3 * d3 - d4 * d4);
            d4 = -d4;
            double d7 = Math.atan2(-2.0 * d5 * d4, d5 * d5 - d4 * d4);
            int n = 0;
            while (n < this.N) {
                double d8;
                this.yf[n] = d2 * this.sni;
                this.zf[n] = d2 * this.csi;
                double d9 = this.Epar * Math.cos(this.k * (d2 - this.t) + d6);
                this.Efx[n] = d8 = this.Eper * Math.cos(this.k * (d2 - this.t) + d7 + this.delta);
                this.Efy[n] = d9 * this.csi;
                this.Efz[n] = -d9 * this.sni;
                ++n;
                d2 += d;
            }
        } else {
            double d;
            double d10 = d = this.length / (double)this.N;
            double d11 = this.Epar * (this.csr - this.n2 * this.csi) / (this.csr + this.n2 * this.csi);
            double d12 = this.Eper * (this.csi - this.n2 * this.csr) / (this.csi + this.n2 * this.csr);
            int n = 0;
            while (n < this.N) {
                double d13;
                this.yf[n] = d10 * this.sni;
                this.zf[n] = d10 * this.csi;
                double d14 = d11 * Math.cos(this.k * (d10 - this.t));
                this.Efx[n] = d13 = d12 * Math.cos(this.k * (d10 - this.t) + this.delta);
                this.Efy[n] = d14 * this.csi;
                this.Efz[n] = -d14 * this.sni;
                ++n;
                d10 += d;
            }
        }
    }

    public void _constraints5() {
        if (!this.totalReflection) {
            double d;
            double d2 = d = this.length / (double)this.N;
            double d3 = this.Epar * (2.0 * this.csi) / (this.csr + this.n2 * this.csi);
            double d4 = this.Eper * (2.0 * this.csi) / (this.csi + this.n2 * this.csr);
            int n = 0;
            while (n < this.N) {
                double d5;
                this.yr[n] = d2 * this.snr;
                this.zr[n] = -d2 * this.csr;
                double d6 = d3 * Math.cos(this.k * (d2 - this.t));
                this.Erx[n] = d5 = d4 * Math.cos(this.k * (d2 - this.t) + this.delta);
                this.Ery[n] = d6 * this.csr;
                this.Erz[n] = d6 * this.snr;
                ++n;
                d2 += d;
            }
        }
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public double _method_for_Space_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Space_minimumY() {
        return -this.ymax;
    }

    public double _method_for_Space_minimumZ() {
        return -this.ymax;
    }

    public double _method_for_Xaxis_sizeX() {
        return 1.1 * this.xmax;
    }

    public double _method_for_Yaxis_sizeY() {
        return 1.1 * this.ymax;
    }

    public double _method_for_Zaxis_sizeZ() {
        return 1.1 * this.ymax;
    }

    public double _method_for_Xlabel_x() {
        return 1.2 * this.xmax;
    }

    public double _method_for_Ylabel_y() {
        return 1.2 * this.ymax;
    }

    public double _method_for_Zlabel_z() {
        return 1.1 * this.ymax;
    }

    public boolean _method_for_Eipar_visible() {
        return !this.showE;
    }

    public boolean _method_for_Eiper_visible() {
        return !this.showE;
    }

    public double _method_for_Iray_y() {
        return -this.length * this.sni;
    }

    public double _method_for_Iray_z() {
        return this.length * this.csi;
    }

    public double _method_for_Iray_sizeY() {
        return this.length * this.sni;
    }

    public double _method_for_Iray_sizeZ() {
        return -this.length * this.csi;
    }

    public boolean _method_for_Efpar_visible() {
        return !this.showE;
    }

    public boolean _method_for_Efper_visible() {
        return !this.showE;
    }

    public double _method_for_Fray_sizeY() {
        return this.length * this.sni;
    }

    public double _method_for_Fray_sizeZ() {
        return this.length * this.csi;
    }

    public boolean _method_for_Erpar_visible() {
        return !this.showE && !this.totalReflection;
    }

    public boolean _method_for_Erper_visible() {
        return !this.showE && !this.totalReflection;
    }

    public boolean _method_for_Er_visible() {
        return this.showE && !this.totalReflection;
    }

    public double _method_for_Rray_sizeY() {
        return this.length * this.snr;
    }

    public double _method_for_Rray_sizeZ() {
        return -this.length * this.csr;
    }

    public boolean _method_for_Rray_visible() {
        return !this.totalReflection;
    }

    public double _method_for_IncidencePlane_sizeX() {
        return 2.0 * this.xmax;
    }

    public double _method_for_IncidencePlane_sizeY() {
        return 2.0 * this.ymax;
    }

    public double _method_for_IncidencePlane_sizeZ() {
        return 2.0 * this.ymax;
    }

    public double _method_for_Boundary_sizeX() {
        return 2.0 * this.xmax;
    }

    public double _method_for_Boundary_sizeY() {
        return 2.0 * this.xmax;
    }

    public void _method_for_Eperpendicular_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Phase_action() {
        this._simulation.disableLoop();
        this.delta = this.deltaDegrees * Math.PI / 180.0;
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Lambda_action() {
        this._simulation.disableLoop();
        this.k = Math.PI * 2 / this.lambda;
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.Epar = 10.0;
        this.Eper = 10.0;
        this.delta = 0.0;
        this.lambda = 10.0;
        this.k = Math.PI * 2 / this.lambda;
        this.thetai = 0.0;
        this.thetar = 0.0;
        this.n2 = 1.4999580000000001;
        this.Nmax = 150;
        this.N = 75;
        this.Eix = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Eix[n] = 0.0;
        }
        this.Eiy = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Eiy[n] = 0.0;
        }
        this.Eiz = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Eiz[n] = 0.0;
        }
        this.Efx = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Efx[n] = 0.0;
        }
        this.Efy = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Efy[n] = 0.0;
        }
        this.Efz = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Efz[n] = 0.0;
        }
        this.Erx = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Erx[n] = 0.0;
        }
        this.Ery = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Ery[n] = 0.0;
        }
        this.Erz = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.Erz[n] = 0.0;
        }
        this.yi = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.yi[n] = 0.0;
        }
        this.zi = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.zi[n] = 0.0;
        }
        this.yf = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.yf[n] = 0.0;
        }
        this.zf = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.zf[n] = 0.0;
        }
        this.yr = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.yr[n] = 0.0;
        }
        this.zr = new double[this.Nmax];
        for (n = 0; n < this.Nmax; ++n) {
            this.zr[n] = 0.0;
        }
        this.length = 20.0;
        this.showE = false;
        this.totalReflection = false;
        this.alpha = 6.283185307154326E-5;
        this.beta = 0.0;
        this.xmin = -20.0;
        this.xmax = 20.0;
        this.ymax = 20.0;
        this.dt = 0.1;
        this.deltaDegrees = 0.0;
        this.thetaiDegrees = 45.0045;
        this.thetarDegrees = 0.0;
        this.csi = 0.0;
        this.sni = 0.0;
        this.csr = 0.0;
        this.snr = 0.0;
        this.showSurface = true;
        this.showIncidence = false;
        this.showAxes = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
        this._constraints5();
    }

    @Override
    public void _freeMemory() {
        this.Eix = null;
        this.Eiy = null;
        this.Eiz = null;
        this.Efx = null;
        this.Efy = null;
        this.Efz = null;
        this.Erx = null;
        this.Ery = null;
        this.Erz = null;
        this.yi = null;
        this.zi = null;
        this.yf = null;
        this.zf = null;
        this.yr = null;
        this.zr = null;
        System.gc();
    }
}

