/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ExportGnuplotFormat;
import org.opensourcephysics.tools.ExportXMLFormat;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class ExportTool
implements Tool,
PropertyChangeListener {
    static ExportTool TOOL;
    JFileChooser fc;
    static String exportExtension;
    static Hashtable formats;
    JCheckBox[] checkBoxes;
    String exportName = "default";

    static {
        exportExtension = "txt";
    }

    public ExportTool() {
        this.createFileChooser();
        this.fc.addPropertyChangeListener(this);
    }

    void createFileChooser() {
        formats = new Hashtable();
        ExportTool.registerFormat(new ExportGnuplotFormat());
        ExportTool.registerFormat(new ExportXMLFormat());
        Object object = UIManager.put("FileChooser.filesOfTypeLabelText", "File Format:");
        this.fc = new JFileChooser(OSPRuntime.chooserDir);
        UIManager.put("FileChooser.filesOfTypeLabelText", object);
        this.fc.setDialogType(1);
        this.fc.setDialogTitle("Export Data");
        this.fc.setApproveButtonText("Export");
        this.setChooserFormats();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileFilter fileFilter = this.fc.getFileFilter();
        if (fileFilter == null) {
            return;
        }
        ExportFormat exportFormat = (ExportFormat)formats.get(fileFilter.getDescription());
        if (exportFormat == null || exportExtension.equals(exportFormat.extension())) {
            return;
        }
        exportExtension = exportFormat.extension();
        this.fc.setSelectedFile(new File(String.valueOf(this.exportName) + '.' + exportExtension));
    }

    void buildAccessory(List list) {
        Object object;
        this.checkBoxes = new JCheckBox[list.size()];
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        int n = 0;
        while (n < list.size()) {
            object = "Unknown" + n;
            Color color = Color.BLACK;
            Object e = list.get(n);
            if (e instanceof Dataset) {
                Dataset dataset = (Dataset)e;
                object = "Dataset" + n;
                color = dataset.getFillColor();
            } else if (e instanceof GridData) {
                object = "GridData" + n;
            }
            this.checkBoxes[n] = new JCheckBox((String)object);
            this.checkBoxes[n].setSelected(true);
            this.checkBoxes[n].setForeground(color);
            this.checkBoxes[n].setBackground(Color.WHITE);
            jPanel.add(this.checkBoxes[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        object = new JPanel(new BorderLayout());
        if (list.size() == 0) {
            ((Container)object).add((Component)new JLabel("No Data"), "North");
        } else {
            ((Container)object).add((Component)new JLabel("Exportable Data"), "North");
        }
        ((Container)object).add((Component)jScrollPane, "Center");
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.fc.setAccessory((JComponent)object);
    }

    void setChooserFormats() {
        this.fc.resetChoosableFileFilters();
        this.fc.setAcceptAllFileFilterUsed(false);
        Enumeration enumeration = formats.keys();
        while (enumeration.hasMoreElements()) {
            final String string = (String)enumeration.nextElement();
            this.fc.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }

                public String getDescription() {
                    return string;
                }
            });
        }
    }

    List getDataObjects(XMLControlElement xMLControlElement) {
        List list = xMLControlElement.getObjects(Dataset.class);
        list.addAll(xMLControlElement.getObjects(GridData.class));
        return list;
    }

    List filterDataObjects(List list) {
        Vector vector = new Vector();
        int n = 0;
        while (n < list.size()) {
            if (this.checkBoxes[n].isSelected()) {
                vector.add(list.get(n));
            }
            ++n;
        }
        return vector;
    }

    public static void registerFormat(ExportFormat exportFormat) {
        formats.put(exportFormat.description(), exportFormat);
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement();
        try {
            xMLControlElement.readXML(job.getXML());
        }
        catch (RemoteException remoteException) {}
        OSPLog.finest(xMLControlElement.toXML());
        List list = this.getDataObjects(xMLControlElement);
        this.buildAccessory(list);
        this.fc.setSelectedFile(new File(String.valueOf(this.exportName) + '.' + exportExtension));
        int n = this.fc.showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = this.fc.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            String string = this.fc.getFileFilter().getDescription();
            ((ExportFormat)formats.get(string)).export(file, this.filterDataObjects(list));
            if (file.getName().endsWith(exportExtension)) {
                this.exportName = file.getName().substring(0, file.getName().length() - 1 - exportExtension.length());
            }
        }
    }

    public static ExportTool getTool() {
        if (TOOL == null) {
            TOOL = new ExportTool();
            Toolbox.addTool("ExportTool", TOOL);
        }
        return TOOL;
    }
}

