/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;

public class ExportGnuplotFormat
implements ExportFormat {
    public String description() {
        return "Text";
    }

    public String extension() {
        return "txt";
    }

    void exportDataset(PrintWriter printWriter, Dataset dataset, int n) throws IOException {
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        printWriter.print("\n# name: data" + n + "\n" + "# type: matrix\n" + "# rows: " + dArray.length + "\n" + "# columns: " + 2 + "\n");
        int n2 = 0;
        while (n2 < dArray.length) {
            printWriter.println(String.valueOf(dArray[n2]) + " " + dArray2[n2]);
            ++n2;
        }
    }

    void exportGridData(PrintWriter printWriter, GridData gridData, int n) throws IOException {
        int n2 = gridData.getNx();
        int n3 = gridData.getNy();
        double d = gridData.getLeft();
        double d2 = gridData.getDx();
        printWriter.println("\n# name: col_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n2);
        int n4 = 0;
        while (n4 < n2) {
            printWriter.print(String.valueOf(d + (double)n4 * d2) + " ");
            ++n4;
        }
        printWriter.println("\n");
        double d3 = gridData.getTop();
        double d4 = gridData.getDy();
        printWriter.println("# name: row_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n3);
        int n5 = 0;
        while (n5 < n3) {
            printWriter.print(String.valueOf(d3 + (double)n5 * d4) + " ");
            ++n5;
        }
        printWriter.println("\n");
        n5 = gridData.getComponentCount();
        int n6 = 0;
        while (n6 < n5) {
            String string = gridData.getComponentName(n6);
            printWriter.println("# name: grid_" + n + '_' + string + '\n' + "# type: matrix\n" + "# rows: " + n3 + '\n' + "# columns: " + n2);
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n2) {
                    printWriter.print(String.valueOf(gridData.getValue(n8, n7, n6)) + " ");
                    ++n8;
                }
                printWriter.println();
                ++n7;
            }
            ++n6;
        }
    }

    public void export(File file, List list) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("# Created by the Open Source Physics library");
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Dataset) {
                    this.exportDataset(printWriter, (Dataset)e, n);
                } else if (e instanceof GridData) {
                    this.exportGridData(printWriter, (GridData)e, n);
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "An error occurred while saving your file. Please try again.", "Error", 0);
        }
    }
}

