/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolTab
extends JPanel {
    protected DataTool dataTool;
    protected final Data owner;
    protected Data[] guests = new Data[0];
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JToolBar toolbar;
    protected JCheckBox statsCheckbox;
    protected JCheckBox fitCheckbox;
    protected JCheckBox propsCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected JButton dataBuilderButton;
    protected SelectionBox selectionBox = new SelectionBox();
    protected Point zoomPoint;
    protected Action fitAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected JButton helpButton;

    public DataToolTab(Data data, DataTool dataTool) {
        this.dataTool = dataTool;
        this.owner = data;
        ArrayList arrayList = this.owner.getDatasets();
        if (arrayList != null && arrayList.size() > 0) {
            for (final Dataset dataset : arrayList) {
                Object object;
                if (dataset == null) continue;
                XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                double[] dArray = dataset.getXPoints();
                if (this.dataManager.getDatasets().isEmpty()) {
                    object = new HighlightableDataset();
                    xMLControlElement.loadObject(object, true, true);
                    ((Dataset)object).setXYColumnNames(dataset.getXColumnName(), dataset.getXColumnName());
                    ((Dataset)object).clear();
                    ((Dataset)object).append(dArray, dArray);
                    ((Dataset)object).setXColumnVisible(false);
                    this.dataManager.addDataset((Dataset)object);
                }
                if (this.isDuplicateColumn(dataset.getXColumnName(), dArray) && !this.isDuplicateColumn(dataset.getYColumnName(), dataset.getYPoints())) {
                    object = new HighlightableDataset();
                    xMLControlElement.loadObject(object, true, true);
                    ((Dataset)object).setXColumnVisible(false);
                    this.dataManager.addDataset((Dataset)object);
                    continue;
                }
                if (this.isDuplicateColumn(dataset.getXColumnName(), dArray) || this.isDuplicateColumn(dataset.getYColumnName(), dataset.getYPoints())) continue;
                object = new Runnable(){

                    public synchronized void run() {
                        DataToolTab.this.dataTool.addTab(dataset, dataset.getName());
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
        }
        this.createGUI();
        this.refreshGUI();
    }

    public boolean addData(Data data) {
        boolean bl = false;
        ArrayList arrayList = data.getDatasets();
        if (arrayList != null && arrayList.size() > 0) {
            for (Dataset dataset : arrayList) {
                Object object;
                XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                if (this.isDuplicateColumn(dataset.getXColumnName(), dataset.getXPoints()) && !this.isDuplicateColumn(dataset.getYColumnName(), dataset.getYPoints())) {
                    HighlightableDataset highlightableDataset = new HighlightableDataset();
                    xMLControlElement.loadObject(highlightableDataset, true, true);
                    highlightableDataset.setXColumnVisible(false);
                    object = dataset.getYColumnName();
                    String string = this.getUniqueYColumnName(highlightableDataset, (String)object, false);
                    highlightableDataset.setXYColumnNames(highlightableDataset.getXColumnName(), string);
                    this.dataManager.addDataset(highlightableDataset);
                    this.dataTable.getWorkingData(string);
                    bl = true;
                }
                if (!bl) continue;
                int n = this.guests.length;
                object = new Data[n + 1];
                System.arraycopy(this.guests, 0, object, 0, n);
                object[n] = data;
                this.guests = object;
            }
            this.dataTable.refreshTable();
        }
        return bl;
    }

    public void setXYColumns(String string, String string2) {
        this.dataTable.setWorkingColumns(string, string2);
    }

    public void setConnected(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.getWorkingData(string);
        if (workingDataset != null) {
            ((Dataset)workingDataset).setConnected(bl);
        }
    }

    public void setMarkersVisible(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.getWorkingData(string);
        if (workingDataset != null) {
            workingDataset.setMarkersVisible(bl);
        }
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        return this.dataTable.getWorkingData();
    }

    protected Data getOwner() {
        return this.owner;
    }

    protected String getUniqueYColumnName(Dataset dataset, String string, boolean bl) {
        int n;
        if (bl) {
            n = 0;
            int n2 = 2;
            while (this.isDuplicateName(dataset, string) && n < n2) {
                ++n;
                string = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2);
            }
        }
        n = 0;
        String string2 = string;
        while (this.isDuplicateName(dataset, string2)) {
            string2 = String.valueOf(string) + ++n;
        }
        return string2;
    }

    private boolean isDuplicateName(Dataset dataset, String string) {
        boolean bl = this.dataManager.getDataset(0).getXColumnName().equals(string);
        for (Dataset dataset2 : this.dataManager.getDatasets()) {
            if (dataset2 == dataset) continue;
            boolean bl2 = bl = bl || dataset2.getYColumnName().equals(string);
        }
        return bl;
    }

    protected boolean reloadData(Data data) {
        ArrayList arrayList = this.dataManager.getDatasets();
        if (arrayList != null) {
            for (Object object : arrayList) {
                Dataset dataset = this.getMatchingID((Dataset)object, data);
                if (dataset == null || dataset == object) continue;
                ((Dataset)object).clear();
                if (((Dataset)object).getYColumnName().equals(dataset.getXColumnName())) {
                    ((Dataset)object).append(dataset.getXPoints(), dataset.getXPoints());
                    ((Dataset)object).setXYColumnNames(dataset.getXColumnName(), dataset.getXColumnName());
                } else {
                    ((Dataset)object).append(dataset.getXPoints(), dataset.getYPoints());
                    ((Dataset)object).setXYColumnNames(dataset.getXColumnName(), dataset.getYColumnName());
                }
                ((Dataset)object).setName(dataset.getName());
            }
        }
        arrayList = data.getDatasets();
        boolean bl = false;
        if (arrayList != null) {
            for (Dataset dataset : arrayList) {
                Dataset dataset2 = this.getMatchingID(dataset, this.dataManager);
                if (dataset2 != null) continue;
                DataToolTab dataToolTab = this.dataTool.getTab(dataset);
                if (dataToolTab != null && dataToolTab != this) {
                    this.dataTool.update(dataset);
                    continue;
                }
                boolean bl2 = bl = this.addData(dataset) || bl;
            }
        }
        this.refresh();
        this.dataTable.refreshTable();
        this.statsTable.refreshStatistics();
        this.statsTable.refreshTable();
        return bl;
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0);
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.dataTable = new DataToolTable(this);
        this.dataTable.setRowNumberVisible(true);
        this.dataTable.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                if (tableColumnModelEvent.getToIndex() != 1) {
                    tableColumnModelEvent.getToIndex();
                }
                DataToolTab.this.selectionBox.setSize(0, 0);
                DataToolTab.this.refresh();
                String string = GUIUtils.removeSubscripting(DataToolTab.this.getWorkingData().getColumnName(1));
                String string2 = GUIUtils.removeSubscripting(DataToolTab.this.getWorkingData().getColumnName(0));
                DataToolTab.this.curveFitter.eqnField.setText(String.valueOf(string) + " = " + DataToolTab.this.curveFitter.fit.getExpression(string2));
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataTool.refreshTabTitles();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    DataToolTab.this.curveFitter.setData(DataToolTab.this.dataTable.getSelectedData());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.fitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean bl = DataToolTab.this.fitCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    int n = DataToolTab.this.splitPanes[1].getDividerLocation();
                    int n2 = DataToolTab.this.curveFitter.getPreferredSize().height;
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(n - n2 - 10);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                DataToolTab.this.refresh();
            }
        };
        this.fitCheckbox = new JCheckBox();
        this.fitCheckbox.setSelected(false);
        this.fitCheckbox.setOpaque(false);
        this.fitCheckbox.addActionListener(this.fitAction);
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataTool.getDataFunctionTool().setSelectedPanel(DataToolTab.this.getName());
                    DataToolTab.this.dataTool.getDataFunctionTool().setVisible(true);
                }
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataTool.helpItem.doClick();
                }
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataToolTab.this.statsCheckbox.isSelected();
                boolean bl2 = DataToolTab.this.propsCheckbox.isSelected();
                if (bl) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                int n = DataToolTab.this.statsTable.getPreferredSize().height;
                int n2 = DataToolTab.this.propsTable.getPreferredSize().height;
                if (bl && bl2) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n + n2 + 10);
                } else if (bl) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n + 4);
                } else if (bl2) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + 4);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setOpaque(false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.setOpaque(false);
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        this.plot = new DataToolPlotter(this.getWorkingData());
        this.plot.addDrawable(this.getWorkingData());
        this.plot.setTitle(this.getWorkingData().getName());
        this.plot.addDrawable(this.selectionBox);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            ArrayList rowsInside = new ArrayList();

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = 4096;
                boolean bl = mouseEvent.isPopupTrigger() || (mouseEvent.getModifiersEx() & n) == n || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                DataToolTab.this.selectionBox.xstart = point.x;
                DataToolTab.this.selectionBox.ystart = point.y;
                this.rowsInside.clear();
                if (bl) {
                    if (DataToolTab.this.selectionBox.isZoomable()) {
                        DataToolTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomToBox"));
                    } else {
                        DataToolTab.this.zoomPoint = mouseEvent.getPoint();
                        DataToolTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomIn"));
                    }
                } else {
                    DataToolTab.this.selectionBox.setSize(0, 0);
                }
                if (!(mouseEvent.isControlDown() || mouseEvent.isShiftDown() || bl)) {
                    DataToolTab.this.dataTable.clearSelection();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                boolean bl;
                int n = 4096;
                boolean bl2 = bl = (mouseEvent.getModifiersEx() & n) == n || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                if (bl) {
                    return;
                }
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.getWorkingData();
                Point point = mouseEvent.getPoint();
                DataToolTab.this.selectionBox.visible = true;
                DataToolTab.this.selectionBox.setSize(point.x - DataToolTab.this.selectionBox.xstart, point.y - DataToolTab.this.selectionBox.ystart);
                double[] dArray = workingDataset.getXPoints();
                double[] dArray2 = workingDataset.getYPoints();
                int n2 = 0;
                while (n2 < dArray.length) {
                    double d = DataToolTab.this.plot.xToPix(dArray[n2]);
                    double d2 = DataToolTab.this.plot.yToPix(dArray2[n2]);
                    Integer n3 = new Integer(n2);
                    if (DataToolTab.this.selectionBox.contains(d, d2)) {
                        if (!this.rowsInside.contains(n3)) {
                            this.rowsInside.add(n3);
                            DataToolTab.this.dataTable.getSelectionModel().addSelectionInterval(n2, n2);
                        }
                    } else if (this.rowsInside.contains(n3)) {
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n2, n2);
                        this.rowsInside.remove(n3);
                    }
                    ++n2;
                }
                DataToolTab.this.dataTable.getSelectedData();
                DataToolTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DataToolTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.propsCheckbox);
        this.toolbar.add(this.fitCheckbox);
        this.toolbar.add(this.statsCheckbox);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.helpButton);
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData());
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("drawer") && DataToolTab.this.fitCheckbox != null && DataToolTab.this.fitCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    DataToolTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.statsTable.getPreferredSize();
                return dimension;
            }
        };
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("display")) {
                    DataToolTab.this.refresh();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.propsTable.getPreferredSize();
                return dimension;
            }
        };
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(jScrollPane);
    }

    protected void refreshGUI() {
        this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        if (this.fitCheckbox != null) {
            this.fitCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
            this.fitCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        }
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.curveFitter.refreshGUI();
        this.statsTable.refreshGUI();
        this.propsTable.refreshGUI();
    }

    protected void init() {
        this.splitPanes[0].setDividerLocation(0.7);
        this.splitPanes[1].setDividerLocation(1.0);
        this.curveFitter.splitPane.setDividerLocation(0.4);
        this.propsAndStatsAction.actionPerformed(null);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            String string = this.dataTable.getColumnName(n);
            this.dataTable.getWorkingData(string);
            ++n;
        }
    }

    private Dataset getMatchingID(Dataset dataset, Data data) {
        ArrayList arrayList = data.getDatasets();
        if (arrayList == null) {
            return null;
        }
        for (Dataset dataset2 : arrayList) {
            if (dataset.getID() != dataset2.getID()) continue;
            return dataset2;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String string, double[] dArray) {
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray2 = dataset.getYPoints();
            if (!string.equals(dataset.getYColumnName()) || !this.isDuplicate(dArray, dataset.getYPoints())) continue;
            if (dArray.length > dArray2.length) {
                dataset.clear();
                dataset.append(dArray, dArray);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (!(Double.isNaN(dArray[n2]) && Double.isNaN(dArray2[n2]) || dArray[n2] == dArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isOwnedBy(Data data) {
        String string = null;
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        if (string != null && string.equals(this.getName())) {
            return true;
        }
        return data == this.owner;
    }

    public void refresh() {
        this.curveFitter.setData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingDataset = this.getWorkingData();
        int n = this.dataTable.convertColumnIndexToView(0);
        String string = this.dataTable.getColumnName(n == 0 ? 1 : 0);
        HashMap hashMap = this.dataTable.workingMap;
        for (DataToolTable.WorkingDataset workingDataset2 : hashMap.values()) {
            String string2 = GUIUtils.removeSubscripting(workingDataset2.getYColumnName());
            if (workingDataset2 == workingDataset || string2.equals(string) || !workingDataset2.isMarkersVisible() && !workingDataset2.isConnected()) continue;
            workingDataset2.clearHighlights();
            if (!workingDataset2.isMarkersVisible()) {
                workingDataset2.setMarkerShape(0);
            }
            this.plot.addDrawable(workingDataset2);
        }
        this.plot.addDrawable(workingDataset);
        if (this.fitCheckbox != null && this.fitCheckbox.isSelected()) {
            this.plot.removeDrawable(this.curveFitter.getDrawer());
            this.plot.addDrawable(this.curveFitter.getDrawer());
        }
        this.plot.setTitle(workingDataset.getName());
        this.plot.setXLabel(workingDataset.getColumnName(0));
        this.plot.setYLabel(workingDataset.getColumnName(1));
        this.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataToolPlotter
    extends PlottingPanel {
        DataToolPlotter(Dataset dataset) {
            super(dataset.getColumnName(0), dataset.getColumnName(1), "");
            this.setAntialiasShapeOn(true);
        }

        protected JMenuItem getZoomInItem() {
            return this.zoomInItem;
        }

        protected void zoomOut() {
            double d = this.xmax - this.xmin;
            double d2 = this.ymax - this.ymin;
            this.setPreferredMinMax(this.xmin - d / 2.0, this.xmax + d / 2.0, this.ymin - d2 / 2.0, this.ymax + d2 / 2.0);
            this.invalidateImage();
            DataToolTab.this.selectionBox.setSize(0, 0);
            this.repaint();
        }

        protected void zoomIn() {
            int n = DataToolTab.this.selectionBox.getBounds().width;
            int n2 = DataToolTab.this.selectionBox.getBounds().height;
            if (DataToolTab.this.selectionBox.isZoomable()) {
                int n3 = DataToolTab.this.selectionBox.getBounds().x;
                int n4 = DataToolTab.this.selectionBox.getBounds().y;
                double d = this.pixToX(n3);
                double d2 = this.pixToX(n3 + n);
                double d3 = this.pixToY(n4);
                double d4 = this.pixToY(n4 + n2);
                this.setPreferredMinMax(d, d2, d4, d3);
                this.invalidateImage();
                DataToolTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            } else if (DataToolTab.this.zoomPoint != null) {
                double d = this.xmax - this.xmin;
                double d5 = this.ymax - this.ymin;
                double d6 = this.pixToX(DataToolTab.this.zoomPoint.x);
                double d7 = this.pixToY(DataToolTab.this.zoomPoint.y);
                this.setPreferredMinMax(d6 - d / 4.0, d6 + d / 4.0, d7 - d5 / 4.0, d7 + d5 / 4.0);
                this.invalidateImage();
                DataToolTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            }
        }

        protected void buildPopupmenu() {
            this.popupmenu.setEnabled(true);
            this.zoomInItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomIn"));
            this.zoomInItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.zoomIn();
                }
            });
            this.popupmenu.add(this.zoomInItem);
            this.zoomOutItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomOut"));
            this.zoomOutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.zoomOut();
                }
            });
            this.popupmenu.add(this.zoomOutItem);
            JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomToFit"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setAutoscaleX(true);
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setAutoscaleY(true);
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.selectionBox.setSize(0, 0);
                    DataToolTab.this.refresh();
                }
            });
            this.popupmenu.add(jMenuItem);
            this.scaleItem = new JMenuItem(ToolsRes.getString("MenuItem.Scale"));
            this.scaleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScaleInspector scaleInspector = new ScaleInspector(DataToolPlotter.this);
                    scaleInspector.setLocationRelativeTo(DataToolPlotter.this);
                    scaleInspector.updateDisplay();
                    scaleInspector.setVisible(true);
                }
            });
            this.popupmenu.add(this.scaleItem);
            this.popupmenu.addSeparator();
            this.snapshotItem = new JMenuItem(ToolsRes.getString("MenuItem.Snapshot"));
            this.snapshotItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolPlotter.this.snapshot();
                }
            });
            this.popupmenu.add(this.snapshotItem);
            this.popupmenu.addSeparator();
            this.propertiesItem = new JMenuItem(ToolsRes.getString("MenuItem.Inspect"));
            this.propertiesItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolPlotter.this.showInspector();
                }
            });
            this.popupmenu.add(this.propertiesItem);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Object object2;
            Dataset dataset2;
            DataToolTab dataToolTab = (DataToolTab)object;
            xMLControl.setValue("name", dataToolTab.getName());
            DatasetManager datasetManager = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset dataset2 : dataToolTab.dataManager.getDatasets()) {
                if (dataset2 instanceof DataFunction) {
                    arrayList.add(dataset2);
                    continue;
                }
                datasetManager.addDataset(dataset2);
            }
            xMLControl.setValue("data", datasetManager);
            if (!arrayList.isEmpty()) {
                object2 = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", object2);
            }
            if (dataToolTab.curveFitter.fitBuilder != null) {
                object2 = new ArrayList(dataToolTab.curveFitter.fitBuilder.panels.values());
                xMLControl.setValue("fits", object2);
            }
            xMLControl.setValue("selected_fit", dataToolTab.curveFitter.getSelectedFitName());
            xMLControl.setValue("autofit", dataToolTab.curveFitter.autofitCheckBox.isSelected());
            xMLControl.setValue("fit_color", dataToolTab.curveFitter.color);
            if (dataToolTab.fitCheckbox != null) {
                xMLControl.setValue("fit_visible", dataToolTab.fitCheckbox.isSelected());
            }
            xMLControl.setValue("props_visible", dataToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", dataToolTab.statsCheckbox.isSelected());
            int n = dataToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            dataset2 = dataToolTab.getWorkingData();
            String[] stringArray = new String[]{dataset2.getXColumnName(), dataset2.getYColumnName()};
            xMLControl.setValue("working_columns", stringArray);
        }

        public Object createObject(XMLControl xMLControl) {
            DatasetManager datasetManager = (DatasetManager)xMLControl.getObject("data");
            return new DataToolTab(datasetManager, null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            Object object32;
            final DataToolTab dataToolTab = (DataToolTab)object;
            dataToolTab.setName(xMLControl.getString("name"));
            for (Object object32 : xMLControl.getPropertyContent()) {
                if (!object32.getPropertyName().equals("data_functions")) continue;
                object2 = object32.getChildControls();
                int n = 0;
                while (n < ((XMLControl[])object2).length) {
                    DataFunction dataFunction = new DataFunction(dataToolTab.dataManager);
                    object2[n].loadObject(dataFunction);
                    dataFunction.setXColumnVisible(false);
                    dataToolTab.dataManager.addDataset(dataFunction);
                    ++n;
                }
                ArrayList arrayList = dataToolTab.dataManager.getDatasets();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (arrayList.get(n2) instanceof DataFunction) {
                        ((DataFunction)arrayList.get(n2)).refreshFunctionData();
                    }
                    ++n2;
                }
                break block0;
            }
            object32 = (ArrayList)xMLControl.getObject("fits");
            if (object32 != null) {
                Iterator iterator = ((ArrayList)object32).iterator();
                while (iterator.hasNext()) {
                    object2 = (FitFunctionPanel)iterator.next();
                    dataToolTab.curveFitter.addUserFit((FitFunctionPanel)object2);
                }
            }
            object2 = xMLControl.getString("selected_fit");
            dataToolTab.curveFitter.fitDropDown.setSelectedItem(object2);
            boolean bl = xMLControl.getBoolean("autofit");
            dataToolTab.curveFitter.autofitCheckBox.setSelected(bl);
            Color color = (Color)xMLControl.getObject("fit_color");
            dataToolTab.curveFitter.setColor(color);
            boolean bl2 = xMLControl.getBoolean("fit_visible");
            if (dataToolTab.fitCheckbox != null) {
                dataToolTab.fitCheckbox.setSelected(bl2);
            }
            bl2 = xMLControl.getBoolean("props_visible");
            dataToolTab.propsCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("stats_visible");
            dataToolTab.statsCheckbox.setSelected(bl2);
            final int n = xMLControl.getInt("split_pane");
            String[] stringArray = (String[])xMLControl.getObject("working_columns");
            dataToolTab.dataTable.setWorkingColumns(stringArray[0], stringArray[1]);
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    dataToolTab.fitAction.actionPerformed(null);
                    dataToolTab.propsAndStatsAction.actionPerformed(null);
                    dataToolTab.splitPanes[0].setDividerLocation(n);
                    dataToolTab.dataTable.refreshTable();
                }
            };
            SwingUtilities.invokeLater(runnable);
            return object;
        }
    }

    class SelectionBox
    extends Rectangle
    implements Drawable {
        boolean visible = true;
        int xstart;
        int ystart;
        int zoomSize = 10;
        Color color = new Color(0, 255, 0, 127);

        SelectionBox() {
        }

        public void setSize(int n, int n2) {
            int n3 = Math.min(0, n);
            int n4 = Math.min(0, n2);
            n = Math.abs(n);
            n2 = Math.abs(n2);
            super.setLocation(this.xstart + n3, this.ystart + n4);
            super.setSize(n, n2);
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            if (this.visible) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(this.color);
                graphics2D.draw(this);
            }
        }

        public boolean isZoomable() {
            return this.getBounds().width > this.zoomSize && this.getBounds().height > this.zoomSize;
        }
    }
}

