/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.displayejs.InteractiveElement;

public class InteractivePlane
extends AbstractInteractiveTile {
    protected double[] vectorU = new double[]{1.0, 0.0, 0.0};
    protected double[] vectorV = new double[]{0.0, 1.0, 0.0};
    protected int nu = -1;
    protected int nv = -1;
    protected double vectorUSize = 1.0;
    protected double vectorVSize = 1.0;

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractivePlane) {
            InteractivePlane interactivePlane = (InteractivePlane)interactiveElement;
            this.setVectorU(interactivePlane.vectorU[0], interactivePlane.vectorU[1], interactivePlane.vectorU[2]);
            this.setVectorV(interactivePlane.vectorV[0], interactivePlane.vectorV[1], interactivePlane.vectorV[2]);
        }
    }

    public void setVectorU(double d, double d2, double d3) {
        this.vectorU[0] = d;
        this.vectorU[1] = d2;
        this.vectorU[2] = d3;
        this.vectorUSize = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        this.hasChanged = true;
    }

    public void setVectorV(double d, double d2, double d3) {
        this.vectorV[0] = d;
        this.vectorV[1] = d2;
        this.vectorV[2] = d3;
        this.vectorVSize = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        this.hasChanged = true;
    }

    protected void computeAbsoluteDifference(double[] dArray) {
        double d = this.originx * this.sizex;
        double d2 = this.originy * this.sizey;
        dArray[0] = d * this.vectorU[0] + d2 * this.vectorV[0];
        dArray[1] = d * this.vectorU[1] + d2 * this.vectorV[1];
        dArray[2] = d * this.vectorU[2] + d2 * this.vectorV[2];
    }

    protected synchronized void computeCorners() {
        int n = 1;
        int n2 = 1;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n = Math.max(this.resolution.n1, 1);
                    n2 = Math.max(this.resolution.n2, 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.sizex) * this.vectorUSize / this.resolution.maxLength), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.sizey) * this.vectorVSize / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nu != n || this.nv != n2) {
            this.nu = n;
            this.nv = n2;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int n3 = 0;
        double d = this.sizex / (double)this.nu;
        double d2 = this.sizey / (double)this.nv;
        double[] dArray = new double[]{this.x, this.y, this.z};
        int n4 = 0;
        while (n4 < this.nu) {
            double d3 = (double)n4 * d;
            int n5 = 0;
            while (n5 < this.nv) {
                double d4 = (double)n5 * d2;
                int n6 = 0;
                while (n6 < 3) {
                    this.corners[n3][0][n6] = dArray[n6] + d3 * this.vectorU[n6] + d4 * this.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    this.corners[n3][1][n6] = dArray[n6] + (d3 + d) * this.vectorU[n6] + d4 * this.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    this.corners[n3][2][n6] = dArray[n6] + (d3 + d) * this.vectorU[n6] + (d4 + d2) * this.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    this.corners[n3][3][n6] = dArray[n6] + d3 * this.vectorU[n6] + (d4 + d2) * this.vectorV[n6];
                    ++n6;
                }
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.transformCorners();
        this.hasChanged = false;
    }
}

