/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Resolution;

public class InteractiveCylinder
extends AbstractInteractiveTile {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int USER_DEFINED = 3;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected boolean closedBottom = true;
    protected boolean closedTop = true;
    protected boolean closedLeft = true;
    protected boolean closedRight = true;
    protected int direction = 2;
    protected int minangleu = 0;
    protected int maxangleu = 360;
    protected double[] center = new double[]{0.0, 0.0, 0.0};
    protected double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected double[] vectorz = new double[]{0.0, 0.0, 1.0};
    protected boolean changeNTiles = true;
    protected int nr = -1;
    protected int nu = -1;
    protected int nz = -1;
    protected double[] cosu = null;
    protected double[] sinu = null;

    public InteractiveCylinder() {
        this(2);
    }

    public InteractiveCylinder(int n) {
        this.setSizeXYZ(0.2, 0.2, 0.5);
        this.setResolution(new Resolution(3, 12, 5));
        this.setDirection(n);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveCylinder) {
            InteractiveCylinder interactiveCylinder = (InteractiveCylinder)interactiveElement;
            this.setMinAngleU(interactiveCylinder.getMinAngleU());
            this.setMaxAngleU(interactiveCylinder.getMaxAngleU());
            this.setClosedBottom(interactiveCylinder.isClosedBottom());
            this.setClosedTop(interactiveCylinder.isClosedTop());
            this.setClosedLeft(interactiveCylinder.isClosedLeft());
            this.setClosedRight(interactiveCylinder.isClosedRight());
            this.setDirection(interactiveCylinder.getDirection());
            int n = 0;
            while (n < 3) {
                this.vectorx[n] = interactiveCylinder.vectorx[n];
                this.vectory[n] = interactiveCylinder.vectory[n];
                this.vectorz[n] = interactiveCylinder.vectorz[n];
                ++n;
            }
        }
    }

    public void setMinAngleU(int n) {
        this.minangleu = n;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public int getMinAngleU() {
        return this.minangleu;
    }

    public void setMaxAngleU(int n) {
        this.maxangleu = n;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public int getMaxAngleU() {
        return this.maxangleu;
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setDirection(int n) {
        if (n == this.direction) {
            return;
        }
        this.direction = n;
        switch (this.direction) {
            case 0: {
                this.vectorx[0] = 0.0;
                this.vectorx[1] = 1.0;
                this.vectorx[2] = 0.0;
                this.vectory[0] = 0.0;
                this.vectory[1] = 0.0;
                this.vectory[2] = 1.0;
                this.vectorz[0] = 1.0;
                this.vectorz[1] = 0.0;
                this.vectorz[2] = 0.0;
                break;
            }
            case 1: {
                this.vectorx[0] = 1.0;
                this.vectorx[1] = 0.0;
                this.vectorx[2] = 0.0;
                this.vectory[0] = 0.0;
                this.vectory[1] = 0.0;
                this.vectory[2] = 1.0;
                this.vectorz[0] = 0.0;
                this.vectorz[1] = 1.0;
                this.vectorz[2] = 0.0;
                break;
            }
            default: {
                this.vectorx[0] = 1.0;
                this.vectorx[1] = 0.0;
                this.vectorx[2] = 0.0;
                this.vectory[0] = 0.0;
                this.vectory[1] = 1.0;
                this.vectory[2] = 0.0;
                this.vectorz[0] = 0.0;
                this.vectorz[1] = 0.0;
                this.vectorz[2] = 1.0;
            }
            case 3: 
        }
        this.hasChanged = true;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setCustomAxes(double[] dArray) {
        this.direction = 3;
        this.vectorx[0] = dArray[0];
        this.vectorx[1] = dArray[1];
        this.vectorx[2] = dArray[2];
        this.vectory[0] = dArray[3];
        this.vectory[1] = dArray[4];
        this.vectory[2] = dArray[5];
        this.vectorz[0] = dArray[6];
        this.vectorz[1] = dArray[7];
        this.vectorz[2] = dArray[8];
        this.hasChanged = true;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    protected void computeAbsoluteDifference(double[] dArray) {
        double d = (this.originx - 0.5) * this.sizex;
        double d2 = (this.originy - 0.5) * this.sizey;
        double d3 = this.originz * this.sizez;
        dArray[0] = d * this.vectorx[0] + d2 * this.vectory[0] + d3 * this.vectorz[0];
        dArray[1] = d * this.vectorx[1] + d2 * this.vectory[1] + d3 * this.vectorz[1];
        dArray[2] = d * this.vectorx[2] + d2 * this.vectory[2] + d3 * this.vectorz[2];
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        double d2 = this.sizex / 2.0;
        double d3 = this.sizey / 2.0;
        double d4 = this.sizez;
        int n5 = 1;
        int n6 = 1;
        int n7 = 1;
        double d5 = this.maxangleu;
        double d6 = this.minangleu;
        if (Math.abs(d5 - d6) > 360.0) {
            d5 = d6 + 360.0;
        }
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n5 = Math.max(this.resolution.n1, 1);
                    n6 = Math.max(this.resolution.n2, 1);
                    n7 = Math.max(this.resolution.n3, 1);
                    break;
                }
                case 1: {
                    n5 = Math.max((int)Math.round(0.49 + Math.max(Math.abs(d2), Math.abs(d3)) / this.resolution.maxLength), 1);
                    n6 = Math.max((int)Math.round(0.49 + Math.abs(d5 - d6) * (Math.PI / 180) * (Math.abs(d2) + Math.abs(d3)) / this.resolution.maxLength), 1);
                    n7 = Math.max((int)Math.round(0.49 + Math.abs(d4) / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nr != n5 || this.nu != n6 || this.nz != n7 || this.changeNTiles) {
            this.nr = n5;
            this.nu = n6;
            this.nz = n7;
            this.cosu = new double[this.nu + 1];
            this.sinu = new double[this.nu + 1];
            n4 = this.nu * this.nz;
            if (this.closedBottom) {
                n4 += this.nr * this.nu;
            }
            if (this.closedTop) {
                n4 += this.nr * this.nu;
            }
            if (Math.abs(d5 - d6) < 360.0) {
                if (this.closedLeft) {
                    n4 += this.nr * this.nz;
                }
                if (this.closedRight) {
                    n4 += this.nr * this.nz;
                }
            }
            this.changeNTiles = false;
            this.setCorners(new double[n4][4][3]);
        }
        n4 = 0;
        while (n4 <= this.nu) {
            d = ((double)(this.nu - n4) * d6 + (double)n4 * d5) * (Math.PI / 180) / (double)this.nu;
            this.cosu[n4] = Math.cos(d) * d2;
            this.sinu[n4] = Math.sin(d) * d3;
            ++n4;
        }
        n4 = 0;
        this.center[0] = this.x;
        this.center[1] = this.y;
        this.center[2] = this.z;
        d = d4 / (double)this.nz;
        int n8 = 0;
        while (n8 < this.nz) {
            n3 = 0;
            while (n3 < this.nu) {
                n2 = 0;
                while (n2 < 3) {
                    this.corners[n4][0][n2] = this.center[n2] + this.cosu[n3] * this.vectorx[n2] + this.sinu[n3] * this.vectory[n2] + (double)n8 * d * this.vectorz[n2];
                    this.corners[n4][1][n2] = this.center[n2] + this.cosu[n3 + 1] * this.vectorx[n2] + this.sinu[n3 + 1] * this.vectory[n2] + (double)n8 * d * this.vectorz[n2];
                    this.corners[n4][2][n2] = this.center[n2] + this.cosu[n3 + 1] * this.vectorx[n2] + this.sinu[n3 + 1] * this.vectory[n2] + (double)(n8 + 1) * d * this.vectorz[n2];
                    this.corners[n4][3][n2] = this.center[n2] + this.cosu[n3] * this.vectorx[n2] + this.sinu[n3] * this.vectory[n2] + (double)(n8 + 1) * d * this.vectorz[n2];
                    ++n2;
                }
                ++n3;
                ++n4;
            }
            ++n8;
        }
        if (this.closedBottom) {
            int n9 = 0;
            while (n9 < this.nu) {
                n = 0;
                while (n < this.nr) {
                    n8 = 0;
                    while (n8 < 3) {
                        this.corners[n4][0][n8] = ((double)(this.nr - n) * this.center[n8] + (double)n * this.corners[n9][0][n8]) / (double)this.nr;
                        this.corners[n4][1][n8] = ((double)(this.nr - n - 1) * this.center[n8] + (double)(n + 1) * this.corners[n9][0][n8]) / (double)this.nr;
                        this.corners[n4][2][n8] = ((double)(this.nr - n - 1) * this.center[n8] + (double)(n + 1) * this.corners[n9][1][n8]) / (double)this.nr;
                        this.corners[n4][3][n8] = ((double)(this.nr - n) * this.center[n8] + (double)n * this.corners[n9][1][n8]) / (double)this.nr;
                        ++n8;
                    }
                    ++n;
                    ++n4;
                }
                ++n9;
            }
        }
        if (this.closedTop) {
            int n10 = this.nu * (this.nz - 1);
            this.center[0] = this.x + d4 * this.vectorz[0];
            this.center[1] = this.y + d4 * this.vectorz[1];
            this.center[2] = this.z + d4 * this.vectorz[2];
            n = 0;
            while (n < this.nu) {
                n8 = 0;
                while (n8 < this.nr) {
                    n3 = 0;
                    while (n3 < 3) {
                        this.corners[n4][0][n3] = ((double)(this.nr - n8) * this.center[n3] + (double)n8 * this.corners[n10 + n][3][n3]) / (double)this.nr;
                        this.corners[n4][1][n3] = ((double)(this.nr - n8 - 1) * this.center[n3] + (double)(n8 + 1) * this.corners[n10 + n][3][n3]) / (double)this.nr;
                        this.corners[n4][2][n3] = ((double)(this.nr - n8 - 1) * this.center[n3] + (double)(n8 + 1) * this.corners[n10 + n][2][n3]) / (double)this.nr;
                        this.corners[n4][3][n3] = ((double)(this.nr - n8) * this.center[n3] + (double)n8 * this.corners[n10 + n][2][n3]) / (double)this.nr;
                        ++n3;
                    }
                    ++n8;
                    ++n4;
                }
                ++n;
            }
        }
        if (Math.abs(d5 - d6) < 360.0) {
            this.center[0] = this.x;
            this.center[1] = this.y;
            this.center[2] = this.z;
            if (this.closedRight) {
                double d7 = d4 / (double)this.nz;
                n8 = 0;
                while (n8 < this.nz) {
                    n3 = 0;
                    while (n3 < this.nr) {
                        n2 = 0;
                        while (n2 < 3) {
                            this.corners[n4][0][n2] = ((double)(this.nr - n3) * this.center[n2] + (double)n3 * this.corners[0][0][n2]) / (double)this.nr + (double)n8 * d7 * this.vectorz[n2];
                            this.corners[n4][1][n2] = ((double)(this.nr - n3 - 1) * this.center[n2] + (double)(n3 + 1) * this.corners[0][0][n2]) / (double)this.nr + (double)n8 * d7 * this.vectorz[n2];
                            this.corners[n4][2][n2] = ((double)(this.nr - n3 - 1) * this.center[n2] + (double)(n3 + 1) * this.corners[0][0][n2]) / (double)this.nr + (double)(n8 + 1) * d7 * this.vectorz[n2];
                            this.corners[n4][3][n2] = ((double)(this.nr - n3) * this.center[n2] + (double)n3 * this.corners[0][0][n2]) / (double)this.nr + (double)(n8 + 1) * d7 * this.vectorz[n2];
                            ++n2;
                        }
                        ++n3;
                        ++n4;
                    }
                    ++n8;
                }
            }
            if (this.closedLeft) {
                double d8 = d4 / (double)this.nz;
                n8 = this.nu - 1;
                n3 = 0;
                while (n3 < this.nz) {
                    n2 = 0;
                    while (n2 < this.nr) {
                        int n11 = 0;
                        while (n11 < 3) {
                            this.corners[n4][0][n11] = ((double)(this.nr - n2) * this.center[n11] + (double)n2 * this.corners[n8][1][n11]) / (double)this.nr + (double)n3 * d8 * this.vectorz[n11];
                            this.corners[n4][1][n11] = ((double)(this.nr - n2 - 1) * this.center[n11] + (double)(n2 + 1) * this.corners[n8][1][n11]) / (double)this.nr + (double)n3 * d8 * this.vectorz[n11];
                            this.corners[n4][2][n11] = ((double)(this.nr - n2 - 1) * this.center[n11] + (double)(n2 + 1) * this.corners[n8][1][n11]) / (double)this.nr + (double)(n3 + 1) * d8 * this.vectorz[n11];
                            this.corners[n4][3][n11] = ((double)(this.nr - n2) * this.center[n11] + (double)n2 * this.corners[n8][1][n11]) / (double)this.nr + (double)(n3 + 1) * d8 * this.vectorz[n11];
                            ++n11;
                        }
                        ++n2;
                        ++n4;
                    }
                    ++n3;
                }
            }
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

