/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.displayejs.InteractiveCylinder;
import org.opensourcephysics.displayejs.Resolution;

public class InteractiveCone
extends InteractiveCylinder {
    protected double[] nextCenter = new double[]{0.0, 0.0, 0.0};

    public InteractiveCone() {
        this(2);
    }

    public InteractiveCone(int n) {
        this.setSizeXYZ(0.2, 0.2, 0.5);
        this.setResolution(new Resolution(3, 12, 5));
        this.setDirection(n);
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        double d;
        int n3;
        double d2 = this.sizex / 2.0;
        double d3 = this.sizey / 2.0;
        double d4 = this.sizez;
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        double d5 = this.maxangleu;
        double d6 = this.minangleu;
        if (Math.abs(d5 - d6) > 360.0) {
            d5 = d6 + 360.0;
        }
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n4 = Math.max(this.resolution.n1, 1);
                    n5 = Math.max(this.resolution.n2, 1);
                    n6 = Math.max(this.resolution.n3, 1);
                    break;
                }
                case 1: {
                    n4 = Math.max((int)Math.round(0.49 + Math.max(Math.abs(d2), Math.abs(d3)) / this.resolution.maxLength), 1);
                    n5 = Math.max((int)Math.round(0.49 + Math.abs(d5 - d6) * (Math.PI / 180) * (Math.abs(d2) + Math.abs(d3)) / this.resolution.maxLength), 1);
                    n6 = Math.max((int)Math.round(0.49 + Math.abs(d4) / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nr != n4 || this.nu != n5 || this.nz != n6 || this.changeNTiles) {
            this.nr = n4;
            this.nu = n5;
            this.nz = n6;
            this.cosu = new double[this.nu + 1];
            this.sinu = new double[this.nu + 1];
            n3 = this.nu * this.nz;
            if (this.closedBottom) {
                n3 += this.nr * this.nu;
            }
            if (Math.abs(d5 - d6) < 360.0) {
                if (this.closedLeft) {
                    n3 += this.nr * this.nz;
                }
                if (this.closedRight) {
                    n3 += this.nr * this.nz;
                }
            }
            this.changeNTiles = false;
            this.setCorners(new double[n3][4][3]);
        }
        n3 = 0;
        while (n3 <= this.nu) {
            d = ((double)(this.nu - n3) * d6 + (double)n3 * d5) * (Math.PI / 180) / (double)this.nu;
            this.cosu[n3] = Math.cos(d) * d2;
            this.sinu[n3] = Math.sin(d) * d3;
            ++n3;
        }
        n3 = 0;
        this.center[0] = this.x;
        this.center[1] = this.y;
        this.center[2] = this.z;
        d = d4 / (double)this.nz;
        int n7 = 0;
        while (n7 < this.nz) {
            n2 = 0;
            while (n2 < this.nu) {
                n = 0;
                while (n < 3) {
                    this.corners[n3][0][n] = this.center[n] + (this.cosu[n2] * this.vectorx[n] + this.sinu[n2] * this.vectory[n]) * (double)(this.nz - n7) / (double)this.nz + (double)n7 * d * this.vectorz[n];
                    this.corners[n3][1][n] = this.center[n] + (this.cosu[n2 + 1] * this.vectorx[n] + this.sinu[n2 + 1] * this.vectory[n]) * (double)(this.nz - n7) / (double)this.nz + (double)n7 * d * this.vectorz[n];
                    this.corners[n3][2][n] = this.center[n] + (this.cosu[n2 + 1] * this.vectorx[n] + this.sinu[n2 + 1] * this.vectory[n]) * (double)(this.nz - n7 - 1) / (double)this.nz + (double)(n7 + 1) * d * this.vectorz[n];
                    this.corners[n3][3][n] = this.center[n] + (this.cosu[n2] * this.vectorx[n] + this.sinu[n2] * this.vectory[n]) * (double)(this.nz - n7 - 1) / (double)this.nz + (double)(n7 + 1) * d * this.vectorz[n];
                    ++n;
                }
                ++n2;
                ++n3;
            }
            ++n7;
        }
        if (this.closedBottom) {
            int n8 = 0;
            while (n8 < this.nu) {
                int n9 = 0;
                while (n9 < this.nr) {
                    n7 = 0;
                    while (n7 < 3) {
                        this.corners[n3][0][n7] = ((double)(this.nr - n9) * this.center[n7] + (double)n9 * this.corners[n8][0][n7]) / (double)this.nr;
                        this.corners[n3][1][n7] = ((double)(this.nr - n9 - 1) * this.center[n7] + (double)(n9 + 1) * this.corners[n8][0][n7]) / (double)this.nr;
                        this.corners[n3][2][n7] = ((double)(this.nr - n9 - 1) * this.center[n7] + (double)(n9 + 1) * this.corners[n8][1][n7]) / (double)this.nr;
                        this.corners[n3][3][n7] = ((double)(this.nr - n9) * this.center[n7] + (double)n9 * this.corners[n8][1][n7]) / (double)this.nr;
                        ++n7;
                    }
                    ++n9;
                    ++n3;
                }
                ++n8;
            }
        }
        if (Math.abs(d5 - d6) < 360.0) {
            int n10;
            this.center[0] = this.x;
            this.center[1] = this.y;
            this.center[2] = this.z;
            if (this.closedRight) {
                int n11 = 0;
                double d7 = d4 / (double)this.nz;
                n2 = 0;
                while (n2 < this.nz) {
                    this.center[0] = this.x + (double)n2 * d7 * this.vectorz[0];
                    this.center[1] = this.y + (double)n2 * d7 * this.vectorz[1];
                    this.center[2] = this.z + (double)n2 * d7 * this.vectorz[2];
                    this.nextCenter[0] = this.x + (double)(n2 + 1) * d7 * this.vectorz[0];
                    this.nextCenter[1] = this.y + (double)(n2 + 1) * d7 * this.vectorz[1];
                    this.nextCenter[2] = this.z + (double)(n2 + 1) * d7 * this.vectorz[2];
                    n = 0;
                    while (n < this.nr) {
                        n10 = 0;
                        while (n10 < 3) {
                            this.corners[n3][0][n10] = ((double)(this.nr - n) * this.center[n10] + (double)n * this.corners[n11][0][n10]) / (double)this.nr;
                            this.corners[n3][1][n10] = ((double)(this.nr - n - 1) * this.center[n10] + (double)(n + 1) * this.corners[n11][0][n10]) / (double)this.nr;
                            this.corners[n3][2][n10] = ((double)(this.nr - n - 1) * this.nextCenter[n10] + (double)(n + 1) * this.corners[n11][3][n10]) / (double)this.nr;
                            this.corners[n3][3][n10] = ((double)(this.nr - n) * this.nextCenter[n10] + (double)n * this.corners[n11][3][n10]) / (double)this.nr;
                            ++n10;
                        }
                        ++n;
                        ++n3;
                    }
                    ++n2;
                    n11 += this.nu;
                }
            }
            if (this.closedLeft) {
                int n12 = this.nu - 1;
                double d8 = d4 / (double)this.nz;
                n2 = 0;
                while (n2 < this.nz) {
                    this.center[0] = this.x + (double)n2 * d8 * this.vectorz[0];
                    this.center[1] = this.y + (double)n2 * d8 * this.vectorz[1];
                    this.center[2] = this.z + (double)n2 * d8 * this.vectorz[2];
                    this.nextCenter[0] = this.x + (double)(n2 + 1) * d8 * this.vectorz[0];
                    this.nextCenter[1] = this.y + (double)(n2 + 1) * d8 * this.vectorz[1];
                    this.nextCenter[2] = this.z + (double)(n2 + 1) * d8 * this.vectorz[2];
                    n = 0;
                    while (n < this.nr) {
                        n10 = 0;
                        while (n10 < 3) {
                            this.corners[n3][0][n10] = ((double)(this.nr - n) * this.center[n10] + (double)n * this.corners[n12][1][n10]) / (double)this.nr;
                            this.corners[n3][1][n10] = ((double)(this.nr - n - 1) * this.center[n10] + (double)(n + 1) * this.corners[n12][1][n10]) / (double)this.nr;
                            this.corners[n3][2][n10] = ((double)(this.nr - n - 1) * this.nextCenter[n10] + (double)(n + 1) * this.corners[n12][2][n10]) / (double)this.nr;
                            this.corners[n3][3][n10] = ((double)(this.nr - n) * this.nextCenter[n10] + (double)n * this.corners[n12][2][n10]) / (double)this.nr;
                            ++n10;
                        }
                        ++n;
                        ++n3;
                    }
                    ++n2;
                    n12 += this.nu;
                }
            }
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

