/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Body;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.numerics.Transformation;

public abstract class AbstractInteractiveTile
extends AbstractInteractiveElement
implements Body {
    protected boolean drawQuickInterior = false;
    protected int interiorTransparency = 128;
    protected int numberOfTiles = 0;
    protected double[][][] corners = null;
    protected boolean levelBelowWhenEqual = true;
    protected double displacementFactor = 1.0;
    protected double levelx = 0.0;
    protected double levely = 0.0;
    protected double levelz = 0.0;
    protected double leveldx = 0.0;
    protected double leveldy = 0.0;
    protected double leveldz = 1.0;
    protected double[] levelZ = null;
    protected Paint[] levelColors = null;
    protected Transformation transformation = null;
    protected double originx = 0.5;
    protected double originy = 0.5;
    protected double originz = 0.5;
    protected boolean originIsRelative = true;
    protected double xmin = Double.NaN;
    protected double xmax = Double.NaN;
    protected double ymin = Double.NaN;
    protected double ymax = Double.NaN;
    protected double zmin = Double.NaN;
    protected double zmax = Double.NaN;
    protected double[] pixel = new double[3];
    protected double[] coordinates = new double[3];
    protected double[] pixelOrigin = new double[3];
    protected double[] pixelEndpoint = new double[3];
    protected Object3D[] objects = null;
    private double[] center = new double[3];
    private int[][] a = null;
    private int[][] b = null;

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof AbstractInteractiveTile) {
            AbstractInteractiveTile abstractInteractiveTile = (AbstractInteractiveTile)interactiveElement;
            this.setOrigin(abstractInteractiveTile.originx, abstractInteractiveTile.originy, abstractInteractiveTile.originz, abstractInteractiveTile.originIsRelative);
            this.setTransformation(abstractInteractiveTile.transformation);
        }
    }

    public void setDisplacementFactor(double d) {
        this.displacementFactor = d;
    }

    public double GetDisplacementFactor() {
        return this.displacementFactor;
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    public void setColorBelowWhenEqual(boolean bl) {
        this.levelBelowWhenEqual = bl;
    }

    public void setColorOriginAndDirection(double d, double d2, double d3, double d4, double d5, double d6) {
        this.levelx = d;
        this.levely = d2;
        this.levelz = d3;
        this.leveldx = d4;
        this.leveldy = d5;
        this.leveldz = d6;
    }

    public void setColorRegions(double[] dArray, Paint[] paintArray) {
        if (dArray == null || paintArray == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[dArray.length];
        this.levelColors = new Paint[dArray.length + 1];
        int n = 0;
        while (n < dArray.length) {
            this.levelZ[n] = dArray[n];
            ++n;
        }
        n = 0;
        while (n < dArray.length + 1) {
            this.levelColors[n] = n < paintArray.length ? paintArray[n] : paintArray[paintArray.length - 1];
            ++n;
        }
        this.hasChanged = true;
    }

    public void setOrigin(double d, double d2, double d3, boolean bl) {
        this.originx = d;
        this.originy = d2;
        this.originz = d3;
        this.originIsRelative = bl;
        this.hasChanged = true;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = (Transformation)transformation.clone();
        this.hasChanged = true;
    }

    public void toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
    }

    public void toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        dArray[0] = dArray[0] - this.x;
        dArray[1] = dArray[1] - this.y;
        dArray[2] = dArray[2] - this.z;
        if (this.transformation != null) {
            this.transformation.inverse(dArray);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.sizeEnabled && Math.abs(this.pixelEndpoint[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelEndpoint[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementSize(this);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Paint paint;
        if (this.levelZ != null) {
            this.drawColorCoded(drawingPanel3D, graphics2D, n);
            return;
        }
        int n2 = this.corners[n].length;
        if (this.style.fillPattern != null) {
            paint = this.style.fillPattern;
            if (paint instanceof Color) {
                paint = drawingPanel3D.projectColor((Color)paint, this.objects[n].distance);
            }
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.style.edgeColor != null) {
            paint = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance);
            graphics2D.setColor((Color)paint);
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        graphics2D.setStroke(this.style.edgeStroke);
        if (this.drawQuickInterior && this.style.fillPattern instanceof Color) {
            Color color = (Color)this.style.fillPattern;
            if (color.getAlpha() > this.interiorTransparency) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(color);
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.fillPolygon(this.a[n], this.b[n], this.corners[n].length);
                ++n;
            }
        }
        if (this.style.edgeColor != null) {
            graphics2D.setColor(this.style.edgeColor);
        } else {
            graphics2D.setColor(Color.black);
        }
        int n = 0;
        while (n < this.numberOfTiles) {
            graphics2D.drawPolygon(this.a[n], this.b[n], this.corners[n].length);
            ++n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else {
            this.projectPoints(drawingPanel);
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.style.edgeStroke);
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            if (this.style.fillPattern != null) {
                graphics2D.setPaint(this.style.fillPattern);
                graphics2D.fillPolygon(this.a[n], this.b[n], n2);
            }
            if (this.style.edgeColor != null) {
                graphics2D.setColor(this.style.edgeColor);
                graphics2D.drawPolygon(this.a[n], this.b[n], n2);
            }
            ++n;
        }
    }

    public double getXMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmin)) {
            this.computeExtrema();
        }
        return this.xmin;
    }

    public double getXMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmax)) {
            this.computeExtrema();
        }
        return this.xmax;
    }

    public double getYMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymin)) {
            this.computeExtrema();
        }
        return this.ymin;
    }

    public double getYMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymax)) {
            this.computeExtrema();
        }
        return this.ymax;
    }

    public double getZMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmin)) {
            this.computeExtrema();
        }
        return this.zmin;
    }

    public double getZMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmax)) {
            this.computeExtrema();
        }
        return this.zmax;
    }

    protected abstract void computeCorners();

    protected void computeAbsoluteDifference(double[] dArray) {
        dArray[0] = this.originx * this.sizex;
        dArray[1] = this.originy * this.sizey;
        dArray[2] = this.originz * this.sizez;
    }

    protected void transformPoint(double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2 = new double[3];
            this.computeAbsoluteDifference(dArray2);
            dArray[0] = dArray[0] - dArray2[0];
            dArray[1] = dArray[1] - dArray2[1];
            dArray[2] = dArray[2] - dArray2[2];
        }
        if (this.transformation != null) {
            dArray[0] = dArray[0] - this.x;
            dArray[1] = dArray[1] - this.y;
            dArray[2] = dArray[2] - this.z;
            this.transformation.direct(dArray);
            dArray[0] = dArray[0] + this.x;
            dArray[1] = dArray[1] + this.y;
            dArray[2] = dArray[2] + this.z;
        }
    }

    protected void transformCorners() {
        if (this.originIsRelative) {
            this.computeAbsoluteDifference(this.coordinates);
        } else {
            this.coordinates[0] = this.originx;
            this.coordinates[1] = this.originy;
            this.coordinates[2] = this.originz;
        }
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = 0;
            int n3 = this.corners[n].length;
            while (n2 < n3) {
                double[] dArray = this.corners[n][n2];
                dArray[0] = dArray[0] - this.coordinates[0];
                double[] dArray2 = this.corners[n][n2];
                dArray2[1] = dArray2[1] - this.coordinates[1];
                double[] dArray3 = this.corners[n][n2];
                dArray3[2] = dArray3[2] - this.coordinates[2];
                if (this.transformation != null) {
                    double[] dArray4 = this.corners[n][n2];
                    dArray4[0] = dArray4[0] - this.x;
                    double[] dArray5 = this.corners[n][n2];
                    dArray5[1] = dArray5[1] - this.y;
                    double[] dArray6 = this.corners[n][n2];
                    dArray6[2] = dArray6[2] - this.z;
                    this.transformation.direct(this.corners[n][n2]);
                    double[] dArray7 = this.corners[n][n2];
                    dArray7[0] = dArray7[0] + this.x;
                    double[] dArray8 = this.corners[n][n2];
                    dArray8[1] = dArray8[1] + this.y;
                    double[] dArray9 = this.corners[n][n2];
                    dArray9[2] = dArray9[2] + this.z;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void setCorners(double[][][] dArray) {
        this.corners = dArray;
        if (this.corners == null) {
            this.numberOfTiles = 0;
            this.a = null;
            this.b = null;
            return;
        }
        this.numberOfTiles = this.corners.length;
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            this.a[n] = new int[n2];
            this.b[n] = new int[n2];
            this.objects[n] = new Object3D(this, n);
            ++n;
        }
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group == null) {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            int n = 0;
            while (n < this.numberOfTiles) {
                int n2 = this.corners[n].length;
                int n3 = 0;
                while (n3 < 3) {
                    this.center[n3] = 0.0;
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    drawingPanel.project(this.corners[n][n3], this.pixel);
                    this.a[n][n3] = (int)this.pixel[0];
                    this.b[n][n3] = (int)this.pixel[1];
                    int n4 = 0;
                    while (n4 < 3) {
                        int n5 = n4;
                        this.center[n5] = this.center[n5] + this.corners[n][n3][n4];
                        ++n4;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < 3) {
                    int n6 = n3++;
                    this.center[n6] = this.center[n6] / (double)n2;
                }
                drawingPanel.project(this.center, this.pixel);
                this.objects[n].distance = this.pixel[2] * this.displacementFactor;
                ++n;
            }
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            int n = 0;
            while (n < this.numberOfTiles) {
                int n7 = this.corners[n].length;
                int n8 = 0;
                while (n8 < 3) {
                    this.center[n8] = 0.0;
                    ++n8;
                }
                n8 = 0;
                while (n8 < n7) {
                    this.coordinates[0] = this.group.x + this.corners[n][n8][0] * this.group.sizex;
                    this.coordinates[1] = this.group.y + this.corners[n][n8][1] * this.group.sizey;
                    this.coordinates[2] = this.group.z + this.corners[n][n8][2] * this.group.sizez;
                    drawingPanel.project(this.coordinates, this.pixel);
                    this.a[n][n8] = (int)this.pixel[0];
                    this.b[n][n8] = (int)this.pixel[1];
                    int n9 = 0;
                    while (n9 < 3) {
                        int n10 = n9;
                        this.center[n10] = this.center[n10] + this.coordinates[n9];
                        ++n9;
                    }
                    ++n8;
                }
                n8 = 0;
                while (n8 < 3) {
                    int n11 = n8++;
                    this.center[n11] = this.center[n11] / (double)n7;
                }
                drawingPanel.project(this.center, this.pixel);
                this.objects[n].distance = this.pixel[2] * this.displacementFactor;
                ++n;
            }
        }
        this.panelWithValidProjection = drawingPanel;
    }

    protected void computeExtrema() {
        this.zmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            int n3 = 0;
            while (n3 < n2) {
                double d = this.corners[n][n3][0];
                if (d < this.xmin) {
                    this.xmin = d;
                }
                if (d > this.xmax) {
                    this.xmax = d;
                }
                if ((d = this.corners[n][n3][1]) < this.ymin) {
                    this.ymin = d;
                }
                if (d > this.ymax) {
                    this.ymax = d;
                }
                if ((d = this.corners[n][n3][2]) < this.zmin) {
                    this.zmin = d;
                }
                if (d > this.zmax) {
                    this.zmax = d;
                }
                ++n3;
            }
            ++n;
        }
        if (this.group != null) {
            this.xmin = this.group.x + this.xmin * this.group.sizex;
            this.xmax = this.group.x + this.xmax * this.group.sizex;
            this.ymin = this.group.y + this.ymin * this.group.sizey;
            this.ymax = this.group.y + this.ymax * this.group.sizey;
            this.zmin = this.group.z + this.zmin * this.group.sizez;
            this.zmax = this.group.z + this.zmax * this.group.sizez;
        }
    }

    private double levelScalarProduct(double[] dArray) {
        if (this.group == null) {
            return (dArray[0] - this.levelx) * this.leveldx + (dArray[1] - this.levely) * this.leveldy + (dArray[2] - this.levelz) * this.leveldz;
        }
        return (this.group.x + dArray[0] * this.group.sizex - this.levelx) * this.leveldx + (this.group.y + dArray[1] * this.group.sizey - this.levely) * this.leveldy + (this.group.z + dArray[2] * this.group.sizez - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.corners[n].length;
        int[] nArray = new int[n5];
        if (this.levelBelowWhenEqual) {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = 0;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n3 = this.levelZ.length - 1;
                while (n3 >= 0) {
                    if (d > this.levelZ[n3]) {
                        nArray[n4] = n3 + 1;
                        break;
                    }
                    --n3;
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = this.levelZ.length;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n3 = 0;
                n2 = this.levelZ.length;
                while (n3 < n2) {
                    if (d < this.levelZ[n3]) {
                        nArray[n4] = n3;
                        break;
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        int n6 = 0;
        n3 = this.levelZ.length;
        while (n6 <= n3) {
            n2 = 0;
            int n7 = 0;
            while (n7 < n5) {
                double d2;
                int n8 = (n7 + 1) % n5;
                if (nArray[n7] <= n6 && nArray[n8] >= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] > n6) {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                } else if (nArray[n7] >= n6 && nArray[n8] <= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] < n6) {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                }
                ++n7;
            }
            if (n2 > 0) {
                Paint paint = this.levelColors[n6];
                graphics2D.setPaint(paint);
                graphics2D.fillPolygon(nArray2, nArray3, n2);
            }
            ++n6;
        }
        if (this.style.edgeColor != null) {
            graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance));
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.drawPolygon(this.a[n], this.b[n], n5);
        }
    }
}

