/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSegment;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementSegment
extends Element
implements org.opensourcephysics.display3d.core.ElementSegment {
    protected int div = -1;
    protected int[] aCoord = null;
    protected int[] bCoord = null;
    protected Object3D[] objects = null;
    private double[][] points = null;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance());
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(color);
        graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
    }

    synchronized void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        graphics2D.drawLine(this.aCoord[0], this.bCoord[0], this.aCoord[this.div], this.bCoord[this.div]);
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = 0.0;
        dArray2[0] = 1.0;
        dArray[1] = 0.0;
        dArray2[1] = 1.0;
        dArray[2] = 0.0;
        dArray2[2] = 1.0;
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.aCoord[0] - n) < 5 && Math.abs(this.bCoord[0] - n2) < 5) {
            return this.targetPosition;
        }
        if (this.targetSize.isEnabled() && Math.abs(this.aCoord[this.div] - n) < 5 && Math.abs(this.bCoord[this.div] - n2) < 5) {
            return this.targetSize;
        }
        return null;
    }

    void projectPoints() {
        int n = 0;
        while (n < this.div) {
            this.getPanel().project(this.points[n], this.pixel);
            this.aCoord[n] = (int)this.pixel[0];
            this.bCoord[n] = (int)this.pixel[1];
            int n2 = 0;
            while (n2 < 3) {
                this.coordinates[n2] = (this.points[n][n2] + this.points[n + 1][n2]) / 2.0;
                ++n2;
            }
            this.getPanel().project(this.coordinates, this.pixel);
            this.objects[n].setDistance(this.pixel[2]);
            ++n;
        }
        this.getPanel().project(this.points[this.div], this.pixel);
        this.aCoord[this.div] = (int)this.pixel[0];
        this.bCoord[this.div] = (int)this.pixel[1];
        this.setNeedToProject(false);
    }

    final void computeDivisions() {
        int n = 1;
        Resolution resolution = this.getRealStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 1: {
                    n = Math.max((int)Math.round(0.49 + this.getDiagonalSize() / resolution.getMaxLength()), 1);
                    break;
                }
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                }
            }
        }
        if (this.div != n) {
            this.div = n;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            int n2 = 0;
            while (n2 < this.div) {
                this.objects[n2] = new Object3D(this, n2);
                ++n2;
            }
        }
        this.points[0][0] = 0.0;
        this.points[0][1] = 0.0;
        this.points[0][2] = 0.0;
        this.points[this.div][0] = 1.0;
        this.points[this.div][1] = 1.0;
        this.points[this.div][2] = 1.0;
        double d = 1.0 / (double)this.div;
        double d2 = 1.0 / (double)this.div;
        double d3 = 1.0 / (double)this.div;
        int n3 = 1;
        while (n3 < this.div) {
            this.points[n3][0] = (double)n3 * d;
            this.points[n3][1] = (double)n3 * d2;
            this.points[n3][2] = (double)n3 * d3;
            ++n3;
        }
        n3 = 0;
        while (n3 <= this.div) {
            this.sizeAndToSpaceFrame(this.points[n3]);
            ++n3;
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSegment.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementSegment();
        }
    }
}

