/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCylinder;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementCylinder
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementCylinder {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    private double[][][] standardCylinder = null;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementCylinder() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int n) {
        this.minAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int n) {
        this.maxAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        org.opensourcephysics.display3d.core.Resolution resolution;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d = this.maxAngle;
        double d2 = this.minAngle;
        if (Math.abs(d - d2) > 360.0) {
            d = d2 + 360.0;
        }
        if ((resolution = this.getRealStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d3 = Math.abs(this.getSizeX()) / 2.0;
                    double d4 = Math.abs(this.getSizeY()) / 2.0;
                    n = Math.max((int)Math.round(0.49 + Math.max(d3, d4) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d - d2) * (Math.PI / 180) * (d3 + d4) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nz != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nz = n3;
            this.changeNTiles = false;
            this.standardCylinder = ElementCylinder.createStandardCylinder(this.nr, this.nu, this.nz, d2, d, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight);
            this.setCorners(new double[this.standardCylinder.length][4][3]);
        }
        int n4 = 0;
        while (n4 < this.numberOfTiles) {
            int n5 = 0;
            int n6 = this.corners[n4].length;
            while (n5 < n6) {
                System.arraycopy(this.standardCylinder[n4][n5], 0, this.corners[n4][n5], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[n4][n5]);
                ++n5;
            }
            ++n4;
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardCylinder(int n, int n2, int n3, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4;
        int n5;
        int n6;
        int n7 = n2 * n3;
        if (bl2) {
            n7 += n * n2;
        }
        if (bl) {
            n7 += n * n2;
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n7 += n * n3;
            }
            if (bl4) {
                n7 += n * n3;
            }
        }
        double[][][] dArray = new double[n7][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        int n8 = 0;
        while (n8 <= n2) {
            double d3 = ((double)(n2 - n8) * d + (double)n8 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n8] = Math.cos(d3) / 2.0;
            dArray3[n8] = Math.sin(d3) / 2.0;
            ++n8;
        }
        n8 = 0;
        double[] dArray4 = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double d4 = 1.0 / (double)n3;
        int n9 = 0;
        while (n9 < n3) {
            n6 = 0;
            while (n6 < n2) {
                n5 = 0;
                while (n5 < 3) {
                    dArray[n8][0][n5] = dArray4[n5] + dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5] + (double)n9 * d4 * vectorz[n5];
                    dArray[n8][1][n5] = dArray4[n5] + dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5] + (double)n9 * d4 * vectorz[n5];
                    dArray[n8][2][n5] = dArray4[n5] + dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5] + (double)(n9 + 1) * d4 * vectorz[n5];
                    dArray[n8][3][n5] = dArray4[n5] + dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5] + (double)(n9 + 1) * d4 * vectorz[n5];
                    ++n5;
                }
                ++n6;
                ++n8;
            }
            ++n9;
        }
        if (bl2) {
            int n10 = 0;
            while (n10 < n2) {
                n4 = 0;
                while (n4 < n) {
                    n9 = 0;
                    while (n9 < 3) {
                        dArray[n8][0][n9] = ((double)(n - n4) * dArray4[n9] + (double)n4 * dArray[n10][0][n9]) / (double)n;
                        dArray[n8][1][n9] = ((double)(n - n4 - 1) * dArray4[n9] + (double)(n4 + 1) * dArray[n10][0][n9]) / (double)n;
                        dArray[n8][2][n9] = ((double)(n - n4 - 1) * dArray4[n9] + (double)(n4 + 1) * dArray[n10][1][n9]) / (double)n;
                        dArray[n8][3][n9] = ((double)(n - n4) * dArray4[n9] + (double)n4 * dArray[n10][1][n9]) / (double)n;
                        ++n9;
                    }
                    ++n4;
                    ++n8;
                }
                ++n10;
            }
        }
        if (bl) {
            int n11 = n2 * (n3 - 1);
            dArray4[0] = vectorz[0];
            dArray4[1] = vectorz[1];
            dArray4[2] = vectorz[2] - 0.5;
            n4 = 0;
            while (n4 < n2) {
                n9 = 0;
                while (n9 < n) {
                    n6 = 0;
                    while (n6 < 3) {
                        dArray[n8][0][n6] = ((double)(n - n9) * dArray4[n6] + (double)n9 * dArray[n11 + n4][3][n6]) / (double)n;
                        dArray[n8][1][n6] = ((double)(n - n9 - 1) * dArray4[n6] + (double)(n9 + 1) * dArray[n11 + n4][3][n6]) / (double)n;
                        dArray[n8][2][n6] = ((double)(n - n9 - 1) * dArray4[n6] + (double)(n9 + 1) * dArray[n11 + n4][2][n6]) / (double)n;
                        dArray[n8][3][n6] = ((double)(n - n9) * dArray4[n6] + (double)n9 * dArray[n11 + n4][2][n6]) / (double)n;
                        ++n6;
                    }
                    ++n9;
                    ++n8;
                }
                ++n4;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            dArray4[0] = -vectorz[0] / 2.0;
            dArray4[1] = -vectorz[1] / 2.0;
            dArray4[2] = -vectorz[2] / 2.0;
            if (bl4) {
                d4 = 1.0 / (double)n3;
                n9 = 0;
                while (n9 < n3) {
                    n6 = 0;
                    while (n6 < n) {
                        n5 = 0;
                        while (n5 < 3) {
                            dArray[n8][0][n5] = ((double)(n - n6) * dArray4[n5] + (double)n6 * dArray[0][0][n5]) / (double)n + (double)n9 * d4 * vectorz[n5];
                            dArray[n8][1][n5] = ((double)(n - n6 - 1) * dArray4[n5] + (double)(n6 + 1) * dArray[0][0][n5]) / (double)n + (double)n9 * d4 * vectorz[n5];
                            dArray[n8][2][n5] = ((double)(n - n6 - 1) * dArray4[n5] + (double)(n6 + 1) * dArray[0][0][n5]) / (double)n + (double)(n9 + 1) * d4 * vectorz[n5];
                            dArray[n8][3][n5] = ((double)(n - n6) * dArray4[n5] + (double)n6 * dArray[0][0][n5]) / (double)n + (double)(n9 + 1) * d4 * vectorz[n5];
                            ++n5;
                        }
                        ++n6;
                        ++n8;
                    }
                    ++n9;
                }
            }
            if (bl3) {
                d4 = 1.0 / (double)n3;
                n9 = n2 - 1;
                n6 = 0;
                while (n6 < n3) {
                    n5 = 0;
                    while (n5 < n) {
                        int n12 = 0;
                        while (n12 < 3) {
                            dArray[n8][0][n12] = ((double)(n - n5) * dArray4[n12] + (double)n5 * dArray[n9][1][n12]) / (double)n + (double)n6 * d4 * vectorz[n12];
                            dArray[n8][1][n12] = ((double)(n - n5 - 1) * dArray4[n12] + (double)(n5 + 1) * dArray[n9][1][n12]) / (double)n + (double)n6 * d4 * vectorz[n12];
                            dArray[n8][2][n12] = ((double)(n - n5 - 1) * dArray4[n12] + (double)(n5 + 1) * dArray[n9][1][n12]) / (double)n + (double)(n6 + 1) * d4 * vectorz[n12];
                            dArray[n8][3][n12] = ((double)(n - n5) * dArray4[n12] + (double)n5 * dArray[n9][1][n12]) / (double)n + (double)(n6 + 1) * d4 * vectorz[n12];
                            ++n12;
                        }
                        ++n5;
                        ++n8;
                    }
                    ++n6;
                }
            }
        }
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends ElementCylinder.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementCylinder();
        }
    }
}

