/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.Element;

public class Style
implements org.opensourcephysics.display3d.core.Style {
    static final int STYLE_LINE_COLOR = 0;
    static final int STYLE_LINE_WIDTH = 1;
    static final int STYLE_FILL_COLOR = 2;
    static final int STYLE_RESOLUTION = 3;
    private Color lineColor = Color.black;
    private float lineWidth = 0.5f;
    private Color fillColor = Color.blue;
    private Resolution resolution = null;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private double depthFactor = 1.0;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element element) {
        this.element = element;
    }

    void setElement(Element element) {
        this.element = element;
    }

    public void setLineColor(Color color) {
        if (color != null) {
            this.lineColor = color;
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Color color) {
        if (color != null) {
            this.fillColor = color;
        }
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public static XML.ObjectLoader getLoader() {
        return new StyleLoader();
    }

    public boolean isDrawingFill() {
        return this.drawsFill && this.fillColor != null;
    }

    public void setDrawingFill(boolean bl) {
        this.drawsFill = bl;
    }

    public boolean isDrawingLines() {
        return this.drawsLines && this.lineColor != null;
    }

    public void setDrawingLines(boolean bl) {
        this.drawsLines = bl;
    }

    protected static class StyleLoader
    extends XMLLoader {
        protected StyleLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            xMLControl.setValue("line color", style.lineColor);
            xMLControl.setValue("line width", style.lineWidth);
            xMLControl.setValue("fill color", style.fillColor);
            xMLControl.setValue("resolution", style.resolution);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Style(null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            style.lineColor = (Color)xMLControl.getObject("line color");
            float f = (float)xMLControl.getDouble("line width");
            style.lineWidth = f;
            style.lineStroke = new BasicStroke(f);
            style.fillColor = (Color)xMLControl.getObject("fill color");
            style.resolution = (Resolution)xMLControl.getObject("resolution");
            return object;
        }
    }
}

