/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Vec3D;

public class ElementSurface
extends Element
implements org.opensourcephysics.display3d.core.ElementSurface {
    protected double[][][] data = new double[0][0][0];
    private Vec3D[][][] normals = new Vec3D[0][0][0];
    protected boolean updateChanges = true;
    protected boolean drawing = false;
    private boolean settingData = false;
    private static final boolean SMOOTH_SHADING = true;
    private int fillDL = -1;
    static final double eps = 1.0E-10;

    public ElementSurface() {
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.getStyle().setDrawingLines(false);
        this.getStyle().setDrawingFill(true);
    }

    public synchronized void setData(double[][][] dArray) {
        this.data = dArray;
        while (this.drawing) {
            Thread.yield();
        }
        this.settingData = true;
        this.fillDL = -1;
        this.normals = new Vec3D[dArray.length - 1][dArray[0].length - 1][2];
        int n = 0;
        while (n < this.normals.length) {
            int n2 = 0;
            while (n2 < this.normals[n].length) {
                Vec3D vec3D = new Vec3D();
                vec3D.subtract(new Vec3D(dArray[n + 1][n2][0], dArray[n + 1][n2][1], dArray[n + 1][n2][2]), new Vec3D(dArray[n][n2][0], dArray[n][n2][1], dArray[n][n2][2]));
                Vec3D vec3D2 = new Vec3D();
                vec3D2.subtract(new Vec3D(dArray[n + 1][n2 + 1][0], dArray[n + 1][n2 + 1][1], dArray[n + 1][n2 + 1][2]), new Vec3D(dArray[n + 1][n2][0], dArray[n + 1][n2][1], dArray[n + 1][n2][2]));
                this.normals[n][n2][0] = new Vec3D();
                this.normals[n][n2][0].cross(vec3D2, vec3D);
                this.normals[n][n2][0].normalize();
                vec3D.subtract(new Vec3D(dArray[n][n2 + 1][0], dArray[n][n2 + 1][1], dArray[n][n2 + 1][2]), new Vec3D(dArray[n + 1][n2 + 1][0], dArray[n + 1][n2 + 1][1], dArray[n + 1][n2 + 1][2]));
                vec3D2.subtract(new Vec3D(dArray[n][n2][0], dArray[n][n2][1], dArray[n][n2][2]), new Vec3D(dArray[n][n2 + 1][0], dArray[n][n2 + 1][1], dArray[n][n2 + 1][2]));
                this.normals[n][n2][1] = new Vec3D();
                this.normals[n][n2][1].cross(vec3D2, vec3D);
                this.normals[n][n2][1].normalize();
                ++n2;
            }
            ++n;
        }
        this.settingData = false;
        if (this.updateChanges) {
            this.setElementChanged(true);
        }
        this.updateChanges = true;
    }

    public double[][][] getData() {
        return this.data;
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible() || this.settingData) {
            return;
        }
        this.drawing = true;
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        this.getRotation().glRotate(gL);
        gL.glScaled(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        if (this.getStyle().isDrawingFill()) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
            gL.glDisable(2884);
            this.preFillGL(gLAutoDrawable);
            this.drawFill(gL);
        }
        if (this.getStyle().isDrawingLines()) {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            this.preLinesGL(gLAutoDrawable);
            int n = 0;
            while (n < this.data.length - 1) {
                int n2 = 0;
                while (n2 < this.data[n].length - 1) {
                    gL.glBegin(2);
                    gL.glVertex3dv(this.data[n][n2], 0);
                    gL.glVertex3dv(this.data[n + 1][n2], 0);
                    gL.glVertex3dv(this.data[n + 1][n2 + 1], 0);
                    gL.glVertex3dv(this.data[n][n2 + 1], 0);
                    gL.glEnd();
                    ++n2;
                }
                ++n;
            }
            gL.glEnd();
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
        this.drawing = false;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingFill()) {
            if (this.getStyle().getFillColor().getAlpha() < 255) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    private void drawFill(GL gL) {
        if (this.fillDL == -1) {
            this.fillDL = gL.glGenLists(1);
            gL.glNewList(this.fillDL, 4864);
            gL.glBegin(4);
            int n = 0;
            while (n < this.data.length - 1) {
                int n2 = 0;
                while (n2 < this.data[n].length - 1) {
                    this.normalOf(gL, n, n2);
                    gL.glVertex3dv(this.data[n][n2], 0);
                    this.normalOf(gL, n + 1, n2);
                    gL.glVertex3dv(this.data[n + 1][n2], 0);
                    this.normalOf(gL, n + 1, n2 + 1);
                    gL.glVertex3dv(this.data[n + 1][n2 + 1], 0);
                    this.normalOf(gL, n + 1, n2 + 1);
                    gL.glVertex3dv(this.data[n + 1][n2 + 1], 0);
                    this.normalOf(gL, n, n2 + 1);
                    gL.glVertex3dv(this.data[n][n2 + 1], 0);
                    this.normalOf(gL, n, n2);
                    gL.glVertex3dv(this.data[n][n2], 0);
                    ++n2;
                }
                ++n;
            }
            gL.glEnd();
            gL.glEndList();
        }
        gL.glCallList(this.fillDL);
    }

    private boolean comp(double[] dArray, double[] dArray2) {
        return Math.abs(dArray[0] - dArray2[0]) < 1.0E-10 && Math.abs(dArray[1] - dArray2[1]) < 1.0E-10 && Math.abs(dArray[2] - dArray2[2]) < 1.0E-10;
    }

    private void normalOf(GL gL, int n, int n2) {
        double[] dArray = this.data[n][n2];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < this.data.length - 1) {
            int n4 = 0;
            while (n4 < this.data[n3].length - 1) {
                if (this.comp(this.data[n3 + 1][n4 + 1], dArray) || this.comp(this.data[n3][n4 + 1], dArray) || this.comp(this.data[n3][n4], dArray)) {
                    d += this.normals[n3][n4][1].x;
                    d2 += this.normals[n3][n4][1].y;
                    d3 += this.normals[n3][n4][1].z;
                    d4 += 1.0;
                }
                if (this.comp(this.data[n3][n4], dArray) || this.comp(this.data[n3 + 1][n4], dArray) || this.comp(this.data[n3 + 1][n4 + 1], dArray)) {
                    d += this.normals[n3][n4][0].x;
                    d2 += this.normals[n3][n4][0].y;
                    d3 += this.normals[n3][n4][0].z;
                    d4 += 1.0;
                }
                ++n4;
            }
            ++n3;
        }
        double d5 = (d /= d4) * d + (d2 /= d4) * d2 + (d3 /= d4) * d3;
        d5 = -1.0 / Math.sqrt(d5);
        gL.glNormal3d(d *= d5, d2 *= d5, d3 *= d5);
    }

    private void normalOfOld(GL gL, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-1, -1, 1};
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        nArray2[2] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArrayArray[3] = nArray3;
        nArrayArray[4] = new int[3];
        int[] nArray4 = new int[3];
        nArray4[2] = 1;
        nArrayArray[5] = nArray4;
        int[][] nArrayArray2 = nArrayArray;
        int n3 = 0;
        while (n3 < 6) {
            if (n + nArrayArray2[n3][0] >= 0 && n + nArrayArray2[n3][0] < this.normals.length && n2 + nArrayArray2[n3][1] >= 0 && n2 + nArrayArray2[n3][1] < this.normals[n + nArrayArray2[n3][0]].length) {
                d += this.normals[n + nArrayArray2[n3][0]][n2 + nArrayArray2[n3][1]][nArrayArray2[n3][2]].x;
                d2 += this.normals[n + nArrayArray2[n3][0]][n2 + nArrayArray2[n3][1]][nArrayArray2[n3][2]].y;
                d3 += this.normals[n + nArrayArray2[n3][0]][n2 + nArrayArray2[n3][1]][nArrayArray2[n3][2]].z;
                d4 += 1.0;
            }
            ++n3;
        }
        double d5 = (d /= d4) * d + (d2 /= d4) * d2 + (d3 /= d4) * d3;
        d5 = 1.0 / Math.sqrt(d5);
        gL.glNormal3d(-(d *= d5), -(d2 *= d5), -(d3 *= d5));
    }
}

