/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.Camera;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Vec3D;

public class ElementCircle
extends Element
implements org.opensourcephysics.display3d.core.ElementCircle {
    private double rotationAngle;

    public ElementCircle() {
        this.getStyle().setResolution(new Resolution(15, 15, 15));
        this.setSizeXYZ(0.01, 0.01, 0.01);
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        double d;
        int n;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        gL.glScaled(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        Camera camera = (Camera)this.getDrawingPanel3D().getCamera();
        Vec3D vec3D = camera.getDirection();
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        double[] dArray2 = new double[]{vec3D.x, vec3D.y, vec3D.z};
        this.toBodyFrame(dArray2);
        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.createAlignmentTransformation(dArray, dArray2);
        gL.glMultMatrixd(matrix3DTransformation.getFlatMatrix(null), 0);
        int n2 = -1;
        if (this.getStyle().isDrawingFill()) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
            gL.glDisable(2884);
            n2 = this.getNumEdges();
            this.preFillGL(gLAutoDrawable);
            gL.glBegin(9);
            n = 0;
            while (n < 360) {
                d = (double)n * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) / 2.0, Math.sin(d) / 2.0, 0.0);
                n += 360 / n2;
            }
            gL.glEnd();
            gL.glTranslated(0.0, 0.0, -0.001);
        }
        if (this.getStyle().isDrawingLines()) {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            if (n2 == -1) {
                n2 = this.getNumEdges();
            }
            this.preLinesGL(gLAutoDrawable);
            gL.glBegin(2);
            n = 0;
            while (n < 360) {
                d = (double)n * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) / 2.0, Math.sin(d) / 2.0, 0.0);
                n += 360 / n2;
            }
            gL.glEnd();
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    private int getNumEdges() {
        switch (this.getStyle().getResolution().getType()) {
            case 1: {
                return (int)(this.getSize().magnitude() / this.getStyle().getResolution().getMaxLength());
            }
        }
        return this.getStyle().getResolution().getN1();
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    private static void buildRot(double d, double d2, double d3, double d4, double[] dArray) {
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = Math.cos(Math.toRadians(d));
        double d7 = Math.sin(Math.toRadians(d));
        if (d5 > 0.0) {
            d5 = 1.0 / d5;
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        dArray[0] = 1.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        dArray[3] = 0.0;
        dArray[4] = 0.0;
        dArray[5] = 1.0;
        dArray[6] = 0.0;
        dArray[7] = 0.0;
        dArray[8] = 0.0;
        dArray[9] = 0.0;
        dArray[10] = 1.0;
        dArray[11] = 0.0;
        dArray[12] = 0.0;
        dArray[13] = 0.0;
        dArray[14] = 0.0;
        dArray[15] = 1.0;
        dArray[0] = d2 * d2 + d6 * (1.0 - d2 * d2) + d7 * 0.0;
        dArray[4] = d2 * d3 + d6 * (0.0 - d2 * d3) + d7 * -d4;
        dArray[8] = d2 * d4 + d6 * (0.0 - d2 * d4) + d7 * d3;
        dArray[1] = d3 * d2 + d6 * (0.0 - d3 * d2) + d7 * d4;
        dArray[5] = d3 * d3 + d6 * (1.0 - d3 * d3) + d7 * 0.0;
        dArray[9] = d3 * d4 + d6 * (0.0 - d3 * d4) + d7 * -d2;
        dArray[2] = d4 * d2 + d6 * (0.0 - d4 * d2) + d7 * -d3;
        dArray[6] = d4 * d3 + d6 * (0.0 - d4 * d3) + d7 * d2;
        dArray[10] = d4 * d4 + d6 * (1.0 - d4 * d4) + d7 * 0.0;
    }

    private static void calcMatrix(GL gL) {
        double[] dArray = new double[16];
        gL.glGetDoublev(2982, dArray, 0);
        ElementCircle.buildRot(-180.0 * Math.atan2(dArray[8], dArray[10]) / Math.PI, 0.0, 1.0, 0.0, dArray);
        gL.glMultMatrixd(dArray, 0);
    }

    private void drawBillBoard(GL gL, Vec3D vec3D, Vec3D vec3D2) {
        Vec3D vec3D3 = new Vec3D(vec3D);
        vec3D3.normalize();
        Vec3D vec3D4 = new Vec3D(0.0, 1.0, 0.0);
        Vec3D vec3D5 = new Vec3D();
        vec3D5.cross(vec3D4, vec3D3);
        vec3D5.normalize();
        vec3D4.cross(vec3D5, vec3D3);
        vec3D4.normalize();
        vec3D4.multiply(vec3D4, -1.0);
        double[] dArray = new double[16];
        dArray[0] = vec3D5.x;
        dArray[1] = vec3D5.y;
        dArray[2] = vec3D5.z;
        dArray[12] = 0.0;
        dArray[4] = vec3D4.x;
        dArray[5] = vec3D4.y;
        dArray[6] = vec3D4.z;
        dArray[13] = 0.0;
        dArray[8] = vec3D3.x;
        dArray[9] = vec3D3.y;
        dArray[10] = vec3D3.z;
        dArray[14] = 0.0;
        dArray[15] = 1.0;
        gL.glMultMatrixd(dArray, 0);
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingLines()) {
            return 1;
        }
        return 0;
    }
}

