/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.Color;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.display3d.java3d.Element;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;

public class ElementSpring
extends Element
implements org.opensourcephysics.display3d.core.ElementSpring,
GeometryUpdater {
    private int length = 0;
    private double radius = 0.1;
    LineStripArray lines;
    double[] points;
    double[] nextPoint;
    double[] size = new double[]{1.0, 0.0, 0.0};
    private int[] stripVertexCounts;

    public ElementSpring() {
        super.setSizeXYZ(1.0, 1.0, 1.0);
        this.points = new double[300];
        this.nextPoint = new double[3];
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
        this.getStyle().setLineColor(Color.black);
        this.getStyle().setResolution(new Resolution(8, 15, 1));
    }

    void init() {
        this.stripVertexCounts = new int[]{Math.max(2, this.length)};
        this.lines = new LineStripArray(this.points.length / 3, 129, this.stripVertexCounts);
        this.lines.setCapability(19);
        this.lines.setCapability(21);
        this.lines.setCapability(8);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCoordRefDouble(this.points);
        this.setNode((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 8) != 0) {
            this.computePoints();
        }
    }

    public void setRadius(double d) {
        if (this.radius != d) {
            this.radius = d;
            this.computePoints();
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void addPoint(double d, double d2, double d3) {
        this.nextPoint[0] = d;
        this.nextPoint[1] = d2;
        this.nextPoint[2] = d3;
        if (this.length * 3 == this.points.length) {
            double[] dArray = new double[this.length * 3 * 2];
            System.arraycopy(this.points, 0, dArray, 0, this.length * 3);
            this.points = dArray;
            this.init();
        } else {
            if (this.lines == null) {
                this.init();
            }
            this.lines.updateData((GeometryUpdater)this);
        }
    }

    public void updateData(Geometry geometry) {
        this.points[this.length * 3] = this.nextPoint[0];
        this.points[this.length * 3 + 1] = this.nextPoint[1];
        this.points[this.length * 3 + 2] = this.nextPoint[2];
        ++this.length;
        this.stripVertexCounts[0] = Math.max(2, this.length);
        if (this.length < 2) {
            this.points[this.length * 3] = this.nextPoint[0];
            this.points[this.length * 3 + 1] = this.nextPoint[1];
            this.points[this.length * 3 + 2] = this.nextPoint[2];
        }
        ((LineStripArray)geometry).setStripVertexCounts(this.stripVertexCounts);
    }

    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2]);
    }

    public void clear() {
        this.length = 0;
        this.init();
    }

    public void computePoints() {
        this.clear();
        int n = 0;
        int n2 = 0;
        org.opensourcephysics.display3d.core.Resolution resolution = this.getStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                default: 
            }
            n = Math.max(resolution.getN1(), 0);
            n2 = Math.max(resolution.getN2(), 1);
        }
        int n3 = n * n2 + 3;
        double[] dArray = VectorAlgebra.normalTo(this.size);
        double[] dArray2 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(this.size, dArray));
        double d = Math.PI * 2 / (double)n2;
        int n4 = n2 / 2;
        int n5 = 0;
        while (n5 <= n3) {
            int n6 = n5 < n4 ? 0 : (n5 < n2 ? n5 - n4 : (n5 > n3 - n4 ? 0 : (n5 > n3 - n2 ? n3 - n5 - n4 : n4)));
            double d2 = (double)n5 * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            this.addPoint((double)n5 * this.size[0] / (double)n3 + (double)n6 * this.radius * (d3 * dArray[0] + d4 * dArray2[0]) / (double)n4, (double)n5 * this.size[1] / (double)n3 + (double)n6 * this.radius * (d3 * dArray[1] + d4 * dArray2[1]) / (double)n4, (double)n5 * this.size[2] / (double)n3 + (double)n6 * this.radius * (d3 * dArray[2] + d4 * dArray2[2]) / (double)n4);
            ++n5;
        }
    }

    public void setSizeX(double d) {
        if (this.size[0] != d) {
            this.size[0] = d;
            this.computePoints();
        }
    }

    public void setSizeY(double d) {
        if (this.size[1] != d) {
            this.size[1] = d;
            this.computePoints();
        }
    }

    public void setSizeZ(double d) {
        if (this.size[2] != d) {
            this.size[2] = d;
            this.computePoints();
        }
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        if (this.size[0] != d || this.size[1] != d2 || this.size[2] != d3) {
            this.size[0] = d;
            this.size[1] = d2;
            this.size[2] = d3;
            this.computePoints();
        }
    }

    public double getSizeX() {
        return this.size[0];
    }

    public double getSizeY() {
        return this.size[1];
    }

    public double getSizeZ() {
        return this.size[2];
    }
}

