/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.java3d.Camera;
import org.opensourcephysics.display3d.java3d.Element;
import org.opensourcephysics.display3d.java3d.ElementArrow;
import org.opensourcephysics.display3d.java3d.ElementSegment;
import org.opensourcephysics.display3d.java3d.ElementText;
import org.opensourcephysics.display3d.java3d.Group;
import org.opensourcephysics.display3d.java3d.InteractionTarget;
import org.opensourcephysics.display3d.java3d.OffScreenCanvas3D;
import org.opensourcephysics.display3d.java3d.TextPanel;
import org.opensourcephysics.display3d.java3d.VisualizationHints;
import org.opensourcephysics.tools.VideoTool;

public class DrawingPanel3D
implements org.opensourcephysics.display3d.core.DrawingPanel3D,
MouseListener,
MouseMotionListener,
KeyListener,
Renderable {
    private ArrayList elements;
    public Canvas3D canvas;
    private VisualizationHints visHints;
    private JFrame parent;
    private int keyPressed = -1;
    private Camera camera;
    private ElementArrow xAxis;
    private ElementArrow yAxis;
    private ElementArrow zAxis;
    public ElementText xText;
    public ElementText yText;
    public ElementText zText;
    private Group box;
    private BoundingSphere bounds;
    private boolean requestingPickingUpdate = false;
    private MouseEvent lastMotionEvent;
    private MouseEvent lastPressEvent;
    private InteractionTarget lastPickedTarget;
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int trackersVisible;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private ArrayList listeners = new ArrayList();
    private ElementSegment[] trackerLines = null;
    private double aconstant;
    private double bconstant;
    private boolean requestingImageRender = false;
    private BufferedImage renderTo;
    private double maxObjectDistance = 500.0;
    private SimpleUniverse universe;
    private TransformGroup root;
    private BranchGroup branchGroup;
    private PickCanvas pickCanvas;
    Vector textList = new Vector();
    protected Java3DTextPanel trMessageBox = new Java3DTextPanel();
    protected Java3DTextPanel tlMessageBox = new Java3DTextPanel();
    protected Java3DTextPanel brMessageBox = new Java3DTextPanel();
    protected Java3DTextPanel blMessageBox = new Java3DTextPanel();
    private OffScreenCanvas3D offScreenCanvas;
    protected VideoTool vidCap;
    boolean first = true;
    private int mouseX;
    private int mouseY;
    private int dX;
    private int dY;
    private int lastX;
    private int lastY;

    public DrawingPanel3D() {
        this.elements = new ArrayList();
        this.visHints = new VisualizationHints(this);
        GraphicsConfiguration graphicsConfiguration = DrawingPanel3D.getPreferredConfiguration();
        int n = 300;
        int n2 = 300;
        this.canvas = new RenderCanvas(graphicsConfiguration);
        this.canvas.setSize(new Dimension(n, n2));
        this.offScreenCanvas = new OffScreenCanvas3D(graphicsConfiguration, true);
        this.canvas.setBackground(new Color(0.9372549f, 0.9372549f, 1.0f, 1.0f));
        String[] stringArray = this.visHints.getAxesLabels();
        this.xAxis = new ElementArrow();
        this.xAxis.getStyle().setLineColor(Color.red);
        this.xAxis.getStyle().setFillColor(Color.red);
        this.xAxis.setVisible(false);
        this.yAxis = new ElementArrow();
        this.yAxis.getStyle().setLineColor(Color.green);
        this.yAxis.getStyle().setFillColor(Color.green);
        this.yAxis.setVisible(false);
        this.zAxis = new ElementArrow();
        this.zAxis.getStyle().setLineColor(Color.blue);
        this.zAxis.getStyle().setFillColor(Color.blue);
        this.zAxis.setVisible(false);
        this.xText = new ElementText(stringArray[0]);
        this.xText.setDrawingPanel3D(this);
        this.xText.setVisible(false);
        this.xText.setFont(new Font("Dialog", 0, 12));
        this.textList.add(this.xText);
        this.yText = new ElementText(stringArray[1]);
        this.yText.setDrawingPanel3D(this);
        this.yText.setVisible(false);
        this.yText.setFont(new Font("Dialog", 0, 12));
        this.textList.add(this.yText);
        this.zText = new ElementText(stringArray[2]);
        this.zText.setDrawingPanel3D(this);
        this.zText.setVisible(false);
        this.zText.setFont(new Font("Dialog", 0, 12));
        this.textList.add(this.zText);
        this.trackerLines = new ElementSegment[9];
        int n3 = 0;
        int n4 = this.trackerLines.length;
        while (n3 < n4) {
            this.trackerLines[n3] = new ElementSegment();
            this.trackerLines[n3].setVisible(false);
            ++n3;
        }
        this.setCursorMode();
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(14);
        Background background = new Background(new Color3f(this.canvas.getBackground()));
        background.setApplicationBounds((Bounds)new BoundingSphere());
        this.branchGroup.addChild((Node)background);
        this.bounds = new BoundingSphere();
        this.bounds.setRadius(Double.MAX_VALUE);
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBounds((Bounds)this.bounds);
        this.branchGroup.addChild((Node)ambientLight);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setInfluencingBounds((Bounds)this.bounds);
        Vector3f vector3f = new Vector3f(-1.0f, -1.0f, -1.0f);
        vector3f.normalize();
        directionalLight.setDirection(vector3f);
        directionalLight.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        this.branchGroup.addChild((Node)directionalLight);
        this.box = new Group();
        ElementSegment elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, -0.5, -0.5);
        elementSegment.setSizeXYZ(1.0, 0.0, 0.0);
        elementSegment.getStyle().setLineColor(new Color(255, 0, 0));
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, -0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 1.0, 0.0);
        elementSegment.getStyle().setLineColor(new Color(0, 255, 0));
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, -0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 0.0, 1.0);
        elementSegment.getStyle().setLineColor(new Color(0, 0, 255));
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, 0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 0.0, 1.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, 0.5, -0.5);
        elementSegment.setSizeXYZ(1.0, 0.0, 0.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(0.5, -0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 0.0, 1.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(0.5, -0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 1.0, 0.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(0.5, 0.5, -0.5);
        elementSegment.setSizeXYZ(0.0, 0.0, 1.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, -0.5, 0.5);
        elementSegment.setSizeXYZ(1.0, 0.0, 0.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, -0.5, 0.5);
        elementSegment.setSizeXYZ(0.0, 1.0, 0.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(-0.5, 0.5, 0.5);
        elementSegment.setSizeXYZ(1.0, 0.0, 0.0);
        this.box.addElement(elementSegment);
        elementSegment = new ElementSegment();
        elementSegment.setXYZ(0.5, -0.5, 0.5);
        elementSegment.setSizeXYZ(0.0, 1.0, 0.0);
        this.box.addElement(elementSegment);
        this.root = new TransformGroup();
        this.root.setCapability(14);
        this.root.setCapability(18);
        this.root.setCapability(17);
        this.root.setBounds((Bounds)this.bounds);
        this.branchGroup.addChild((Node)this.root);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMotionListener((MouseMotionListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.camera = new Camera(this);
        this.camera.setTransformGroup(this.root);
        this.universe = new SimpleUniverse(this.canvas);
        this.universe.getViewer().getView().setLocalEyeLightingEnable(true);
        this.universe.getViewer().getView().setCompatibilityModeEnable(false);
        this.universe.getViewer().getView().setBackClipDistance(200.0);
        this.pickCanvas = new PickCanvas(this.canvas, this.branchGroup);
        this.pickCanvas.setMode(512);
        this.universe.addBranchGraph(this.branchGroup);
        this.root.addChild((Node)this.box.getBranch());
        this.root.addChild((Node)this.xAxis.getBranch());
        this.root.addChild((Node)this.xText.getBranch());
        this.root.addChild((Node)this.yAxis.getBranch());
        this.root.addChild((Node)this.yText.getBranch());
        this.root.addChild((Node)this.zAxis.getBranch());
        this.root.addChild((Node)this.zText.getBranch());
        int n5 = 0;
        int n6 = this.trackerLines.length;
        while (n5 < n6) {
            this.root.addChild((Node)this.trackerLines[n5].getBranch());
            ++n5;
        }
        this.visHints.setDecorationType(2);
        Screen3D screen3D = this.canvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D((Canvas3D)this.offScreenCanvas);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    private static final GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (string != null) {
            if (string.equals("REQUIRED")) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if (string.equals("PREFERRED")) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
    }

    private void setBehaviorForBackgroundObjects() {
        this.box.setDrawingPanel3D(this);
        this.xAxis.setDrawingPanel3D(this);
        this.yAxis.setDrawingPanel3D(this);
        this.zAxis.setDrawingPanel3D(this);
        this.xText.setDrawingPanel3D(this);
        this.yText.setDrawingPanel3D(this);
        this.zText.setDrawingPanel3D(this);
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            this.trackerLines[n].setDrawingPanel3D(this);
            ++n;
        }
    }

    public double getScreenRatio() {
        return this.isSquareAspect() ? (float)this.canvas.getWidth() / (float)this.canvas.getHeight() : 1.0f;
    }

    public void cameraChanged(int n) {
        if (n == 5) {
            double d = Math.sqrt(this.box.getSizeX() * this.box.getSizeX() + this.box.getSizeY() * this.box.getSizeY() + this.box.getSizeZ() * this.box.getSizeZ());
            double d2 = 1.37;
            double d3 = 2.0 * Math.atan(d2 * d / (2.0 * this.camera.getDistanceToScreen()));
            this.universe.getViewer().getView().setFieldOfView(d3);
        }
        int n2 = 0;
        while (n2 < this.textList.size()) {
            ElementText elementText = (ElementText)this.textList.get(n2);
            elementText.update(this.camera);
            ++n2;
        }
    }

    public void setParent(JFrame jFrame, DrawingPanel3D drawingPanel3D) {
        if (this.parent != null && drawingPanel3D != null) {
            this.parent.getContentPane().remove((Component)drawingPanel3D.canvas);
        }
        this.parent = jFrame;
        if (jFrame != null) {
            jFrame.getContentPane().add((Component)this.canvas, "Center");
        }
        this.setBehaviorForBackgroundObjects();
    }

    public void resizeBoundsFor(org.opensourcephysics.display3d.core.Element element) {
        Vector3d vector3d = new Vector3d(this.box.getSize());
        vector3d.scale(0.5);
        this.box.getPosition().sub((Tuple3d)vector3d);
        if (element instanceof ElementSegment) {
            element.setX(element.getX() - element.getSizeX() / 2.0);
            element.setY(element.getY() - element.getSizeY() / 2.0);
            element.setZ(element.getZ() - element.getSizeZ() / 2.0);
        }
        Vector3d vector3d2 = new Vector3d(this.box.getPosition());
        Vector3d vector3d3 = new Vector3d(vector3d2);
        vector3d3.add((Tuple3d)this.box.getSize());
        if (vector3d2.x > element.getX() - element.getSizeX() / 2.0) {
            vector3d2.x = element.getX() - element.getSizeX() / 2.0;
        }
        if (vector3d2.y > element.getY() - element.getSizeY() / 2.0) {
            vector3d2.y = element.getY() - element.getSizeY() / 2.0;
        }
        if (vector3d2.z > element.getZ() - element.getSizeZ() / 2.0) {
            vector3d2.z = element.getZ() - element.getSizeZ() / 2.0;
        }
        if (vector3d3.x < element.getX() + element.getSizeX() / 2.0) {
            vector3d3.x = element.getX() + element.getSizeX() / 2.0;
        }
        if (vector3d3.y < element.getY() + element.getSizeY() / 2.0) {
            vector3d3.y = element.getY() + element.getSizeY() / 2.0;
        }
        if (vector3d3.z < element.getZ() + element.getSizeZ() / 2.0) {
            vector3d3.z = element.getZ() + element.getSizeZ() / 2.0;
        }
        if (element instanceof ElementSegment) {
            element.setX(element.getX() + element.getSizeX() / 2.0);
            element.setY(element.getY() + element.getSizeY() / 2.0);
            element.setZ(element.getZ() + element.getSizeZ() / 2.0);
        }
        this.box.setXYZ(vector3d2.x, vector3d2.y, vector3d2.z);
        vector3d3.sub((Tuple3d)vector3d2);
        this.box.setSizeXYZ(vector3d3.x, vector3d3.y, vector3d3.z);
        vector3d = new Vector3d(this.box.getSize());
        vector3d.scale(0.5);
        this.box.getPosition().add((Tuple3d)vector3d);
        double d = this.getMaximum3DSize();
        this.aconstant = 0.5 * (double)this.canvas.getWidth() / d;
        this.bconstant = 0.5 * (double)this.canvas.getHeight() / d;
        if (element instanceof Group) {
            Iterator iterator = ((Group)element).getElements().iterator();
            while (iterator.hasNext()) {
                this.resizeBoundsFor((Element)iterator.next());
            }
        }
    }

    public Component getComponent() {
        return this.canvas;
    }

    public double[] getCenter() {
        return new double[]{this.box.getX(), this.box.getY(), this.box.getZ()};
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4, double d5, double d6) {
        this.box.setXYZ((d2 + d) / 2.0, (d4 + d3) / 2.0, (d6 + d5) / 2.0);
        this.box.setSizeXYZ(d2 - d, d4 - d3, d6 - d5);
        this.resetAxes();
        this.camera.reset();
    }

    public double getPreferredMinX() {
        return this.box.getX() - this.box.getSizeX() / 2.0;
    }

    public double getPreferredMaxX() {
        return this.box.getX() + this.box.getSizeX() / 2.0;
    }

    public double getPreferredMinY() {
        return this.box.getY() - this.box.getSizeY() / 2.0;
    }

    public double getPreferredMaxY() {
        return this.box.getY() + this.box.getSizeY() / 2.0;
    }

    public double getPreferredMinZ() {
        return this.box.getZ() - this.box.getSizeZ() / 2.0;
    }

    public double getPreferredMaxZ() {
        return this.box.getZ() + this.box.getSizeZ() / 2.0;
    }

    public void zoomToFit() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).getExtrema(dArray, dArray2);
            d = Math.min(Math.min(d, dArray[0]), dArray2[0]);
            d2 = Math.max(Math.max(d2, dArray[0]), dArray2[0]);
            d3 = Math.min(Math.min(d3, dArray[1]), dArray2[1]);
            d4 = Math.max(Math.max(d4, dArray[1]), dArray2[1]);
            d5 = Math.min(Math.min(d5, dArray[2]), dArray2[2]);
            d6 = Math.max(Math.max(d6, dArray[2]), dArray2[2]);
        }
        double d7 = Math.max(Math.max(d2 - d, d4 - d3), d6 - d5);
        if (d7 == 0.0) {
            d7 = 2.0;
        }
        if (d >= d2) {
            d = d2 - d7 / 2.0;
            d2 = d + d7;
        }
        if (d3 >= d4) {
            d3 = d4 - d7 / 2.0;
            d4 = d3 + d7;
        }
        if (d5 >= d6) {
            d5 = d6 - d7 / 2.0;
            d6 = d5 + d7;
        }
        this.setPreferredMinMax(d, d2, d3, d4, d5, d6);
    }

    public void setSquareAspect(boolean bl) {
    }

    public boolean isSquareAspect() {
        return false;
    }

    public org.opensourcephysics.display3d.core.VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    public org.opensourcephysics.display3d.core.Camera getCamera() {
        return this.camera;
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
    }

    public BufferedImage render() {
        BufferedImage bufferedImage = null;
        if (this.vidCap != null && this.vidCap.isRecording() && (bufferedImage = this.render(null)) != null) {
            this.vidCap.addFrame(bufferedImage);
        }
        return bufferedImage;
    }

    public BufferedImage render(BufferedImage bufferedImage) {
        bufferedImage = bufferedImage == null ? this.offScreenCanvas.doRender(null, this.canvas.getWidth(), this.canvas.getHeight()) : this.offScreenCanvas.doRender(bufferedImage, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
        return bufferedImage;
    }

    public void repaint() {
    }

    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to panel (incorrect implementation)");
        }
        if (!this.elements.contains(element)) {
            this.elements.add(element);
            ((Element)element).setDrawingPanel3D(this);
            this.root.addChild((Node)((Element)element).getBranch());
            if (element instanceof ElementText) {
                this.textList.add(element);
            }
            this.maxObjectDistance = this.getMaximum3DSize();
            this.maxObjectDistance *= 10.0;
        }
    }

    public void addBehavior(Behavior behavior) {
        if (this.root != null) {
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.addChild((Node)behavior);
            this.root.addChild((Node)branchGroup);
            behavior.setSchedulingBounds((Bounds)this.bounds);
        }
    }

    private void resetAxes() {
        this.xAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.xAxis.setSizeXYZ(this.box.getSizeX(), 0.0, 0.0);
        this.xText.setXYZ(this.xAxis.getX() + this.xAxis.getSizeX() * 1.01, this.xAxis.getY() + this.xAxis.getSizeY() * 1.01, this.xAxis.getZ() + this.xAxis.getSizeZ() * 1.01);
        this.yAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.yAxis.setSizeXYZ(0.0, this.box.getSizeY(), 0.0);
        this.yText.setXYZ(this.yAxis.getX() + this.yAxis.getSizeX() * 1.01, this.yAxis.getY() + this.yAxis.getSizeY() * 1.01, this.yAxis.getZ() + this.yAxis.getSizeZ() * 1.01);
        this.zAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.zAxis.setSizeXYZ(0.0, 0.0, this.box.getSizeZ());
        this.zText.setXYZ(this.zAxis.getX() + this.zAxis.getSizeX() * 1.01, this.zAxis.getY() + this.zAxis.getSizeY() * 1.01, this.zAxis.getZ() + this.zAxis.getSizeZ() * 1.01);
    }

    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        this.elements.remove(element);
    }

    public void removeAllElements() {
        this.elements.clear();
    }

    public ArrayList getElements() {
        return null;
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        return this.myTarget;
    }

    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    final double getMaximum3DSize() {
        double d = this.box.getSizeX();
        double d2 = this.box.getSizeY();
        double d3 = this.box.getSizeZ();
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(d, d2);
            }
            case 1: {
                return Math.max(d, d3);
            }
            case 2: {
                return Math.max(d2, d3);
            }
        }
        return Math.max(Math.max(d, d2), d3);
    }

    public void setQuickRedraw(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mousePressed(MouseEvent mouseEvent) {
        this.canvas.requestFocus();
        this.setQuickRedraw(this.visHints.isAllowQuickRedraw() && this.keyPressed != 83);
        this.rePickTarget();
        this.targetHit = this.lastPickedTarget;
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            this.trackerPoint = element.getHotSpot(this.targetHit);
            element.invokeActions(new InteractionEvent((Object)element, 2000, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
            this.trackerPoint = element.getHotSpot(this.targetHit);
        } else {
            if (!this.myTarget.isEnabled()) {
                this.resetInteraction();
                return;
            }
            if (this.camera.is3dMode() && !mouseEvent.isAltDown()) {
                this.invokeActions(new InteractionEvent((Object)this, 2000, this.myTarget.getActionCommand(), null, mouseEvent));
                this.resetInteraction();
                return;
            }
            this.trackerPoint = this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
            this.invokeActions(new InteractionEvent((Object)this, 2000, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
        }
        this.positionTrackers();
        this.showTrackers(true);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            element.invokeActions(new InteractionEvent((Object)element, 2002, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
        } else if (this.myTarget.isEnabled()) {
            if (!this.camera.is3dMode() || mouseEvent.isAltDown()) {
                this.invokeActions(new InteractionEvent((Object)this, 2002, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
            } else {
                this.invokeActions(new InteractionEvent((Object)this, 2002, this.myTarget.getActionCommand(), null, mouseEvent));
            }
        }
        this.resetInteraction();
        this.setQuickRedraw(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl = this.mouseDraggedComputations(mouseEvent);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        if (!bl) {
            this.invokeActions(new InteractionEvent((Object)this, 2001, this.myTarget.getActionCommand(), null, mouseEvent));
            this.resetInteraction();
            return;
        }
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            element.updateHotSpot(this.targetHit, this.trackerPoint);
            element.invokeActions(new InteractionEvent((Object)element, 2001, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
            this.trackerPoint = element.getHotSpot(this.targetHit);
            this.displayPosition(this.trackerPoint);
            this.positionTrackers();
            this.showTrackers(true);
        } else if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2001, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
            this.displayPosition(this.trackerPoint);
            this.positionTrackers();
            this.showTrackers(true);
        }
    }

    private void displayPosition(double[] dArray) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), dArray);
    }

    private void setMouseCursor(Cursor cursor) {
        this.canvas.setCursor(cursor);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setMouseCursor(Cursor.getPredefinedCursor(1));
        if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2003, this.myTarget.getActionCommand(), null, mouseEvent));
        }
        this.targetEntered = null;
        this.targetHit = null;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setMouseCursor(Cursor.getPredefinedCursor(0));
        if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2004, this.myTarget.getActionCommand(), null, mouseEvent));
        }
        this.targetEntered = null;
        this.targetHit = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.lastMotionEvent = mouseEvent;
        this.rePickTarget();
        InteractionTarget interactionTarget = this.lastPickedTarget;
        if (interactionTarget != null) {
            if (this.targetEntered == null) {
                interactionTarget.getElement().invokeActions(new InteractionEvent((Object)interactionTarget.getElement(), 2003, interactionTarget.getActionCommand(), interactionTarget, mouseEvent));
            }
            this.setMouseCursor(Cursor.getPredefinedCursor(12));
        } else {
            if (this.targetEntered != null) {
                this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)this.targetEntered.getElement(), 2004, this.targetEntered.getActionCommand(), this.targetEntered, mouseEvent));
            } else if (this.myTarget.isEnabled()) {
                this.invokeActions(new InteractionEvent((Object)this, 2005, this.myTarget.getActionCommand(), null, mouseEvent));
            }
            this.setMouseCursor(Cursor.getPredefinedCursor(1));
        }
        this.targetEntered = interactionTarget;
    }

    private boolean mouseDraggedComputations(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            if (this.camera.is3dMode()) {
                double d = this.camera.getFocusX();
                double d2 = this.camera.getFocusY();
                double d3 = this.camera.getFocusZ();
                double d4 = (double)(mouseEvent.getX() - this.lastX) * this.getMaximum3DSize() * 0.01;
                double d5 = (double)(mouseEvent.getY() - this.lastY) * this.getMaximum3DSize() * 0.01;
                switch (this.keyPressed) {
                    case 88: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d + d5, d2, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d - d5, d2, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3);
                        break;
                    }
                    case 89: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d5, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2 - d5, d3);
                        break;
                    }
                    case 90: {
                        if (this.camera.cosBeta >= 0.0) {
                            this.camera.setFocusXYZ(d, d2, d3 + d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2, d3 - d5);
                        break;
                    }
                    default: {
                        if (this.camera.cosBeta < 0.0) {
                            d5 = -d5;
                        }
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3 + d5);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3 + d5);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3 - d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3 - d5);
                    }
                }
            }
            return false;
        }
        if (mouseEvent.isShiftDown()) {
            this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(mouseEvent.getY() - this.lastY) * this.getMaximum3DSize() * 0.01);
            return false;
        }
        if (this.camera.is3dMode() && this.targetHit == null && !mouseEvent.isAltDown()) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - (double)(mouseEvent.getX() - this.lastX) * 0.01, this.camera.getAltitude() + (double)(mouseEvent.getY() - this.lastY) * 0.005);
            return false;
        }
        if (this.trackerPoint == null) {
            return true;
        }
        double[] dArray = this.worldDistance(mouseEvent.getX() - this.lastX, mouseEvent.getY() - this.lastY);
        if (!this.camera.is3dMode()) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
            }
        } else {
            switch (this.keyPressed) {
                case 88: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] + dArray[1];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[1];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[1] = this.trackerPoint[1] - dArray[1];
                    break;
                }
                case 90: {
                    if (this.camera.cosBeta >= 0.0) {
                        this.trackerPoint[2] = this.trackerPoint[2] - dArray[1];
                        break;
                    }
                    this.trackerPoint[2] = this.trackerPoint[2] - dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[2] = this.camera.cosBeta >= 0.0 ? this.trackerPoint[2] - dArray[1] : this.trackerPoint[2] + dArray[1];
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                }
            }
        }
        return true;
    }

    public void rePickTarget() {
        if (this.lastMotionEvent == null) {
            return;
        }
        this.pickCanvas.setShapeLocation(this.lastMotionEvent.getX(), this.lastMotionEvent.getY());
        PickResult[] pickResultArray = null;
        try {
            pickResultArray = this.pickCanvas.pickAllSorted();
        }
        catch (Exception exception) {
            pickResultArray = null;
        }
        if (pickResultArray != null) {
            Object object;
            Element element = null;
            int n = 0;
            while (n < pickResultArray.length && element == null) {
                object = pickResultArray[n].getSceneGraphPath();
                Iterator iterator = this.elements.iterator();
                while (iterator.hasNext() && element == null) {
                    element = this.findElement((Element)iterator.next(), (SceneGraphPath)object);
                }
                ++n;
            }
            if (element != null) {
                InteractionTarget interactionTarget = (InteractionTarget)element.getInteractionTarget(0);
                object = (InteractionTarget)element.getInteractionTarget(1);
                this.lastPickedTarget = interactionTarget != null && interactionTarget.isEnabled() ? interactionTarget : (object != null && ((InteractionTarget)object).isEnabled() ? object : null);
            } else {
                this.lastPickedTarget = null;
            }
        } else {
            this.lastPickedTarget = null;
        }
    }

    private Element findElement(Element element, SceneGraphPath sceneGraphPath) {
        if (element instanceof Group) {
            ArrayList arrayList = ((Group)element).getElements();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Element element2 = this.findElement((Element)iterator.next(), sceneGraphPath);
                if (element2 == null) continue;
                return element2;
            }
        } else {
            int n = sceneGraphPath.nodeCount();
            int n2 = 0;
            while (n2 < n) {
                Node node = sceneGraphPath.getNode(n2);
                if (node == element.transformGroup) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.showTrackers(false);
    }

    private void showTrackers(boolean bl) {
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            if (n < this.trackersVisible) {
                this.trackerLines[n].setVisible(bl);
            } else {
                this.trackerLines[n].setVisible(false);
            }
            ++n;
        }
    }

    private void positionTrackers() {
        double d = this.box.getX() - this.box.getSizeX() * 0.5;
        double d2 = this.box.getY() - this.box.getSizeY() * 0.5;
        double d3 = this.box.getZ() - this.box.getSizeZ() * 0.5;
        switch (this.visHints.getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[1].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(d, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], d2, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[3].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[4].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[6].setXYZ(d, d2, this.trackerPoint[2]);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[7].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[8].setXYZ(d, d2, this.trackerPoint[2]);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(d, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.box.getSizeX(), 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], d2, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.box.getSizeY(), 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.box.getSizeZ());
            }
        }
    }

    private void invokeActions(InteractionEvent interactionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((InteractionListener)iterator.next()).interactionPerformed(interactionEvent);
        }
    }

    private double[] worldDistance(double d, double d2) {
        double d3 = this.getMaximum3DSize();
        this.aconstant = 0.5 * (double)this.canvas.getWidth() / d3;
        this.bconstant = 0.5 * (double)this.canvas.getHeight() / d3;
        double d4 = 1.5;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{d / (d4 * this.aconstant), -d2 / (d4 * this.bconstant), 0.0};
            }
            case 1: {
                return new double[]{d / (d4 * this.aconstant), 0.0, -d2 / (d4 * this.bconstant)};
            }
            case 2: {
                return new double[]{0.0, d / (d4 * this.aconstant), -d2 / (d4 * this.bconstant)};
            }
        }
        d4 = 1.0;
        return new double[]{d / (d4 * this.aconstant), d2 / (d4 * this.bconstant), 0.0};
    }

    private double[] worldPoint(int n, int n2) {
        return this.getCenter();
    }

    private void setCursorMode() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    void hintChanged(int n) {
        switch (n) {
            case 0: {
                switch (this.visHints.getDecorationType()) {
                    case 0: {
                        this.box.setVisible(false);
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 2: {
                        this.box.setVisible(true);
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 1: {
                        this.box.setVisible(false);
                        this.xAxis.setVisible(true);
                        this.yAxis.setVisible(true);
                        this.zAxis.setVisible(true);
                        this.xText.setVisible(true);
                        this.yText.setVisible(true);
                        this.zText.setVisible(true);
                    }
                }
                break;
            }
            case 4: {
                this.setCursorMode();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                String[] stringArray = this.visHints.getAxesLabels();
                this.xText.setText(stringArray[0]);
                this.yText.setText(stringArray[1]);
                this.zText.setText(stringArray[2]);
            }
        }
    }

    public void setMessage(String string) {
        this.brMessageBox.setText(string);
    }

    public void setMessage(String string, int n) {
        switch (n) {
            case 0: {
                this.blMessageBox.setText(string);
                break;
            }
            default: {
                this.brMessageBox.setText(string);
                break;
            }
            case 2: {
                this.trMessageBox.setText(string);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(string);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private class Java3DTextPanel
    extends TextPanel {
        private BufferedImage image;

        public Java3DTextPanel() {
            int n = 200;
            int n2 = 50;
            this.image = new BufferedImage(n, n2, 2);
        }

        public void render(J3DGraphics2D j3DGraphics2D) {
            if (this == DrawingPanel3D.this.tlMessageBox) {
                j3DGraphics2D.drawAndFlushImage(this.image, 0, 0, null);
            } else if (this == DrawingPanel3D.this.trMessageBox) {
                j3DGraphics2D.drawAndFlushImage(this.image, DrawingPanel3D.this.canvas.getWidth() - this.getWidth(), 0, null);
            } else if (this == DrawingPanel3D.this.brMessageBox) {
                j3DGraphics2D.drawAndFlushImage(this.image, DrawingPanel3D.this.canvas.getWidth() - this.getWidth(), DrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
            } else if (this == DrawingPanel3D.this.blMessageBox) {
                j3DGraphics2D.drawAndFlushImage(this.image, 0, DrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.image.getWidth() != this.getWidth() || this.image.getHeight() != this.getHeight()) {
                this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            }
            this.paint(this.image.getGraphics());
        }
    }

    class RenderCanvas
    extends Canvas3D
    implements Renderable {
        RenderCanvas(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration);
        }

        public void postRender() {
            J3DGraphics2D j3DGraphics2D = DrawingPanel3D.this.canvas.getGraphics2D();
            DrawingPanel3D.this.tlMessageBox.render(j3DGraphics2D);
            DrawingPanel3D.this.trMessageBox.render(j3DGraphics2D);
            DrawingPanel3D.this.brMessageBox.render(j3DGraphics2D);
            DrawingPanel3D.this.blMessageBox.render(j3DGraphics2D);
        }

        public BufferedImage render() {
            return DrawingPanel3D.this.render();
        }

        public BufferedImage render(BufferedImage bufferedImage) {
            return DrawingPanel3D.this.render(bufferedImage);
        }
    }
}

