/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public class HardcopyWriter
extends Writer {
    protected PrintJob job;
    protected Graphics page;
    protected String jobname;
    protected int fontsize;
    protected String time;
    protected Dimension pagesize;
    protected int pagedpi;
    protected Font font;
    protected Font headerfont;
    protected FontMetrics metrics;
    protected FontMetrics headermetrics;
    protected int x0;
    protected int y0;
    protected int width;
    protected int height;
    protected int headery;
    protected int charwidth;
    protected int lineheight;
    protected int lineascent;
    protected int chars_per_line;
    protected int lines_per_page;
    protected int charnum = 0;
    protected int linenum = 0;
    protected int pagenum = 0;
    private boolean last_char_was_return = false;
    protected static Properties printprops = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardcopyWriter(Frame frame, String string, int n, double d, double d2, double d3, double d4) throws PrintCanceledException {
        Toolkit toolkit = frame.getToolkit();
        Cloneable cloneable = printprops;
        synchronized (cloneable) {
            this.job = toolkit.getPrintJob(frame, string, printprops);
        }
        if (this.job == null) {
            throw new PrintCanceledException("User cancelled print request");
        }
        this.pagesize = this.job.getPageDimension();
        this.pagedpi = this.job.getPageResolution();
        if (System.getProperty("os.name").regionMatches(true, 0, "windows", 0, 7)) {
            this.pagedpi = toolkit.getScreenResolution();
            this.pagesize = new Dimension((int)(8.5 * (double)this.pagedpi), 11 * this.pagedpi);
            this.pagesize = new Dimension((int)(8.2677 * (double)this.pagedpi), 11 * this.pagedpi);
            this.pagesize = new Dimension((int)(6.25 * (double)this.pagedpi), 9 * this.pagedpi);
            n = n * this.pagedpi / 72;
        }
        this.x0 = (int)(d * (double)this.pagedpi);
        this.y0 = (int)(d3 * (double)this.pagedpi);
        this.width = this.pagesize.width - (int)((d + d2) * (double)this.pagedpi);
        this.height = this.pagesize.height - (int)((d3 + d4) * (double)this.pagedpi);
        this.font = new Font("Monospaced", 0, n);
        this.metrics = frame.getFontMetrics(this.font);
        this.lineheight = this.metrics.getHeight();
        this.lineascent = this.metrics.getAscent();
        this.charwidth = this.metrics.charWidth('0');
        this.chars_per_line = this.width / this.charwidth;
        this.lines_per_page = this.height / this.lineheight;
        this.headerfont = new Font("SansSerif", 2, n);
        this.headermetrics = frame.getFontMetrics(this.headerfont);
        this.headery = this.y0 - (int)(0.125 * (double)this.pagedpi) - this.headermetrics.getHeight() + this.headermetrics.getAscent();
        cloneable = DateFormat.getDateTimeInstance(1, 3);
        ((DateFormat)cloneable).setTimeZone(TimeZone.getDefault());
        this.time = ((DateFormat)cloneable).format(new Date());
        this.jobname = string;
        this.fontsize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = n;
            while (n3 < n + n2) {
                if (this.page == null) {
                    this.newpage();
                }
                if (cArray[n3] == '\n') {
                    if (!this.last_char_was_return) {
                        this.newline();
                    }
                } else if (cArray[n3] == '\r') {
                    this.newline();
                    this.last_char_was_return = true;
                } else {
                    this.last_char_was_return = false;
                    if (!Character.isWhitespace(cArray[n3]) || Character.isSpaceChar(cArray[n3]) || cArray[n3] == '\t') {
                        if (this.charnum >= this.chars_per_line) {
                            this.newline();
                            if (this.page == null) {
                                this.newpage();
                            }
                        }
                        if (Character.isSpaceChar(cArray[n3])) {
                            ++this.charnum;
                        } else if (cArray[n3] == '\t') {
                            this.charnum += 8 - this.charnum % 8;
                        } else {
                            this.page.drawChars(cArray, n3, 1, this.x0 + this.charnum * this.charwidth, this.y0 + this.linenum * this.lineheight + this.lineascent);
                            ++this.charnum;
                        }
                    }
                }
                ++n3;
            }
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.page != null) {
                this.page.dispose();
            }
            this.job.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontStyle(int n) {
        Object object = this.lock;
        synchronized (object) {
            Font font = this.font;
            try {
                this.font = new Font("Monospaced", n, this.fontsize);
            }
            catch (Exception exception) {
                this.font = font;
            }
            if (this.page != null) {
                this.page.setFont(this.font);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageBreak() {
        Object object = this.lock;
        synchronized (object) {
            this.newpage();
        }
    }

    public int getCharactersPerLine() {
        return this.chars_per_line;
    }

    public int getLinesPerPage() {
        return this.lines_per_page;
    }

    protected void newline() {
        this.charnum = 0;
        ++this.linenum;
        if (this.linenum >= this.lines_per_page) {
            this.page.dispose();
            this.page = null;
        }
    }

    protected void newpage() {
        this.page = this.job.getGraphics();
        this.linenum = 0;
        this.charnum = 0;
        ++this.pagenum;
        this.page.setFont(this.headerfont);
        this.page.drawString(this.jobname, this.x0, this.headery);
        String string = "- " + this.pagenum + " -";
        int n = this.headermetrics.stringWidth(string);
        this.page.drawString(string, this.x0 + (this.width - n) / 2, this.headery);
        n = this.headermetrics.stringWidth(this.time);
        this.page.drawString(this.time, this.x0 + this.width - n, this.headery);
        int n2 = this.headery + this.headermetrics.getDescent() + 1;
        this.page.drawLine(this.x0, n2, this.x0 + this.width, n2);
        this.page.setFont(this.font);
    }

    public static class PrintCanceledException
    extends Exception {
        public PrintCanceledException(String string) {
            super(string);
        }
    }
}

