/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JSplitPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;

public class ControlSplitPanel
extends ControlContainer {
    protected JSplitPane splitpanel;
    private boolean hasOne = false;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.splitpanel = new JSplitPane();
        this.splitpanel.setOneTouchExpandable(true);
        this.splitpanel.setDividerLocation(-1);
        return this.splitpanel;
    }

    public void reset() {
        this.splitpanel.setDividerLocation(-1);
    }

    public void add(ControlElement controlElement) {
        if (this.hasOne) {
            this.splitpanel.setBottomComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
        } else {
            this.splitpanel.setTopComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
            this.hasOne = true;
        }
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.add(controlElement);
            ((ControlRadioButton)controlElement).setParent(this);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("orientation");
            infoList.add("expandable");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        if (string.equals("expandable")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Orientation") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("vertical")) {
                return new IntegerValue(0);
            }
            if (string2.equals("horizontal")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.splitpanel.getOrientation() == value.getInteger()) break;
                this.splitpanel.setOrientation(value.getInteger());
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.splitpanel.setOrientation(1);
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

