/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlMenuBar;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.ResourceLoader;

public class ControlFrame
extends ControlWindow {
    private static final int FRAME_ADDED = 5;
    private static final int NAME = 10;
    protected JFrame frame;
    protected String iconImageFile = null;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.startingup = true;
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        Image image = ResourceLoader.getImage("data/icons/EjsFrameIcon.gif");
        if (image == null) {
            image = ResourceLoader.getImage(String.valueOf(Simulation.getPathToLibrary()) + "_ejs_library/images/EjsMainIcon.gif");
        }
        if (image != null) {
            this.frame.setIconImage(image);
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        return this.frame.getContentPane();
    }

    public String getObjectClassname() {
        return "java.awt.Component";
    }

    public Object getObject() {
        return this.frame;
    }

    protected void whenClosing() {
        super.whenClosing();
        if (this.frame.getDefaultCloseOperation() == 3 || this.frame.getDefaultCloseOperation() == 2) {
            this.invokeActions();
        }
    }

    protected int getVisibleIndex() {
        return 14;
    }

    protected int getLocationIndex() {
        return 6;
    }

    protected int getSizeIndex() {
        return 15;
    }

    public Component getComponent() {
        return this.frame;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    public Container getContainer() {
        return this.frame.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    public void add(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        this.menubar = (JMenuBar)controlElement.getVisual();
        this.frame.setJMenuBar(this.menubar);
        ((ControlMenuBar)controlElement).setControlWindow(this);
        this.adjustSize();
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    public void remove(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        this.menubar = null;
        this.frame.setJMenuBar(null);
        this.getRootPane().validate();
        this.getRootPane().repaint();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.add("image");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("resizable")) {
            return "boolean";
        }
        if (string.equals("exit")) {
            return "boolean CONSTANT";
        }
        if (string.equals("onExit")) {
            return "Action CONSTANT";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(String.valueOf(GUIUtils.parseTeX(value.getString())) + " " + string);
                    break;
                }
                this.frame.setTitle(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                this.frame.setResizable(value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                if (value.getString().equals(this.iconImageFile)) {
                    return;
                }
                this.iconImageFile = value.getString();
                this.frame.setIconImage(this.getIcon(this.iconImageFile).getImage());
                break;
            }
            case 10: {
                super.setValue(5, value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String string = this.getGroup().getReplaceOwnerName();
                if (string != null && string.equals(value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(string);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 4: {
                this.iconImageFile = null;
                this.frame.setIconImage(null);
                break;
            }
            case 10: {
                super.setDefaultValue(5);
                if (this.getGroup() != null && this.getGroup().getOwnerFrame() == this.getComponent()) {
                    this.getGroup().setOwnerFrame(this.frame);
                }
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }
}

