/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.tools.ResourceLoader;

public class ControlImage
extends ControlInteractiveElement {
    private static final int IMAGE_ADDED = 2;
    protected InteractiveImage image;
    private String imageFile = null;
    private static ArrayList infoList = null;

    public ControlImage() {
        this.enabledEjsEdit = true;
    }

    protected Drawable createDrawable() {
        this.image = new InteractiveImage();
        this.image.setEnabled(0, true);
        return this.image;
    }

    protected int getPropertiesDisplacement() {
        return 2;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("image");
            infoList.add("trueSize");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("trueSize")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setImage(value.getString());
                break;
            }
            case 1: {
                this.image.setTrueSize(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setImage(null);
                break;
            }
            case 1: {
                this.image.setTrueSize(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }

    private void setImage(String string) {
        if (this.imageFile != null && this.imageFile.equals(string)) {
            return;
        }
        this.imageFile = string;
        ImageIcon imageIcon = ResourceLoader.getIcon(string);
        if (imageIcon != null) {
            this.image.getStyle().setDisplayObject(imageIcon.getImage());
        }
    }
}

