/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

public class ControlTrailSet3D
extends ControlSet3D
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int PROPERTIES_ADDED = 6;
    protected double[] x;
    protected double[] y;
    protected double[] z;
    protected double[] xOne = new double[]{0.0};
    protected double[] yOne;
    protected double[] zOne;
    static ArrayList infoList = null;

    public ControlTrailSet3D() {
        this.x = this.xOne;
        this.yOne = new double[]{0.0};
        this.y = this.yOne;
        this.zOne = new double[]{0.0};
        this.z = this.zOne;
    }

    protected int getPropertiesDisplacement() {
        return 6;
    }

    protected Element createAnElement() {
        ElementTrail elementTrail = OSP3DFactory.ElementTrail();
        return elementTrail;
    }

    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementTrail)element2).setMaximumPoints(((ElementTrail)element).getMaximumPoints());
        ((ElementTrail)element2).setConnected(((ElementTrail)element).isConnected());
    }

    public void reset() {
        int n = 0;
        while (n < this.numElements) {
            ((ElementTrail)this.elements[n]).clear();
            ++n;
        }
        this.zOne[0] = 0.0;
        this.yOne[0] = 0.0;
        this.xOne[0] = 0.0;
        this.x = this.xOne;
        this.y = this.yOne;
        this.z = this.zOne;
    }

    public void onExit() {
        int n = 0;
        while (n < this.numElements) {
            ((ElementTrail)this.elements[n]).clear();
            ++n;
        }
    }

    public void preupdate() {
        int n = this.x.length - 1;
        int n2 = this.y.length - 1;
        int n3 = this.z.length - 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n4 < this.numElements) {
            ((ElementTrail)this.elements[n4]).addPoint(this.x[n5], this.y[n6], this.z[n7]);
            if (n5 < n) {
                ++n5;
            }
            if (n6 < n2) {
                ++n6;
            }
            if (n7 < n3) {
                ++n7;
            }
            ++n4;
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("maximumPoints");
            infoList.add("connected");
            infoList.add("inputX");
            infoList.add("inputY");
            infoList.add("inputZ");
            infoList.add("depthFactor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("maximumPoints")) {
            return "int|int[]";
        }
        if (string.equals("connected")) {
            return "boolean|boolean[]";
        }
        if (string.equals("inputX")) {
            return "int|double|double[]";
        }
        if (string.equals("inputY")) {
            return "int|double|double[]";
        }
        if (string.equals("inputZ")) {
            return "int|double|double[]";
        }
        if (string.equals("depthFactor")) {
            return "double";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    while (n2 < this.numElements) {
                        ((ElementTrail)this.elements[n2]).setMaximumPoints(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n3 = value.getInteger();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementTrail)this.elements[n4]).setMaximumPoints(n3);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementTrail)this.elements[n5]).setConnected(blArray[n5]);
                        ++n5;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n6 = 0;
                    while (n6 < this.numElements) {
                        ((ElementTrail)this.elements[n6]).setConnected(bl);
                        ++n6;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof double[]) {
                    this.x = (double[])value.getObject();
                    break;
                }
                this.xOne[0] = value.getDouble();
                this.x = this.xOne;
                break;
            }
            case 3: {
                if (value.getObject() instanceof double[]) {
                    this.y = (double[])value.getObject();
                    break;
                }
                this.yOne[0] = value.getDouble();
                this.y = this.yOne;
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[]) {
                    this.z = (double[])value.getObject();
                    break;
                }
                this.zOne[0] = value.getDouble();
                this.z = this.zOne;
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < this.numElements) {
                    ((ElementTrail)this.elements[n7]).getStyle().setDepthFactor(value.getDouble());
                    ++n7;
                }
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementTrail)this.elements[n2]).setMaximumPoints(0);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    ((ElementTrail)this.elements[n3]).setConnected(true);
                    ++n3;
                }
                break;
            }
            case 2: {
                this.xOne[0] = 0.0;
                this.x = this.xOne;
                break;
            }
            case 3: {
                this.yOne[0] = 0.0;
                this.y = this.yOne;
                break;
            }
            case 4: {
                this.zOne[0] = 0.0;
                this.z = this.zOne;
                break;
            }
            case 5: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    ((ElementTrail)this.elements[n4]).getStyle().setDepthFactor(1.0);
                    ++n4;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

