function evaporationV3primary(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = EJSS_CORE.Tools;
  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var t; // EjsS Model.Variables.Var Table.t
  var dt; // EjsS Model.Variables.Var Table.dt
  var pi; // EjsS Model.Variables.Var Table.pi
  var x; // EjsS Model.Variables.Var Table.x
  var y; // EjsS Model.Variables.Var Table.y
  var xs; // EjsS Model.Variables.Var Table.xs
  var ys; // EjsS Model.Variables.Var Table.ys
  var vy; // EjsS Model.Variables.Var Table.vy
  var zz; // EjsS Model.Variables.Var Table.zz
  var xbase; // EjsS Model.Variables.Var Table.xbase
  var datatable; // EjsS Model.Variables.Var Table.datatable

  var xC; // EjsS Model.Variables.Var Table 2.xC
  var yC; // EjsS Model.Variables.Var Table 2.yC
  var xsC; // EjsS Model.Variables.Var Table 2.xsC
  var ysC; // EjsS Model.Variables.Var Table 2.ysC

  var temperature; // EjsS Model.Variables.variables.temperature
  var wind; // EjsS Model.Variables.variables.wind
  var humidity; // EjsS Model.Variables.variables.humidity
  var area; // EjsS Model.Variables.variables.area
  var Pressure; // EjsS Model.Variables.variables.Pressure
  var PressureText; // EjsS Model.Variables.variables.PressureText
  var displaypressure; // EjsS Model.Variables.variables.displaypressure
  var WindNo; // EjsS Model.Variables.variables.WindNo
  var xWind; // EjsS Model.Variables.variables.xWind
  var yWind; // EjsS Model.Variables.variables.yWind
  var WindText; // EjsS Model.Variables.variables.WindText
  var HumidNo; // EjsS Model.Variables.variables.HumidNo
  var xHumid; // EjsS Model.Variables.variables.xHumid
  var yHumid; // EjsS Model.Variables.variables.yHumid
  var HumidityText; // EjsS Model.Variables.variables.HumidityText
  var infoNo; // EjsS Model.Variables.variables.infoNo
  var temptNo; // EjsS Model.Variables.variables.temptNo
  var memorycolory; // EjsS Model.Variables.variables.memorycolory
  var factor; // EjsS Model.Variables.variables.factor
  var fixarea; // EjsS Model.Variables.variables.fixarea
  var display; // EjsS Model.Variables.variables.display
  var displaywind; // EjsS Model.Variables.variables.displaywind

  var xCm; // EjsS Model.Variables.memory.xCm
  var yCm; // EjsS Model.Variables.memory.yCm
  var xbasem; // EjsS Model.Variables.memory.xbasem
  var memorycolory0; // EjsS Model.Variables.memory.memorycolory0

  var font; // EjsS Model.Variables.layout.font
  var font2; // EjsS Model.Variables.layout.font2
  var Width; // EjsS Model.Variables.layout.Width
  var Height; // EjsS Model.Variables.layout.Height
  var Width1; // EjsS Model.Variables.layout.Width1
  var Width2; // EjsS Model.Variables.layout.Width2
  var world; // EjsS Model.Variables.layout.world
  var graph; // EjsS Model.Variables.layout.graph
  var disabledworld; // EjsS Model.Variables.layout.disabledworld
  var disabled; // EjsS Model.Variables.layout.disabled

  var xmin; // EjsS Model.Variables.cells.xmin
  var xmax; // EjsS Model.Variables.cells.xmax
  var ymin; // EjsS Model.Variables.cells.ymin
  var ymax; // EjsS Model.Variables.cells.ymax

  var _privateOdesList;
  var _ODEi_evolution1;
  var userEvents1=[];

  _model.getOdes = function() { return [_ODEi_evolution1]; };

  _model.removeEvents = function(){
    userEvents1=[];
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      t : t,
      dt : dt,
      pi : pi,
      x : x,
      y : y,
      xs : xs,
      ys : ys,
      vy : vy,
      zz : zz,
      xbase : xbase,
      datatable : datatable,
      xC : xC,
      yC : yC,
      xsC : xsC,
      ysC : ysC,
      temperature : temperature,
      wind : wind,
      humidity : humidity,
      area : area,
      Pressure : Pressure,
      PressureText : PressureText,
      displaypressure : displaypressure,
      WindNo : WindNo,
      xWind : xWind,
      yWind : yWind,
      WindText : WindText,
      HumidNo : HumidNo,
      xHumid : xHumid,
      yHumid : yHumid,
      HumidityText : HumidityText,
      infoNo : infoNo,
      temptNo : temptNo,
      memorycolory : memorycolory,
      factor : factor,
      fixarea : fixarea,
      display : display,
      displaywind : displaywind,
      xCm : xCm,
      yCm : yCm,
      xbasem : xbasem,
      memorycolory0 : memorycolory0,
      font : font,
      font2 : font2,
      Width : Width,
      Height : Height,
      Width1 : Width1,
      Width2 : Width2,
      world : world,
      graph : graph,
      disabledworld : disabledworld,
      disabled : disabled,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.pi != "undefined") pi = json.pi;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.xs != "undefined") xs = json.xs;
    if(typeof json.ys != "undefined") ys = json.ys;
    if(typeof json.vy != "undefined") vy = json.vy;
    if(typeof json.zz != "undefined") zz = json.zz;
    if(typeof json.xbase != "undefined") xbase = json.xbase;
    if(typeof json.datatable != "undefined") datatable = json.datatable;
    if(typeof json.xC != "undefined") xC = json.xC;
    if(typeof json.yC != "undefined") yC = json.yC;
    if(typeof json.xsC != "undefined") xsC = json.xsC;
    if(typeof json.ysC != "undefined") ysC = json.ysC;
    if(typeof json.temperature != "undefined") temperature = json.temperature;
    if(typeof json.wind != "undefined") wind = json.wind;
    if(typeof json.humidity != "undefined") humidity = json.humidity;
    if(typeof json.area != "undefined") area = json.area;
    if(typeof json.Pressure != "undefined") Pressure = json.Pressure;
    if(typeof json.PressureText != "undefined") PressureText = json.PressureText;
    if(typeof json.displaypressure != "undefined") displaypressure = json.displaypressure;
    if(typeof json.WindNo != "undefined") WindNo = json.WindNo;
    if(typeof json.xWind != "undefined") xWind = json.xWind;
    if(typeof json.yWind != "undefined") yWind = json.yWind;
    if(typeof json.WindText != "undefined") WindText = json.WindText;
    if(typeof json.HumidNo != "undefined") HumidNo = json.HumidNo;
    if(typeof json.xHumid != "undefined") xHumid = json.xHumid;
    if(typeof json.yHumid != "undefined") yHumid = json.yHumid;
    if(typeof json.HumidityText != "undefined") HumidityText = json.HumidityText;
    if(typeof json.infoNo != "undefined") infoNo = json.infoNo;
    if(typeof json.temptNo != "undefined") temptNo = json.temptNo;
    if(typeof json.memorycolory != "undefined") memorycolory = json.memorycolory;
    if(typeof json.factor != "undefined") factor = json.factor;
    if(typeof json.fixarea != "undefined") fixarea = json.fixarea;
    if(typeof json.display != "undefined") display = json.display;
    if(typeof json.displaywind != "undefined") displaywind = json.displaywind;
    if(typeof json.xCm != "undefined") xCm = json.xCm;
    if(typeof json.yCm != "undefined") yCm = json.yCm;
    if(typeof json.xbasem != "undefined") xbasem = json.xbasem;
    if(typeof json.memorycolory0 != "undefined") memorycolory0 = json.memorycolory0;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.font2 != "undefined") font2 = json.font2;
    if(typeof json.Width != "undefined") Width = json.Width;
    if(typeof json.Height != "undefined") Height = json.Height;
    if(typeof json.Width1 != "undefined") Width1 = json.Width1;
    if(typeof json.Width2 != "undefined") Width2 = json.Width2;
    if(typeof json.world != "undefined") world = json.world;
    if(typeof json.graph != "undefined") graph = json.graph;
    if(typeof json.disabledworld != "undefined") disabledworld = json.disabledworld;
    if(typeof json.disabled != "undefined") disabled = json.disabled;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["undefined"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["waterlevel"] = true;
    __pagesEnabled["FixRel Page"] = true;
    __pagesEnabled["datatable"] = true;
    __pagesEnabled["display"] = true;
    __pagesEnabled["memorycolory"] = true;
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Var Table.t
    dt = 0.05; // EjsS Model.Variables.Var Table.dt
    pi = Math.PI; // EjsS Model.Variables.Var Table.pi
    x = 2; // EjsS Model.Variables.Var Table.x
    y = 3; // EjsS Model.Variables.Var Table.y
    xs = 2; // EjsS Model.Variables.Var Table.xs
    ys = 3; // EjsS Model.Variables.Var Table.ys
    vy = 0; // EjsS Model.Variables.Var Table.vy
    xbase = 2; // EjsS Model.Variables.Var Table.xbase
    datatable = []; // EjsS Model.Variables.Var Table.datatable
  });

  _model.addToReset(function() {
    xC = 2; // EjsS Model.Variables.Var Table 2.xC
    yC = 3; // EjsS Model.Variables.Var Table 2.yC
    xsC = 2; // EjsS Model.Variables.Var Table 2.xsC
    ysC = 3; // EjsS Model.Variables.Var Table 2.ysC
  });

  _model.addToReset(function() {
    temperature = 30; // EjsS Model.Variables.variables.temperature
    wind = 1; // EjsS Model.Variables.variables.wind
    humidity = 1; // EjsS Model.Variables.variables.humidity
    area = x*y; // EjsS Model.Variables.variables.area
    Pressure = 1; // EjsS Model.Variables.variables.Pressure
    PressureText = 1; // EjsS Model.Variables.variables.PressureText
    WindNo = 1; // EjsS Model.Variables.variables.WindNo
    xWind = [-1.5,0,1.5]; // EjsS Model.Variables.variables.xWind
    yWind = [7,7,7]; // EjsS Model.Variables.variables.yWind
    WindText = "Low"; // EjsS Model.Variables.variables.WindText
    HumidNo = 1; // EjsS Model.Variables.variables.HumidNo
    xHumid = [1.5,2.5,3.5]; // EjsS Model.Variables.variables.xHumid
    yHumid = [-2.5, -2.5, -2.5]; // EjsS Model.Variables.variables.yHumid
    HumidityText = "Low"; // EjsS Model.Variables.variables.HumidityText
    infoNo = 1; // EjsS Model.Variables.variables.infoNo
    temptNo = 1; // EjsS Model.Variables.variables.temptNo
    memorycolory = 0; // EjsS Model.Variables.variables.memorycolory
    factor = 60; // EjsS Model.Variables.variables.factor
    fixarea = true; // EjsS Model.Variables.variables.fixarea
    display = ""; // EjsS Model.Variables.variables.display
    displaywind = ""; // EjsS Model.Variables.variables.displaywind
  });

  _model.addToReset(function() {
    xCm = xC; // EjsS Model.Variables.memory.xCm
    yCm = yC; // EjsS Model.Variables.memory.yCm
    xbasem = xbase; // EjsS Model.Variables.memory.xbasem
    memorycolory0 = -1; // EjsS Model.Variables.memory.memorycolory0
  });

  _model.addToReset(function() {
    font = "normal normal 1.2vw "; // EjsS Model.Variables.layout.font
    font2 = "normal normal 1vw "; // EjsS Model.Variables.layout.font2
    Width = (_isEPub)?"400":"100%"; // EjsS Model.Variables.layout.Width
    Height = (_isEPub)?"500":"100%"; // EjsS Model.Variables.layout.Height
    Width1 = "50%"; // EjsS Model.Variables.layout.Width1
    Width2 = "50%"; // EjsS Model.Variables.layout.Width2
    world = true; // EjsS Model.Variables.layout.world
    graph = true; // EjsS Model.Variables.layout.graph
    disabledworld = false; // EjsS Model.Variables.layout.disabledworld
    disabled = false; // EjsS Model.Variables.layout.disabled
  });

  _model.addToReset(function() {
    xmin = -10; // EjsS Model.Variables.cells.xmin
    xmax = 10; // EjsS Model.Variables.cells.xmax
    ymin = -10; // EjsS Model.Variables.cells.ymin
    ymax = 10; // EjsS Model.Variables.cells.ymax
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  //https://developer.mozilla.org/en-US/docs/Web/Guide/API/DOM/Using_full_screen_mode  // > CustomCode.fullscreen:1
  // does not work for iOS   // > CustomCode.fullscreen:2
  /*jslint browser:true */  // > CustomCode.fullscreen:3
  function toggleFullScreen() {  // > CustomCode.fullscreen:4
    if (!document.fullscreenElement &&    // alternative standard method  // > CustomCode.fullscreen:5
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement ) {  // current working methods  // > CustomCode.fullscreen:6
      if (document.documentElement.requestFullscreen) {  // > CustomCode.fullscreen:7
        document.documentElement.requestFullscreen();  // > CustomCode.fullscreen:8
      } else if (document.documentElement.msRequestFullscreen) {  // > CustomCode.fullscreen:9
        document.documentElement.msRequestFullscreen();  // > CustomCode.fullscreen:10
      } else if (document.documentElement.mozRequestFullScreen) {  // > CustomCode.fullscreen:11
        document.documentElement.mozRequestFullScreen();  // > CustomCode.fullscreen:12
      } else if (document.documentElement.webkitRequestFullscreen) {  // > CustomCode.fullscreen:13
        document.documentElement.webkitRequestFullscreen();  // > CustomCode.fullscreen:14
      }  // > CustomCode.fullscreen:15
    } else {  // > CustomCode.fullscreen:16
      if (document.exitFullscreen) {  // > CustomCode.fullscreen:17
        document.exitFullscreen();  // > CustomCode.fullscreen:18
      } else if (document.msExitFullscreen) {  // > CustomCode.fullscreen:19
        document.msExitFullscreen();  // > CustomCode.fullscreen:20
      } else if (document.mozCancelFullScreen) {  // > CustomCode.fullscreen:21
        document.mozCancelFullScreen();  // > CustomCode.fullscreen:22
      } else if (document.webkitExitFullscreen) {  // > CustomCode.fullscreen:23
        document.webkitExitFullscreen();  // > CustomCode.fullscreen:24
      }  // > CustomCode.fullscreen:25
    }  // > CustomCode.fullscreen:26
  }  // > CustomCode.fullscreen:27

  // code to be copied to EJSS source code under Custom and used in drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:1
  // address the problem is height difference is iOS app , epub, and Firefox  // > CustomCode.changeOrientation:2
  // user need to change only k and kepub  // > CustomCode.changeOrientation:3
  // copy %changeOrientation()% into the Height Field of drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:4
  function changeOrientation() {  // > CustomCode.changeOrientation:5
     // > CustomCode.changeOrientation:6
  var k =0.80 ; // k control height 1 is for full screen, 0.9 shorten etc  // > CustomCode.changeOrientation:7
  var kapple =0.90 // control apple app height  // > CustomCode.changeOrientation:8
  var kepub =0.90 ;  // > CustomCode.changeOrientation:9
  // check platform for Apps  // > CustomCode.changeOrientation:10
  try { // allow code to run in Student Learning Space   // > CustomCode.changeOrientation:11
    var iOSapp =  (typeof parent.device != 'undefined' && parent.device.platform == "iOS");  // > CustomCode.changeOrientation:12
    var Androidapp = (typeof parent.device != 'undefined' && parent.device.platform == "Android");  // > CustomCode.changeOrientation:13
  } catch(e) {  // > CustomCode.changeOrientation:14
    var iOSapp = false;  // > CustomCode.changeOrientation:15
    var Androidapp = false;  // > CustomCode.changeOrientation:16
  }  // > CustomCode.changeOrientation:17
  // check platform for web browsers  // > CustomCode.changeOrientation:18
  var iOS =/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:19
  var iPad =/iPad/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:20
  var iPhone = /iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:21
  var Android= /Android|android/i.test(navigator.userAgent);  // > CustomCode.changeOrientation:22
  //navigator  // > CustomCode.changeOrientation:23
  var Firefox = navigator.userAgent.indexOf("Firefox") != -1;  // > CustomCode.changeOrientation:24
     // > CustomCode.changeOrientation:25
  switch (window.orientation) { // using window.orientation as deciding factor  // > CustomCode.changeOrientation:26
    case 0:  // > CustomCode.changeOrientation:27
    case 180:  // > CustomCode.changeOrientation:28
      this.screenOrientation = 'portrait';  // > CustomCode.changeOrientation:29
      if (iOSapp){ // does not seems to work  // > CustomCode.changeOrientation:30
          // > CustomCode.changeOrientation:31
        return window.screen.height*kapple;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:32
        // > CustomCode.changeOrientation:33
      }  // > CustomCode.changeOrientation:34
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:35
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:36
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:37
        // return window.screen.height;  // > CustomCode.changeOrientation:38
        //  return window.innerHeight;  // > CustomCode.changeOrientation:39
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:40
      }  // > CustomCode.changeOrientation:41
       // > CustomCode.changeOrientation:42
      else {  // > CustomCode.changeOrientation:43
         // > CustomCode.changeOrientation:44
        return 100*k+"vh";  // > CustomCode.changeOrientation:45
      }  // > CustomCode.changeOrientation:46
      break;  // > CustomCode.changeOrientation:47
    case 90:  // > CustomCode.changeOrientation:48
    case -90:  // > CustomCode.changeOrientation:49
      this.screenOrientation = 'landscape';  // > CustomCode.changeOrientation:50
     // > CustomCode.changeOrientation:51
      if (iOSapp){ // App  // > CustomCode.changeOrientation:52
        return window.screen.width*kapple;    // > CustomCode.changeOrientation:53
        // return window.screen.height;  // > CustomCode.changeOrientation:54
        //  return window.innerHeight;  // > CustomCode.changeOrientation:55
        //  return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:56
      }  // > CustomCode.changeOrientation:57
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:58
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:59
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:60
        // return window.screen.height;  // > CustomCode.changeOrientation:61
        //  return window.innerHeight;  // > CustomCode.changeOrientation:62
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:63
      }  // > CustomCode.changeOrientation:64
       // > CustomCode.changeOrientation:65
      else {  // > CustomCode.changeOrientation:66
        return 100*k+"vh";  // > CustomCode.changeOrientation:67
        }  // > CustomCode.changeOrientation:68
      break;  // > CustomCode.changeOrientation:69
    default:  // > CustomCode.changeOrientation:70
      this.screenOrientation = 'unknown';  // > CustomCode.changeOrientation:71
      //       return (iPad)?""+(window.screen.width+window.screen.height)*0.4:((iPhone)?""+window.screen.width:_view._format(window.innerHeight*0.9,"0"));  // > CustomCode.changeOrientation:72
       if (Firefox){  // > CustomCode.changeOrientation:73
        return window.innerHeight*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:74
        }  // > CustomCode.changeOrientation:75
     //   else if (iOS&&(window.orientation==0)||(window.orientation==180)){  // > CustomCode.changeOrientation:76
     //   return  window.screen.height*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:77
     //   }  // > CustomCode.changeOrientation:78
      //  else if (iOS&&(window.orientation==90)||(window.orientation==-90)){  // > CustomCode.changeOrientation:79
     //   return  window.screen.width*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:80
     //   }  // > CustomCode.changeOrientation:81
        else {  // > CustomCode.changeOrientation:82
        //alert();  // > CustomCode.changeOrientation:83
        // return 100*k+"%"; // work on fullscreen works in EJSS6.0beta  // > CustomCode.changeOrientation:84
          //  works in EjsS_5.3_180131  // > CustomCode.changeOrientation:85
        return  window.innerHeight*k; // work on panel   // > CustomCode.changeOrientation:86
           // > CustomCode.changeOrientation:87
  }  // > CustomCode.changeOrientation:88
  }  // > CustomCode.changeOrientation:89
     // > CustomCode.changeOrientation:90
  }  // > CustomCode.changeOrientation:91

  // copy this custom function  // > CustomCode.speech:1
  // in iOS need to add speech to the play button as On iOS the API works but must be triggered by a user action callback, like a response to a tap event, to provide a better experience to users and avoid unexpected sounds out of your phone  // > CustomCode.speech:2
  function speech (option) {  // > CustomCode.speech:3
  try { // allow code to run in Student Learning Space   // > CustomCode.speech:4
  var isCordova = (!!this.parent.cordova || !!window.cordova);  // > CustomCode.speech:5
  if(isCordova) { // check it is running in Android or iOS  // > CustomCode.speech:6
         // parent.TTS.speak({text:option,locale:'zh-CN'});  // > CustomCode.speech:7
  	parent.TTS.speak({text:option,locale:'us-EN'});  // > CustomCode.speech:8
  	// parent.TTS.speak({text:option,locale:'en-US'});  // > CustomCode.speech:9
  	// parent.TTS.speak({text:option,locale:'id-ID'});  // > CustomCode.speech:10
  }   // > CustomCode.speech:11
  }   // > CustomCode.speech:12
  catch(e) {  // > CustomCode.speech:13
    var isCordova = false;  // > CustomCode.speech:14
    }  // > CustomCode.speech:15
      // > CustomCode.speech:16
     var msg = new SpeechSynthesisUtterance(option);  // > CustomCode.speech:17
    //https://stackoverflow.com/questions/43983845/speechsynthesis-api-for-chinese-firefox  // > CustomCode.speech:18
    // Set the text.  // > CustomCode.speech:19
  	//msg.text = option;   // > CustomCode.speech:20
  	//https://forums.developer.apple.com/message/323564#323564  // > CustomCode.speech:21
  	// comment out the next 2 lines for english  // > CustomCode.speech:22
  //msg.voice = speechSynthesis.getVoices().filter(function(voice) { return voice.name == 'Ting-Ting'; })[0];  // > CustomCode.speech:23
  //msg.lang = 'zh-CH'; // need for android?  // > CustomCode.speech:24
  //msg.lang = 'id-ID'; // need for android?  // > CustomCode.speech:25
  msg.lang = 'us-EN'; // need for android?  // > CustomCode.speech:26
  //https://flaviocopes.com/speech-synthesis-api/  // > CustomCode.speech:27
  //debug  // > CustomCode.speech:28
  //console.log(`Voices #: ${speechSynthesis.getVoices().length}`)  // > CustomCode.speech:29
  //speechSynthesis.getVoices().forEach(voice => {  // > CustomCode.speech:30
  // console.log(voice.name, voice.lang)  // > CustomCode.speech:31
  //})  // > CustomCode.speech:32
  //debug  // > CustomCode.speech:33
  // Queue this utterance.  // > CustomCode.speech:34
  window.speechSynthesis.speak(msg);  // > CustomCode.speech:35
     // > CustomCode.speech:36
  }  // > CustomCode.speech:37

  // declare memorycolor = 0; in the variable page  // > CustomCode.storedata:1
  // declare t = 0 ; in the variable page  // > CustomCode.storedata:2
  function storedata () {  // > CustomCode.storedata:3
    // add data to datatable  // > CustomCode.storedata:4
    datatable.push([x*2, temperature, wind, humidity, xs*ys, t*factor])  // > CustomCode.storedata:5
    console.log(datatable)  // > CustomCode.storedata:6
      // > CustomCode.storedata:7
    _view.trail.newSegment(); //assume the default name Trail is used  // > CustomCode.storedata:8
    memorycolory=memorycolory+1; // change color to next number  // > CustomCode.storedata:9
    memory (); // memory container shape  // > CustomCode.storedata:10
    t=0; //reset back to zero time  // > CustomCode.storedata:11
  }  // > CustomCode.storedata:12

  function formatTime (t) {  // > CustomCode.displayTime:1
    let time = t * factor  // > CustomCode.displayTime:2
    time = time.toFixed(1)  // > CustomCode.displayTime:3
    hours = time.toString().split(".")[0]  // > CustomCode.displayTime:4
    minutes = time.toString().split(".")[1]  // > CustomCode.displayTime:5
    minutes = (Number(minutes)/10) * 60  // > CustomCode.displayTime:6
      // > CustomCode.displayTime:7
    let timeString = ""  // > CustomCode.displayTime:8
      // > CustomCode.displayTime:9
    if (Number(hours) < 10) {  // > CustomCode.displayTime:10
      timeString += "0" + hours + ":";  // > CustomCode.displayTime:11
    } else {  // > CustomCode.displayTime:12
      timeString += hours + ":";  // > CustomCode.displayTime:13
    }  // > CustomCode.displayTime:14
      // > CustomCode.displayTime:15
    if (minutes < 10) {  // > CustomCode.displayTime:16
      timeString += "0" + minutes + ":";  // > CustomCode.displayTime:17
    } else {  // > CustomCode.displayTime:18
      timeString += minutes + ":";  // > CustomCode.displayTime:19
    }  // > CustomCode.displayTime:20
      // > CustomCode.displayTime:21
    timeString += "00" // seconds  // > CustomCode.displayTime:22
      // > CustomCode.displayTime:23
    return timeString  // > CustomCode.displayTime:24
  }  // > CustomCode.displayTime:25

  function memory () {  // > CustomCode.memory:1
  //[[-xCm,yCm],[-xbasem,0],[xbasem,0],[xCm,yCm]]  // > CustomCode.memory:2
  xCm = xC; //stored as memory  // > CustomCode.memory:3
  yCm = yC;  // > CustomCode.memory:4
  xbasem = xbase;  // > CustomCode.memory:5
  }  // > CustomCode.memory:6

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    if (_isMobile){  // > Initialization.Init Page:1
      //do nothing  // > Initialization.Init Page:2
      }  // > Initialization.Init Page:3
        // > Initialization.Init Page:4
      else{  // > Initialization.Init Page:5
        // copy this into the initialization  // > Initialization.Init Page:6
    // make the font bigger  // > Initialization.Init Page:7
    _view.plottingPanel.getMessageDecoration("TL").getFont().setFontSize("2vw");  // > Initialization.Init Page:8
    _view.plottingPanel.getMessageDecoration("TR").getFont().setFontSize("2vw");  // > Initialization.Init Page:9
    _view.plottingPanel.getMessageDecoration("BL").getFont().setFontSize("2vw");  // > Initialization.Init Page:10
    _view.plottingPanel.getMessageDecoration("BR").getFont().setFontSize("2vw");  // > Initialization.Init Page:11
    _view.plottingPanel2.getMessageDecoration("TL").getFont().setFontSize("1vw");  // > Initialization.Init Page:12
    _view.plottingPanel2.getMessageDecoration("TR").getFont().setFontSize("1vw");  // > Initialization.Init Page:13
    _view.plottingPanel2.getMessageDecoration("BL").getFont().setFontSize("1vw");  // > Initialization.Init Page:14
    _view.plottingPanel2.getMessageDecoration("BR").getFont().setFontSize("1vw");  // > Initialization.Init Page:15
        }  // > Initialization.Init Page:16
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["undefined"]) return;
    if (xbase==undefined){  // > Initialization.undefined:1
      xbase= 0.5;  // > Initialization.undefined:2
      }  // > Initialization.undefined:3
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    //[[-2,0],[2,0],[x,y],[-x,y],[-2,0]]  // > FixedRelations.FixRel Page:1
    //______________(x,y)  // > FixedRelations.FixRel Page:2
    //            grad = (y-0)/(x-2) = (ynew -0)/(xnew-2)  // > FixedRelations.FixRel Page:3
    //    _____(2,0)  // > FixedRelations.FixRel Page:4
    //area = ((xbase+xbase)+(x+x))/2*y; // parallelogram    // > FixedRelations.FixRel Page:5
    area = x*y  // > FixedRelations.FixRel Page:6
    if (y<=0){ // to prevent user overplaying  // > FixedRelations.FixRel Page:7
      y=0;  // > FixedRelations.FixRel Page:8
      _pause();  // > FixedRelations.FixRel Page:9
      }  // > FixedRelations.FixRel Page:10
  });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["datatable"]) return;
  });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["display"]) return;
    if (humidity==1){  // > FixedRelations.display:1
      display = "Humidity/% = ";  // > FixedRelations.display:2
      display =display+ "💧";  // > FixedRelations.display:3
    }  // > FixedRelations.display:4
    else  if (humidity==2){  // > FixedRelations.display:5
      display = "Humidity/% = ";  // > FixedRelations.display:6
      display =display+ "💧💧";  // > FixedRelations.display:7
      }  // > FixedRelations.display:8
    else if (humidity==3){  // > FixedRelations.display:9
      display = "Humidity/% = ";  // > FixedRelations.display:10
      display =display+ "💧💧💧";  // > FixedRelations.display:11
    }  // > FixedRelations.display:12
      //wind  // > FixedRelations.display:13
    if (wind==1){  // > FixedRelations.display:14
      displaywind = "Wind = ";  // > FixedRelations.display:15
      displaywind =displaywind+"💨"  // > FixedRelations.display:16
    }  // > FixedRelations.display:17
    else if (wind==2){  // > FixedRelations.display:18
      displaywind = "Wind = ";  // > FixedRelations.display:19
      displaywind =displaywind+"💨💨"  // > FixedRelations.display:20
    }  // > FixedRelations.display:21
    else if (wind==3){  // > FixedRelations.display:22
      displaywind = "Wind = ";  // > FixedRelations.display:23
      displaywind =displaywind+"💨💨💨";  // > FixedRelations.display:24
    }  // > FixedRelations.display:25
      //p  // > FixedRelations.display:26
    if (Pressure==1){  // > FixedRelations.display:27
      displaypressure = "Pressure = ";  // > FixedRelations.display:28
      displaypressure =displaypressure + "🌏"  // > FixedRelations.display:29
    }  // > FixedRelations.display:30
    else if (Pressure==0.5){  // > FixedRelations.display:31
      displaypressure = "Pressure = ";  // > FixedRelations.display:32
      displaypressure =displaypressure + "🏔"  // > FixedRelations.display:33
    }  // > FixedRelations.display:34
    else if (Pressure==1.5){  // > FixedRelations.display:35
      displaypressure = "Pressure = ";  // > FixedRelations.display:36
      displaypressure =displaypressure + "🌊"  // > FixedRelations.display:37
    }  // > FixedRelations.display:38
  });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["memorycolory"]) return;
    memorycolory0 = memorycolory-1;  // > FixedRelations.memorycolory:1
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  _getODE = function (_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var _ODE_evolution1_Event1;
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf._getOdeVars = function (){ return["y","x","t"]};

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      if (__pagesEnabled["waterlevel"]) __eventSolver.addEvent(_ODE_evolution1_Event1());
      for(k in userEvents1){__eventSolver.addEvent(userEvents1[k]);}
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=y) __mustReinitialize = true;
        __state[__cIn++] = y;
        if (__state[__cIn]!=x) __mustReinitialize = true;
        __state[__cIn++] = x;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        y = __state[__cOut++];
        x = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      _aRate[_aRate.length-1] = 0.0; // In case the prelim code returns
      var __index=-1; // so that it can be used in preliminary code
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var y = _aState[__cOut++];
        var x = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Preliminary code: Code to be executed before rate equations are evaluated
        //vy = -(x+x)*(temperature/20)*wind*(1/humidity);  // > Preliminary code for ODE.Evol Page:1
        vy = -(x+x)*(temperature/20)*wind*(1/humidity)*(1/Pressure);  // > Preliminary code for ODE.Evol Page:2
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = vy; // Rate for ODE: Evol Page:y
        _aRate[__cRate++] = vy*(xs-xbase)/(ys-0); // Rate for ODE: Evol Page:x
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __odeSelf._addEvent = function(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent){
    var User_Event = function (userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent) {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return eventType; };

      _eventSelf.getRootFindingMethod = function() { return eventMethod; };

      _eventSelf.getMaxIterations = function() { return maxIter; };

      _eventSelf.getTolerance = function() { return eventTolerance; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var y = _aState[__cOut++];
        var x = _aState[__cOut++];
        var t = _aState[__cOut++];
      return eval(userCondition);
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        y = __state[__cOut++];
        x = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = y;
        __state[__cIn++] = x;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        if (undefined != functions) eval(functions.toString());
        eval(userAction);
        return endAtEvent;
      }

      return _eventSelf;
    }; // End of event

   userEvents1.push(User_Event(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent));
   }

    _ODE_evolution1_Event1 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var y = _aState[__cOut++];
        var x = _aState[__cOut++];
        var t = _aState[__cOut++];
        return y-0;  // > Event zero-condition for page Evol Page:1
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        y = __state[__cOut++];
        x = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = y;
        __state[__cIn++] = x;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        _pause();  // > Event action for page Evol Page:1
        disabled=true;  // > Event action for page Evol Page:2
        return true;
      }

      return _eventSelf;
    }; // End of event

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_y(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_x(__time) {
    var __index = 0 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : null, height : null };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new evaporationV3primary_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.fullscreen.linkProperty("Width",  function() { return Width; }, function(_v) { Width = _v; } ); // HtmlView Page linking property 'Width' for element 'fullscreen'
          _view.sa.linkProperty("Text",  function() { return "🌐Surface Area ="+2*x.toFixed(2); } ); // HtmlView Page linking property 'Text' for element 'sa'
          _view.sa.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'sa'
          _view.slider.setAction("OnRelease", function(_data,_info) {
  xs=x;
  ys=y;
  xC=x;
  yC=y;
  if (fixarea==true){
    //area = ((2+2)+(x+x))/2*y; // parallelogram
    //y = area/((xbase+xbase)+(x+x))*2;
    y = area / x
  }
  else {
    //area = ((xbase+xbase)+(x+x))/2*y; // parallelogram  
    area = x * y
  }

}); // HtmlView Page setting action 'OnRelease' for element 'slider'
          _view.slider.linkProperty("Value",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'Value' for element 'slider'
          _view.slider.setAction("OnChange", function(_data,_info) {
  xs=x;
  ys=y;
  xC=x;
  yC=y;
  xbase=x;
  if (fixarea==true){
    //area = ((2+2)+(x+x))/2*y; // parallelogram
    //y = area/((xbase+xbase)+(x+x))*2;
    y = area / x
  }
  else {
    //area = ((xbase+xbase)+(x+x))/2*y; // parallelogram  
    area = x*y
  }

}); // HtmlView Page setting action 'OnChange' for element 'slider'
          _view.slider.linkProperty("Disabled",  function() { return t>0; } ); // HtmlView Page linking property 'Disabled' for element 'slider'
          _view.Temperature.linkProperty("Text",  function() { return "🌡️Temperature ="+temperature+" °C"; } ); // HtmlView Page linking property 'Text' for element 'Temperature'
          _view.Temperature.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'Temperature'
          _view.slider2.linkProperty("Value",  function() { return temperature; }, function(_v) { temperature = _v; } ); // HtmlView Page linking property 'Value' for element 'slider2'
          _view.slider2.linkProperty("Disabled",  function() { return t>0; } ); // HtmlView Page linking property 'Disabled' for element 'slider2'
          _view.wind2.linkProperty("Text",  function() { return "💨Wind ="+WindText; } ); // HtmlView Page linking property 'Text' for element 'wind2'
          _view.wind2.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'wind2'
          _view.slider22.linkProperty("Value",  function() { return wind; }, function(_v) { wind = _v; } ); // HtmlView Page linking property 'Value' for element 'slider22'
          _view.slider22.setAction("OnChange", function(_data,_info) {
  WindNo=wind;
  if (wind==1){
  WindText="Low";	
  }
  else if (wind==2){
  WindText="Medium";	
  }
  if (wind==3){
  WindText="High";	
  }

}); // HtmlView Page setting action 'OnChange' for element 'slider22'
          _view.slider22.linkProperty("Disabled",  function() { return t>0; } ); // HtmlView Page linking property 'Disabled' for element 'slider22'
          _view.hum.linkProperty("Text",  function() { return "💧Humidity ="+HumidityText; } ); // HtmlView Page linking property 'Text' for element 'hum'
          _view.hum.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'hum'
          _view.slider3.linkProperty("Value",  function() { return humidity; }, function(_v) { humidity = _v; } ); // HtmlView Page linking property 'Value' for element 'slider3'
          _view.slider3.setAction("OnChange", function(_data,_info) {
  HumidNo=humidity;
  if (humidity==1){
  HumidityText="Low";	
  }
  else if (humidity==2){
  HumidityText="Medium";	
  }
  if (humidity==3){
  HumidityText="High";	
  }

}); // HtmlView Page setting action 'OnChange' for element 'slider3'
          _view.slider3.linkProperty("Disabled",  function() { return t>0; } ); // HtmlView Page linking property 'Disabled' for element 'slider3'
          _view.p.linkProperty("Text",  function() { return "⛰Pressure ="+Pressure + " atm"; } ); // HtmlView Page linking property 'Text' for element 'p'
          _view.p.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'p'
          _view.slider32.linkProperty("Value",  function() { return Pressure; }, function(_v) { Pressure = _v; } ); // HtmlView Page linking property 'Value' for element 'slider32'
          _view.slider32.setAction("OnChange", function(_data,_info) {
  //HumidNo=humidity;
  if (Pressure==0.5){
  PressureText="Low Atmospheric";	
  }
  else if (Pressure==1.9){
  PressureText="Normal Atmospheric";	
  }
  if (Pressure==1.5){
  PressureText="High Atmospheric";	
  }

}); // HtmlView Page setting action 'OnChange' for element 'slider32'
          _view.slider32.linkProperty("Disabled",  function() { return t>0; } ); // HtmlView Page linking property 'Disabled' for element 'slider32'
          _view.fixarea.linkProperty("Checked",  function() { return fixarea; }, function(_v) { fixarea = _v; } ); // HtmlView Page linking property 'Checked' for element 'fixarea'
          _view.fixarea.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'fixarea'
          _view.playPauseButton2.setAction("OffClick", function(_data,_info) {
  _pause();
  //speech ("paused");

}); // HtmlView Page setting action 'OffClick' for element 'playPauseButton2'
          _view.playPauseButton2.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton2'
          _view.playPauseButton2.linkProperty("Disabled",  function() { return disabled; }, function(_v) { disabled = _v; } ); // HtmlView Page linking property 'Disabled' for element 'playPauseButton2'
          _view.playPauseButton2.setAction("OnClick", function(_data,_info) {
  //memory();
  _play();
  //speech ("play");

}); // HtmlView Page setting action 'OnClick' for element 'playPauseButton2'
          _view.playPauseButton2.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'playPauseButton2'
          _view.stepButton2.linkProperty("Disabled",  function() { return area<=0; } ); // HtmlView Page linking property 'Disabled' for element 'stepButton2'
          _view.stepButton2.setAction("OnClick", function(_data,_info) {
  _step();

}); // HtmlView Page setting action 'OnClick' for element 'stepButton2'
          _view.stepButton2.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'stepButton2'
          _view.Storedatabutton.setAction("OnClick", function(_data,_info) {
  storedata();
  t= 0;
  x=xs;
  y=ys;
  disabled=false;
  //speech("store")
  //_reset();
  //speechzh ("你好");

}); // HtmlView Page setting action 'OnClick' for element 'Storedatabutton'
          _view.Storedatabutton.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'Storedatabutton'
          _view.resetButton3.setAction("OnClick", function(_data,_info) {
  _reset();
  //speechzh ("你好");
  //speech("Reset");

}); // HtmlView Page setting action 'OnClick' for element 'resetButton3'
          _view.resetButton3.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'resetButton3'
          _view.displaytext.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'displaytext'
          _view.worldgraph.linkProperty("Options",  function() { return ["Both","Diagram","Graph"]; } ); // HtmlView Page linking property 'Options' for element 'worldgraph'
          _view.worldgraph.setAction("OnChange", function(_data,_info) {
  //var option = _view.worldgraph.getProperty("SelectedOptions");
  //alert(option);
  var opts = _view.worldgraph.getProperty("SelectedOptions");  // array of options
      var option = (opts.length > 0)? opts[0]:""; // selected option 
  if ( option=="Diagram"){
    world=true;
  Width1 = "100%";
  Width2 = "0%";
  //disabled=false;
    }
  //printing ends today
  else if ( option=="Graph"){
  graph=true;
  Width1 = "0%";
  Width2 = "100%";
  //disabledworld=false;
  }
  else if ( option=="Both"){
  world=true;
  graph=true;
  Width1 = "50%";
  Width2 = "50%";
  //disabledworld=false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'worldgraph'
          _view.worldgraph.linkProperty("Disabled",  function() { return _isPlaying; } ); // HtmlView Page linking property 'Disabled' for element 'worldgraph'
          _view.worldgraph.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'worldgraph'
          _view.plottingPanel.linkProperty("Height",  function() { return changeOrientation(); }, function(_v) { changeOrientation() = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("Width",  function() { return Width1; }, function(_v) { Width1 = _v; } ); // HtmlView Page linking property 'Width' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnDoubleClick", function(_data,_info) {
  toggleFullScreen();

}); // HtmlView Page setting action 'OnDoubleClick' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnResize", function(_data,_info) {
  MinimumX=-10;
  MaximumX=10;
  MinimumY=-10;
  MaximumY=10;

}); // HtmlView Page setting action 'OnResize' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TRMessage",  function() { return "Volume="+ area.toFixed(2)+ " mℓ"; } ); // HtmlView Page linking property 'TRMessage' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnPress", function(_data,_info) {
  var position = _view.plottingPanel.getInteraction().getInteractionPoint();

}); // HtmlView Page setting action 'OnPress' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TLMessage",  function() { return display+"\n"+displaywind+"\n"; } ); // HtmlView Page linking property 'TLMessage' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("Visibility",  function() { return world===true; } ); // HtmlView Page linking property 'Visibility' for element 'plottingPanel'
          _view.water.linkProperty("Points",  function() { return [[-xbase,0],[xbase,0],[x,y],[-x,y],[-xbase,0]]; } ); // HtmlView Page linking property 'Points' for element 'water'
          _view.polygonContainerMemort.linkProperty("Points",  function() { return [[-xCm,yCm],[-xbasem,0],[xbasem,0],[xCm,yCm]]; } ); // HtmlView Page linking property 'Points' for element 'polygonContainerMemort'
          _view.polygonContainerMemort.linkProperty("LineColor",  function() { return memorycolory0; }, function(_v) { memorycolory0 = _v; } ); // HtmlView Page linking property 'LineColor' for element 'polygonContainerMemort'
          _view.polygonContainer2.linkProperty("Points",  function() { return [[-xC,yC],[-xbase,0],[xbase,0],[xC,yC]]; } ); // HtmlView Page linking property 'Points' for element 'polygonContainer2'
          _view.text.linkProperty("Text",  function() { return formatTime(t); }, function(_v) { formatTime(t) = _v; } ); // HtmlView Page linking property 'Text' for element 'text'
          _view.text.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'text'
          _view.text2.linkProperty("Text",  function() { return (t*factor).toFixed(0) + " min"; } ); // HtmlView Page linking property 'Text' for element 'text2'
          _view.text2.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'text2'
          _view.dragbase.setAction("OnRelease", function(_data,_info) {
  xs=x; // for store values to go back
  ys=y;

}); // HtmlView Page setting action 'OnRelease' for element 'dragbase'
          _view.dragbase.linkProperty("X",  function() { return xbase; }, function(_v) { xbase = _v; } ); // HtmlView Page linking property 'X' for element 'dragbase'
          _view.dragbase.linkProperty("Visibility",  function() { return _isPaused&&t==0; } ); // HtmlView Page linking property 'Visibility' for element 'dragbase'
          _view.dragbase.setAction("OnDrag", function(_data,_info) {
  //xbase= Math.round(xbase);
  xbase= Math.round(_info.point[0]*2)/2;
  xbase = Math.max(0.5,xbase);
  if (fixarea==true){
    //area = ((2+2)+(x+x))/2*y; // parallelogram
    y = area/((xbase+xbase)+(x+x))*2;
   // x = (area*2/y - (xbase+xbase))/2;
   //alert();
    yC =y; // need to move he volume correctly
    
    }
    else {
    area = ((xbase+xbase)+(x+x))/2*y; // parallelogram  
      }

}); // HtmlView Page setting action 'OnDrag' for element 'dragbase'
          _view.dragtopy.setAction("OnRelease", function(_data,_info) {
  xs=x; // for store values to go back
  ys=y;

}); // HtmlView Page setting action 'OnRelease' for element 'dragtopy'
          _view.dragtopy.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'dragtopy'
          _view.dragtopy.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'dragtopy'
          _view.dragtopy.linkProperty("Visibility",  function() { return _isPaused&&t==0; } ); // HtmlView Page linking property 'Visibility' for element 'dragtopy'
          _view.dragtopy.setAction("OnDrag", function(_data,_info) {
  //xbase= Math.round(xbase);
  //if (x<4.5){
    x= Math.round(_info.point[0]*2)/2;
    x = Math.max(0.5,x);
    xbase= Math.round(_info.point[0]*2)/2;
    xbase = Math.max(0.5,xbase);
    xs=x;
    ys=y;
    xC=x;
    yC=y;
    if (fixarea==true){
      //area = ((2+2)+(x+x))/2*y; // parallelogram
      //y = area/((2+2)+(x+x))/2
      // x = (area*2/y - (xbase+xbase))/2;
      //alert();
      y = area / x
    }
    else {
      //area = ((xbase+xbase)+(x+x))/2*y; // parallelogram  
      area = x * y
    }
  //}

}); // HtmlView Page setting action 'OnDrag' for element 'dragtopy'
          _view.tempt.linkProperty("NumberOfElements",  function() { return infoNo; }, function(_v) { infoNo = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'tempt'
          _view.tempt.linkProperty("Text",  function() { return temperature; }, function(_v) { temperature = _v; } ); // HtmlView Page linking property 'Text' for element 'tempt'
          _view.wind3.linkProperty("NumberOfElements",  function() { return WindNo; }, function(_v) { WindNo = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'wind3'
          _view.wind3.linkProperty("X",  function() { return xWind; }, function(_v) { xWind = _v; } ); // HtmlView Page linking property 'X' for element 'wind3'
          _view.wind3.linkProperty("Y",  function() { return yWind; }, function(_v) { yWind = _v; } ); // HtmlView Page linking property 'Y' for element 'wind3'
          _view.textSet2.linkProperty("NumberOfElements",  function() { return WindNo; }, function(_v) { WindNo = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'textSet2'
          _view.textSet2.linkProperty("X",  function() { return xWind; }, function(_v) { xWind = _v; } ); // HtmlView Page linking property 'X' for element 'textSet2'
          _view.textSet2.linkProperty("Y",  function() { return yWind; }, function(_v) { yWind = _v; } ); // HtmlView Page linking property 'Y' for element 'textSet2'
          _view.humid.linkProperty("NumberOfElements",  function() { return HumidNo; }, function(_v) { HumidNo = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'humid'
          _view.humid.linkProperty("X",  function() { return xHumid; }, function(_v) { xHumid = _v; } ); // HtmlView Page linking property 'X' for element 'humid'
          _view.humid.linkProperty("Y",  function() { return yHumid; }, function(_v) { yHumid = _v; } ); // HtmlView Page linking property 'Y' for element 'humid'
          _view.textSet.linkProperty("NumberOfElements",  function() { return HumidNo; }, function(_v) { HumidNo = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'textSet'
          _view.textSet.linkProperty("X",  function() { return xHumid; }, function(_v) { xHumid = _v; } ); // HtmlView Page linking property 'X' for element 'textSet'
          _view.textSet.linkProperty("Y",  function() { return yHumid; }, function(_v) { yHumid = _v; } ); // HtmlView Page linking property 'Y' for element 'textSet'
          _view.plottingPanel2.linkProperty("Height",  function() { return changeOrientation(); }, function(_v) { changeOrientation() = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel2'
          _view.plottingPanel2.linkProperty("Width",  function() { return Width2; }, function(_v) { Width2 = _v; } ); // HtmlView Page linking property 'Width' for element 'plottingPanel2'
          _view.plottingPanel2.linkProperty("XTickStep",  function() { return t<1?60:600; } ); // HtmlView Page linking property 'XTickStep' for element 'plottingPanel2'
          _view.plottingPanel2.linkProperty("TLMessage",  function() { return "Amount of Water = "+_view._format(area,"0.0") + "mℓ"; } ); // HtmlView Page linking property 'TLMessage' for element 'plottingPanel2'
          _view.plottingPanel2.linkProperty("BRMessage",  function() { return "Time = "+_view._format(t*factor,"0")+ " min "; } ); // HtmlView Page linking property 'BRMessage' for element 'plottingPanel2'
          _view.trail.linkProperty("Connected",  function() { return t>0; } ); // HtmlView Page linking property 'Connected' for element 'trail'
          _view.trail.linkProperty("LineColor",  function() { return memorycolory; }, function(_v) { memorycolory = _v; } ); // HtmlView Page linking property 'LineColor' for element 'trail'
          _view.trail.linkProperty("InputX",  function() { return t*factor; } ); // HtmlView Page linking property 'InputX' for element 'trail'
          _view.trail.linkProperty("InputY",  function() { return area; }, function(_v) { area = _v; } ); // HtmlView Page linking property 'InputY' for element 'trail'
          _view.shape.linkProperty("X",  function() { return t*factor; } ); // HtmlView Page linking property 'X' for element 'shape'
          _view.shape.linkProperty("Y",  function() { return area; }, function(_v) { area = _v; } ); // HtmlView Page linking property 'Y' for element 'shape'
          _view.dataTable.linkProperty("Input",  function() { return datatable; }, function(_v) { datatable = _v; } ); // HtmlView Page linking property 'Input' for element 'dataTable'
          _view.dataTable.linkProperty("HeadersText",  function() { return ["Surface Area (cm²)", "Temperature (°C)", "Wind", "Humidity", "Volume (mℓ)", "Time (min)"]; } ); // HtmlView Page linking property 'HeadersText' for element 'dataTable'
          _view.dataTable.linkProperty("CellsFormat",  function() { return ["0","0","0","0","0","0"]; } ); // HtmlView Page linking property 'CellsFormat' for element 'dataTable'
          _view.dataTable.linkProperty("ClearAtInput",  function() { return (datatable.length<=1)?false:true; } ); // HtmlView Page linking property 'ClearAtInput' for element 'dataTable'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function evaporationV3primary_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = evaporationV3primary_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function evaporationV3primary_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"fullscreen", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'fullscreen'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"control", _view.fullscreen) // EJsS HtmlView.HtmlView Page: declaration of element 'control'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'control'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view.control) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'controlPanel'
      .setProperty("CSS",{"display":"inline"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'controlPanel'
      .setProperty("Display","inline-flex") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'topPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'topPanel'
      .setProperty("Display","inline-flex") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'topPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"surfacearea", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'surfacearea'
      .setProperty("Width","20%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'surfacearea'
      .setProperty("Background","Orange") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'surfacearea'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'surfacearea'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"sa", _view.surfacearea) // EJsS HtmlView.HtmlView Page: declaration of element 'sa'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider", _view.surfacearea) // EJsS HtmlView.HtmlView Page: declaration of element 'slider'
      .setProperty("Minimum",0.5) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider'
      .setProperty("Maximum",4.5) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider'
      .setProperty("Step",0.5) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"temperature", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'temperature'
      .setProperty("Width","20%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'temperature'
      .setProperty("Background","Cyan") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'temperature'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'temperature'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"Temperature", _view.temperature) // EJsS HtmlView.HtmlView Page: declaration of element 'Temperature'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider2", _view.temperature) // EJsS HtmlView.HtmlView Page: declaration of element 'slider2'
      .setProperty("Minimum",1) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider2'
      .setProperty("Maximum",40) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider2'
      .setProperty("Step",1) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider2'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"wind", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'wind'
      .setProperty("Width","20%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'wind'
      .setProperty("Background","rgba(0,255,0)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'wind'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'wind'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"wind2", _view.wind) // EJsS HtmlView.HtmlView Page: declaration of element 'wind2'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider22", _view.wind) // EJsS HtmlView.HtmlView Page: declaration of element 'slider22'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'slider22'
      .setProperty("Minimum",1) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider22'
      .setProperty("Maximum",3) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider22'
      .setProperty("Step",1) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider22'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"humidity", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'humidity'
      .setProperty("Width","20%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'humidity'
      .setProperty("Background","Magenta") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'humidity'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'humidity'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"hum", _view.humidity) // EJsS HtmlView.HtmlView Page: declaration of element 'hum'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider3", _view.humidity) // EJsS HtmlView.HtmlView Page: declaration of element 'slider3'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'slider3'
      .setProperty("Minimum",1) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider3'
      .setProperty("Maximum",3) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider3'
      .setProperty("Step",1) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider3'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"pressure", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'pressure'
      .setProperty("Width","20%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'pressure'
      .setProperty("Background","Blue") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'pressure'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'pressure'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"p", _view.pressure) // EJsS HtmlView.HtmlView Page: declaration of element 'p'
      .setProperty("Foreground","White") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'p'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"slider32", _view.pressure) // EJsS HtmlView.HtmlView Page: declaration of element 'slider32'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'slider32'
      .setProperty("Minimum",0.5) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'slider32'
      .setProperty("Maximum",1.5) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'slider32'
      .setProperty("Step",0.5) // EJsS HtmlView.HtmlView Page: setting property 'Step' for element 'slider32'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"fixareaPanel", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fixareaPanel'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'fixareaPanel'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"fixarea", _view.fixareaPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fixarea'
      .setProperty("Text","Fix volume?") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'fixarea'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'fixarea'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton2", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton2'
      .setProperty("TextOn","Play ▶") // EJsS HtmlView.HtmlView Page: setting property 'TextOn' for element 'playPauseButton2'
      .setProperty("Tooltip","Play/Pause") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'playPauseButton2'
      .setProperty("TextOff","Pause ❚❚") // EJsS HtmlView.HtmlView Page: setting property 'TextOff' for element 'playPauseButton2'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'playPauseButton2'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepButton2", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepButton2'
      .setProperty("Text","Next |►") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'stepButton2'
      ;

    _view._addElement(EJSS_INTERFACE.button,"Storedatabutton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'Storedatabutton'
      .setProperty("Text","Store▼") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'Storedatabutton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton3", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton3'
      .setProperty("Text","Reset ↻") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'resetButton3'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'resetButton3'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"display", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'display'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'display'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"displaytext", _view.display) // EJsS HtmlView.HtmlView Page: declaration of element 'displaytext'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'displaytext'
      .setProperty("TextAlign","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'displaytext'
      .setProperty("Text","Display: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'displaytext'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"worldgraph", _view.display) // EJsS HtmlView.HtmlView Page: declaration of element 'worldgraph'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'worldgraph'
      .setProperty("Tooltip","select user_defined and drag the mass") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'worldgraph'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'worldgraph'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panel", _view.fullscreen) // EJsS HtmlView.HtmlView Page: declaration of element 'panel'
      .setProperty("Height","100%") // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'panel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'panel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.panel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Gutters",[50,0,0,50]) // EJsS HtmlView.HtmlView Page: setting property 'Gutters' for element 'plottingPanel'
      .setProperty("ShowAreaRectangle",false) // EJsS HtmlView.HtmlView Page: setting property 'ShowAreaRectangle' for element 'plottingPanel'
      .setProperty("YScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'YScalePrecision' for element 'plottingPanel'
      .setProperty("XFixedTick",-5) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("XTickStep",1) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",1) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("MaximumY",12.5) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'plottingPanel'
      .setProperty("MaximumX",5) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("MinimumX",-5) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'plottingPanel'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("MarginY",1) // EJsS HtmlView.HtmlView Page: setting property 'MarginY' for element 'plottingPanel'
      .setProperty("XScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'XScalePrecision' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.polygon,"water", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'water'
      .setProperty("FillColor","rgba(137,209,254,1)") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'water'
      ;

    _view._addElement(EJSS_DRAWING2D.polygon,"polygonContainerMemort", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'polygonContainerMemort'
      .setProperty("Attributes",{ "stroke-dasharray":"8 8 8 8" }) // EJsS HtmlView.HtmlView Page: setting property 'Attributes' for element 'polygonContainerMemort'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'polygonContainerMemort'
      .setProperty("LineWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'polygonContainerMemort'
      ;

    _view._addElement(EJSS_DRAWING2D.polygon,"polygonContainer2", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'polygonContainer2'
      .setProperty("LineWidth",4) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'polygonContainer2'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"stopwatch", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stopwatch'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"image", _view.stopwatch) // EJsS HtmlView.HtmlView Page: declaration of element 'image'
      .setProperty("SizeX",3) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'image'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'image'
      .setProperty("X",3) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'image'
      .setProperty("ImageUrl","./evaporation/stopwatch.png") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'image'
      .setProperty("Y",10) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'image'
      .setProperty("SizeY",4) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'image'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"offset", _view.stopwatch) // EJsS HtmlView.HtmlView Page: declaration of element 'offset'
      .setProperty("X",-0.05) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'offset'
      .setProperty("Y",-0.05) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'offset'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"text", _view.offset) // EJsS HtmlView.HtmlView Page: declaration of element 'text'
      .setProperty("X",3) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'text'
      .setProperty("Y",10) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'text'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'text'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"text2", _view.offset) // EJsS HtmlView.HtmlView Page: declaration of element 'text2'
      .setProperty("X",3) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'text2'
      .setProperty("Y",10) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'text2'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"hide", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'hide'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'hide'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"dragbase", _view.hide) // EJsS HtmlView.HtmlView Page: declaration of element 'dragbase'
      .setProperty("SizeX",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'dragbase'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'dragbase'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'dragbase'
      .setProperty("SizeY",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'dragbase'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'dragbase'
      .setProperty("DrawFill",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'dragbase'
      .setProperty("EnabledPosition","ENABLED_X") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'dragbase'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"dragtopy", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'dragtopy'
      .setProperty("SizeX",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'dragtopy'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'dragtopy'
      .setProperty("SizeY",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'dragtopy'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'dragtopy'
      .setProperty("DrawFill",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'dragtopy'
      .setProperty("EnabledPosition","ENABLED_X") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'dragtopy'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"temp", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'temp'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'temp'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"tempt", _view.temp) // EJsS HtmlView.HtmlView Page: declaration of element 'tempt'
      .setProperty("FontSize",30) // EJsS HtmlView.HtmlView Page: setting property 'FontSize' for element 'tempt'
      .setProperty("RelativePosition","EAST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'tempt'
      .setProperty("X",-2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'tempt'
      .setProperty("Y",-1) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'tempt'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"temptext", _view.temp) // EJsS HtmlView.HtmlView Page: declaration of element 'temptext'
      .setProperty("FontSize",30) // EJsS HtmlView.HtmlView Page: setting property 'FontSize' for element 'temptext'
      .setProperty("X",-0.5) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'temptext'
      .setProperty("Y",-1) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'temptext'
      .setProperty("Text","Temperature/°C =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'temptext'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"wind4", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'wind4'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'wind4'
      ;

    _view._addElement(EJSS_DRAWING2D.imageSet,"wind3", _view.wind4) // EJsS HtmlView.HtmlView Page: declaration of element 'wind3'
      .setProperty("SizeX",100) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'wind3'
      .setProperty("Rotate",4.7) // EJsS HtmlView.HtmlView Page: setting property 'Rotate' for element 'wind3'
      .setProperty("ImageUrl","./evaporation/wind.png") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'wind3'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'wind3'
      .setProperty("SizeY",100) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'wind3'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'wind3'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"textSet2", _view.wind4) // EJsS HtmlView.HtmlView Page: declaration of element 'textSet2'
      .setProperty("Text","💨") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'textSet2'
      .setProperty("Font","normal normal 4vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'textSet2'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"humidity2", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'humidity2'
      .setProperty("X",1.5) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'humidity2'
      .setProperty("Y",11) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'humidity2'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'humidity2'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"humidtext", _view.humidity2) // EJsS HtmlView.HtmlView Page: declaration of element 'humidtext'
      .setProperty("FontSize",30) // EJsS HtmlView.HtmlView Page: setting property 'FontSize' for element 'humidtext'
      .setProperty("X",-0.5) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'humidtext'
      .setProperty("Y",-2.5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'humidtext'
      .setProperty("Text","Humidity/% =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'humidtext'
      ;

    _view._addElement(EJSS_DRAWING2D.imageSet,"humid", _view.humidity2) // EJsS HtmlView.HtmlView Page: declaration of element 'humid'
      .setProperty("SizeX",80) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'humid'
      .setProperty("ImageUrl","./evaporation/humidity.png") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'humid'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'humid'
      .setProperty("SizeY",50) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'humid'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'humid'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"textSet", _view.humidity2) // EJsS HtmlView.HtmlView Page: declaration of element 'textSet'
      .setProperty("Text","💧") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'textSet'
      .setProperty("Font","normal normal 4vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'textSet'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel2", _view.panel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel2'
      .setProperty("YScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'YScalePrecision' for element 'plottingPanel2'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel2'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel2'
      .setProperty("YTickStep",10) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel2'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel2'
      .setProperty("TitleYFont","normal normal 15px ") // EJsS HtmlView.HtmlView Page: setting property 'TitleYFont' for element 'plottingPanel2'
      .setProperty("TitleXFont","normal normal 15px ") // EJsS HtmlView.HtmlView Page: setting property 'TitleXFont' for element 'plottingPanel2'
      .setProperty("Title","Evaporation Graph") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel2'
      .setProperty("MaximumY",25) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'plottingPanel2'
      .setProperty("MaximumX",3) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'plottingPanel2'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel2'
      .setProperty("MinimumX",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'plottingPanel2'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'plottingPanel2'
      .setProperty("TitleY","Amount of Water /mℓ") // EJsS HtmlView.HtmlView Page: setting property 'TitleY' for element 'plottingPanel2'
      .setProperty("AutoScaleY",true) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel2'
      .setProperty("TitleX","Time Taken /min") // EJsS HtmlView.HtmlView Page: setting property 'TitleX' for element 'plottingPanel2'
      .setProperty("AutoScaleX",true) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel2'
      .setProperty("MarginX",5) // EJsS HtmlView.HtmlView Page: setting property 'MarginX' for element 'plottingPanel2'
      .setProperty("MarginY",5) // EJsS HtmlView.HtmlView Page: setting property 'MarginY' for element 'plottingPanel2'
      .setProperty("TitleFont","normal normal 20px ") // EJsS HtmlView.HtmlView Page: setting property 'TitleFont' for element 'plottingPanel2'
      .setProperty("XScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'XScalePrecision' for element 'plottingPanel2'
      ;

    _view._addElement(EJSS_DRAWING2D.trail,"trail", _view.plottingPanel2) // EJsS HtmlView.HtmlView Page: declaration of element 'trail'
      .setProperty("NoRepeat",true) // EJsS HtmlView.HtmlView Page: setting property 'NoRepeat' for element 'trail'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'trail'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"shape", _view.plottingPanel2) // EJsS HtmlView.HtmlView Page: declaration of element 'shape'
      .setProperty("SizeX",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'shape'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'shape'
      .setProperty("SizeY",20) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'shape'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'shape'
      ;

    _view._addElement(EJSS_INTERFACE.dataTable,"dataTable", _view.panel) // EJsS HtmlView.HtmlView Page: declaration of element 'dataTable'
      .setProperty("Active",true) // EJsS HtmlView.HtmlView Page: setting property 'Active' for element 'dataTable'
      .setProperty("NoRepeat",true) // EJsS HtmlView.HtmlView Page: setting property 'NoRepeat' for element 'dataTable'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"html", _view.fullscreen) // EJsS HtmlView.HtmlView Page: declaration of element 'html'
      .setProperty("Html","<h2>Description</h2> <p>This simulation has a container with the front view under the following controllable variables</p> <p>Surface Area of the container as shown by the water level decreasing due to evaporation</p> <p>Temperature of the surroundings that as it increase also increases the rate of evaporation of the water in the container</p> <p>Presence of Wind, with 3 settings, Low, Medium and High winds conditions. Higher the wind conditions, faster the rate of evaporation of water in the container</p> <p> Humidity , with 3 settings, Low, Medium and High Humidity, Low humidity imply Higher rate of evaporation, High humidity imply Lower rate of evaporation </p> <h2>Controls</h2> <p>Play/Pause button starts and pause the simulation</p> <p>Step button forward the simulation by one time step</p> <p>Store Data button allows different runs of the experiment with different variables values, the graph will show different color trail for comparison like a datalogger setup.</p> <p>Reset button puts the simulation back to its default state.</p> <h2>Sample Question Type that the Simulation is made to address. Suggested Answer is Beaker B is line Q, Beaker A is line S</h2>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'html'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'html'
      ;

    _view._addElement(EJSS_INTERFACE.html,"htmlArea", _view.fullscreen) // EJsS HtmlView.HtmlView Page: declaration of element 'htmlArea'
      .setProperty("Height",600) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'htmlArea'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'htmlArea'
      .setProperty("Html","<img src=\"./evaporation/WhatsApp Image 2020-06-11 at 2.15.55 PM.jpeg\" alt=\"./evaporation/humidity.png\">") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'htmlArea'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'htmlArea'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new evaporationV3primary("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
