/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.concord.energy2d.undo.UndoClock;
import org.concord.energy2d.undo.UndoColorPalette;
import org.concord.energy2d.undo.UndoColoringProperty;
import org.concord.energy2d.undo.UndoColoringStyle;
import org.concord.energy2d.undo.UndoControlPanel;
import org.concord.energy2d.undo.UndoGridLines;
import org.concord.energy2d.undo.UndoHeatFluxArrows;
import org.concord.energy2d.undo.UndoHeatFluxLines;
import org.concord.energy2d.undo.UndoIsotherm;
import org.concord.energy2d.undo.UndoMaximumTemperature;
import org.concord.energy2d.undo.UndoMinimumTemperature;
import org.concord.energy2d.undo.UndoMouseReadType;
import org.concord.energy2d.undo.UndoSeeThrough;
import org.concord.energy2d.undo.UndoSmooth;
import org.concord.energy2d.undo.UndoStreamlines;
import org.concord.energy2d.undo.UndoTickmarks;
import org.concord.energy2d.undo.UndoVelocity;
import org.concord.energy2d.undo.UndoViewFactorLines;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ViewDialog
extends JDialog {
    private Window owner;
    private JTextField lowerTempField;
    private JTextField upperTempField;
    private JTextField fanRotationSpeedScaleField;
    private JLabel nameLabel1;
    private JLabel nameLabel2;
    private JLabel unitLabel1;
    private JLabel unitLabel2;

    ViewDialog(final View2D view, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "View Options", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ViewDialog.this.parse(ViewDialog.this.lowerTempField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                if ((double)Math.abs(x - view.getMinimumTemperature()) > 0.001) {
                    view.getUndoManager().addEdit(new UndoMinimumTemperature(view));
                    view.setMinimumTemperature(x);
                }
                if (Float.isNaN(x = ViewDialog.this.parse(ViewDialog.this.upperTempField.getText()))) {
                    return;
                }
                if ((double)Math.abs(x - view.getMaximumTemperature()) > 0.001) {
                    view.getUndoManager().addEdit(new UndoMaximumTemperature(view));
                    view.setMaximumTemperature(x);
                }
                if (Float.isNaN(x = ViewDialog.this.parse(ViewDialog.this.fanRotationSpeedScaleField.getText()))) {
                    return;
                }
                if (x <= 0.0f) {
                    JOptionPane.showMessageDialog(ViewDialog.this.owner, "Fan rotation speed scale must be positive.", "Error", 0);
                    return;
                }
                if ((double)Math.abs(x - view.getFanRotationSpeedScaleFactor()) > 0.001) {
                    view.setFanRotationSpeedScaleFactor(x);
                }
                view.notifyManipulationListeners(null, (byte)3);
                view.repaint();
                ViewDialog.this.dispose();
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(null, (byte)3);
                view.repaint();
                ViewDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(okListener);
        buttonPanel.add(button);
        JTabbedPane tab = new JTabbedPane();
        panel.add((Component)tab, "Center");
        tab.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new SpringLayout());
        p2.add((Component)p, "North");
        tab.add((Component)p2, "General");
        int count = 0;
        JCheckBox checkBox = new JCheckBox("Isotherm");
        checkBox.setSelected(view.isIsothermOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoIsotherm(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setIsothermOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Velocity");
        checkBox.setSelected(view.isVelocityOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoVelocity(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setVelocityOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Streamlines");
        checkBox.setSelected(view.isStreamlineOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoStreamlines(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setStreamlineOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Heat Flux Lines");
        checkBox.setSelected(view.isHeatFluxLinesOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoHeatFluxLines(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setHeatFluxLinesOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        ++count;
        checkBox = new JCheckBox("Heat Flux Arrows");
        checkBox.setSelected(view.isHeatFluxArrowsOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoHeatFluxArrows(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setHeatFluxArrowsOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Tickmarks");
        checkBox.setSelected(view.isBorderTickmarksOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoTickmarks(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setBorderTickmarksOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Graph");
        checkBox.setSelected(view.isGraphOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
                view.setGraphOn(src.isSelected());
                view.repaint();
                view.notifyGraphListeners(src.isSelected() ? (byte)0 : 1);
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("See-Through");
        checkBox.setSelected(view.getSeeThrough());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoSeeThrough(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setSeeThrough(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        ++count;
        checkBox = new JCheckBox("Smooth");
        checkBox.setSelected(view.isSmooth());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoSmooth(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setSmooth(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Clock");
        checkBox.setSelected(view.isClockOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoClock(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setClockOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Grid");
        checkBox.setSelected(view.isGridOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoGridLines(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setGridOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("View Factor Lines");
        checkBox.setSelected(view.isViewFactorLinesOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoViewFactorLines(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setViewFactorLinesOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Color Palette");
        checkBox.setSelected(view.isColorPaletteOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoColorPalette(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setColorPaletteOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        ++count;
        checkBox = new JCheckBox("Brand");
        checkBox.setSelected(view.isFrankOn());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
                view.setFrankOn(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        checkBox = new JCheckBox("Control Panel");
        checkBox.setSelected(view.isControlPanelVisible());
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                view.getUndoManager().addEdit(new UndoControlPanel(view));
                JCheckBox src = (JCheckBox)e.getSource();
                view.setControlPanelVisible(src.isSelected());
                view.repaint();
            }
        });
        p.add(checkBox);
        p.add(new JPanel());
        p.add(new JPanel());
        MiscUtil.makeCompactGrid(p, ++count, 4, 5, 5, 10, 2);
        p2 = new JPanel(new BorderLayout());
        p = new JPanel(new SpringLayout());
        p2.add((Component)p, "North");
        tab.add((Component)p2, "Visualization");
        count = 0;
        p.add(new JLabel("Coloring property"));
        final JComboBox<String> coloringComboBox = new JComboBox<String>();
        coloringComboBox.addItem("None");
        coloringComboBox.addItem("Temperature");
        coloringComboBox.addItem("Thermal energy");
        coloringComboBox.setSelectedIndex(view.getHeatMapType() - 0);
        coloringComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int i = coloringComboBox.getSelectedIndex();
                    ViewDialog.this.nameLabel1.setEnabled(i > 0);
                    ViewDialog.this.nameLabel2.setEnabled(i > 0);
                    ViewDialog.this.unitLabel1.setEnabled(i > 0);
                    ViewDialog.this.unitLabel2.setEnabled(i > 0);
                    switch (i) {
                        case 0: {
                            ViewDialog.this.lowerTempField.setEnabled(false);
                            ViewDialog.this.upperTempField.setEnabled(false);
                            ViewDialog.this.nameLabel1.setText(null);
                            ViewDialog.this.nameLabel2.setText(null);
                            ViewDialog.this.unitLabel1.setText(null);
                            ViewDialog.this.unitLabel2.setText(null);
                            break;
                        }
                        case 1: {
                            ViewDialog.this.lowerTempField.setEnabled(true);
                            ViewDialog.this.upperTempField.setEnabled(true);
                            ViewDialog.this.nameLabel1.setText("Lowest temperature");
                            ViewDialog.this.nameLabel2.setText("Highest temperature");
                            ViewDialog.this.unitLabel1.setText("\u00b0C");
                            ViewDialog.this.unitLabel2.setText("\u00b0C");
                            break;
                        }
                        case 2: {
                            ViewDialog.this.lowerTempField.setEnabled(true);
                            ViewDialog.this.upperTempField.setEnabled(true);
                            ViewDialog.this.nameLabel1.setText("Lowest energy");
                            ViewDialog.this.nameLabel2.setText("Highest energy");
                            ViewDialog.this.unitLabel1.setText("J");
                            ViewDialog.this.unitLabel2.setText("J");
                        }
                    }
                    view.getUndoManager().addEdit(new UndoColoringProperty(view));
                    view.setHeatMapType((byte)(i + 0));
                    view.repaint();
                }
            }
        });
        p.add(coloringComboBox);
        p.add(new JPanel());
        ++count;
        p.add(new JLabel("Coloring style"));
        final JComboBox<String> coloringStyleComboBox = new JComboBox<String>();
        coloringStyleComboBox.addItem("Rainbow");
        coloringStyleComboBox.addItem("Iron");
        coloringStyleComboBox.addItem("Gray");
        coloringStyleComboBox.setSelectedIndex(view.getColorPaletteType() - 0);
        coloringStyleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    view.getUndoManager().addEdit(new UndoColoringStyle(view));
                    int i = coloringStyleComboBox.getSelectedIndex();
                    view.setColorPaletteType((byte)(i + 0));
                    view.repaint();
                }
            }
        });
        p.add(coloringStyleComboBox);
        p.add(new JPanel());
        ++count;
        this.nameLabel1 = new JLabel("Lowest temperature");
        p.add(this.nameLabel1);
        this.lowerTempField = new JTextField(String.valueOf(view.getMinimumTemperature()), 8);
        this.lowerTempField.addActionListener(okListener);
        p.add(this.lowerTempField);
        this.unitLabel1 = new JLabel("\u00b0C");
        p.add(this.unitLabel1);
        ++count;
        this.nameLabel2 = new JLabel("Highest temperature");
        p.add(this.nameLabel2);
        this.upperTempField = new JTextField(String.valueOf(view.getMaximumTemperature()), 8);
        this.upperTempField.addActionListener(okListener);
        p.add(this.upperTempField);
        this.unitLabel2 = new JLabel("\u00b0C");
        p.add(this.unitLabel2);
        ++count;
        p.add(new JLabel("Fan rotation speed scale"));
        this.fanRotationSpeedScaleField = new JTextField(String.valueOf(view.getFanRotationSpeedScaleFactor()), 8);
        this.fanRotationSpeedScaleField.addActionListener(okListener);
        p.add(this.fanRotationSpeedScaleField);
        p.add(new JLabel("Dimensionless"));
        ++count;
        p.add(new JLabel("Mouse reading"));
        final JComboBox<String> mouseReadingComboBox = new JComboBox<String>();
        mouseReadingComboBox.addItem("Default");
        mouseReadingComboBox.addItem("Temperature");
        mouseReadingComboBox.addItem("Thermal energy");
        mouseReadingComboBox.addItem("Velocity");
        mouseReadingComboBox.addItem("Heat flux");
        mouseReadingComboBox.addItem("Coordinates");
        mouseReadingComboBox.setSelectedIndex(view.getMouseReadType());
        mouseReadingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    view.getUndoManager().addEdit(new UndoMouseReadType(view));
                    view.setMouseReadType((byte)mouseReadingComboBox.getSelectedIndex());
                    view.repaint();
                    view.notifyManipulationListeners(null, (byte)17);
                }
            }
        });
        p.add(mouseReadingComboBox);
        p.add(new JPanel());
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

