/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.concord.energy2d.event.GraphEvent;
import org.concord.energy2d.event.GraphListener;
import org.concord.energy2d.event.ManipulationEvent;
import org.concord.energy2d.event.ManipulationListener;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Photon;
import org.concord.energy2d.model.Segment;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.system.Helper;
import org.concord.energy2d.undo.UndoAddManipulable;
import org.concord.energy2d.undo.UndoEditBlob;
import org.concord.energy2d.undo.UndoEditBlobOrPolygon;
import org.concord.energy2d.undo.UndoEditPolygon;
import org.concord.energy2d.undo.UndoPaste;
import org.concord.energy2d.undo.UndoRemoveManipulable;
import org.concord.energy2d.undo.UndoResizeManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.undo.UndoZoom;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.ContourMap;
import org.concord.energy2d.util.FieldLines;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.TextureFactory;
import org.concord.energy2d.view.ColorPalette;
import org.concord.energy2d.view.DataViewer;
import org.concord.energy2d.view.DialogFactory;
import org.concord.energy2d.view.GraphRenderer;
import org.concord.energy2d.view.GridRenderer;
import org.concord.energy2d.view.HandleSetter;
import org.concord.energy2d.view.MovingAnnulus;
import org.concord.energy2d.view.MovingBlob;
import org.concord.energy2d.view.MovingCloud;
import org.concord.energy2d.view.MovingEllipse;
import org.concord.energy2d.view.MovingFan;
import org.concord.energy2d.view.MovingHeliostat;
import org.concord.energy2d.view.MovingParticleFeeder;
import org.concord.energy2d.view.MovingPolygon;
import org.concord.energy2d.view.MovingRoundRectangle;
import org.concord.energy2d.view.MovingShape;
import org.concord.energy2d.view.MovingTree;
import org.concord.energy2d.view.Picture;
import org.concord.energy2d.view.ScalarDistributionRenderer;
import org.concord.energy2d.view.Symbol;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.TextBoxPanel;
import org.concord.energy2d.view.ThermostatRenderer;
import org.concord.energy2d.view.TickmarksRenderer;
import org.concord.energy2d.view.VectorRenderer;

public class View2D
extends JPanel
implements PropertyChangeListener {
    public static final byte SELECT_MODE = 0;
    public static final byte RECTANGLE_MODE = 1;
    public static final byte ELLIPSE_MODE = 2;
    public static final byte POLYGON_MODE = 3;
    public static final byte BLOB_MODE = 4;
    public static final byte THERMOMETER_MODE = 11;
    public static final byte HEAT_FLUX_SENSOR_MODE = 12;
    public static final byte ANEMOMETER_MODE = 13;
    public static final byte HEATING_MODE = 21;
    public static final byte PARTICLE_MODE = 31;
    public static final byte PARTICLE_FEEDER_MODE = 32;
    public static final byte FAN_MODE = 33;
    public static final byte HELIOSTAT_MODE = 34;
    public static final byte CLOUD_MODE = 35;
    public static final byte TREE_MODE = 36;
    public static final byte HEATMAP_NONE = 0;
    public static final byte HEATMAP_TEMPERATURE = 1;
    public static final byte HEATMAP_THERMAL_ENERGY = 2;
    public static final byte MOUSE_READ_DEFAULT = 0;
    public static final byte MOUSE_READ_TEMPERATURE = 1;
    public static final byte MOUSE_READ_THERMAL_ENERGY = 2;
    public static final byte MOUSE_READ_VELOCITY = 3;
    public static final byte MOUSE_READ_HEAT_FLUX = 4;
    public static final byte MOUSE_READ_COORDINATES = 5;
    public static final byte RAINBOW = 0;
    public static final byte IRON = 1;
    public static final byte GRAY = 2;
    static final byte UPPER_LEFT = 0;
    static final byte LOWER_LEFT = 1;
    static final byte UPPER_RIGHT = 2;
    static final byte LOWER_RIGHT = 3;
    static final byte TOP = 4;
    static final byte BOTTOM = 5;
    static final byte LEFT = 6;
    static final byte RIGHT = 7;
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    private static final int MINIMUM_MOUSE_DRAG_RESPONSE_INTERVAL = 5;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("###.#");
    private static final DecimalFormat TEMPERATURE_FORMAT = new DecimalFormat("###.#");
    static final DecimalFormat VELOCITY_FORMAT = new DecimalFormat("#.####");
    private static final DecimalFormat HEAT_FLUX_FORMAT = new DecimalFormat("###.##");
    static final DecimalFormat COORDINATES_FORMAT = new DecimalFormat("###.###");
    private Font smallFont = new Font(null, 0, 10);
    private Font sensorReadingFont = new Font(null, 0, 10);
    private Font labelFont = new Font("Arial", 1, 14);
    private BufferedImage bimg;
    private TickmarksRenderer borderTickmarksRenderer;
    private GridRenderer gridRenderer;
    private ColorPalette colorPalette;
    private GraphRenderer graphRenderer;
    private ScalarDistributionRenderer temperatureRenderer;
    private ScalarDistributionRenderer thermalEnergyRenderer;
    private VectorRenderer vectorFieldRenderer;
    private float heatFluxMinimumValueSquare = VectorRenderer.getDefaultMinimumValueSquare();
    private float heatFluxScale = VectorRenderer.getDefaultScale();
    private boolean dotForZeroHeatFlux;
    private ThermostatRenderer thermostatRenderer;
    private boolean fahrenheitUsed;
    private boolean showIsotherm;
    private boolean showStreamLines;
    private boolean showVelocity;
    private boolean showHeatFluxArrows;
    private boolean showHeatFluxLines;
    private boolean showGraph;
    private boolean showColorPalette;
    private boolean showGrid;
    private boolean showViewFactorLines;
    private boolean snapToGrid = true;
    private float fanRotationSpeedScaleFactor = 1.0f;
    private boolean clockOn = true;
    private boolean frankOn = true;
    private boolean showControlPanel;
    private byte heatMapType = 1;
    private byte mouseReadType = 0;
    private byte colorPaletteType = 0;
    private float[][] distribution;
    private static Stroke thinStroke = new BasicStroke(1.0f);
    private static Stroke moderateStroke = new BasicStroke(2.0f);
    private static Stroke thickStroke = new BasicStroke(4.0f);
    private static Stroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f}, 0.0f);
    private static Stroke longDashed = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
    private static final Color TRANSLUCENT_GRAY = new Color(128, 128, 128, 128);
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private int nx;
    private int ny;
    private float time;
    private JPopupMenu modelPopupMenu;
    private JPopupMenu partPopupMenu;
    private JMenuItem partViewOptionsMenuItem;
    private Rectangle[] handle = new Rectangle[256];
    private boolean mouseBeingDragged;
    private MovingShape movingShape;
    private Point pressedPointRelative = new Point();
    private long mousePressedTime;
    private int selectedSpot = -1;
    private Point anchorPoint = new Point();
    private AffineTransform scale;
    private ContourMap isotherms;
    private FieldLines streamlines;
    private FieldLines heatFluxLines;
    private Polygon multigon;
    private float photonLength = 5.0f;
    private byte actionMode = 0;
    private Rectangle rectangle = new Rectangle();
    private Ellipse2D.Float ellipse = new Ellipse2D.Float();
    private Polygon polygon = new Polygon();
    private Point mousePressedPoint = new Point(-1, -1);
    private Point mouseReleasedPoint = new Point(-1, -1);
    private Point mouseMovedPoint = new Point(-1, -1);
    private Point mouseDraggedPoint = new Point(-1, -1);
    private String errorMessage;
    private DecimalFormat formatter = new DecimalFormat("#####.#####");
    private Color lightColor = new Color(255, 255, 255, 128);
    private Symbol brand;
    private Symbol moon;
    private Symbol sun;
    private Symbol startIcon;
    private Symbol resetIcon;
    private Symbol graphIcon;
    private Symbol switchIcon;
    private Symbol nextIcon;
    private Symbol prevIcon;
    private Symbol modeIcon;
    private String tipText;
    private Point tipTextLocation = new Point(30, 30);
    Model2D model;
    private UndoManager undoManager;
    private Manipulable selectedManipulable;
    private Manipulable copiedManipulable;
    private List<TextBox> textBoxes;
    private List<Picture> pictures;
    private JPopupMenu tipPopupMenu;
    private boolean runToggle;
    private DialogFactory dialogFactory;
    private DataViewer dataViewer;
    private List<ManipulationListener> manipulationListeners;
    private List<GraphListener> graphListeners;
    private Action copyAction;
    private Action cutAction;
    private Action pasteAction;
    private volatile boolean runHeatingThread;
    private volatile boolean cooling;
    private volatile float heatingX;
    private volatile float heatingY;
    private float temperatureIncrement = 10.0f;

    public View2D() {
        int i = 0;
        while (i < this.handle.length) {
            this.handle[i] = new Rectangle(0, 0, 6, 6);
            ++i;
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                View2D.this.processKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                View2D.this.processKeyReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                View2D.this.processMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                View2D.this.processMouseReleased(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                View2D.this.processMouseExited(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                View2D.this.processMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                View2D.this.processMouseDragged(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                View2D.this.processComponentResized(e);
            }
        });
        this.textBoxes = Collections.synchronizedList(new ArrayList());
        this.createActions();
        this.createModelPopupMenu();
        this.setColorPaletteType(this.colorPaletteType);
        this.dialogFactory = new DialogFactory(this);
        this.graphRenderer = new GraphRenderer(50, 50, 200, 200);
        this.graphRenderer.setMouseMovedPoint(this.mouseMovedPoint);
        this.thermostatRenderer = new ThermostatRenderer();
        this.manipulationListeners = new ArrayList<ManipulationListener>();
        this.graphListeners = new ArrayList<GraphListener>();
        this.brand = new Symbol.BrandIcon();
        this.brand.setStroke(moderateStroke);
        this.undoManager = new UndoManager();
    }

    private void createActions() {
        this.cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.cut();
            }
        };
        KeyStroke ks = IS_MAC ? KeyStroke.getKeyStroke(88, 4) : KeyStroke.getKeyStroke(88, 2);
        this.cutAction.putValue("Name", "Cut");
        this.cutAction.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Cut");
        this.getActionMap().put("Cut", this.cutAction);
        this.copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.copy();
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(67, 4) : KeyStroke.getKeyStroke(67, 2);
        this.copyAction.putValue("Name", "Copy");
        this.copyAction.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Copy");
        this.getActionMap().put("Copy", this.copyAction);
        this.pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.paste();
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(86, 4) : KeyStroke.getKeyStroke(86, 2);
        this.pasteAction.putValue("Name", "Paste");
        this.pasteAction.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Paste");
        this.getActionMap().put("Paste", this.pasteAction);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBox t = new TextBox(new Rectangle2D.Float());
                t.setX(((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.1f);
                t.setY(((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.model.getLy() - View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.9f);
                View2D.this.addTextBox(t);
                TextBoxPanel tbp = new TextBoxPanel(t, View2D.this);
                tbp.createDialog(true).setVisible(true);
                if (tbp.isCancelled() || t.getLabel() == null || t.getLabel().trim().equals("")) {
                    View2D.this.removeTextBox(t);
                } else {
                    View2D.this.notifyManipulationListeners(t, (byte)7);
                    View2D.this.setSelectedManipulable(t);
                    View2D.this.undoManager.addEdit(new UndoAddManipulable(t, View2D.this));
                }
            }
        };
        a.putValue("Name", "Text Box");
        a.putValue("ShortDescription", "Insert a text box where the mouse last clicked");
        this.getActionMap().put("Insert Text Box", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.05f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.025f;
                Fan fan = View2D.this.addFan(x, y, View2D.this.model.getLx() * 0.3f, View2D.this.model.getLy() * 0.1f);
                View2D.this.notifyManipulationListeners(fan, (byte)7);
                View2D.this.setSelectedManipulable(fan);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(fan, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Fan");
        a.putValue("ShortDescription", "Insert a fan where the mouse last clicked");
        this.getActionMap().put("Insert Fan", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.05f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.05f;
                Heliostat heliostat = View2D.this.addHeliostat(x, y, View2D.this.model.getLx() * 0.2f, View2D.this.model.getLy() * 0.2f);
                View2D.this.notifyManipulationListeners(heliostat, (byte)7);
                View2D.this.setSelectedManipulable(heliostat);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(heliostat, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Heliostat");
        a.putValue("ShortDescription", "Insert a heliostat where the mouse last clicked");
        this.getActionMap().put("Insert Heliostat", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.05f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.025f;
                Cloud cloud = View2D.this.addCloud(x, y, View2D.this.model.getLx() * 0.3f, View2D.this.model.getLy() * 0.1f, 0.0f);
                View2D.this.notifyManipulationListeners(cloud, (byte)7);
                View2D.this.setSelectedManipulable(cloud);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(cloud, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Cloud");
        a.putValue("ShortDescription", "Insert a cloud where the mouse last clicked");
        this.getActionMap().put("Insert Cloud", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.025f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.05f;
                Tree tree = View2D.this.addTree(x, y, View2D.this.model.getLx() * 0.1f, View2D.this.model.getLy() * 0.2f, (byte)1);
                View2D.this.notifyManipulationListeners(tree, (byte)7);
                View2D.this.setSelectedManipulable(tree);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(tree, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Tree");
        a.putValue("ShortDescription", "Insert a tree where the mouse last clicked");
        this.getActionMap().put("Insert Tree", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.5f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.5f;
                Thermometer thermometer = View2D.this.addThermometer(x, y);
                View2D.this.notifyManipulationListeners(thermometer, (byte)8);
                View2D.this.setSelectedManipulable(thermometer);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(thermometer, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Thermometer");
        a.putValue("ShortDescription", "Insert a thermometer where the mouse last clicked");
        this.getActionMap().put("Insert Thermometer", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.5f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.5f;
                HeatFluxSensor heatFluxSensor = View2D.this.addHeatFluxSensor(x, y);
                View2D.this.notifyManipulationListeners(heatFluxSensor, (byte)8);
                View2D.this.setSelectedManipulable(heatFluxSensor);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(heatFluxSensor, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Heat Flux Sensor");
        a.putValue("ShortDescription", "Insert a heat flux sensor where the mouse last clicked");
        this.getActionMap().put("Insert Heat Flux Sensor", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.5f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.5f;
                Anemometer anemometer = View2D.this.addAnemometer(x, y);
                View2D.this.notifyManipulationListeners(anemometer, (byte)8);
                View2D.this.setSelectedManipulable(anemometer);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(anemometer, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Anemometer");
        a.putValue("ShortDescription", "Insert an anemometer where the mouse last clicked");
        this.getActionMap().put("Insert Anemometer", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.025f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.05f;
                Particle particle = View2D.this.addParticle(x, y);
                View2D.this.notifyManipulationListeners(particle, (byte)7);
                View2D.this.setSelectedManipulable(particle);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(particle, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Particle");
        a.putValue("ShortDescription", "Insert a particle where the mouse last clicked");
        this.getActionMap().put("Insert Particle", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = ((View2D)View2D.this).mouseReleasedPoint.x > 0 ? View2D.this.convertPixelToPointX(((View2D)View2D.this).mouseReleasedPoint.x) : View2D.this.model.getLx() * 0.025f;
                float y = ((View2D)View2D.this).mouseReleasedPoint.y > 0 ? View2D.this.convertPixelToPointY(((View2D)View2D.this).mouseReleasedPoint.y) : View2D.this.model.getLy() * 0.05f;
                ParticleFeeder particleFeeder = View2D.this.addParticleFeeder(x, y);
                View2D.this.notifyManipulationListeners(particleFeeder, (byte)7);
                View2D.this.setSelectedManipulable(particleFeeder);
                View2D.this.undoManager.addEdit(new UndoAddManipulable(particleFeeder, View2D.this));
                View2D.this.repaint();
            }
        };
        a.putValue("Name", "Particle Feeder");
        a.putValue("ShortDescription", "Insert a particle feeder where the mouse last clicked");
        this.getActionMap().put("Insert Particle Feeder", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (View2D.this.undoManager.canUndo()) {
                    View2D.this.undoManager.undo();
                }
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(90, 4) : KeyStroke.getKeyStroke(90, 2);
        a.putValue("Name", "Undo");
        a.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Undo");
        this.getActionMap().put("Undo", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (View2D.this.undoManager.canRedo()) {
                    View2D.this.undoManager.redo();
                }
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(89, 4) : KeyStroke.getKeyStroke(89, 2);
        a.putValue("Name", "Redo");
        a.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Redo");
        this.getActionMap().put("Redo", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.zoom(0.5f);
                View2D.this.undoManager.addEdit(new UndoZoom(View2D.this, 0.5f));
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(61, 4) : KeyStroke.getKeyStroke(61, 2);
        a.putValue("Name", "Zoom In");
        a.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Zoom In");
        this.getActionMap().put("Zoom In", a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.zoom(2.0f);
                View2D.this.undoManager.addEdit(new UndoZoom(View2D.this, 2.0f));
            }
        };
        ks = IS_MAC ? KeyStroke.getKeyStroke(45, 4) : KeyStroke.getKeyStroke(45, 2);
        a.putValue("Name", "Zoom Out");
        a.putValue("AcceleratorKey", ks);
        this.getInputMap().put(ks, "Zoom Out");
        this.getActionMap().put("Zoom Out", a);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void addUndoableEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
    }

    public void setMouseReadType(byte mouseReadType) {
        this.mouseReadType = mouseReadType;
    }

    public byte getMouseReadType() {
        return this.mouseReadType;
    }

    public void setHeatMapType(byte heatMapType) {
        this.heatMapType = heatMapType;
        switch (heatMapType) {
            case 0: {
                this.lightColor = new Color(0, 0, 0, 128);
                break;
            }
            case 1: {
                this.lightColor = new Color(255, 255, 255, 128);
                break;
            }
            case 2: {
                this.lightColor = new Color(255, 255, 255, 128);
            }
        }
    }

    public byte getHeatMapType() {
        return this.heatMapType;
    }

    public void setColorPaletteType(byte colorPaletteType) {
        this.colorPaletteType = colorPaletteType;
        this.temperatureRenderer = new ScalarDistributionRenderer(ColorPalette.getRgbArray(colorPaletteType), this.temperatureRenderer == null ? 0.0f : this.temperatureRenderer.getMinimum(), this.temperatureRenderer == null ? 40.0f : this.temperatureRenderer.getMaximum());
        this.thermalEnergyRenderer = new ScalarDistributionRenderer(ColorPalette.getRgbArray(colorPaletteType), this.thermalEnergyRenderer == null ? 0.0f : this.thermalEnergyRenderer.getMinimum(), this.thermalEnergyRenderer == null ? 40.0f : this.thermalEnergyRenderer.getMaximum());
        this.colorPalette = new ColorPalette(ColorPalette.getRgbArray(colorPaletteType));
    }

    public byte getColorPaletteType() {
        return this.colorPaletteType;
    }

    public void setActionMode(byte mode) {
        this.resetMousePoints();
        this.setSelectedManipulable(null);
        this.actionMode = mode;
        switch (mode) {
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.modeIcon == null) break;
                this.modeIcon.setPressed(false);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 21: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.model.refreshTemperatureBoundaryArray();
                this.model.refreshMaterialPropertyArrays();
                if (this.modeIcon == null) break;
                this.modeIcon.setPressed(true);
            }
        }
        this.repaint();
    }

    public byte getActionMode() {
        return this.actionMode;
    }

    public void setGraphDataType(byte dataType) {
        this.graphRenderer.setDataType(dataType);
    }

    public byte getGraphDataType() {
        return this.graphRenderer.getDataType();
    }

    public void setGraphTimeUnit(byte timeUnit) {
        this.graphRenderer.setTimeUnit(timeUnit);
    }

    public byte getGraphTimeUnit() {
        return this.graphRenderer.getTimeUnit();
    }

    public void setTemperatureIncrement(float temperatureIncrement) {
        this.temperatureIncrement = temperatureIncrement;
    }

    public float getTemperatureIncrement() {
        return this.temperatureIncrement;
    }

    public void clear() {
        this.setSelectedManipulable(null);
        this.textBoxes.clear();
        if (this.pictures != null) {
            this.pictures.clear();
        }
        this.selectedSpot = -1;
        this.hideHandles();
    }

    public void hideHandles() {
        Rectangle[] rectangleArray = this.handle;
        int n = this.handle.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle h = rectangleArray[n2];
            h.y = 0;
            h.x = 0;
            ++n2;
        }
    }

    public void addTextBox(TextBox t) {
        this.textBoxes.add(t);
        this.repaint();
    }

    public void addTextBox(TextBox t, int index) {
        this.textBoxes.add(index, t);
        this.repaint();
    }

    public void removeTextBox(TextBox t) {
        this.textBoxes.remove(t);
        this.repaint();
    }

    public TextBox addText(String text, float x, float y) {
        TextBox t = new TextBox(new Rectangle2D.Float(), text, x, y);
        this.addTextBox(t);
        return t;
    }

    public List<TextBox> getTextBoxes() {
        return this.textBoxes;
    }

    public int getTextBoxCount() {
        return this.textBoxes.size();
    }

    public TextBox getTextBox(int i) {
        if (i < 0 || i >= this.textBoxes.size()) {
            return null;
        }
        return this.textBoxes.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextBox getTextBoxByUid(String uid) {
        if (uid == null) {
            return null;
        }
        List<TextBox> list = this.textBoxes;
        synchronized (list) {
            for (TextBox t : this.textBoxes) {
                if (!uid.equals(t.getUid())) continue;
                return t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUidUsed(String uid) {
        if (uid == null) throw new IllegalArgumentException("UID cannot be null or an empty string.");
        if (uid.trim().equals("")) {
            throw new IllegalArgumentException("UID cannot be null or an empty string.");
        }
        List<TextBox> list = this.textBoxes;
        synchronized (list) {
            TextBox t;
            Iterator<TextBox> iterator = this.textBoxes.iterator();
            do {
                if (iterator.hasNext()) continue;
                return this.model.isUidUsed(uid);
            } while (!uid.equals((t = iterator.next()).getUid()));
            return true;
        }
    }

    public void addPicture(Icon image, int x, int y) {
        if (this.pictures == null) {
            this.pictures = new ArrayList<Picture>();
        }
        this.pictures.add(new Picture(image, x, y));
    }

    public int getPictureCount() {
        if (this.pictures == null) {
            return 0;
        }
        return this.pictures.size();
    }

    public Picture getPicture(int i) {
        if (this.pictures == null) {
            return null;
        }
        if (i < 0 || i >= this.pictures.size()) {
            return null;
        }
        return this.pictures.get(i);
    }

    public Fan addFan(float x, float y, float w, float h) {
        Fan f = new Fan(new Rectangle2D.Float(x, y, w, h));
        this.model.addFan(f);
        return f;
    }

    public void removeFan(Fan f) {
        this.model.removeFan(f);
        this.repaint();
    }

    public Heliostat addHeliostat(float x, float y, float w, float h) {
        Heliostat f = new Heliostat(new Rectangle2D.Float(x, y, w, h), this.model);
        this.model.addHeliostat(f);
        return f;
    }

    public void removeHeliostat(Heliostat h) {
        this.model.removeHeliostat(h);
        this.repaint();
    }

    public Cloud addCloud(float x, float y, float w, float h, float speed) {
        Cloud c = new Cloud(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        c.setX(x);
        c.setY(y);
        c.setSpeed(speed);
        this.model.addCloud(c);
        return c;
    }

    public void removeCloud(Cloud c) {
        this.model.removeCloud(c);
        this.repaint();
    }

    public Tree addTree(float x, float y, float w, float h, byte type) {
        Tree t = new Tree(new Rectangle2D.Float(0.0f, 0.0f, w, h), type);
        t.setX(x);
        t.setY(y);
        this.model.addTree(t);
        return t;
    }

    public void removeTree(Tree t) {
        this.model.removeTree(t);
        this.repaint();
    }

    public Particle addParticle(float x, float y) {
        Particle p = new Particle(x, y);
        this.model.addParticle(p);
        return p;
    }

    public ParticleFeeder addParticleFeeder(float x, float y) {
        ParticleFeeder p = new ParticleFeeder(x, y);
        this.model.addParticleFeeder(p);
        return p;
    }

    public void removeParticleFeeder(ParticleFeeder f) {
        this.model.removeParticleFeeder(f);
        this.repaint();
    }

    public void addManipulationListener(ManipulationListener l) {
        if (!this.manipulationListeners.contains(l)) {
            this.manipulationListeners.add(l);
        }
    }

    public void removeManipulationListener(ManipulationListener l) {
        this.manipulationListeners.remove(l);
    }

    public void notifyManipulationListeners(Manipulable m, byte type) {
        if (this.manipulationListeners.isEmpty()) {
            return;
        }
        ManipulationEvent e = new ManipulationEvent(this, m, type);
        for (ManipulationListener l : this.manipulationListeners) {
            l.manipulationOccured(e);
        }
    }

    public void addGraphListener(GraphListener l) {
        if (!this.graphListeners.contains(l)) {
            this.graphListeners.add(l);
        }
    }

    public void removeGraphListener(GraphListener l) {
        this.graphListeners.remove(l);
    }

    public void notifyGraphListeners(byte eventType) {
        if (this.graphListeners.isEmpty()) {
            return;
        }
        GraphEvent e = new GraphEvent(this);
        for (GraphListener l : this.graphListeners) {
            switch (eventType) {
                case 1: {
                    l.graphClosed(e);
                    break;
                }
                case 0: {
                    l.graphOpened(e);
                }
            }
        }
    }

    public void setModel(Model2D model) {
        this.model = model;
        this.nx = model.getTemperature().length;
        this.ny = model.getTemperature()[0].length;
    }

    public Model2D getModel() {
        return this.model;
    }

    public void reset() {
        this.runToggle = false;
        if (this.startIcon != null) {
            this.startIcon.setPressed(false);
        }
        this.setSelectedManipulable(null);
        this.setTime(0.0f);
        if (this.graphRenderer.getDataType() == 0) {
            this.graphRenderer.setYmin(this.getMinimumTemperature());
            this.graphRenderer.setYmax(this.getMaximumTemperature());
        }
        this.setActionMode((byte)0);
        if (this.modeIcon != null) {
            this.modeIcon.setPressed(false);
        }
        if (this.showViewFactorLines) {
            this.model.generateViewFactorMesh();
        }
    }

    public void setRunToggle(boolean b) {
        this.runToggle = b;
        if (this.startIcon != null) {
            this.startIcon.setPressed(this.runToggle);
        }
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setFahrenheitUsed(boolean b) {
        this.fahrenheitUsed = b;
    }

    public boolean getFahrenheitUsed() {
        return this.fahrenheitUsed;
    }

    public void setControlPanelVisible(boolean b) {
        if (b) {
            if (this.startIcon == null) {
                this.startIcon = new Symbol.StartIcon(Color.WHITE, 32, 32);
                this.startIcon.setStroke(moderateStroke);
                this.startIcon.setBorderPainted(true);
            }
            if (this.resetIcon == null) {
                this.resetIcon = new Symbol.ResetIcon(Color.WHITE, 32, 32);
                this.resetIcon.setStroke(moderateStroke);
                this.resetIcon.setBorderPainted(true);
            }
            if (this.graphIcon == null) {
                this.graphIcon = new Symbol.GraphIcon(Color.WHITE, 32, 32);
                this.graphIcon.setStroke(moderateStroke);
                this.graphIcon.setBorderPainted(true);
            }
            if (this.nextIcon == null) {
                this.nextIcon = new Symbol.NextIcon(Color.WHITE, 32, 32);
                this.nextIcon.setStroke(moderateStroke);
                this.nextIcon.setBorderPainted(true);
            }
            if (this.prevIcon == null) {
                this.prevIcon = new Symbol.PrevIcon(Color.WHITE, 32, 32);
                this.prevIcon.setStroke(moderateStroke);
                this.prevIcon.setBorderPainted(true);
            }
            if (this.modeIcon == null) {
                this.modeIcon = new Symbol.ModeIcon(Color.WHITE, 32, 32);
                this.modeIcon.setStroke(moderateStroke);
                this.modeIcon.setBorderPainted(true);
            }
            if (this.switchIcon == null) {
                this.switchIcon = new Symbol.SwitchIcon(Color.WHITE, 32, 32);
                this.switchIcon.setStroke(moderateStroke);
                this.switchIcon.setBorderPainted(true);
            }
        }
        this.showControlPanel = b;
    }

    public boolean isControlPanelVisible() {
        return this.showControlPanel;
    }

    public void setFrankOn(boolean b) {
        this.frankOn = b;
    }

    public boolean isFrankOn() {
        return this.frankOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewFactorLinesOn(boolean b) {
        if (b) {
            List<Part> parts;
            List<Part> list = parts = this.model.getParts();
            synchronized (list) {
                for (Part p : parts) {
                    Polygon2D r;
                    int n;
                    Shape shape = p.getShape();
                    if (!(shape instanceof Polygon2D) || (n = (r = (Polygon2D)shape).getVertexCount()) <= 50) continue;
                    if (JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this), "This model has many points. Radiation calculation can be very slow. Do you want to continue?", "Too Many Points", 0, 2) != 1) break;
                    return;
                }
            }
            this.model.generateViewFactorMesh();
        }
        this.showViewFactorLines = b;
    }

    public boolean isViewFactorLinesOn() {
        return this.showViewFactorLines;
    }

    public void setBorderTickmarksOn(boolean b) {
        TickmarksRenderer tickmarksRenderer = this.borderTickmarksRenderer = b ? new TickmarksRenderer() : null;
        if (b) {
            this.borderTickmarksRenderer.setSize(this.xmin, this.xmax, this.ymin, this.ymax);
        }
    }

    public boolean isBorderTickmarksOn() {
        return this.borderTickmarksRenderer != null;
    }

    public void setGridOn(boolean b) {
        this.showGrid = b;
        if (b && this.gridRenderer == null) {
            this.gridRenderer = new GridRenderer(this.nx, this.ny);
        }
    }

    public boolean isGridOn() {
        return this.showGrid;
    }

    public void setSnapToGrid(boolean b) {
        this.snapToGrid = b;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setGridSize(int gridSize) {
        if (this.gridRenderer == null) {
            this.gridRenderer = new GridRenderer(this.nx, this.ny);
        }
        this.gridRenderer.setGridSize(gridSize);
    }

    public int getGridSize() {
        if (this.gridRenderer == null) {
            return 10;
        }
        return this.gridRenderer.getGridSize();
    }

    public void setFanRotationSpeedScaleFactor(float fanRotationSpeedScaleFactor) {
        this.fanRotationSpeedScaleFactor = fanRotationSpeedScaleFactor;
    }

    public float getFanRotationSpeedScaleFactor() {
        return this.fanRotationSpeedScaleFactor;
    }

    public void setColorPaletteOn(boolean b) {
        this.showColorPalette = b;
    }

    public boolean isColorPaletteOn() {
        return this.showColorPalette;
    }

    public void setColorPaletteRectangle(float rx, float ry, float rw, float rh) {
        this.colorPalette.setRect(rx, ry, rw, rh);
    }

    public Rectangle2D.Float getColorPaletteRectangle() {
        return this.colorPalette.getRect();
    }

    public Color getTemperatureColor(float value) {
        return new Color(this.temperatureRenderer.getColor(value));
    }

    public void setGraphOn(boolean b) {
        if (b && !this.model.hasSensor()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(View2D.this, "No graph can be shown because there is no virtual sensor.");
                }
            });
            this.notifyManipulationListeners(null, (byte)16);
            return;
        }
        this.showGraph = b;
        if (this.graphIcon != null) {
            this.graphIcon.setPressed(this.showGraph);
        }
    }

    public boolean isGraphOn() {
        return this.showGraph;
    }

    public void setGraphXLabel(String xLabel) {
        this.graphRenderer.setLabelX(xLabel);
    }

    public String getGraphXLabel() {
        return this.graphRenderer.getLabelX();
    }

    public void setGraphYLabel(String yLabel) {
        this.graphRenderer.setLabelY(yLabel);
    }

    public String getGraphYLabel() {
        return this.graphRenderer.getLabelY();
    }

    public void setGraphYmin(float ymin) {
        this.graphRenderer.setYmin(ymin);
    }

    public float getGraphYmin() {
        return this.graphRenderer.getYmin();
    }

    public void setGraphYmax(float ymax) {
        this.graphRenderer.setYmax(ymax);
    }

    public float getGraphYmax() {
        return this.graphRenderer.getYmax();
    }

    public void setVectorStroke(BasicStroke s) {
        if (this.vectorFieldRenderer == null) {
            this.vectorFieldRenderer = new VectorRenderer(this, this.nx, this.ny);
        }
        this.vectorFieldRenderer.setStroke(s);
    }

    public void setVelocityOn(boolean b) {
        this.showVelocity = b;
        if (b && this.vectorFieldRenderer == null) {
            this.vectorFieldRenderer = new VectorRenderer(this, this.nx, this.ny);
        }
    }

    public boolean isVelocityOn() {
        return this.showVelocity;
    }

    public void setHeatFluxArrowsOn(boolean b) {
        this.showHeatFluxArrows = b;
        if (b && this.vectorFieldRenderer == null) {
            this.vectorFieldRenderer = new VectorRenderer(this, this.nx, this.ny);
        }
    }

    public boolean isHeatFluxArrowsOn() {
        return this.showHeatFluxArrows;
    }

    public void setHeatFluxArrowMinimum(float minSquare) {
        this.heatFluxMinimumValueSquare = minSquare;
    }

    public void setHeatFluxScale(float scale) {
        this.heatFluxScale = scale;
    }

    public void setDotForZeroHeatFlux(boolean b) {
        this.dotForZeroHeatFlux = b;
    }

    public void setHeatFluxLinesOn(boolean b) {
        this.showHeatFluxLines = b;
        if (b && this.heatFluxLines == null) {
            this.heatFluxLines = new FieldLines();
        }
    }

    public boolean isHeatFluxLinesOn() {
        return this.showHeatFluxLines;
    }

    public void setVectorFieldSpacing(int spacing) {
        if (this.vectorFieldRenderer == null) {
            this.vectorFieldRenderer = new VectorRenderer(this, this.nx, this.ny);
        }
        this.vectorFieldRenderer.setSpacing(spacing);
    }

    public int getVectorFieldSpacing() {
        if (this.vectorFieldRenderer == null) {
            return 5;
        }
        return this.vectorFieldRenderer.getSpacing();
    }

    public void setStreamlineOn(boolean b) {
        this.showStreamLines = b;
        if (b && this.streamlines == null) {
            this.streamlines = new FieldLines();
            this.streamlines.setColor(Color.white);
        }
    }

    public FieldLines getStreamlines() {
        if (this.streamlines == null) {
            this.streamlines = new FieldLines();
        }
        return this.streamlines;
    }

    public boolean isStreamlineOn() {
        return this.showStreamLines;
    }

    public void setIsothermOn(boolean b) {
        this.showIsotherm = b;
        if (b) {
            if (this.isotherms == null) {
                this.isotherms = new ContourMap();
            }
        } else {
            this.isotherms = null;
        }
    }

    public boolean isIsothermOn() {
        return this.showIsotherm;
    }

    public void setIsothermResolution(float resolution) {
        if (this.isotherms != null) {
            this.isotherms.setResolution(resolution);
        }
    }

    public float getIsothermResolution() {
        if (this.isotherms == null) {
            return 5.0f;
        }
        return this.isotherms.getResolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeeThrough(boolean b) {
        List<Part> parts;
        List<Part> list = parts = this.model.getParts();
        synchronized (list) {
            for (Part p : parts) {
                p.setFilled(!b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSeeThrough() {
        List<Part> parts;
        if (this.model.getPartCount() == 0) {
            return false;
        }
        List<Part> list = parts = this.model.getParts();
        synchronized (list) {
            Part p;
            Iterator<Part> iterator = parts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(p = iterator.next()).isFilled());
            return false;
        }
    }

    public void setClockOn(boolean b) {
        this.clockOn = b;
    }

    public boolean isClockOn() {
        return this.clockOn;
    }

    public void setSmooth(boolean smooth) {
        this.temperatureRenderer.setSmooth(smooth);
    }

    public boolean isSmooth() {
        return this.temperatureRenderer.isSmooth();
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void setSensorReadingFont(Font font) {
        this.sensorReadingFont = font;
    }

    public void setMinimumTemperature(float min) {
        this.temperatureRenderer.setMinimum(min);
        this.thermalEnergyRenderer.setMinimum(min);
        if (this.getGraphDataType() == 0) {
            this.graphRenderer.setYmin(min);
        }
    }

    public float getMinimumTemperature() {
        return this.temperatureRenderer.getMinimum();
    }

    public void setMaximumTemperature(float max) {
        this.temperatureRenderer.setMaximum(max);
        this.thermalEnergyRenderer.setMaximum(max);
        if (this.getGraphDataType() == 0) {
            this.graphRenderer.setYmax(max);
        }
    }

    public float getMaximumTemperature() {
        return this.temperatureRenderer.getMaximum();
    }

    public float getBackgroundTemperature() {
        return this.model.getBackgroundTemperature();
    }

    public JPopupMenu getPopupMenu() {
        return this.modelPopupMenu;
    }

    private void cut() {
        if (this.selectedManipulable != null) {
            this.copiedManipulable = this.selectedManipulable;
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the selected object?", "Delete Object", 0, 3) == 0) {
                this.undoManager.addEdit(new UndoRemoveManipulable(this));
                this.notifyManipulationListeners(this.selectedManipulable, (byte)0);
                this.setSelectedManipulable(null);
            }
        }
    }

    private void copy() {
        this.copiedManipulable = this.selectedManipulable;
    }

    private void paste() {
        float x = this.convertPixelToPointX(this.mouseReleasedPoint.x);
        float y = this.convertPixelToPointY(this.mouseReleasedPoint.y);
        Manipulable pastedManipulable = null;
        if (this.copiedManipulable instanceof Part) {
            pastedManipulable = ((Part)this.copiedManipulable).duplicate(x, y);
            this.model.addPart((Part)pastedManipulable);
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.setInitialTemperature();
        } else if (this.copiedManipulable instanceof Fan) {
            pastedManipulable = ((Fan)this.copiedManipulable).duplicate(x, y);
            this.model.addFan((Fan)pastedManipulable);
            this.model.refreshMaterialPropertyArrays();
        } else if (this.copiedManipulable instanceof Heliostat) {
            pastedManipulable = ((Heliostat)this.copiedManipulable).duplicate(x, y);
            this.model.addHeliostat((Heliostat)pastedManipulable);
        } else if (this.copiedManipulable instanceof Particle) {
            pastedManipulable = ((Particle)this.copiedManipulable).duplicate(x, y);
            this.model.addParticle((Particle)pastedManipulable);
        } else if (this.copiedManipulable instanceof Thermometer) {
            pastedManipulable = this.addThermometer(x, y);
        } else if (this.copiedManipulable instanceof HeatFluxSensor) {
            pastedManipulable = this.addHeatFluxSensor(x, y);
            ((HeatFluxSensor)pastedManipulable).setAngle(((HeatFluxSensor)this.copiedManipulable).getAngle());
        } else if (this.copiedManipulable instanceof Anemometer) {
            pastedManipulable = this.addAnemometer(x, y);
        } else if (this.copiedManipulable instanceof TextBox) {
            pastedManipulable = ((TextBox)this.copiedManipulable).duplicate(x, this.model.getLy() - y);
            this.addTextBox((TextBox)pastedManipulable);
        } else if (this.copiedManipulable instanceof Cloud) {
            pastedManipulable = ((Cloud)this.copiedManipulable).duplicate(x, y);
            this.model.addCloud((Cloud)pastedManipulable);
        } else if (this.copiedManipulable instanceof Tree) {
            pastedManipulable = ((Tree)this.copiedManipulable).duplicate(x, y);
            this.model.addTree((Tree)pastedManipulable);
        } else if (this.copiedManipulable instanceof ParticleFeeder) {
            pastedManipulable = ((ParticleFeeder)this.copiedManipulable).duplicate(x, y);
            this.model.addParticleFeeder((ParticleFeeder)pastedManipulable);
        }
        this.notifyManipulationListeners(pastedManipulable, (byte)3);
        this.undoManager.addEdit(new UndoPaste(pastedManipulable, this));
        this.repaint();
    }

    private void createModelPopupMenu() {
        if (this.modelPopupMenu != null) {
            return;
        }
        this.modelPopupMenu = new JPopupMenu();
        this.modelPopupMenu.setInvoker(this);
        this.modelPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean b = View2D.this.selectedManipulable != null;
                View2D.this.copyAction.setEnabled(b);
                View2D.this.cutAction.setEnabled(b);
                View2D.this.pasteAction.setEnabled(View2D.this.copiedManipulable != null);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.modelPopupMenu.add(this.copyAction);
        this.modelPopupMenu.add(this.cutAction);
        this.modelPopupMenu.add(this.pasteAction);
        this.modelPopupMenu.addSeparator();
        JMenuItem mi = new JMenuItem("Properties...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.createDialog(View2D.this.model, true);
            }
        });
        this.modelPopupMenu.add(mi);
        mi = new JMenuItem("View Options...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.createDialog(View2D.this, false);
            }
        });
        this.modelPopupMenu.add(mi);
        mi = new JMenuItem("View Data...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (View2D.this.dataViewer == null) {
                    View2D.this.dataViewer = new DataViewer(View2D.this);
                }
                if (View2D.this.selectedManipulable instanceof Sensor) {
                    View2D.this.dataViewer.showData((Sensor)View2D.this.selectedManipulable);
                } else {
                    View2D.this.dataViewer.showAllData();
                }
            }
        });
        this.modelPopupMenu.add(mi);
        mi = new JMenuItem("Task Manager...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a = View2D.this.getActionMap().get("Task_Manager");
                if (a != null) {
                    a.actionPerformed(e);
                }
            }
        });
        this.modelPopupMenu.add(mi);
        mi = new JMenuItem("Preferences...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a = View2D.this.getActionMap().get("Preferences");
                if (a != null) {
                    a.actionPerformed(e);
                }
            }
        });
        this.modelPopupMenu.add(mi);
        this.modelPopupMenu.addSeparator();
        JMenu subMenu = new JMenu("Help");
        this.modelPopupMenu.add(subMenu);
        mi = new JMenuItem("Script Console...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a = View2D.this.getActionMap().get("Script");
                if (a != null) {
                    a.actionPerformed(e);
                }
            }
        });
        subMenu.add(mi);
        mi = new JMenuItem("Keyboard Shortcuts...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.showKeyboardShortcuts(JOptionPane.getFrameForComponent(View2D.this));
            }
        });
        subMenu.add(mi);
        mi = new JMenuItem("About...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Helper.showAbout(JOptionPane.getFrameForComponent(View2D.this));
            }
        });
        subMenu.add(mi);
    }

    private void createPartPopupMenu() {
        if (this.partPopupMenu != null) {
            if (this.selectedManipulable instanceof Part) {
                this.partPopupMenu.add(this.partViewOptionsMenuItem);
            } else {
                this.partPopupMenu.remove(this.partViewOptionsMenuItem);
            }
            return;
        }
        this.partPopupMenu = new JPopupMenu();
        this.partPopupMenu.setInvoker(this);
        this.partPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean b = View2D.this.selectedManipulable != null;
                View2D.this.copyAction.setEnabled(b);
                View2D.this.cutAction.setEnabled(b);
                View2D.this.pasteAction.setEnabled(View2D.this.copiedManipulable != null);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.partPopupMenu.add(this.copyAction);
        this.partPopupMenu.add(this.cutAction);
        this.partPopupMenu.add(this.pasteAction);
        this.partPopupMenu.addSeparator();
        JMenuItem mi = new JMenuItem("Properties...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.createDialog(View2D.this.selectedManipulable, true);
            }
        });
        this.partPopupMenu.add(mi);
        this.partViewOptionsMenuItem = new JMenuItem("View Options...");
        this.partViewOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2D.this.createDialog(View2D.this.selectedManipulable, false);
            }
        });
        if (this.selectedManipulable instanceof Part) {
            this.partPopupMenu.add(this.partViewOptionsMenuItem);
        }
    }

    public void createDialog(Object o, boolean forModel) {
        JDialog d;
        JDialog jDialog = d = forModel ? this.dialogFactory.createModelDialog(o) : this.dialogFactory.createViewDialog(o);
        if (d != null) {
            d.setVisible(true);
        }
    }

    public void setArea(float xmin, float xmax, float ymin, float ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        if (this.borderTickmarksRenderer != null) {
            this.borderTickmarksRenderer.setSize(xmin, xmax, ymin, ymax);
        }
    }

    private Graphics2D createGraphics2D() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.bimg == null || this.bimg.getWidth() != w || this.bimg.getHeight() != h) {
            this.bimg = (BufferedImage)this.createImage(w, h);
        }
        Graphics2D g = this.bimg.createGraphics();
        g.setBackground(this.getBackground());
        g.clearRect(0, 0, w, h);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = this.createGraphics2D();
        this.draw(g2);
        g2.dispose();
        if (this.bimg != null) {
            g.drawImage(this.bimg, 0, 0, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(Graphics2D g) {
        boolean noFatalError = !this.model.fatalErrorOccurred();
        int w = this.getWidth();
        int h = this.getHeight();
        Stroke stroke = g.getStroke();
        if (noFatalError) {
            this.setErrorMessage(null);
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
            switch (this.heatMapType) {
                case 1: {
                    this.drawTemperatureField(g);
                    break;
                }
                case 2: {
                    this.drawThermalEnergyField(g);
                }
            }
        } else {
            this.setErrorMessage("FATAL ERROR!");
            g.setColor(Color.black);
            g.fillRect(0, 0, w, h);
        }
        this.drawParts(g);
        this.drawFans(g);
        this.drawHeliostats(g);
        this.drawClouds(g);
        this.drawTrees(g);
        this.drawTextBoxes(g);
        this.drawPictures(g);
        this.drawParticles(g);
        this.drawParticleFeeders(g);
        if (this.showViewFactorLines) {
            this.drawViewFactorMesh(g);
        }
        if (this.showGrid && this.gridRenderer != null) {
            this.gridRenderer.render(this, g);
        }
        if (this.borderTickmarksRenderer != null) {
            this.borderTickmarksRenderer.render(this, g);
        }
        if (this.showColorPalette && this.heatMapType != 0) {
            this.colorPalette.setUseFahrenheit(this.fahrenheitUsed);
            g.setStroke(thinStroke);
            switch (this.heatMapType) {
                case 1: {
                    this.colorPalette.render(this, g, this.temperatureRenderer.getMaximum(), this.temperatureRenderer.getMinimum());
                    break;
                }
                case 2: {
                    this.colorPalette.render(this, g, this.thermalEnergyRenderer.getMaximum(), this.thermalEnergyRenderer.getMinimum());
                }
            }
        }
        if (noFatalError) {
            if (this.isotherms != null) {
                g.setStroke(thinStroke);
                this.isotherms.render(g, this.getSize(), this.model.getTemperature());
            }
            if (this.showStreamLines && this.streamlines != null) {
                g.setStroke(thinStroke);
                this.streamlines.render(g, this.getSize(), this.model.getXVelocity(), this.model.getYVelocity());
            }
            if (this.showHeatFluxLines && this.heatFluxLines != null) {
                g.setStroke(thinStroke);
                this.heatFluxLines.render(g, this.getSize(), this.model.getTemperature(), -1);
            }
            if (this.showVelocity) {
                this.vectorFieldRenderer.renderVectors(this.model.getXVelocity(), this.model.getYVelocity(), this, g);
            }
            if (this.showHeatFluxArrows) {
                this.vectorFieldRenderer.renderHeatFlux(this.model.getTemperature(), this.model.getConductivity(), this, g, this.heatFluxScale, this.heatFluxMinimumValueSquare, this.dotForZeroHeatFlux);
            }
        }
        if (this.selectedManipulable != null) {
            int wa;
            int yt;
            int xt;
            int wt;
            if (this.selectedManipulable instanceof Thermometer) {
                Thermometer t = (Thermometer)this.selectedManipulable;
                Rectangle2D.Float r = (Rectangle2D.Float)t.getShape();
                wt = this.convertLengthToPixelX(r.width);
                int ht = this.convertLengthToPixelY(r.height);
                xt = this.convertPointToPixelX(t.getX()) - wt / 2;
                yt = this.convertPointToPixelY(t.getY()) - ht / 2;
                g.setColor(Color.yellow);
                g.fillRect(xt - 3, yt - 3, wt + 7, ht + 7);
            } else if (this.selectedManipulable instanceof HeatFluxSensor) {
                HeatFluxSensor f = (HeatFluxSensor)this.selectedManipulable;
                Rectangle2D.Float r = (Rectangle2D.Float)f.getShape();
                wt = this.convertLengthToPixelX(r.width);
                int ht = this.convertLengthToPixelY(r.height);
                xt = this.convertPointToPixelX(f.getX()) - wt / 2;
                yt = this.convertPointToPixelY(f.getY()) - ht / 2;
                g.setColor(Color.yellow);
                if (f.getAngle() != 0.0f) {
                    g.rotate(f.getAngle(), xt + wt / 2, yt + ht / 2);
                }
                g.fillRect(xt - 3, yt - 3, wt + 5, ht + 5);
                if (f.getAngle() != 0.0f) {
                    g.rotate(-f.getAngle(), xt + wt / 2, yt + ht / 2);
                }
            } else if (this.selectedManipulable instanceof Anemometer) {
                Anemometer a = (Anemometer)this.selectedManipulable;
                Rectangle2D.Float r = (Rectangle2D.Float)a.getShape();
                wa = this.convertLengthToPixelX(r.width);
                int ha = this.convertLengthToPixelY(r.height);
                int xa = this.convertPointToPixelX(a.getX()) - wa / 2;
                int ya = this.convertPointToPixelY(a.getY()) - ha / 2;
                g.setColor(Color.yellow);
                g.setStroke(dashed);
                g.drawRect(xa - 2, ya - 2, wa + 4, ha + 4);
            } else if (!(this.selectedManipulable instanceof TextBox)) {
                g.setStroke(thinStroke);
                Rectangle[] ha = this.handle;
                wa = this.handle.length;
                int r = 0;
                while (r < wa) {
                    Rectangle r2 = ha[r];
                    if (r2.x != 0 || r2.y != 0) {
                        g.setColor(Color.yellow);
                        g.fill(r2);
                        g.setColor(Color.black);
                        g.draw(r2);
                    }
                    ++r;
                }
            }
        }
        if (this.mouseBeingDragged && this.movingShape != null) {
            g.setColor(Color.white);
            g.setStroke(dashed);
            if (this.selectedManipulable instanceof HeatFluxSensor) {
                float angle = ((HeatFluxSensor)this.selectedManipulable).getAngle();
                Rectangle r = this.movingShape.getShape().getBounds();
                g.rotate(angle, r.x + r.width / 2, r.y + r.height / 2);
                this.movingShape.render(g);
                g.rotate(-angle, r.x + r.width / 2, r.y + r.height / 2);
            } else {
                this.movingShape.render(g);
            }
        }
        this.drawPhotons(g);
        this.showSunOrMoon(g);
        this.drawThermometers(g);
        this.drawHeatFluxSensors(g);
        this.drawAnemometers(g);
        if (this.showGraph) {
            this.graphRenderer.drawFrame(g);
            if (this.model.getTime() > this.graphRenderer.getXmax()) {
                this.graphRenderer.doubleXmax();
            }
            switch (this.graphRenderer.getDataType()) {
                case 0: {
                    if (this.model.getThermometers().isEmpty()) break;
                    List<Thermometer> angle = this.model.getThermometers();
                    synchronized (angle) {
                        for (Thermometer t : this.model.getThermometers()) {
                            if (t.getCurrentData() > this.graphRenderer.getYmax()) {
                                this.graphRenderer.increaseYmax();
                            } else if (t.getCurrentData() < this.graphRenderer.getYmin()) {
                                this.graphRenderer.decreaseYmin();
                            }
                            this.graphRenderer.drawData(g, t.getData(), t.getLabel(), this.selectedManipulable == t);
                        }
                        break;
                    }
                }
                case 1: {
                    if (this.model.getHeatFluxSensors().isEmpty()) break;
                    List<HeatFluxSensor> angle = this.model.getHeatFluxSensors();
                    synchronized (angle) {
                        for (HeatFluxSensor f : this.model.getHeatFluxSensors()) {
                            if (f.getCurrentData() > this.graphRenderer.getYmax()) {
                                this.graphRenderer.increaseYmax();
                            } else if (f.getCurrentData() < this.graphRenderer.getYmin()) {
                                this.graphRenderer.decreaseYmin();
                            }
                            this.graphRenderer.drawData(g, f.getData(), f.getLabel(), this.selectedManipulable == f);
                        }
                        break;
                    }
                }
                case 2: {
                    if (this.model.getAnemometers().isEmpty()) break;
                    List<Anemometer> angle = this.model.getAnemometers();
                    synchronized (angle) {
                        for (Anemometer a : this.model.getAnemometers()) {
                            if (a.getCurrentData() > this.graphRenderer.getYmax()) {
                                this.graphRenderer.increaseYmax();
                            } else if (a.getCurrentData() < this.graphRenderer.getYmin()) {
                                this.graphRenderer.decreaseYmin();
                            }
                            this.graphRenderer.drawData(g, a.getData(), a.getLabel(), this.selectedManipulable == a);
                        }
                        break;
                    }
                }
            }
        }
        if (this.clockOn) {
            g.setFont(this.smallFont);
            g.setColor(this.getContrastColor(w - 68, 16));
            g.drawString(MiscUtil.formatTime((int)this.time), w - 68, 16);
        }
        g.setStroke(dashed);
        switch (this.actionMode) {
            case 1: {
                g.setColor(TRANSLUCENT_GRAY);
                g.fill(this.rectangle);
                g.setColor(Color.WHITE);
                g.draw(this.rectangle);
                break;
            }
            case 2: {
                g.setColor(TRANSLUCENT_GRAY);
                g.fill(this.ellipse);
                g.setColor(Color.WHITE);
                g.draw(this.ellipse);
                break;
            }
            case 3: {
                g.setColor(TRANSLUCENT_GRAY);
                g.fill(this.polygon);
                g.setColor(Color.WHITE);
                g.draw(this.polygon);
                if (this.mouseMovedPoint.x < 0 || this.mouseMovedPoint.y < 0 || this.mouseReleasedPoint.x < 0 || this.mouseReleasedPoint.y < 0) break;
                g.setColor(Color.GREEN);
                g.drawLine(this.mouseMovedPoint.x, this.mouseMovedPoint.y, this.mouseReleasedPoint.x, this.mouseReleasedPoint.y);
                int np = this.polygon.npoints;
                if (np <= 1) break;
                double dx = this.polygon.xpoints[0] - this.mouseMovedPoint.x;
                double dy = this.polygon.ypoints[0] - this.mouseMovedPoint.y;
                double distance = Math.hypot(dx, dy);
                int n = (int)Math.round(distance * 0.1);
                dx /= (double)n;
                dy /= (double)n;
                int i = 0;
                while (i < n + 1) {
                    g.fillOval((int)((double)this.mouseMovedPoint.x + dx * (double)i), (int)((double)this.mouseMovedPoint.y + dy * (double)i), 2, 2);
                    ++i;
                }
                break;
            }
            case 4: {
                if (this.mouseMovedPoint.x >= 0 && this.mouseMovedPoint.y >= 0 && this.mouseReleasedPoint.x >= 0 && this.mouseReleasedPoint.y >= 0) {
                    if (this.polygon.npoints == 1) {
                        g.setColor(Color.WHITE);
                        g.drawLine(this.mouseMovedPoint.x, this.mouseMovedPoint.y, this.polygon.xpoints[0], this.polygon.ypoints[0]);
                    } else if (this.polygon.npoints >= 2) {
                        boolean tooClose = false;
                        int i = 0;
                        while (i < this.polygon.npoints) {
                            if (this.mouseMovedPoint.distanceSq(this.polygon.xpoints[i], this.polygon.ypoints[i]) < 100.0) {
                                tooClose = true;
                                break;
                            }
                            ++i;
                        }
                        if (tooClose) {
                            if (this.polygon.npoints >= 3) {
                                this.drawBlobFromPolygon(g, this.polygon);
                            }
                        } else {
                            Polygon p2 = new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
                            p2.addPoint(this.mouseMovedPoint.x, this.mouseMovedPoint.y);
                            this.drawBlobFromPolygon(g, p2);
                        }
                    }
                } else if (this.polygon.npoints >= 3) {
                    this.drawBlobFromPolygon(g, this.polygon);
                }
                g.setColor(Color.YELLOW);
                int i = 0;
                while (i < this.polygon.npoints) {
                    g.fillOval(this.polygon.xpoints[i] - 2, this.polygon.ypoints[i] - 2, 4, 4);
                    ++i;
                }
                break;
            }
        }
        if (!this.model.getThermostats().isEmpty()) {
            for (Thermostat t : this.model.getThermostats()) {
                this.thermostatRenderer.render(t, this, g);
            }
        }
        g.setStroke(stroke);
        if (this.frankOn) {
            this.brand.setColor(this.heatMapType != 0 ? Color.lightGray : Color.black);
            this.brand.paintIcon(this, g, this.getWidth() - 84, this.getHeight() - (this.borderTickmarksRenderer != null ? 30 : 15));
        }
        if (this.showControlPanel) {
            this.drawControlPanel(g, this.getWidth() / 2, this.getHeight() - (this.borderTickmarksRenderer != null ? 50 : 36));
        }
        if ((this.actionMode == 0 || this.actionMode == 21) && this.mouseMovedPoint.x >= 0 && this.mouseMovedPoint.y >= 0 && this.mouseMovedPoint.x < this.getWidth() && this.mouseMovedPoint.y < this.getHeight()) {
            Symbol controlButton = this.overWhichButton(this.mouseMovedPoint.x, this.mouseMovedPoint.y);
            if (controlButton != null) {
                if (controlButton == this.startIcon) {
                    this.drawButtonInfo(g, this.startIcon.isPressed() ? "Pause" : "Run", this.startIcon);
                } else if (controlButton == this.resetIcon) {
                    this.drawButtonInfo(g, "Reset", this.resetIcon);
                } else if (controlButton == this.graphIcon) {
                    this.drawButtonInfo(g, this.graphIcon.isPressed() ? "Close graph" : "Open graph", this.graphIcon);
                } else if (controlButton == this.nextIcon && !this.nextIcon.isDisabled()) {
                    this.drawButtonInfo(g, "Next", this.nextIcon);
                } else if (controlButton == this.prevIcon && !this.prevIcon.isDisabled()) {
                    this.drawButtonInfo(g, "Previous", this.prevIcon);
                } else if (controlButton == this.modeIcon) {
                    this.drawButtonInfo(g, this.modeIcon.isPressed() ? "Heat" : "Select", this.modeIcon);
                } else if (controlButton == this.switchIcon) {
                    this.drawButtonInfo(g, "Exit", this.switchIcon);
                } else if (controlButton == this.brand && this.frankOn) {
                    this.drawButtonInfo(g, "energy.concord.org", this.brand);
                }
            } else {
                switch (this.mouseReadType) {
                    case 5: {
                        float coorx = this.convertPixelToPointXPrecisely(this.mouseMovedPoint.x);
                        float coory = this.model.getLy() - this.convertPixelToPointYPrecisely(this.mouseMovedPoint.y);
                        this.drawMouseReadString(g, "(" + COORDINATES_FORMAT.format(coorx) + ", " + COORDINATES_FORMAT.format(coory) + ") m");
                        break;
                    }
                    case 1: {
                        float pointValue = this.model.getTemperatureAt(this.convertPixelToPointXPrecisely(this.mouseMovedPoint.x), this.convertPixelToPointYPrecisely(this.mouseMovedPoint.y));
                        this.drawMouseReadString(g, String.valueOf(TEMPERATURE_FORMAT.format(this.fahrenheitUsed ? (double)pointValue * 1.8 + 32.0 : (double)pointValue)) + " " + (this.fahrenheitUsed ? (char)'\u2109' : '\u2103'));
                        break;
                    }
                    case 2: {
                        float pointValue = this.model.getThermalEnergyAt(this.convertPixelToPointXPrecisely(this.mouseMovedPoint.x), this.convertPixelToPointYPrecisely(this.mouseMovedPoint.y));
                        this.drawMouseReadString(g, String.valueOf(TEMPERATURE_FORMAT.format(pointValue)) + " J");
                        break;
                    }
                    case 3: {
                        float[] velocity = this.model.getVelocityAt(this.convertPixelToPointXPrecisely(this.mouseMovedPoint.x), this.convertPixelToPointYPrecisely(this.mouseMovedPoint.y));
                        this.drawMouseReadString(g, "(" + VELOCITY_FORMAT.format(velocity[0]) + ", " + VELOCITY_FORMAT.format(-velocity[1]) + ") m/s");
                        break;
                    }
                    case 4: {
                        float[] heatFlux = this.model.getHeatFluxAt(this.convertPixelToPointXPrecisely(this.mouseMovedPoint.x), this.convertPixelToPointYPrecisely(this.mouseMovedPoint.y));
                        this.drawMouseReadString(g, String.valueOf(HEAT_FLUX_FORMAT.format(Math.hypot(heatFlux[0], heatFlux[1]))) + ": (" + HEAT_FLUX_FORMAT.format(heatFlux[0]) + ", " + HEAT_FLUX_FORMAT.format(-heatFlux[1]) + ") W/m" + '\u00b2');
                        break;
                    }
                    case 0: {
                        String dataInfo;
                        if (!this.showGraph || (dataInfo = this.getGraphDataAt(this.mouseMovedPoint.x, this.mouseMovedPoint.y)) == null) break;
                        this.drawMouseReadString(g, dataInfo);
                    }
                }
            }
        }
        if (this.errorMessage != null) {
            g.setColor(Color.red);
            g.setFont(new Font("Arial", 1, 30));
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this.errorMessage, w / 2 - fm.stringWidth(this.errorMessage) / 2, h / 2);
        }
        if (this.tipText != null) {
            g.setColor(Color.YELLOW);
            g.setFont(this.smallFont);
            g.drawString(this.tipText, this.tipTextLocation.x, this.tipTextLocation.y);
        }
    }

    private void drawBlobFromPolygon(Graphics2D g, Polygon p) {
        Blob2D blob = new Blob2D(p);
        g.setColor(TRANSLUCENT_GRAY);
        g.fill(blob.getPath());
        g.setColor(Color.WHITE);
        g.draw(blob.getPath());
    }

    private void drawButtonInfo(Graphics2D g, String s, Symbol button) {
        g.setFont(this.sensorReadingFont);
        int stringWidth = g.getFontMetrics().stringWidth(s);
        g.setStroke(thinStroke);
        g.setColor(Color.black);
        g.fillRoundRect(button.xSymbol + (button.wSymbol - stringWidth) / 2 - 5, button.ySymbol - 24, stringWidth + 10, 20, 8, 8);
        g.setColor(Color.white);
        g.drawString(s, button.xSymbol + (button.wSymbol - stringWidth) / 2, button.ySymbol - 12);
    }

    private void drawMouseReadString(Graphics2D g, String s) {
        g.setFont(this.sensorReadingFont);
        FontMetrics fm = g.getFontMetrics();
        int stringWidth = fm.stringWidth(s);
        g.setStroke(thinStroke);
        int x2 = this.mouseMovedPoint.x;
        boolean nearRightBorder = x2 > this.getWidth() - 50;
        int n = nearRightBorder ? -30 : 20;
        g.setColor(Color.black);
        g.fillRoundRect((x2 += n) - 5, this.mouseMovedPoint.y - 14, stringWidth + 10, 20, 8, 8);
        g.drawLine(nearRightBorder ? x2 + stringWidth + 5 : x2 - 5, this.mouseMovedPoint.y - 5, this.mouseMovedPoint.x, this.mouseMovedPoint.y);
        g.fillOval(this.mouseMovedPoint.x - 2, this.mouseMovedPoint.y - 2, 4, 4);
        g.setColor(Color.white);
        g.drawString(s, x2, this.mouseMovedPoint.y);
    }

    private void showSunOrMoon(Graphics g) {
        if (this.model.isSunny()) {
            if (this.model.getSunAngle() <= 0.0f || (double)this.model.getSunAngle() > Math.PI) {
                if (this.moon == null) {
                    this.moon = new Symbol.Moon(Color.WHITE, 16, 16);
                }
                this.moon.paintIcon(this, g, this.getWidth() - this.moon.getIconWidth() * 2, this.moon.getIconHeight() + 10);
            } else {
                if (this.sun == null) {
                    this.sun = new Symbol.Sun(Color.YELLOW, 16, 16);
                }
                this.sun.paintIcon(this, g, this.getWidth() - this.sun.getIconWidth() * 2, this.sun.getIconHeight() + 10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawParticles(Graphics2D g) {
        if (this.model.getParticles().isEmpty()) {
            return;
        }
        g.setStroke(thinStroke);
        Ellipse2D.Float e = new Ellipse2D.Float();
        List<Particle> list = this.model.getParticles();
        synchronized (list) {
            for (Particle p : this.model.getParticles()) {
                e.width = this.convertLengthToPixelX(p.getRadius() * 2.0f);
                e.height = this.convertLengthToPixelY(p.getRadius() * 2.0f);
                if (e.height > e.width) {
                    e.height = e.width;
                } else {
                    e.width = e.height;
                }
                e.x = (float)this.convertPointToPixelX(p.getRx()) - e.width * 0.5f;
                e.y = (float)this.convertPointToPixelY(p.getRy()) - e.height * 0.5f;
                g.setColor(p.getColor());
                g.fill(e);
                g.setColor(this.selectedManipulable == p ? Color.yellow : Color.gray);
                g.draw(e);
                if (this.model.isRunning() && p == this.selectedManipulable) {
                    HandleSetter.setRects(this, this.selectedManipulable, this.handle);
                }
                if (this.showVelocity || this.showStreamLines) {
                    g.setColor(p.getVelocityColor());
                    float r = e.width * 0.5f;
                    VectorRenderer.drawVector(g, e.x + e.width * 0.5f, e.y + e.height * 0.5f, r, p.getVx(), p.getVy(), VectorRenderer.getDefaultScale(), (BasicStroke)thinStroke);
                }
                if (p.getLabel() == null) continue;
                g.setFont(this.labelFont);
                g.setColor(this.getContrastColor((int)e.getCenterX(), (int)e.getCenterY()));
                String label = p.getLabel();
                FontMetrics fm = g.getFontMetrics();
                g.drawString(label, (int)e.getCenterX() - fm.stringWidth(label) / 2, (int)e.getCenterY() + fm.getAscent() - (fm.getAscent() + fm.getDescent()) / 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawViewFactorMesh(Graphics2D g) {
        Segment s2;
        Segment s1;
        List<Segment> segments = this.model.getPerimeterSegments();
        int n = segments.size();
        if (n == 0) {
            return;
        }
        g.setStroke(thinStroke);
        List<Segment> list = segments;
        synchronized (list) {
            for (Segment seg : segments) {
                int x1 = this.convertPointToPixelX(seg.x1);
                int y1 = this.convertPointToPixelY(seg.y1);
                int x2 = this.convertPointToPixelX(seg.x2);
                int y2 = this.convertPointToPixelY(seg.y2);
                g.setColor(Color.WHITE);
                g.drawLine(x1, y1, x2, y2);
                g.setColor(Color.BLACK);
                g.fillOval(x1 - 2, y1 - 2, 4, 4);
            }
        }
        g.setColor(Color.WHITE);
        g.setStroke(dashed);
        float viewFactorMax = -3.4028235E38f;
        float viewFactorMin = Float.MAX_VALUE;
        int i = 0;
        while (i < n - 1) {
            s1 = segments.get(i);
            int j = i + 1;
            while (j < n) {
                s2 = segments.get(j);
                if (this.model.isVisible(s1, s2)) {
                    float vf = s2.getViewFactor(s1);
                    if (vf > viewFactorMax) {
                        viewFactorMax = vf;
                    }
                    if (vf < viewFactorMin) {
                        viewFactorMin = vf;
                    }
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < n - 1) {
            s1 = segments.get(i2);
            Point2D.Float p1 = s1.getCenter();
            int x1 = this.convertPointToPixelX(p1.x);
            int y1 = this.convertPointToPixelY(p1.y);
            int j = i2 + 1;
            while (j < n) {
                s2 = segments.get(j);
                if (this.model.isVisible(s1, s2)) {
                    Point2D.Float p2 = s2.getCenter();
                    int x2 = this.convertPointToPixelX(p2.x);
                    int y2 = this.convertPointToPixelY(p2.y);
                    float vf = s2.getViewFactor(s1);
                    if (Math.abs(vf) > 1.0E-4f) {
                        g.setColor(new Color(255, 255, 255, (int)(55.0f + 200.0f * (vf - viewFactorMin) / (viewFactorMax - viewFactorMin))));
                        g.drawLine(x1, y1, x2, y2);
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawClouds(Graphics2D g) {
        if (this.model.getClouds().isEmpty()) {
            return;
        }
        Symbol.CloudIcon cloudIcon = new Symbol.CloudIcon(false);
        cloudIcon.setStroke(thickStroke);
        boolean daytime = this.model.isSunny() && this.model.getSunAngle() > 0.0f && (double)this.model.getSunAngle() < Math.PI;
        List<Cloud> list = this.model.getClouds();
        synchronized (list) {
            for (Cloud c : this.model.getClouds()) {
                int x = this.convertPointToPixelX(c.getX());
                int y = this.convertPointToPixelY(c.getY());
                int w = this.convertLengthToPixelX(c.getWidth());
                int h = this.convertLengthToPixelY(c.getHeight());
                cloudIcon.setIconWidth(w);
                cloudIcon.setIconHeight(h);
                cloudIcon.setColor(daytime ? c.getColor() : c.getColor().darker());
                cloudIcon.setBorderColor(this.selectedManipulable == c ? Color.yellow : Color.GRAY);
                cloudIcon.paintIcon(this, g, x, y);
                if (this.model.isRunning() && c.getSpeed() != 0.0f && c == this.selectedManipulable) {
                    HandleSetter.setRects(this, this.selectedManipulable, this.handle);
                }
                if (c.getLabel() == null) continue;
                g.setFont(this.labelFont);
                g.setColor(this.getContrastColor(x + w / 2, y + h / 2));
                String label = c.getLabel();
                FontMetrics fm = g.getFontMetrics();
                g.drawString(label, x + w / 2 - fm.stringWidth(label) / 2, y + h / 2 + fm.getHeight());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTrees(Graphics2D g) {
        if (this.model.getTrees().isEmpty()) {
            return;
        }
        Symbol.TreeIcon treeIcon = new Symbol.TreeIcon(1, false);
        treeIcon.setStroke(thickStroke);
        List<Tree> list = this.model.getTrees();
        synchronized (list) {
            for (Tree t : this.model.getTrees()) {
                int x = this.convertPointToPixelX(t.getX());
                int y = this.convertPointToPixelY(t.getY());
                int w = this.convertLengthToPixelX(t.getWidth());
                int h = this.convertLengthToPixelY(t.getHeight());
                treeIcon.setIconWidth(w);
                treeIcon.setIconHeight(h);
                treeIcon.setType(t.getType());
                treeIcon.setColor(t.getColor());
                treeIcon.setBorderColor(this.selectedManipulable == t ? Color.YELLOW : Color.GRAY);
                treeIcon.paintIcon(this, g, x, y);
                if (t == this.selectedManipulable) {
                    HandleSetter.setRects(this, this.selectedManipulable, this.handle);
                }
                if (t.getLabel() == null) continue;
                g.setFont(this.labelFont);
                g.setColor(this.getContrastColor(x + w / 2, y + h / 2));
                String label = t.getLabel();
                FontMetrics fm = g.getFontMetrics();
                g.drawString(label, x + w / 2 - fm.stringWidth(label) / 2, y + h / 2 + fm.getHeight());
            }
        }
    }

    void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    Color getContrastColor(int x, int y) {
        switch (this.heatMapType) {
            case 1: {
                return new Color(~this.temperatureRenderer.getRGB(x, y));
            }
            case 2: {
                return new Color(~this.thermalEnergyRenderer.getRGB(x, y));
            }
        }
        return Color.BLACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawAnemometers(Graphics2D g) {
        List<Anemometer> anemometers = this.model.getAnemometers();
        if (anemometers.isEmpty()) {
            return;
        }
        g.setStroke(thinStroke);
        Symbol.Anemometer s = new Symbol.Anemometer(false);
        float w = 0.05f * this.model.getLx();
        float h = 0.05f * this.model.getLy();
        s.setIconWidth((int)(w * (float)this.getHeight() / (this.xmax - this.xmin)));
        s.setIconHeight((int)(h * (float)this.getHeight() / (this.ymax - this.ymin)));
        float iconW2 = (float)s.getIconWidth() * 0.5f;
        float iconH2 = (float)s.getIconHeight() * 0.5f;
        g.setFont(this.sensorReadingFont);
        List<Anemometer> list = anemometers;
        synchronized (list) {
            for (Anemometer a : anemometers) {
                Rectangle2D.Float r = (Rectangle2D.Float)a.getShape();
                r.width = w;
                r.height = h;
                float rx = (a.getX() - this.xmin) / (this.xmax - this.xmin);
                float ry = (a.getY() - this.ymin) / (this.ymax - this.ymin);
                if (!(rx >= 0.0f) || !(rx < 1.0f) || !(ry >= 0.0f) || !(ry < 1.0f)) continue;
                int x = (int)(rx * (float)this.getWidth() - iconW2);
                int y = (int)(ry * (float)this.getHeight() - iconH2);
                int ix = Math.round((float)this.nx * rx);
                int iy = Math.round((float)this.ny * ry);
                if (ix < 0) {
                    ix = 0;
                } else if (ix >= this.nx) {
                    ix = this.nx - 1;
                }
                if (iy < 0) {
                    iy = 0;
                } else if (iy >= this.ny) {
                    iy = this.ny - 1;
                }
                float vx = this.model.getXVelocity()[ix][iy];
                float vy = this.model.getYVelocity()[ix][iy];
                if (Float.isNaN(vx) || Float.isNaN(vy)) continue;
                if (this.model.isRunning()) {
                    float direction = Math.signum(this.model.getVorticity(ix, iy, (byte)9));
                    a.setAngle((a.getAngle() + (float)Math.hypot(vx, vy) * direction * iconW2 * this.model.getTimeStep()) % ((float)Math.PI * 2));
                }
                if (a.getLabel() != null) {
                    View2D.centerString(a.getLabel(), g, (int)((float)x + iconW2), y + s.getIconHeight() + 12, false);
                }
                s.setAngle(a.getAngle());
                s.paintIcon(this, g, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawHeatFluxSensors(Graphics2D g) {
        List<HeatFluxSensor> heatFluxSensors = this.model.getHeatFluxSensors();
        if (heatFluxSensors.isEmpty()) {
            return;
        }
        g.setStroke(thinStroke);
        Symbol.HeatFluxSensor s = new Symbol.HeatFluxSensor(false);
        float w = 0.036f * this.model.getLx();
        float h = 0.012f * this.model.getLy();
        s.setIconWidth((int)(w * (float)this.getHeight() / (this.xmax - this.xmin)));
        s.setIconHeight((int)(h * (float)this.getHeight() / (this.ymax - this.ymin)));
        float iconW2 = (float)s.getIconWidth() * 0.5f;
        float iconH2 = (float)s.getIconHeight() * 0.5f;
        g.setFont(this.sensorReadingFont);
        List<HeatFluxSensor> list = heatFluxSensors;
        synchronized (list) {
            for (HeatFluxSensor f : heatFluxSensors) {
                Rectangle2D.Float r = (Rectangle2D.Float)f.getShape();
                r.width = w;
                r.height = h;
                float rx = (f.getX() - this.xmin) / (this.xmax - this.xmin);
                float ry = (f.getY() - this.ymin) / (this.ymax - this.ymin);
                if (!(rx >= 0.0f) || !(rx < 1.0f) || !(ry >= 0.0f) || !(ry < 1.0f)) continue;
                int x = (int)(rx * (float)this.getWidth() - iconW2);
                int y = (int)(ry * (float)this.getHeight() - iconH2);
                String str = String.valueOf(HEAT_FLUX_FORMAT.format(f.getValue())) + "W/m" + '\u00b2';
                if (f.getAngle() != 0.0f) {
                    g.rotate(f.getAngle(), x + s.wSymbol / 2, y + s.hSymbol / 2);
                }
                View2D.centerString(str, g, (int)((float)x + iconW2), y - 5, true);
                if (f.getLabel() != null) {
                    View2D.centerString(f.getLabel(), g, (int)((float)x + iconW2), y + s.getIconHeight() + 12, false);
                }
                s.paintIcon(this, g, x, y);
                if (f.getAngle() == 0.0f) continue;
                g.rotate(-f.getAngle(), x + s.wSymbol / 2, y + s.hSymbol / 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawThermometers(Graphics2D g) {
        List<Thermometer> thermometers = this.model.getThermometers();
        if (thermometers.isEmpty()) {
            return;
        }
        g.setStroke(thinStroke);
        Symbol.Thermometer s = new Symbol.Thermometer(false);
        float w = 0.01f * this.model.getLx();
        float h = 0.05f * this.model.getLy();
        s.setIconWidth(Math.round((float)this.getHeight() * w / (this.xmax - this.xmin)));
        s.setIconHeight(Math.round((float)this.getHeight() * h / (this.ymax - this.ymin)));
        float iconW2 = (float)s.getIconWidth() * 0.5f;
        float iconH2 = (float)s.getIconHeight() * 0.5f;
        float sensingSpotY = this.convertPixelToLengthYPrecisely((int)(iconH2 - (float)s.getBallDiameterOffset() * 0.5f));
        int shiftH = Math.round(sensingSpotY / this.model.getLy() * (float)this.ny);
        g.setFont(this.sensorReadingFont);
        List<Thermometer> list = thermometers;
        synchronized (list) {
            for (Thermometer t : thermometers) {
                Rectangle2D.Float r = (Rectangle2D.Float)t.getShape();
                r.width = w;
                r.height = h;
                float rx = (t.getX() - this.xmin) / (this.xmax - this.xmin);
                float ry = (t.getY() - this.ymin) / (this.ymax - this.ymin);
                if (!(rx >= 0.0f) || !(rx < 1.0f) || !(ry >= 0.0f) || !(ry < 1.0f)) continue;
                int x = Math.round(rx * (float)this.getWidth() - iconW2);
                int y = Math.round(ry * (float)this.getHeight() - iconH2);
                float temp = this.model.getTemperature(Math.round((float)this.nx * rx), Math.round((float)this.ny * ry) + shiftH, t.getStencil());
                if (!Float.isNaN(temp)) {
                    t.setSensingSpotY(sensingSpotY);
                    String str = String.valueOf(TEMPERATURE_FORMAT.format(this.fahrenheitUsed ? (double)temp * 1.8 + 32.0 : (double)temp)) + (this.fahrenheitUsed ? (char)'\u2109' : '\u2103');
                    View2D.centerString(str, g, (int)((float)x + iconW2), y - 5, true);
                    if (t.getLabel() != null) {
                        View2D.centerString(t.getLabel(), g, (int)((float)x + iconW2), y + s.getIconHeight() + 12, false);
                    }
                    s.setValue(Math.round((temp - this.getMinimumTemperature()) / (this.getMaximumTemperature() - this.getMinimumTemperature()) * (float)s.getBarHeight()));
                }
                s.paintIcon(this, g, x, y);
            }
        }
    }

    private static void centerString(String s, Graphics2D g, int x, int y, boolean box) {
        FontMetrics fm = g.getFontMetrics();
        int stringWidth = fm.stringWidth(s);
        int x2 = x - stringWidth / 2;
        if (box) {
            g.setColor(Color.gray);
            g.fillRoundRect(x2 - 5, y - fm.getAscent(), stringWidth + 10, fm.getHeight(), 8, 8);
        }
        g.setColor(Color.white);
        g.drawString(s, x2, y);
    }

    private Color getPartColor(Part p, Color proposedColor) {
        if (p.getPower() > 0.0f && p.getPowerSwitch()) {
            return new Color(0xFFFF00);
        }
        if (p.getPower() < 0.0f && p.getPowerSwitch()) {
            return new Color(11584734);
        }
        if (p.getConstantTemperature()) {
            return new Color(this.temperatureRenderer.getColor(p.getTemperature()));
        }
        return proposedColor;
    }

    private void setPaint(Graphics2D g, Texture texture, boolean filled) {
        Color bg = new Color((filled ? texture.getAlpha() : 0) << 24 | 0xFFFFFF & texture.getBackground(), true);
        Color fg = new Color(texture.getAlpha() << 24 | 0xFFFFFF & texture.getForeground(), true);
        g.setPaint(TextureFactory.createPattern(texture.getStyle(), texture.getCellWidth(), texture.getCellHeight(), fg, bg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawParts(Graphics2D g) {
        List<Part> parts = this.model.getParts();
        if (parts.isEmpty()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(moderateStroke);
        List<Part> list = parts;
        synchronized (list) {
            for (Part p : parts) {
                if (p.isVisible()) {
                    Shape s = p.getShape();
                    if (s instanceof Ellipse2D.Float) {
                        Ellipse2D.Float e = (Ellipse2D.Float)s;
                        int x = this.convertPointToPixelX(e.x);
                        int y = this.convertPointToPixelY(e.y);
                        int w = this.convertLengthToPixelX(e.width);
                        int h = this.convertLengthToPixelY(e.height);
                        FillPattern fillPattern = p.getFillPattern();
                        if (fillPattern instanceof ColorFill) {
                            if (p.isFilled()) {
                                g.setColor(this.getPartColor(p, ((ColorFill)fillPattern).getColor()));
                                g.fillOval(x, y, w, h);
                            } else {
                                this.drawStatus(g, p, x + w / 2, y + h / 2);
                            }
                        } else if (fillPattern instanceof Texture) {
                            this.setPaint(g, (Texture)fillPattern, p.isFilled());
                            g.fillOval(x, y, w, h);
                        }
                        g.setColor(Color.black);
                        g.drawOval(x - 1, y - 1, w + 2, h + 2);
                        String label = p.getLabel();
                        if (label != null) {
                            String partLabel = p.getLabel(label, this.model, this.fahrenheitUsed);
                            if (partLabel != null) {
                                label = partLabel;
                            }
                            this.drawLabelWithLineBreaks(g, label, (float)x + 0.5f * (float)w, (float)y + 0.5f * (float)h, (float)w < (float)h * 0.25f);
                        }
                    } else if (s instanceof Rectangle2D.Float) {
                        Rectangle2D.Float r = (Rectangle2D.Float)s;
                        int x = this.convertPointToPixelX(r.x);
                        int y = this.convertPointToPixelY(r.y);
                        int w = this.convertLengthToPixelX(r.width);
                        int h = this.convertLengthToPixelY(r.height);
                        FillPattern fp = p.getFillPattern();
                        if (fp instanceof ColorFill) {
                            if (p.isFilled()) {
                                g.setColor(this.getPartColor(p, ((ColorFill)fp).getColor()));
                                g.fillRect(x, y, w, h);
                            } else {
                                this.drawStatus(g, p, x + w / 2, y + h / 2);
                            }
                        } else if (fp instanceof Texture) {
                            Texture tex = (Texture)fp;
                            if (tex.getStyle() == 13) {
                                Rectangle r2 = new Rectangle(x, y, w, h);
                                if (p.isFilled()) {
                                    g.setColor(this.getPartColor(p, new Color(tex.getBackground())));
                                    g.fill(r2);
                                }
                                TextureFactory.renderSpecialCases(r2, tex, g);
                            } else {
                                this.setPaint(g, (Texture)fp, p.isFilled());
                                g.fillRect(x, y, w, h);
                            }
                        }
                        g.setColor(Color.BLACK);
                        g.drawRect(x - 1, y - 1, w + 2, h + 2);
                        String label = p.getLabel();
                        if (label != null) {
                            String partLabel = p.getLabel(label, this.model, this.fahrenheitUsed);
                            if (partLabel != null) {
                                label = partLabel;
                            }
                            this.drawLabelWithLineBreaks(g, label, (float)x + 0.5f * (float)w, (float)y + 0.5f * (float)h, (float)w < (float)h * 0.25f);
                        }
                    } else if (s instanceof Area) {
                        if (this.scale == null) {
                            this.scale = new AffineTransform();
                        }
                        this.scale.setToScale((float)this.getWidth() / (this.xmax - this.xmin), (float)this.getHeight() / (this.ymax - this.ymin));
                        Area area = (Area)s;
                        area.transform(this.scale);
                        FillPattern fillPattern = p.getFillPattern();
                        if (fillPattern instanceof ColorFill) {
                            if (p.isFilled()) {
                                g.setColor(this.getPartColor(p, ((ColorFill)fillPattern).getColor()));
                                g.fill(area);
                            } else {
                                Rectangle bounds = area.getBounds();
                                this.drawStatus(g, p, (int)bounds.getCenterX(), (int)bounds.getCenterY());
                            }
                        } else if (fillPattern instanceof Texture) {
                            this.setPaint(g, (Texture)fillPattern, p.isFilled());
                            g.fill(area);
                        }
                        g.setColor(Color.black);
                        g.draw(area);
                        this.scale.setToScale((this.xmax - this.xmin) / (float)this.getWidth(), (this.ymax - this.ymin) / (float)this.getHeight());
                        area.transform(this.scale);
                    } else if (s instanceof Polygon2D) {
                        Polygon2D q = (Polygon2D)s;
                        int n = q.getVertexCount();
                        if (this.multigon == null) {
                            this.multigon = new Polygon();
                        } else {
                            this.multigon.reset();
                        }
                        int cx = 0;
                        int cy = 0;
                        int i = 0;
                        while (i < n) {
                            Point2D.Float v = q.getVertex(i);
                            int x = this.convertPointToPixelX(v.x);
                            int y = this.convertPointToPixelY(v.y);
                            this.multigon.addPoint(x, y);
                            cx += x;
                            cy += y;
                            ++i;
                        }
                        FillPattern fp = p.getFillPattern();
                        if (fp instanceof ColorFill) {
                            if (p.isFilled()) {
                                g.setColor(this.getPartColor(p, ((ColorFill)fp).getColor()));
                                g.fill(this.multigon);
                            } else {
                                this.drawStatus(g, p, cx / n, cy / n);
                            }
                        } else if (fp instanceof Texture) {
                            this.setPaint(g, (Texture)fp, p.isFilled());
                            g.fill(this.multigon);
                        }
                        g.setColor(Color.black);
                        g.draw(this.multigon);
                        String label = p.getLabel();
                        if (label != null) {
                            String partLabel = p.getLabel(label, this.model, this.fahrenheitUsed);
                            if (partLabel != null) {
                                label = partLabel;
                            }
                            this.drawLabelWithLineBreaks(g, label, cx / n, cy / n, false);
                        }
                    } else if (s instanceof Blob2D) {
                        Blob2D b = (Blob2D)s;
                        int n = b.getPointCount();
                        if (this.multigon == null) {
                            this.multigon = new Polygon();
                        } else {
                            this.multigon.reset();
                        }
                        int cx = 0;
                        int cy = 0;
                        int i = 0;
                        while (i < n) {
                            Point2D.Float v = b.getPoint(i);
                            int x = this.convertPointToPixelX(v.x);
                            int y = this.convertPointToPixelY(v.y);
                            this.multigon.addPoint(x, y);
                            cx += x;
                            cy += y;
                            ++i;
                        }
                        GeneralPath path = new Blob2D(this.multigon).getPath();
                        FillPattern fp = p.getFillPattern();
                        if (fp instanceof ColorFill) {
                            if (p.isFilled()) {
                                g.setColor(this.getPartColor(p, ((ColorFill)fp).getColor()));
                                g.fill(path);
                            } else {
                                this.drawStatus(g, p, cx / n, cy / n);
                            }
                        } else if (fp instanceof Texture) {
                            this.setPaint(g, (Texture)fp, p.isFilled());
                            g.fill(path);
                        }
                        g.setColor(Color.black);
                        g.draw(path);
                        String label = p.getLabel();
                        if (label != null) {
                            String partLabel = p.getLabel(label, this.model, this.fahrenheitUsed);
                            if (partLabel != null) {
                                label = partLabel;
                            }
                            this.drawLabelWithLineBreaks(g, label, cx / n, cy / n, false);
                        }
                    }
                }
                if (p.getWindSpeed() == 0.0f) continue;
                FillPattern fp = p.getFillPattern();
                Color bgColor = g.getColor();
                if (fp instanceof ColorFill) {
                    bgColor = ((ColorFill)fp).getColor();
                } else if (fp instanceof Texture) {
                    bgColor = new Color(((Texture)fp).getBackground());
                }
                bgColor = bgColor.darker();
                bgColor = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 128);
                Color fgColor = MiscUtil.getContrastColor(bgColor, 255);
                float rotation = this.fanRotationSpeedScaleFactor * p.getWindSpeed() * this.model.getTime();
                Rectangle2D r = p.getShape().getBounds2D();
                int x = this.convertPointToPixelX((float)r.getX());
                int y = this.convertPointToPixelY((float)r.getY());
                int w = this.convertLengthToPixelX((float)r.getWidth());
                int h = this.convertLengthToPixelY((float)r.getHeight());
                Area a = Fan.getShape(new Rectangle2D.Float(x, y, w, h), p.getWindSpeed(), p.getWindAngle(), (float)Math.abs(Math.sin(rotation)));
                g.setColor(bgColor);
                g.fill(a);
                g.setColor(fgColor);
                g.draw(a);
            }
        }
        g.setStroke(oldStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFans(Graphics2D g) {
        List<Fan> fans = this.model.getFans();
        if (fans.isEmpty()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        Symbol.FanIcon fanIcon = new Symbol.FanIcon(Color.GRAY, Color.BLACK, false);
        List<Fan> list = fans;
        synchronized (list) {
            for (Fan f : fans) {
                if (!f.isVisible()) continue;
                Rectangle2D r = f.getShape().getBounds2D();
                int x = this.convertPointToPixelX((float)r.getX());
                int y = this.convertPointToPixelY((float)r.getY());
                int w = this.convertLengthToPixelX((float)r.getWidth());
                int h = this.convertLengthToPixelY((float)r.getHeight());
                fanIcon.setIconWidth(w);
                fanIcon.setIconHeight(h);
                fanIcon.setAngle(f.getAngle());
                fanIcon.setSpeed(f.getSpeed());
                fanIcon.setRotation(this.fanRotationSpeedScaleFactor * f.getSpeed() * this.model.getTime());
                fanIcon.setStroke(moderateStroke);
                fanIcon.setBorderColor(f == this.selectedManipulable ? Color.YELLOW : Color.BLACK);
                fanIcon.paintIcon(this, g, x, y);
                Shape s = f.getShape();
                if (!(s instanceof Rectangle2D.Float)) continue;
                Rectangle2D.Float r2 = (Rectangle2D.Float)s;
                x = this.convertPointToPixelX(r2.x);
                y = this.convertPointToPixelY(r2.y);
                w = this.convertLengthToPixelX(r2.width);
                h = this.convertLengthToPixelY(r2.height);
                String label = f.getLabel();
                if (label != null) {
                    this.drawLabelWithLineBreaks(g, label, (float)x + 0.5f * (float)w, (float)y + 0.5f * (float)h, (float)w < (float)h * 0.25f);
                }
                if (this.selectedManipulable != f) continue;
                g.setStroke(longDashed);
                g.drawRect(x, y, w, h);
            }
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawHeliostats(Graphics2D g) {
        List<Heliostat> heliostats = this.model.getHeliostats();
        if (heliostats.isEmpty()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        Symbol.HeliostatIcon heliostatIcon = new Symbol.HeliostatIcon(Color.GRAY, Color.BLACK, false);
        List<Heliostat> list = heliostats;
        synchronized (list) {
            for (Heliostat hs : heliostats) {
                if (!hs.isVisible()) continue;
                Rectangle2D r = hs.getShape().getBounds2D();
                int x = this.convertPointToPixelX((float)r.getX());
                int y = this.convertPointToPixelY((float)r.getY());
                int w = this.convertLengthToPixelX((float)r.getWidth());
                int h = this.convertLengthToPixelY((float)r.getHeight());
                heliostatIcon.setIconWidth(w);
                heliostatIcon.setIconHeight(h);
                heliostatIcon.setAngle(hs.getAngle());
                heliostatIcon.setStroke(moderateStroke);
                heliostatIcon.setBorderColor(hs == this.selectedManipulable ? Color.YELLOW : Color.BLACK);
                heliostatIcon.paintIcon(this, g, x, y);
                Shape s = hs.getShape();
                if (!(s instanceof Rectangle2D.Float)) continue;
                Rectangle2D.Float r2 = (Rectangle2D.Float)s;
                x = this.convertPointToPixelX(r2.x);
                y = this.convertPointToPixelY(r2.y);
                w = this.convertLengthToPixelX(r2.width);
                h = this.convertLengthToPixelY(r2.height);
                String label = hs.getLabel();
                if (label != null) {
                    this.drawLabelWithLineBreaks(g, label, (float)x + 0.5f * (float)w, (float)y + 0.5f * (float)h, (float)w < (float)h * 0.25f);
                }
                if (this.selectedManipulable != hs) continue;
                g.setStroke(longDashed);
                g.drawRect(x, y, w, h);
            }
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawParticleFeeders(Graphics2D g) {
        List<ParticleFeeder> particleFeeders = this.model.getParticleFeeders();
        if (particleFeeders.isEmpty()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        Symbol.ParticleFeederIcon s = new Symbol.ParticleFeederIcon(Color.GRAY, Color.WHITE, false);
        s.setStroke(moderateStroke);
        float w = 0.02f * this.model.getLx();
        float h = 0.02f * this.model.getLy();
        s.setIconWidth((int)(w * (float)this.getHeight() / (this.xmax - this.xmin)));
        s.setIconHeight((int)(h * (float)this.getHeight() / (this.ymax - this.ymin)));
        List<ParticleFeeder> list = particleFeeders;
        synchronized (list) {
            for (ParticleFeeder pf : particleFeeders) {
                Rectangle2D.Float r = (Rectangle2D.Float)pf.getShape();
                r.x = pf.getX() - w * 0.5f;
                r.y = pf.getY() - h * 0.5f;
                r.width = w;
                r.height = h;
                float rx = (pf.getX() - this.xmin) / (this.xmax - this.xmin);
                float ry = (pf.getY() - this.ymin) / (this.ymax - this.ymin);
                if (!(rx >= 0.0f) || !(rx < 1.0f) || !(ry >= 0.0f) || !(ry < 1.0f)) continue;
                int x = (int)(rx * (float)this.getWidth() - 0.5f * (float)s.getIconWidth());
                int y = (int)(ry * (float)this.getHeight() - 0.5f * (float)s.getIconHeight());
                if (pf.getLabel() != null) {
                    View2D.centerString(pf.getLabel(), g, x, y, false);
                }
                s.setColor(pf.getColor());
                s.paintIcon(this, g, x, y);
            }
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    private void drawLabelWithLineBreaks(Graphics2D g, String label, float x0, float y0, boolean vertical) {
        g.setFont(this.labelFont);
        FontMetrics fm = g.getFontMetrics();
        int stringHeight = fm.getHeight();
        String[] lines = label.split("-linebreak-");
        int half = lines.length / 2;
        int h = lines.length % 2 == 0 ? -(half - 1) * stringHeight : -half * stringHeight - (fm.getAscent() + fm.getDescent()) / 2 + fm.getAscent();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            float x1 = x0 - (float)(fm.stringWidth(line) / 2);
            g.setColor(this.getContrastColor(Math.round(x1), Math.round(y0 + (float)h)));
            if (vertical) {
                g.rotate(1.5707963267948966, x0, y0);
                g.drawString(line, x1, y0 + (float)h);
                g.rotate(-1.5707963267948966, x0, y0);
            } else {
                g.drawString(line, x1, y0 + (float)h);
            }
            h += stringHeight;
            ++n2;
        }
    }

    private void drawStatus(Graphics2D g, Part p, int x, int y) {
        if (p.getPower() != 0.0f && this.model.getThermostat(p) != null) {
            String onoff = p.getPowerSwitch() ? "On" : "Off";
            g.setColor(this.getContrastColor(x, y));
            g.setFont(this.smallFont);
            FontMetrics fm = g.getFontMetrics();
            g.drawString(onoff, x - fm.stringWidth(onoff) / 2, y - 5);
        }
    }

    private void drawTextBoxes(Graphics2D g) {
        if (this.textBoxes.isEmpty()) {
            return;
        }
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        String s = null;
        for (TextBox x : this.textBoxes) {
            if (!x.isVisible()) continue;
            g.setFont(new Font(x.getFace(), x.getStyle(), x.getSize()));
            g.setColor(x.getColor());
            s = x.getLabel();
            if (s == null) continue;
            s = s.replaceAll("%Prandtl", this.formatter.format(this.model.getPrandtlNumber()));
            s = s.replaceAll("%thermal_energy", "" + Math.round(this.model.getThermalEnergy()));
            this.drawStringWithLineBreaks(g, s, x);
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private void drawStringWithLineBreaks(Graphics2D g, String text, TextBox t) {
        int x = this.convertPointToPixelX(t.getX());
        int y = this.getHeight() - this.convertPointToPixelY(t.getY());
        FontMetrics fm = g.getFontMetrics();
        int stringHeight = fm.getHeight();
        int stringWidth = 0;
        int w = 0;
        int h = 0;
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            g.drawString(line, x, y + (h += stringHeight));
            stringWidth = fm.stringWidth(line);
            if (stringWidth > w) {
                w = stringWidth;
            }
            ++n2;
        }
        Rectangle2D.Float r = (Rectangle2D.Float)t.getShape();
        r.x = x - 8;
        r.y = y - 2;
        r.width = w + 16;
        r.height = h + 10;
        if (t.hasBorder()) {
            g.setStroke(moderateStroke);
            g.drawRoundRect((int)r.x, (int)r.y, (int)r.width, (int)r.height, 10, 10);
        }
        if (t.isSelected()) {
            g.setStroke(dashed);
            g.drawRoundRect((int)(r.x - 5.0f), (int)(r.y - 5.0f), (int)(r.width + 10.0f), (int)(r.height + 10.0f), 15, 15);
        }
        r.x = this.convertPixelToPointX((int)r.x);
        r.y = this.convertPixelToPointX((int)r.y);
        r.width = this.convertPixelToPointX((int)r.width);
        r.height = this.convertPixelToPointX((int)r.height);
    }

    private void drawPictures(Graphics2D g) {
        if (this.pictures == null || this.pictures.isEmpty()) {
            return;
        }
        for (Picture x : this.pictures) {
            x.getImage().paintIcon(this, g, this.convertPointToPixelX(x.getX()), this.getHeight() - this.convertPointToPixelY(x.getY()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPhotons(Graphics2D g) {
        if (this.model.getPhotons().isEmpty()) {
            return;
        }
        g.setColor(this.lightColor);
        g.setStroke(thinStroke);
        List<Photon> list = this.model.getPhotons();
        synchronized (list) {
            for (Photon p : this.model.getPhotons()) {
                int x = this.convertPointToPixelX(p.getRx());
                int y = this.convertPointToPixelY(p.getRy());
                float r = 1.0f / (float)Math.hypot(p.getVx(), p.getVy());
                g.drawLine(Math.round((float)x - this.photonLength * p.getVx() * r), Math.round((float)y - this.photonLength * p.getVy() * r), x, y);
            }
        }
    }

    private void drawTemperatureField(Graphics2D g) {
        this.temperatureRenderer.render(this, g, this.model.getTemperature());
    }

    private void drawThermalEnergyField(Graphics2D g) {
        float[][] density = this.model.getDensity();
        float[][] specificHeat = this.model.getSpecificHeat();
        float[][] temperature = this.model.getTemperature();
        int nx = temperature.length;
        int ny = temperature[0].length;
        if (this.distribution == null) {
            this.distribution = new float[nx][ny];
        }
        float factor = 1.0f / this.model.getMaximumHeatCapacity();
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                this.distribution[i][j] = factor * density[i][j] * specificHeat[i][j] * temperature[i][j];
                ++j;
            }
            ++i;
        }
        this.thermalEnergyRenderer.render(this, g, this.distribution);
    }

    private void setAnchorPointForRectangularShape(int i, float x, float y, float w, float h) {
        switch (i) {
            case 0: {
                this.anchorPoint.setLocation(x + w, y + h);
                break;
            }
            case 2: {
                this.anchorPoint.setLocation(x, y + h);
                break;
            }
            case 3: {
                this.anchorPoint.setLocation(x, y);
                break;
            }
            case 1: {
                this.anchorPoint.setLocation(x + w, y);
                break;
            }
            case 4: {
                this.anchorPoint.setLocation(x, y + h);
                break;
            }
            case 7: {
                this.anchorPoint.setLocation(x, y);
                break;
            }
            case 5: {
                this.anchorPoint.setLocation(x, y);
                break;
            }
            case 6: {
                this.anchorPoint.setLocation(x + w, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectManipulable(int x, int y) {
        Manipulable f;
        Manipulable t;
        Manipulable p;
        int i;
        List<Manipulable> list;
        this.setSelectedManipulable(null);
        float rx = this.convertPixelToPointXPrecisely(x);
        float ry = this.convertPixelToPointYPrecisely(y);
        int n = this.model.getParticles().size();
        if (n > 0) {
            list = this.model.getParticles();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    p = this.model.getParticles().get(i);
                    if (p.contains(rx, ry)) {
                        this.setSelectedManipulable(p);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getThermometers().size()) > 0) {
            list = this.model.getThermometers();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    t = this.model.getThermometers().get(i);
                    if (t.contains(rx, ry)) {
                        this.setSelectedManipulable(t);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getAnemometers().size()) > 0) {
            list = this.model.getAnemometers();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    Anemometer a = this.model.getAnemometers().get(i);
                    if (a.contains(rx, ry)) {
                        this.setSelectedManipulable(a);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getHeatFluxSensors().size()) > 0) {
            list = this.model.getHeatFluxSensors();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    f = this.model.getHeatFluxSensors().get(i);
                    if (f.contains(rx, ry)) {
                        this.setSelectedManipulable(f);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getClouds().size()) > 0) {
            list = this.model.getClouds();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    Cloud c = this.model.getClouds().get(i);
                    if (c.contains(rx, ry)) {
                        this.setSelectedManipulable(c);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getTrees().size()) > 0) {
            list = this.model.getTrees();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    t = this.model.getTrees().get(i);
                    if (((Tree)t).contains(rx, ry)) {
                        this.setSelectedManipulable(t);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.textBoxes.size()) > 0) {
            list = this.textBoxes;
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    t = this.textBoxes.get(i);
                    if (t.contains(rx, ry)) {
                        this.setSelectedManipulable(t);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getFans().size()) > 0) {
            list = this.model.getFans();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    f = this.model.getFans().get(i);
                    if (f.contains(rx, ry)) {
                        this.setSelectedManipulable(f);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getHeliostats().size()) > 0) {
            list = this.model.getHeliostats();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    Heliostat h = this.model.getHeliostats().get(i);
                    if (h.contains(rx, ry)) {
                        this.setSelectedManipulable(h);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getParticleFeeders().size()) > 0) {
            list = this.model.getParticleFeeders();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    f = this.model.getParticleFeeders().get(i);
                    if (f.contains(rx, ry)) {
                        this.setSelectedManipulable(f);
                        return;
                    }
                    --i;
                }
            }
        }
        if ((n = this.model.getParts().size()) > 0) {
            list = this.model.getParts();
            synchronized (list) {
                i = n - 1;
                while (i >= 0) {
                    p = this.model.getPart(i);
                    if (p.contains(rx, ry)) {
                        this.setSelectedManipulable(p);
                        return;
                    }
                    --i;
                }
            }
        }
    }

    public void setSelectedManipulable(Manipulable m) {
        if (this.selectedManipulable != null) {
            this.selectedManipulable.setSelected(false);
        }
        this.selectedManipulable = m;
        if (this.selectedManipulable != null) {
            this.selectedManipulable.setSelected(true);
            HandleSetter.setRects(this, this.selectedManipulable, this.handle);
        }
    }

    public Manipulable getSelectedManipulable() {
        return this.selectedManipulable;
    }

    public Manipulable getBufferedManipulable() {
        return this.copiedManipulable;
    }

    public void scaleAll(float scaleFactor) {
        if (this.model.scaleAll(scaleFactor)) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "Your scale factor is too large -- some objects are out of the window.", "Warning", 2);
        }
        if (this.model.getPartCount() > 0) {
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
        }
        this.setSelectedManipulable(this.getSelectedManipulable());
        this.repaint();
        this.notifyManipulationListeners(null, (byte)2);
    }

    public void zoom(float extent) {
        if (this.model.getTime() > 0.0f) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "Sorry, the simulation must be reset before this action can be taken.", "Cannot zoom now", 1);
            return;
        }
        float lx = this.model.getLx();
        float ly = this.model.getLy();
        this.model.setLx(extent * lx);
        this.model.setLy(extent * ly);
        this.model.translateAllBy(0.0f, extent > 1.0f ? ly : -ly * 0.5f);
        this.setArea(0.0f, extent * lx, 0.0f, extent * ly);
        this.model.refreshPowerArray();
        this.model.refreshTemperatureBoundaryArray();
        this.model.refreshMaterialPropertyArrays();
        if (this.isViewFactorLinesOn()) {
            this.model.generateViewFactorMesh();
        }
        this.setSelectedManipulable(this.selectedManipulable);
        this.repaint();
        this.notifyManipulationListeners(null, (byte)3);
    }

    private void translateAllBy(float dx, float dy) {
        this.model.translateAllBy(dx, dy);
        if (!this.textBoxes.isEmpty()) {
            for (TextBox t : this.textBoxes) {
                t.translateBy(dx, -dy);
            }
        }
        if (!this.model.getParts().isEmpty()) {
            this.notifyManipulationListeners(this.model.getPart(0), (byte)1);
        }
    }

    private void translateManipulableBy(Manipulable m, float dx, float dy) {
        if (m == null || !m.isDraggable()) {
            return;
        }
        this.undoManager.addEdit(new UndoTranslateManipulable(this));
        Shape s = m.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x += dx;
            r.y += dy;
            if (m instanceof Thermometer || m instanceof Anemometer || m instanceof HeatFluxSensor) {
                if (r.x + r.width / 2.0f < this.xmin + dx) {
                    r.x = this.xmin + dx - r.width / 2.0f;
                } else if (r.x + r.width / 2.0f > this.xmax - dx) {
                    r.x = this.xmax - dx - r.width / 2.0f;
                }
                if (r.y + r.height / 2.0f < this.ymin + dy) {
                    r.y = this.ymin + dy - r.height / 2.0f;
                } else if (r.y + r.height / 2.0f > this.ymax - dy) {
                    r.y = this.ymax - dy - r.height / 2.0f;
                }
            } else if (m instanceof TextBox) {
                ((TextBox)m).translateBy(dx, -dy);
            } else if (m instanceof Heliostat) {
                ((Heliostat)m).setAngle();
            }
        } else if (s instanceof Ellipse2D.Float) {
            Ellipse2D.Float r = (Ellipse2D.Float)s;
            r.x += dx;
            r.y += dy;
            if (m instanceof Particle) {
                ((Particle)m).translateBy(dx, dy);
            }
        } else if (s instanceof Ring2D) {
            ((Ring2D)s).translateBy(dx, dy);
        } else if (s instanceof Area) {
            if (m instanceof Cloud) {
                ((Cloud)m).translateBy(dx, dy);
            } else if (m instanceof Tree) {
                ((Tree)m).translateBy(dx, dy);
            }
        } else if (s instanceof Polygon2D) {
            ((Polygon2D)s).translateBy(dx, dy);
        } else if (s instanceof Blob2D) {
            Blob2D b = (Blob2D)s;
            b.translateBy(dx, dy);
            b.update();
        }
        if (!this.model.getParticles().isEmpty()) {
            this.model.attachSensors();
        }
        if (m instanceof Part) {
            this.model.refreshHeliostatsAimedAt((Part)m);
        }
        this.notifyManipulationListeners(m, (byte)1);
    }

    private void translateManipulableTo(Manipulable m, float x, float y) {
        Shape shape;
        this.undoManager.addEdit(new UndoTranslateManipulable(this));
        Shape s = m.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.x = x - r.width / 2.0f;
            r.y = y - r.height / 2.0f;
            if (m instanceof TextBox) {
                ((TextBox)m).setLocation(r.x + this.convertPixelToPointX(8), this.model.getLy() - r.y - this.convertPixelToPointY(2));
            } else if (m instanceof Heliostat) {
                ((Heliostat)m).setAngle();
            }
        } else if (s instanceof Ellipse2D.Float) {
            Ellipse2D.Float r = (Ellipse2D.Float)s;
            r.x = x - r.width / 2.0f;
            r.y = y - r.height / 2.0f;
            if (m instanceof Particle) {
                ((Particle)m).setLocation(x, y);
            }
        } else if (s instanceof Ring2D) {
            if (m instanceof Part) {
                Ring2D r = (Ring2D)s;
                r.setRing(x, y, r.getInnerDiameter(), r.getOuterDiameter());
            }
        } else if (s instanceof Area) {
            if (m instanceof Cloud) {
                ((Cloud)m).setLocation((float)((double)x - s.getBounds2D().getCenterX()), (float)((double)y - s.getBounds2D().getCenterY()));
            } else if (m instanceof Tree) {
                ((Tree)m).setLocation((float)((double)x - s.getBounds2D().getCenterX()), (float)((double)y - s.getBounds2D().getCenterY()));
            }
        } else if (s instanceof Polygon2D) {
            Shape shape2 = this.movingShape.getShape();
            if (shape2 instanceof Polygon) {
                Polygon poly = (Polygon)shape2;
                float xc = 0.0f;
                float yc = 0.0f;
                int i = 0;
                while (i < poly.npoints) {
                    xc += (float)poly.xpoints[i];
                    yc += (float)poly.ypoints[i];
                    ++i;
                }
                xc = this.convertPixelToPointXPrecisely((int)(xc / (float)poly.npoints));
                yc = this.convertPixelToPointYPrecisely((int)(yc / (float)poly.npoints));
                Polygon2D p = (Polygon2D)s;
                Point2D.Float center = p.getCenter();
                p.translateBy(xc - center.x, yc - center.y);
            }
        } else if (s instanceof Blob2D && (shape = this.movingShape.getShape()) instanceof Blob2D) {
            Blob2D blob = (Blob2D)shape;
            float xc = 0.0f;
            float yc = 0.0f;
            int n = blob.getPointCount();
            int i = 0;
            while (i < n) {
                xc += blob.getPoint((int)i).x;
                yc += blob.getPoint((int)i).y;
                ++i;
            }
            xc = this.convertPixelToPointXPrecisely((int)(xc / (float)n));
            yc = this.convertPixelToPointYPrecisely((int)(yc / (float)n));
            Blob2D b = (Blob2D)s;
            Point2D.Float center = b.getCenter();
            b.translateBy(xc - center.x, yc - center.y);
            b.update();
        }
        if (!this.model.getParticles().isEmpty()) {
            this.model.attachSensors();
        }
        if (m instanceof Part) {
            this.model.refreshHeliostatsAimedAt((Part)m);
        }
        this.notifyManipulationListeners(m, (byte)1);
    }

    void resizeManipulableTo(Manipulable m, float x, float y, float w, float h, float x0, float y0) {
        w = Math.max(this.model.getLx() / (float)this.nx, w);
        h = Math.max(this.model.getLy() / (float)this.ny, h);
        Shape s = m.getShape();
        if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            r.setRect(x, y, w, h);
        } else if (s instanceof Ellipse2D.Float) {
            Ellipse2D.Float r = (Ellipse2D.Float)s;
            r.setFrame(x, y, w, h);
        } else if (s instanceof Ring2D) {
            Ring2D r = (Ring2D)s;
            r.setRing(x, y, w, h);
        } else if (s instanceof Area) {
            if (m instanceof Cloud) {
                Cloud c = (Cloud)m;
                c.setDimension(w, h);
                c.setX(x0 + x);
                c.setY(y0 + y);
            } else if (m instanceof Tree) {
                Tree t = (Tree)m;
                t.setDimension(w, h);
                t.setX(x0 + x);
                t.setY(y0 + y);
            }
        }
        if (m instanceof Part) {
            this.model.refreshHeliostatsAimedAt((Part)m);
        }
        this.notifyManipulationListeners(m, (byte)2);
    }

    private void processKeyPressed(KeyEvent e) {
        if (this.runHeatingThread && e.getKeyCode() == 16) {
            this.cooling = true;
        }
        boolean keyDown = IS_MAC ? e.isMetaDown() : e.isControlDown();
        float delta = keyDown ? 5 : 1;
        switch (e.getKeyCode()) {
            case 37: {
                delta *= -(this.xmax - this.xmin) / (float)this.nx;
                if (this.selectedManipulable != null) {
                    this.translateManipulableBy(this.selectedManipulable, delta, 0.0f);
                    break;
                }
                if (!e.isAltDown()) break;
                this.translateAllBy(delta, 0.0f);
                break;
            }
            case 39: {
                delta *= (this.xmax - this.xmin) / (float)this.nx;
                if (this.selectedManipulable != null) {
                    this.translateManipulableBy(this.selectedManipulable, delta, 0.0f);
                    break;
                }
                if (!e.isAltDown()) break;
                this.translateAllBy(delta, 0.0f);
                break;
            }
            case 40: {
                delta *= (this.ymax - this.ymin) / (float)this.ny;
                if (this.selectedManipulable != null) {
                    this.translateManipulableBy(this.selectedManipulable, 0.0f, delta);
                    break;
                }
                if (!e.isAltDown()) break;
                this.translateAllBy(0.0f, delta);
                break;
            }
            case 38: {
                delta *= -(this.ymax - this.ymin) / (float)this.ny;
                if (this.selectedManipulable != null) {
                    this.translateManipulableBy(this.selectedManipulable, 0.0f, delta);
                    break;
                }
                if (!e.isAltDown()) break;
                this.translateAllBy(0.0f, delta);
            }
        }
        if (this.showGrid) {
            int gridSize = this.gridRenderer.getGridSize();
            if (e.isAltDown()) {
                switch (e.getKeyChar()) {
                    case ']': {
                        if (gridSize >= 25) break;
                        this.gridRenderer.setGridSize(++gridSize);
                        break;
                    }
                    case '[': {
                        if (gridSize <= 2) break;
                        this.gridRenderer.setGridSize(--gridSize);
                    }
                }
            }
        }
        this.setSelectedManipulable(this.selectedManipulable);
        this.repaint();
    }

    private void processKeyReleased(KeyEvent e) {
        if (this.runHeatingThread && e.getKeyCode() == 16) {
            this.cooling = false;
        }
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                if (this.selectedManipulable != null) {
                    if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the selected object?", "Delete Object", 0, 3) != 0) break;
                    this.undoManager.addEdit(new UndoRemoveManipulable(this));
                    this.notifyManipulationListeners(this.selectedManipulable, (byte)0);
                    this.setSelectedManipulable(null);
                    break;
                }
                if (!this.showGraph || JOptionPane.showConfirmDialog(this, "Are you sure you want to erase the graph?", "Erase Graph", 0, 3) != 0) break;
                this.eraseGraph();
                break;
            }
            case 82: {
                this.notifyManipulationListeners(null, this.runToggle ? (byte)12 : 11);
                break;
            }
            case 84: {
                this.notifyManipulationListeners(null, (byte)13);
                break;
            }
            case 76: {
                this.notifyManipulationListeners(null, (byte)14);
                break;
            }
            case 83: {
                if (e.isControlDown() || e.isMetaDown() || e.isAltDown()) break;
                this.notifyManipulationListeners(null, (byte)4);
                break;
            }
            case 81: {
                this.notifyManipulationListeners(null, (byte)5);
                break;
            }
            case 87: {
                this.notifyManipulationListeners(null, (byte)6);
                break;
            }
            case 71: {
                this.showGraph = !this.showGraph;
                this.notifyGraphListeners(this.showGraph ? (byte)0 : 1);
                break;
            }
            case 27: {
                Object r = this.getClientProperty("close_full_screen");
                if (!(r instanceof Runnable)) break;
                ((Runnable)r).run();
            }
        }
        this.repaint();
    }

    private void processMousePressed(MouseEvent e) {
        this.mousePressedTime = System.currentTimeMillis();
        this.requestFocusInWindow();
        int x = e.getX();
        int y = e.getY();
        this.mousePressedPoint.setLocation(x, y);
        if (this.isFullScreen() && this.switchIcon != null && this.switchIcon.contains(x, y)) {
            Object r = this.getClientProperty("close_full_screen");
            if (r instanceof Runnable) {
                ((Runnable)r).run();
            } else {
                Action a = this.getActionMap().get("Quit");
                if (a != null) {
                    a.actionPerformed(null);
                }
            }
            e.consume();
            return;
        }
        if (this.showControlPanel) {
            if (this.startIcon != null && this.startIcon.contains(x, y)) {
                this.startIcon.setPressed(!this.runToggle);
                this.notifyManipulationListeners(null, this.runToggle ? (byte)12 : 11);
                this.repaint();
                e.consume();
                return;
            }
            if (this.resetIcon != null && this.resetIcon.contains(x, y)) {
                this.notifyManipulationListeners(null, (byte)13);
                this.repaint();
                e.consume();
                return;
            }
            if (this.nextIcon != null && this.nextIcon.contains(x, y) && !this.nextIcon.isDisabled()) {
                Action a = this.getActionMap().get("Next_Simulation");
                if (a != null) {
                    a.actionPerformed(null);
                }
                e.consume();
                return;
            }
            if (this.prevIcon != null && this.prevIcon.contains(x, y) && !this.prevIcon.isDisabled()) {
                Action a = this.getActionMap().get("Previous_Simulation");
                if (a != null) {
                    a.actionPerformed(null);
                }
                e.consume();
                return;
            }
            if (this.graphIcon != null && this.graphIcon.contains(x, y)) {
                this.setGraphOn(!this.showGraph);
                this.notifyGraphListeners(this.showGraph ? (byte)0 : 1);
                this.repaint();
                e.consume();
                return;
            }
            if (this.modeIcon != null && this.modeIcon.contains(x, y)) {
                this.modeIcon.setPressed(!this.modeIcon.isPressed());
                this.setActionMode(this.modeIcon.isPressed() ? (byte)21 : 0);
                this.notifyManipulationListeners(null, this.modeIcon.isPressed() ? (byte)22 : 21);
                this.mouseMovedPoint.setLocation(x, y);
                this.repaint();
                e.consume();
                return;
            }
        }
        if (this.showGraph && this.graphRenderer.buttonContains(x, y)) {
            e.consume();
            return;
        }
        switch (this.actionMode) {
            case 0: {
                if (this.selectedManipulable != null) {
                    this.selectedSpot = -1;
                    int i = 0;
                    while (i < this.handle.length) {
                        if (this.handle[i].x >= -10 && this.handle[i].y >= -10 && this.handle[i].contains(x, y)) {
                            this.selectedSpot = i;
                            break;
                        }
                        ++i;
                    }
                    if (this.selectedSpot != -1) {
                        this.setMovingShape(true);
                        return;
                    }
                }
                if (MiscUtil.isRightClick(e)) break;
                this.selectManipulable(x, y);
                if (this.selectedManipulable == null) break;
                Point2D.Float center = this.selectedManipulable.getCenter();
                this.pressedPointRelative.x = x - this.convertPointToPixelX(center.x);
                this.pressedPointRelative.y = y - this.convertPointToPixelY(center.y);
                this.setMovingShape(false);
                break;
            }
            case 1: 
            case 2: {
                if (this.showGraph) {
                    e.consume();
                    return;
                }
                if (!this.snapToGrid) break;
                this.mousePressedPoint.x = this.getXOnGrid(this.mousePressedPoint.x);
                this.mousePressedPoint.y = this.getYOnGrid(this.mousePressedPoint.y);
                break;
            }
            case 3: {
                this.tipText = "Double-click to finalize the shape";
                if (this.showGraph) {
                    e.consume();
                    return;
                }
                if (e.getClickCount() >= 2) break;
                this.addPolygonPoint(x, y);
                break;
            }
            case 4: {
                this.tipText = "Double-click to finalize the shape";
                if (this.showGraph) {
                    e.consume();
                    return;
                }
                if (e.getClickCount() >= 2) break;
                this.addBlobPoint(x, y);
                break;
            }
            case 21: {
                this.runHeatingThread = true;
                this.heatingX = this.convertPixelToPointXPrecisely(x);
                this.heatingY = this.convertPixelToPointYPrecisely(y);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (View2D.this.runHeatingThread) {
                            float t = View2D.this.model.getTemperatureAt(View2D.this.heatingX, View2D.this.heatingY);
                            if (View2D.this.cooling) {
                                if (!(t > -100.0f)) continue;
                                View2D.this.model.changeTemperatureAt(View2D.this.heatingX, View2D.this.heatingY, -View2D.this.temperatureIncrement);
                                continue;
                            }
                            if (!(t < 100.0f)) continue;
                            View2D.this.model.changeTemperatureAt(View2D.this.heatingX, View2D.this.heatingY, View2D.this.temperatureIncrement);
                        }
                    }
                }).start();
            }
        }
        this.repaint();
        e.consume();
    }

    private void processMouseDragged(MouseEvent e) {
        if (MiscUtil.isRightClick(e)) {
            return;
        }
        if (this.showGraph && !(this.selectedManipulable instanceof Sensor)) {
            e.consume();
            return;
        }
        this.mouseBeingDragged = true;
        if (System.currentTimeMillis() - this.mousePressedTime < 5L) {
            return;
        }
        this.mousePressedTime = System.currentTimeMillis();
        int x = e.getX();
        int y = e.getY();
        this.mouseDraggedPoint.setLocation(x, y);
        switch (this.actionMode) {
            case 0: {
                if (this.movingShape == null || this.selectedManipulable == null) break;
                Shape shape = this.movingShape.getShape();
                if (shape instanceof RectangularShape) {
                    if (this.selectedManipulable instanceof Sensor) {
                        if (x < 8) {
                            x = 8;
                        } else if (x > this.getWidth() - 8) {
                            x = this.getWidth() - 8;
                        }
                        if (y < 8) {
                            y = 8;
                        } else if (y > this.getHeight() - 8) {
                            y = this.getHeight() - 8;
                        }
                    }
                    RectangularShape s = (RectangularShape)shape;
                    float[] a = new float[]{(float)s.getX(), (float)s.getY(), (float)s.getWidth(), (float)s.getHeight()};
                    if (this.selectedSpot == -1) {
                        a[0] = (float)(x - this.pressedPointRelative.x) - a[2] * 0.5f;
                        a[1] = (float)(y - this.pressedPointRelative.y) - a[3] * 0.5f;
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    } else if (this.selectedManipulable instanceof Part) {
                        this.setMovingRect(a, x, y);
                        this.setCursor(Cursor.getPredefinedCursor(1));
                    }
                    s.setFrame(a[0], a[1], a[2], a[3]);
                } else if (shape instanceof Polygon) {
                    Polygon s = (Polygon)shape;
                    if (this.selectedSpot == -1) {
                        float xc = 0.0f;
                        float yc = 0.0f;
                        int i = 0;
                        while (i < s.npoints) {
                            xc += (float)s.xpoints[i];
                            yc += (float)s.ypoints[i];
                            ++i;
                        }
                        xc /= (float)s.npoints;
                        yc /= (float)s.npoints;
                        xc = (float)(x - this.pressedPointRelative.x) - xc;
                        yc = (float)(y - this.pressedPointRelative.y) - yc;
                        s.translate((int)xc, (int)yc);
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    } else if (this.selectedManipulable instanceof Part) {
                        int k;
                        int n = k = s.npoints < this.handle.length ? this.selectedSpot : (int)((float)this.selectedSpot * (float)s.npoints / (float)this.handle.length);
                        if (k >= s.npoints) {
                            k = s.npoints - 1;
                        }
                        s.xpoints[k] = x;
                        s.ypoints[k] = y;
                        this.setCursor(Cursor.getPredefinedCursor(1));
                    }
                } else if (shape instanceof Blob2D) {
                    Blob2D b = (Blob2D)shape;
                    int n = b.getPointCount();
                    if (this.selectedSpot == -1) {
                        float xc = 0.0f;
                        float yc = 0.0f;
                        int i = 0;
                        while (i < n) {
                            xc += b.getPoint((int)i).x;
                            yc += b.getPoint((int)i).y;
                            ++i;
                        }
                        xc /= (float)n;
                        yc /= (float)n;
                        xc = (float)(x - this.pressedPointRelative.x) - xc;
                        yc = (float)(y - this.pressedPointRelative.y) - yc;
                        b.translateBy((int)xc, (int)yc);
                        b.update();
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    } else if (this.selectedManipulable instanceof Part) {
                        int k;
                        int n2 = k = n < this.handle.length ? this.selectedSpot : (int)((float)this.selectedSpot * (float)n / (float)this.handle.length);
                        if (k >= n) {
                            k = n - 1;
                        }
                        b.setPoint(k, x, y);
                        b.update();
                        this.setCursor(Cursor.getPredefinedCursor(1));
                    }
                } else if (shape instanceof Area) {
                    if (this.selectedManipulable instanceof Cloud && this.movingShape instanceof MovingCloud) {
                        MovingCloud mc = (MovingCloud)this.movingShape;
                        Rectangle r = mc.getShape().getBounds();
                        if (this.selectedSpot == -1) {
                            int xc = (int)((double)(x - this.pressedPointRelative.x) - r.getCenterX());
                            int yc = (int)((double)(y - this.pressedPointRelative.y) - r.getCenterY());
                            mc.setLocation(xc, yc);
                        } else {
                            float[] a = new float[]{(float)r.getX() + (float)mc.getX(), (float)r.getY() + (float)mc.getY(), (float)r.getWidth(), (float)r.getHeight()};
                            this.movingShape = new MovingCloud(this.setMovingRect(a, x, y));
                            this.setCursor(Cursor.getPredefinedCursor(1));
                        }
                    } else if (this.selectedManipulable instanceof Tree && this.movingShape instanceof MovingTree) {
                        MovingTree mt = (MovingTree)this.movingShape;
                        Rectangle r = mt.getShape().getBounds();
                        if (this.selectedSpot == -1) {
                            int xc = (int)((double)(x - this.pressedPointRelative.x) - r.getCenterX());
                            int yc = (int)((double)(y - this.pressedPointRelative.y) - r.getCenterY());
                            mt.setLocation(xc, yc);
                        } else {
                            float[] a = new float[]{(float)r.getX() + (float)mt.getX(), (float)r.getY() + (float)mt.getY(), (float)r.getWidth(), (float)r.getHeight()};
                            this.movingShape = new MovingTree(this.setMovingRect(a, x, y), ((Tree)this.selectedManipulable).getType());
                            this.setCursor(Cursor.getPredefinedCursor(1));
                        }
                    } else if (this.selectedManipulable instanceof Fan && this.movingShape instanceof MovingFan) {
                        MovingFan mf = (MovingFan)this.movingShape;
                        Rectangle2D.Float r = mf.getBoundingBox();
                        if (this.selectedSpot == -1) {
                            int xc = (int)((double)(x - this.pressedPointRelative.x) - r.getCenterX());
                            int yc = (int)((double)(y - this.pressedPointRelative.y) - r.getCenterY());
                            mf.setLocation(xc, yc);
                        } else {
                            float[] a = new float[]{(float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight()};
                            Fan f = (Fan)this.selectedManipulable;
                            float rotation = f.getSpeed() * this.model.getTime();
                            this.movingShape = new MovingFan(this.setMovingRect(a, x, y), f.getSpeed(), f.getAngle(), (float)Math.abs(Math.sin(rotation)));
                            this.setCursor(Cursor.getPredefinedCursor(1));
                        }
                    } else if (this.selectedManipulable instanceof Heliostat && this.movingShape instanceof MovingHeliostat) {
                        MovingHeliostat mh = (MovingHeliostat)this.movingShape;
                        Rectangle2D.Float r = mh.getBoundingBox();
                        if (this.selectedSpot == -1) {
                            int xc = (int)((double)(x - this.pressedPointRelative.x) - r.getCenterX());
                            int yc = (int)((double)(y - this.pressedPointRelative.y) - r.getCenterY());
                            mh.setLocation(xc, yc);
                        } else {
                            float[] a = new float[]{(float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight()};
                            Heliostat h = (Heliostat)this.selectedManipulable;
                            this.movingShape = new MovingHeliostat(this.setMovingRect(a, x, y), h.getAngle());
                            this.setCursor(Cursor.getPredefinedCursor(1));
                        }
                    } else if (this.selectedManipulable instanceof Part && this.movingShape instanceof MovingAnnulus) {
                        MovingAnnulus ma = (MovingAnnulus)this.movingShape;
                        Rectangle r = ma.getShape().getBounds();
                        if (this.selectedSpot == -1) {
                            int xc = (int)((double)(x - this.pressedPointRelative.x) - r.getCenterX());
                            int yc = (int)((double)(y - this.pressedPointRelative.y) - r.getCenterY());
                            ma.setLocation(xc, yc);
                        }
                    }
                } else {
                    this.showTipPopupMenu("<html><font color=red>The selected object is not draggable!</font></html>", x, y, 500);
                }
                e.isAltDown();
                break;
            }
            case 1: {
                if (this.snapToGrid) {
                    this.mouseDraggedPoint.x = this.getXOnGrid(this.mouseDraggedPoint.x);
                    this.mouseDraggedPoint.y = this.getYOnGrid(this.mouseDraggedPoint.y);
                }
                if (this.mouseDraggedPoint.x > this.mousePressedPoint.x) {
                    this.rectangle.width = this.mouseDraggedPoint.x - this.mousePressedPoint.x;
                    this.rectangle.x = this.mousePressedPoint.x;
                } else {
                    this.rectangle.width = this.mousePressedPoint.x - this.mouseDraggedPoint.x;
                    this.rectangle.x = this.mousePressedPoint.x - this.rectangle.width;
                }
                if (this.mouseDraggedPoint.y > this.mousePressedPoint.y) {
                    this.rectangle.height = this.mouseDraggedPoint.y - this.mousePressedPoint.y;
                    this.rectangle.y = this.mousePressedPoint.y;
                    break;
                }
                this.rectangle.height = this.mousePressedPoint.y - this.mouseDraggedPoint.y;
                this.rectangle.y = this.mousePressedPoint.y - this.rectangle.height;
                break;
            }
            case 2: {
                if (this.mouseDraggedPoint.x > this.mousePressedPoint.x) {
                    this.ellipse.width = this.mouseDraggedPoint.x - this.mousePressedPoint.x;
                    this.ellipse.x = this.mousePressedPoint.x;
                } else {
                    this.ellipse.width = this.mousePressedPoint.x - this.mouseDraggedPoint.x;
                    this.ellipse.x = (float)this.mousePressedPoint.x - this.ellipse.width;
                }
                if (this.mouseDraggedPoint.y > this.mousePressedPoint.y) {
                    this.ellipse.height = this.mouseDraggedPoint.y - this.mousePressedPoint.y;
                    this.ellipse.y = this.mousePressedPoint.y;
                    break;
                }
                this.ellipse.height = this.mousePressedPoint.y - this.mouseDraggedPoint.y;
                this.ellipse.y = (float)this.mousePressedPoint.y - this.ellipse.height;
                break;
            }
            case 21: {
                this.heatingX = this.convertPixelToPointXPrecisely(x);
                this.heatingY = this.convertPixelToPointYPrecisely(y);
            }
        }
        if (!this.model.isRunning()) {
            this.repaint();
        }
        e.consume();
    }

    private Rectangle2D.Float setMovingRect(float[] a, int x, int y) {
        switch (this.selectedSpot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                a[0] = Math.min(x, this.anchorPoint.x);
                a[1] = Math.min(y, this.anchorPoint.y);
                a[2] = Math.abs(x - this.anchorPoint.x);
                a[3] = Math.abs(y - this.anchorPoint.y);
                break;
            }
            case 4: 
            case 5: {
                a[1] = Math.min(y, this.anchorPoint.y);
                a[3] = Math.abs(y - this.anchorPoint.y);
                break;
            }
            case 6: 
            case 7: {
                a[0] = Math.min(x, this.anchorPoint.x);
                a[2] = Math.abs(x - this.anchorPoint.x);
            }
        }
        return new Rectangle2D.Float(a[0], a[1], a[2], a[3]);
    }

    private void processMouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mouseReleasedPoint.setLocation(x, y);
        if (this.showGraph) {
            if (this.graphRenderer.buttonContains((byte)0, x, y)) {
                this.showGraph = false;
                this.notifyGraphListeners((byte)1);
                this.notifyManipulationListeners(null, (byte)3);
                if (this.graphIcon != null) {
                    this.graphIcon.setPressed(false);
                }
            } else if (this.graphRenderer.buttonContains((byte)1, x, y)) {
                if (this.dataViewer == null) {
                    this.dataViewer = new DataViewer(this);
                }
                this.dataViewer.showDataOfType(this.graphRenderer.getDataType());
            } else if (this.graphRenderer.buttonContains((byte)2, x, y)) {
                this.graphRenderer.doubleXmax();
            } else if (this.graphRenderer.buttonContains((byte)3, x, y)) {
                this.graphRenderer.halveXmax();
            } else if (this.graphRenderer.buttonContains((byte)4, x, y)) {
                this.graphRenderer.increaseYmax();
            } else if (this.graphRenderer.buttonContains((byte)5, x, y)) {
                this.graphRenderer.decreaseYmax();
            } else if (this.graphRenderer.buttonContains((byte)6, x, y)) {
                this.autofitGraph();
            } else if (this.graphRenderer.buttonContains((byte)7, x, y)) {
                this.graphRenderer.previous();
                this.autofitGraph();
            } else if (this.graphRenderer.buttonContains((byte)8, x, y)) {
                this.graphRenderer.next();
                this.autofitGraph();
            }
            this.repaint();
            e.consume();
            this.movingShape = null;
            this.mouseBeingDragged = false;
            if (this.graphRenderer.windowContains(x, y)) {
                return;
            }
        }
        switch (this.actionMode) {
            case 0: {
                if (MiscUtil.isRightClick(e)) {
                    this.selectManipulable(x, y);
                    if (this.selectedManipulable == null) {
                        this.createModelPopupMenu();
                        this.modelPopupMenu.show(this, x, y);
                    } else {
                        this.createPartPopupMenu();
                        this.partPopupMenu.show(this, x, y);
                    }
                    this.repaint();
                    return;
                }
                if (this.movingShape != null && this.mouseBeingDragged && this.selectedManipulable != null) {
                    if (this.selectedManipulable.isDraggable()) {
                        Shape shape = this.movingShape.getShape();
                        if (shape instanceof RectangularShape) {
                            if (this.selectedSpot == -1) {
                                float x2 = this.convertPixelToPointX(x - this.pressedPointRelative.x);
                                float y2 = this.convertPixelToPointY(y - this.pressedPointRelative.y);
                                this.translateManipulableTo(this.selectedManipulable, x2, y2);
                                this.setSelectedManipulable(this.selectedManipulable);
                                break;
                            }
                            if (!(this.selectedManipulable instanceof Part)) break;
                            RectangularShape r = (RectangularShape)shape;
                            float x2 = this.convertPixelToPointX((int)r.getX());
                            float y2 = this.convertPixelToPointY((int)r.getY());
                            float w2 = this.convertPixelToLengthX((int)r.getWidth());
                            float h2 = this.convertPixelToLengthY((int)r.getHeight());
                            this.undoManager.addEdit(new UndoResizeManipulable(this));
                            this.resizeManipulableTo(this.selectedManipulable, x2, y2, w2, h2, 0.0f, 0.0f);
                            this.setSelectedManipulable(this.selectedManipulable);
                            break;
                        }
                        if (shape instanceof Polygon) {
                            if (this.selectedSpot == -1) {
                                float x2 = this.convertPixelToPointX(x - this.pressedPointRelative.x);
                                float y2 = this.convertPixelToPointY(y - this.pressedPointRelative.y);
                                this.translateManipulableTo(this.selectedManipulable, x2, y2);
                                this.setSelectedManipulable(this.selectedManipulable);
                                break;
                            }
                            Shape s = this.selectedManipulable.getShape();
                            if (!(s instanceof Polygon2D)) break;
                            Polygon2D p = (Polygon2D)s;
                            this.undoManager.addEdit(new UndoEditPolygon(this, this.selectedManipulable, p));
                            Polygon p0 = (Polygon)shape;
                            int n = p0.npoints;
                            int i = 0;
                            while (i < n) {
                                p.setVertex(i, this.convertPixelToPointX(p0.xpoints[i]), this.convertPixelToPointY(p0.ypoints[i]));
                                ++i;
                            }
                            this.setSelectedManipulable(this.selectedManipulable);
                            this.notifyManipulationListeners(this.selectedManipulable, (byte)2);
                            break;
                        }
                        if (shape instanceof Blob2D) {
                            if (this.selectedSpot == -1) {
                                float x2 = this.convertPixelToPointX(x - this.pressedPointRelative.x);
                                float y2 = this.convertPixelToPointY(y - this.pressedPointRelative.y);
                                this.translateManipulableTo(this.selectedManipulable, x2, y2);
                                this.setSelectedManipulable(this.selectedManipulable);
                                break;
                            }
                            Shape s = this.selectedManipulable.getShape();
                            if (!(s instanceof Blob2D)) break;
                            Blob2D b = (Blob2D)s;
                            this.undoManager.addEdit(new UndoEditBlob(this, this.selectedManipulable, b));
                            Blob2D b0 = (Blob2D)shape;
                            int n = b0.getPointCount();
                            int i = 0;
                            while (i < n) {
                                b.setPoint(i, this.convertPixelToPointX((int)b0.getPoint((int)i).x), this.convertPixelToPointY((int)b0.getPoint((int)i).y));
                                ++i;
                            }
                            b.update();
                            this.setSelectedManipulable(this.selectedManipulable);
                            this.notifyManipulationListeners(this.selectedManipulable, (byte)2);
                            break;
                        }
                        if (!(shape instanceof Area)) break;
                        if (this.selectedSpot == -1) {
                            float x2 = this.convertPixelToPointX(x - this.pressedPointRelative.x);
                            float y2 = this.convertPixelToPointY(y - this.pressedPointRelative.y);
                            this.translateManipulableTo(this.selectedManipulable, x2, y2);
                            this.setSelectedManipulable(this.selectedManipulable);
                            break;
                        }
                        if (this.selectedManipulable instanceof Cloud && this.movingShape instanceof MovingCloud) {
                            Rectangle2D r = shape.getBounds2D();
                            float x2 = this.convertPixelToPointX((int)r.getX());
                            float y2 = this.convertPixelToPointY((int)r.getY());
                            float w2 = this.convertPixelToLengthX((int)r.getWidth());
                            float h2 = this.convertPixelToLengthY((int)r.getHeight());
                            Point p = ((MovingCloud)this.movingShape).getLocation();
                            this.undoManager.addEdit(new UndoResizeManipulable(this));
                            this.resizeManipulableTo(this.selectedManipulable, x2, y2, w2, h2, this.convertPixelToPointX(p.x), this.convertPixelToPointY(p.y));
                            this.setSelectedManipulable(this.selectedManipulable);
                            break;
                        }
                        if (this.selectedManipulable instanceof Tree && this.movingShape instanceof MovingTree) {
                            Rectangle2D r = shape.getBounds2D();
                            float x2 = this.convertPixelToPointX((int)r.getX());
                            float y2 = this.convertPixelToPointY((int)r.getY());
                            float w2 = this.convertPixelToLengthX((int)r.getWidth());
                            float h2 = this.convertPixelToLengthY((int)r.getHeight());
                            Point p = ((MovingTree)this.movingShape).getLocation();
                            this.undoManager.addEdit(new UndoResizeManipulable(this));
                            this.resizeManipulableTo(this.selectedManipulable, x2, y2, w2, h2, this.convertPixelToPointX(p.x), this.convertPixelToPointY(p.y));
                            this.setSelectedManipulable(this.selectedManipulable);
                            break;
                        }
                        if (this.selectedManipulable instanceof Fan && this.movingShape instanceof MovingFan) {
                            Rectangle2D.Float r = ((MovingFan)this.movingShape).getBoundingBox();
                            float x2 = this.convertPixelToPointX((int)((RectangularShape)r).getX());
                            float y2 = this.convertPixelToPointY((int)((RectangularShape)r).getY());
                            float w2 = this.convertPixelToLengthX((int)((RectangularShape)r).getWidth());
                            float h2 = this.convertPixelToLengthY((int)((RectangularShape)r).getHeight());
                            ((Fan)this.selectedManipulable).setAngle(w2 < h2 ? 0.0f : 1.5707964f);
                            Point p = ((MovingFan)this.movingShape).getLocation();
                            this.undoManager.addEdit(new UndoResizeManipulable(this));
                            this.resizeManipulableTo(this.selectedManipulable, x2, y2, w2, h2, this.convertPixelToPointX(p.x), this.convertPixelToPointY(p.y));
                            this.setSelectedManipulable(this.selectedManipulable);
                            break;
                        }
                        if (!(this.selectedManipulable instanceof Heliostat) || !(this.movingShape instanceof MovingHeliostat)) break;
                        Rectangle2D.Float r = ((MovingHeliostat)this.movingShape).getBoundingBox();
                        float x2 = this.convertPixelToPointX((int)((RectangularShape)r).getX());
                        float y2 = this.convertPixelToPointY((int)((RectangularShape)r).getY());
                        float w2 = this.convertPixelToLengthX((int)((RectangularShape)r).getWidth());
                        float h2 = this.convertPixelToLengthY((int)((RectangularShape)r).getHeight());
                        Point p = ((MovingHeliostat)this.movingShape).getLocation();
                        this.undoManager.addEdit(new UndoResizeManipulable(this));
                        this.resizeManipulableTo(this.selectedManipulable, x2, y2, w2, h2, this.convertPixelToPointX(p.x), this.convertPixelToPointY(p.y));
                        ((Heliostat)this.selectedManipulable).setAngle();
                        this.setSelectedManipulable(this.selectedManipulable);
                        break;
                    }
                    this.showTipPopupMenu("<html><font color=red>The selected object is not draggable!</font></html>", x, y, 500);
                    break;
                }
                if (e.getClickCount() <= 1 || !(this.selectedManipulable instanceof Part) || this.selectedSpot == -1) break;
                Part selectedPart = (Part)this.selectedManipulable;
                Shape s = selectedPart.getShape();
                if (s instanceof Polygon2D) {
                    this.model.removePart(selectedPart);
                    Polygon2D p = (Polygon2D)s;
                    int vertexCount = p.getVertexCount();
                    int i = this.selectedSpot;
                    if (vertexCount > this.handle.length) {
                        i = (int)((float)this.selectedSpot * (float)vertexCount / (float)this.handle.length);
                    }
                    Part newPart = this.model.addPolygonPart(e.isShiftDown() ? p.deleteVertexBefore(i) : p.insertVertexBefore(i));
                    selectedPart.copyPropertiesTo(newPart);
                    newPart.setUid(selectedPart.getUid());
                    this.setSelectedManipulable(newPart);
                    this.undoManager.addEdit(new UndoEditBlobOrPolygon(this, selectedPart, newPart));
                } else if (s instanceof Blob2D) {
                    this.model.removePart(selectedPart);
                    Blob2D p = (Blob2D)s;
                    int pointCount = p.getPointCount();
                    int i = this.selectedSpot;
                    if (pointCount > this.handle.length) {
                        i = (int)((float)this.selectedSpot * (float)pointCount / (float)this.handle.length);
                    }
                    Part newPart = this.model.addBlobPart(e.isShiftDown() ? p.deletePointBefore(i) : p.insertPointBefore(i));
                    selectedPart.copyPropertiesTo(newPart);
                    newPart.setUid(selectedPart.getUid());
                    this.setSelectedManipulable(newPart);
                    this.undoManager.addEdit(new UndoEditBlobOrPolygon(this, selectedPart, newPart));
                }
                this.notifyManipulationListeners(this.selectedManipulable, (byte)3);
                break;
            }
            case 1: {
                if ((float)this.rectangle.width > (float)this.getWidth() / (float)this.nx && (float)this.rectangle.height > (float)this.getHeight() / (float)this.ny) {
                    Part addedPart = this.model.addRectangularPart(this.convertPixelToPointX(this.rectangle.x), this.convertPixelToPointY(this.rectangle.y), this.convertPixelToLengthX(this.rectangle.width), this.convertPixelToLengthY(this.rectangle.height), this.model.getBackgroundTemperature() + 20.0f);
                    this.model.refreshPowerArray();
                    this.model.refreshTemperatureBoundaryArray();
                    this.model.refreshMaterialPropertyArrays();
                    this.model.setInitialTemperature();
                    this.notifyManipulationListeners(addedPart, (byte)7);
                    this.setSelectedManipulable(addedPart);
                    this.undoManager.addEdit(new UndoAddManipulable(addedPart, this));
                } else if (this.rectangle.width > 0 && this.rectangle.height > 0) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "The rectangle you tried to add was too small!", "Error", 0);
                }
                this.rectangle.setRect(-1000.0, -1000.0, 0.0, 0.0);
                break;
            }
            case 2: {
                if (this.ellipse.width > (float)this.getWidth() / (float)this.nx && this.ellipse.height > (float)this.getHeight() / (float)this.ny) {
                    float ex = this.convertPixelToPointX((int)this.ellipse.x);
                    float ey = this.convertPixelToPointY((int)this.ellipse.y);
                    float ew = this.convertPixelToLengthX((int)this.ellipse.width);
                    float eh = this.convertPixelToLengthY((int)this.ellipse.height);
                    Part addedPart = this.model.addEllipticalPart(ex + 0.5f * ew, ey + 0.5f * eh, ew, eh, this.model.getBackgroundTemperature() + 20.0f);
                    this.model.refreshPowerArray();
                    this.model.refreshTemperatureBoundaryArray();
                    this.model.refreshMaterialPropertyArrays();
                    this.model.setInitialTemperature();
                    this.notifyManipulationListeners(addedPart, (byte)7);
                    this.setSelectedManipulable(addedPart);
                    this.undoManager.addEdit(new UndoAddManipulable(addedPart, this));
                } else if (this.ellipse.width > 0.0f || this.ellipse.height > 0.0f) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "The ellipse you tried to add was too small!", "Error", 0);
                }
                this.ellipse.setFrame(-1000.0f, -1000.0f, 0.0f, 0.0f);
                break;
            }
            case 3: {
                if (e.getClickCount() < 2) break;
                this.resetMousePoints();
                int n = this.polygon.npoints;
                if (n >= 3) {
                    float[] px = new float[n];
                    float[] py = new float[n];
                    int i = 0;
                    while (i < n) {
                        px[i] = this.convertPixelToPointX(this.polygon.xpoints[i]);
                        py[i] = this.convertPixelToPointY(this.polygon.ypoints[i]);
                        ++i;
                    }
                    Part addedPart = this.model.addPolygonPart(px, py, this.model.getBackgroundTemperature() + 20.0f);
                    this.model.refreshPowerArray();
                    this.model.refreshTemperatureBoundaryArray();
                    this.model.refreshMaterialPropertyArrays();
                    this.model.setInitialTemperature();
                    this.notifyManipulationListeners(addedPart, (byte)7);
                    this.setSelectedManipulable(addedPart);
                    this.undoManager.addEdit(new UndoAddManipulable(addedPart, this));
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "The polygon must be at least a triangle!", "Error", 0);
                }
                this.polygon.reset();
                this.tipText = null;
                break;
            }
            case 4: {
                if (e.getClickCount() < 2) break;
                this.resetMousePoints();
                int n = this.polygon.npoints;
                if (n >= 3) {
                    float[] px = new float[n];
                    float[] py = new float[n];
                    int i = 0;
                    while (i < n) {
                        px[i] = this.convertPixelToPointX(this.polygon.xpoints[i]);
                        py[i] = this.convertPixelToPointY(this.polygon.ypoints[i]);
                        ++i;
                    }
                    Part addedPart = this.model.addBlobPart(px, py, this.model.getBackgroundTemperature() + 20.0f);
                    this.model.refreshPowerArray();
                    this.model.refreshTemperatureBoundaryArray();
                    this.model.refreshMaterialPropertyArrays();
                    this.model.setInitialTemperature();
                    this.notifyManipulationListeners(addedPart, (byte)7);
                    this.setSelectedManipulable(addedPart);
                    this.undoManager.addEdit(new UndoAddManipulable(addedPart, this));
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), "The blob must contain at least three points!", "Error", 0);
                }
                this.polygon.reset();
                this.tipText = null;
                break;
            }
            case 21: {
                this.runHeatingThread = false;
                this.cooling = false;
                break;
            }
            case 11: {
                Thermometer thermometer = this.addThermometer(this.convertPixelToPointX(x), this.convertPixelToPointY(y));
                this.notifyManipulationListeners(thermometer, (byte)7);
                this.setSelectedManipulable(thermometer);
                this.undoManager.addEdit(new UndoAddManipulable(thermometer, this));
                break;
            }
            case 12: {
                HeatFluxSensor heatFluxSensor = this.addHeatFluxSensor(this.convertPixelToPointX(x), this.convertPixelToPointY(y));
                this.notifyManipulationListeners(heatFluxSensor, (byte)7);
                this.setSelectedManipulable(heatFluxSensor);
                this.undoManager.addEdit(new UndoAddManipulable(heatFluxSensor, this));
                break;
            }
            case 13: {
                Anemometer anemometer = this.addAnemometer(this.convertPixelToPointX(x), this.convertPixelToPointY(y));
                this.notifyManipulationListeners(anemometer, (byte)7);
                this.setSelectedManipulable(anemometer);
                this.undoManager.addEdit(new UndoAddManipulable(anemometer, this));
                break;
            }
            case 31: {
                Particle particle = this.addParticle(this.convertPixelToPointX(x), this.convertPixelToPointY(y));
                this.notifyManipulationListeners(particle, (byte)7);
                this.setSelectedManipulable(particle);
                this.undoManager.addEdit(new UndoAddManipulable(particle, this));
                break;
            }
            case 32: {
                ParticleFeeder particleFeeder = this.addParticleFeeder(this.convertPixelToPointX(x), this.convertPixelToPointY(y));
                this.notifyManipulationListeners(particleFeeder, (byte)7);
                this.setSelectedManipulable(particleFeeder);
                this.undoManager.addEdit(new UndoAddManipulable(particleFeeder, this));
                break;
            }
            case 33: {
                Fan fan = this.addFan(this.convertPixelToPointX(x) - this.model.getLx() * 0.1f, this.convertPixelToPointY(y) - this.model.getLy() * 0.1f, this.model.getLx() * 0.2f, this.model.getLy() * 0.2f);
                this.notifyManipulationListeners(fan, (byte)7);
                this.setSelectedManipulable(fan);
                this.undoManager.addEdit(new UndoAddManipulable(fan, this));
                break;
            }
            case 34: {
                Heliostat heliostat = this.addHeliostat(this.convertPixelToPointX(x) - this.model.getLx() * 0.1f, this.convertPixelToPointY(y) - this.model.getLy() * 0.1f, this.model.getLx() * 0.2f, this.model.getLy() * 0.2f);
                this.notifyManipulationListeners(heliostat, (byte)7);
                this.setSelectedManipulable(heliostat);
                this.undoManager.addEdit(new UndoAddManipulable(heliostat, this));
                break;
            }
            case 35: {
                Cloud cloud = this.addCloud(this.convertPixelToPointX(x) - this.model.getLx() * 0.15f, this.convertPixelToPointY(y) - this.model.getLy() * 0.05f, this.model.getLx() * 0.3f, this.model.getLy() * 0.1f, 0.0f);
                this.notifyManipulationListeners(cloud, (byte)7);
                this.setSelectedManipulable(cloud);
                this.undoManager.addEdit(new UndoAddManipulable(cloud, this));
                break;
            }
            case 36: {
                Tree tree = this.addTree(this.convertPixelToPointX(x) - this.model.getLx() * 0.05f, this.convertPixelToPointY(y) - this.model.getLy() * 0.1f, this.model.getLx() * 0.1f, this.model.getLy() * 0.2f, (byte)1);
                this.notifyManipulationListeners(tree, (byte)7);
                this.setSelectedManipulable(tree);
                this.undoManager.addEdit(new UndoAddManipulable(tree, this));
            }
        }
        this.repaint();
        e.consume();
        this.movingShape = null;
        this.mouseBeingDragged = false;
    }

    private void autofitGraph() {
        float[] bounds = this.model.getSensorDataBounds(this.getGraphDataType());
        if (bounds != null && bounds[0] < bounds[1]) {
            float diff = 0.05f * (bounds[1] - bounds[0]);
            if ((double)Math.abs(bounds[0]) < 1.0E-6 * (double)diff) {
                this.graphRenderer.setYmin(bounds[0]);
                this.graphRenderer.setYmax(bounds[1] + diff);
            } else {
                this.graphRenderer.setYmin(bounds[0] - diff);
                this.graphRenderer.setYmax(bounds[1] + diff);
            }
        }
    }

    public void addThermometer(float x, float y, String label) {
        this.addThermometer(x, y).setLabel(label);
    }

    private Thermometer addThermometer(float x, float y) {
        Thermometer t = new Thermometer(x, y);
        Rectangle2D.Float r = (Rectangle2D.Float)t.getShape();
        r.width = 0.01f * this.model.getLx();
        r.height = 0.05f * this.model.getLy();
        t.setCenter(x, y);
        this.model.addThermometer(t);
        return t;
    }

    public void addHeatFluxSensor(float x, float y, String label) {
        this.addHeatFluxSensor(x, y).setLabel(label);
    }

    private HeatFluxSensor addHeatFluxSensor(float x, float y) {
        HeatFluxSensor h = new HeatFluxSensor(x, y);
        Rectangle2D.Float r = (Rectangle2D.Float)h.getShape();
        r.width = 0.036f * this.model.getLx();
        r.height = 0.012f * this.model.getLy();
        h.setCenter(x, y);
        this.model.addHeatFluxSensor(h);
        return h;
    }

    public void addAnemometer(float x, float y, String label) {
        this.addAnemometer(x, y).setLabel(label);
    }

    private Anemometer addAnemometer(float x, float y) {
        Anemometer a = new Anemometer(x, y);
        Rectangle2D.Float r = (Rectangle2D.Float)a.getShape();
        r.width = 0.05f * this.model.getLx();
        r.height = 0.05f * this.model.getLy();
        a.setCenter(x, y);
        this.model.addAnemometer(a);
        return a;
    }

    private String getFormattedTime(float time) {
        String s;
        switch (this.graphRenderer.getTimeUnit()) {
            case 1: {
                s = String.valueOf(TIME_FORMAT.format(time / 60.0f)) + " min";
                break;
            }
            case 2: {
                s = String.valueOf(TIME_FORMAT.format(time)) + " s";
                break;
            }
            default: {
                s = String.valueOf(TIME_FORMAT.format(time / 3600.0f)) + " hr";
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGraphDataAt(int x, int y) {
        switch (this.getGraphDataType()) {
            case 0: {
                List<Thermometer> list = this.model.getThermometers();
                synchronized (list) {
                    for (Thermometer t : this.model.getThermometers()) {
                        float[] data = this.graphRenderer.getData(t.getData(), x, y);
                        if (data == null) continue;
                        String s = "(" + this.getFormattedTime(data[0]) + ", " + TEMPERATURE_FORMAT.format(data[1]) + " " + '\u2103' + ")";
                        if (t.getLabel() == null) {
                            return s;
                        }
                        return String.valueOf(t.getLabel()) + ": " + s;
                    }
                    break;
                }
            }
            case 1: {
                List<HeatFluxSensor> list = this.model.getHeatFluxSensors();
                synchronized (list) {
                    for (HeatFluxSensor f : this.model.getHeatFluxSensors()) {
                        float[] data = this.graphRenderer.getData(f.getData(), x, y);
                        if (data == null) continue;
                        String s = "(" + this.getFormattedTime(data[0]) + ", " + HEAT_FLUX_FORMAT.format(data[1]) + " W/m" + '\u00b2' + ")";
                        if (f.getLabel() == null) {
                            return s;
                        }
                        return String.valueOf(f.getLabel()) + ": " + s;
                    }
                    break;
                }
            }
            case 2: {
                List<Anemometer> list = this.model.getAnemometers();
                synchronized (list) {
                    for (Anemometer a : this.model.getAnemometers()) {
                        float[] data = this.graphRenderer.getData(a.getData(), x, y);
                        if (data == null) continue;
                        String s = "(" + this.getFormattedTime(data[0]) + ", " + VELOCITY_FORMAT.format(data[1]) + " m/s)";
                        if (a.getLabel() == null) {
                            return s;
                        }
                        return String.valueOf(a.getLabel()) + ": " + s;
                    }
                    break;
                }
            }
        }
        return null;
    }

    private void processMouseExited(MouseEvent e) {
        this.mouseMovedPoint.setLocation(-1, -1);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mouseMovedPoint.setLocation(x, y);
        Symbol button = this.overWhichButton(x, y);
        if (button != null && button != this.brand) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
            e.consume();
            return;
        }
        if (this.showGraph) {
            if (this.graphRenderer.buttonContains(x, y)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
                e.consume();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        switch (this.actionMode) {
            case 0: {
                this.tipText = null;
                int iSpot = -1;
                if (!this.showGraph && (this.selectedManipulable instanceof Part || this.selectedManipulable instanceof Cloud || this.selectedManipulable instanceof Tree || this.selectedManipulable instanceof Fan || this.selectedManipulable instanceof Heliostat)) {
                    int i = 0;
                    while (i < this.handle.length) {
                        if (this.handle[i].x >= -10 && this.handle[i].y >= -10 && this.handle[i].contains(x, y)) {
                            iSpot = i;
                            break;
                        }
                        ++i;
                    }
                    if (iSpot >= 0) {
                        Shape shape = this.selectedManipulable.getShape();
                        if (shape instanceof RectangularShape || shape instanceof Area) {
                            switch (iSpot) {
                                case 0: {
                                    this.setCursor(Cursor.getPredefinedCursor(6));
                                    break;
                                }
                                case 1: {
                                    this.setCursor(Cursor.getPredefinedCursor(4));
                                    break;
                                }
                                case 2: {
                                    this.setCursor(Cursor.getPredefinedCursor(7));
                                    break;
                                }
                                case 3: {
                                    this.setCursor(Cursor.getPredefinedCursor(5));
                                    break;
                                }
                                case 4: {
                                    this.setCursor(Cursor.getPredefinedCursor(8));
                                    break;
                                }
                                case 5: {
                                    this.setCursor(Cursor.getPredefinedCursor(9));
                                    break;
                                }
                                case 6: {
                                    this.setCursor(Cursor.getPredefinedCursor(10));
                                    break;
                                }
                                case 7: {
                                    this.setCursor(Cursor.getPredefinedCursor(11));
                                }
                            }
                        } else {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                            if (shape instanceof Polygon2D || shape instanceof Blob2D) {
                                this.tipText = "Drag to resize; double-click to insert a point; shift + double-click to remove this point";
                            }
                        }
                    }
                }
                if (iSpot == -1) {
                    float rx = this.convertPixelToPointXPrecisely(x);
                    float ry = this.convertPixelToPointYPrecisely(y);
                    boolean contained = false;
                    List<Sensor> list = this.model.getThermometers();
                    synchronized (list) {
                        for (Thermometer t : this.model.getThermometers()) {
                            if (!t.contains(rx, ry)) continue;
                            contained = true;
                            break;
                        }
                    }
                    if (!contained) {
                        list = this.model.getAnemometers();
                        synchronized (list) {
                            for (Anemometer a : this.model.getAnemometers()) {
                                if (!a.contains(rx, ry)) continue;
                                contained = true;
                                break;
                            }
                        }
                    }
                    if (!contained) {
                        list = this.model.getHeatFluxSensors();
                        synchronized (list) {
                            for (HeatFluxSensor f : this.model.getHeatFluxSensors()) {
                                if (!f.contains(rx, ry)) continue;
                                contained = true;
                                break;
                            }
                        }
                    }
                    if (!contained && !this.showGraph) {
                        boolean draggable = false;
                        List<Manipulable> list2 = this.model.getParts();
                        synchronized (list2) {
                            for (Part part : this.model.getParts()) {
                                if (!part.contains(rx, ry)) continue;
                                contained = true;
                                draggable = part.isDraggable();
                                break;
                            }
                        }
                        if (!draggable) {
                            contained = false;
                        }
                        if (!contained) {
                            list2 = this.model.getClouds();
                            synchronized (list2) {
                                for (Cloud cloud : this.model.getClouds()) {
                                    if (!cloud.contains(rx, ry)) continue;
                                    contained = true;
                                    draggable = cloud.isDraggable();
                                    break;
                                }
                            }
                            if (!draggable) {
                                contained = false;
                            }
                        }
                        if (!contained) {
                            list2 = this.model.getTrees();
                            synchronized (list2) {
                                for (Tree tree : this.model.getTrees()) {
                                    if (!tree.contains(rx, ry)) continue;
                                    contained = true;
                                    draggable = tree.isDraggable();
                                    break;
                                }
                            }
                            if (!draggable) {
                                contained = false;
                            }
                        }
                        if (!contained) {
                            list2 = this.textBoxes;
                            synchronized (list2) {
                                for (TextBox textBox : this.textBoxes) {
                                    if (!textBox.contains(rx, ry)) continue;
                                    contained = true;
                                    draggable = textBox.isDraggable();
                                    break;
                                }
                            }
                            if (!draggable) {
                                contained = false;
                            }
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(contained ? 13 : 0));
                }
                if (this.model.isRunning()) break;
                this.repaint();
            }
        }
        if (!this.showGraph && !this.model.isRunning()) {
            this.repaint();
        }
        e.consume();
    }

    private void processComponentResized(ComponentEvent e) {
        this.graphRenderer.setFrame(50, 50, this.getWidth() - 100, this.getHeight() - 100);
        if (this.selectedManipulable != null) {
            this.setSelectedManipulable(this.selectedManipulable);
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pName = e.getPropertyName();
        if (pName.equals("Time step")) {
            float timeStep = ((Float)e.getNewValue()).floatValue();
            this.graphRenderer.setXmax(7200.0f * timeStep);
            this.photonLength = Math.max(5.0f, timeStep * 0.1f);
        } else if (pName.equals("Next Simulation")) {
            if (this.nextIcon != null) {
                this.nextIcon.setDisabled(e.getNewValue() == null);
                this.repaint();
            }
        } else if (pName.equals("Prev Simulation") && this.prevIcon != null) {
            this.prevIcon.setDisabled(e.getNewValue() == null);
            this.repaint();
        }
    }

    private void eraseGraph() {
        this.model.clearSensorData();
        this.repaint();
    }

    private void addPolygonPoint(int x, int y) {
        int n = this.polygon.npoints;
        if (n > 0) {
            boolean tooClose = false;
            int dx = 0;
            int dy = 0;
            int i = 0;
            while (i < n) {
                dx = x - this.polygon.xpoints[i];
                dy = y - this.polygon.ypoints[i];
                if (dx * dx + dy * dy < 16) {
                    tooClose = true;
                    break;
                }
                ++i;
            }
            if (!tooClose) {
                this.polygon.addPoint(x, y);
            }
        } else {
            this.polygon.addPoint(x, y);
        }
    }

    private void addBlobPoint(int x, int y) {
        int n = this.polygon.npoints;
        if (n > 0) {
            boolean tooClose = false;
            int dx = 0;
            int dy = 0;
            int i = 0;
            while (i < n) {
                dx = x - this.polygon.xpoints[i];
                dy = y - this.polygon.ypoints[i];
                if (dx * dx + dy * dy < 100) {
                    tooClose = true;
                    break;
                }
                ++i;
            }
            if (!tooClose) {
                this.polygon.addPoint(x, y);
            }
        } else {
            this.polygon.addPoint(x, y);
        }
    }

    private void resetMousePoints() {
        this.mousePressedPoint.setLocation(-1, -1);
        this.mouseReleasedPoint.setLocation(-1, -1);
        this.mouseMovedPoint.setLocation(-1, -1);
    }

    private void setMovingShape(boolean anchor) {
        ParticleFeeder f;
        Shape shape;
        if (this.selectedManipulable instanceof Part) {
            Part p = (Part)this.selectedManipulable;
            Shape shape2 = p.getShape();
            if (shape2 instanceof Rectangle2D.Float) {
                Rectangle2D.Float r = (Rectangle2D.Float)shape2;
                int a = this.convertPointToPixelX(r.x);
                int b = this.convertPointToPixelY(r.y);
                int c = this.convertLengthToPixelX(r.width);
                int d = this.convertLengthToPixelY(r.height);
                if (anchor) {
                    this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
                }
                this.movingShape = new MovingRoundRectangle(new RoundRectangle2D.Float(a, b, c, d, 0.0f, 0.0f));
            } else if (shape2 instanceof Ellipse2D.Float) {
                Ellipse2D.Float e = (Ellipse2D.Float)shape2;
                int a = this.convertPointToPixelX(e.x);
                int b = this.convertPointToPixelY(e.y);
                int c = this.convertLengthToPixelX(e.width);
                int d = this.convertLengthToPixelY(e.height);
                if (anchor) {
                    this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
                }
                this.movingShape = new MovingEllipse(new Ellipse2D.Float(a, b, c, d));
            } else if (shape2 instanceof Polygon2D) {
                Polygon2D q = (Polygon2D)shape2;
                int n = q.getVertexCount();
                int[] x = new int[n];
                int[] y = new int[n];
                int i = 0;
                while (i < n) {
                    Point2D.Float point = q.getVertex(i);
                    x[i] = this.convertPointToPixelX(point.x);
                    y[i] = this.convertPointToPixelY(point.y);
                    ++i;
                }
                this.movingShape = new MovingPolygon(new Polygon(x, y, n));
            } else if (shape2 instanceof Blob2D) {
                Blob2D b = (Blob2D)shape2;
                int n = b.getPointCount();
                int[] x = new int[n];
                int[] y = new int[n];
                int i = 0;
                while (i < n) {
                    Point2D.Float point = b.getPoint(i);
                    x[i] = this.convertPointToPixelX(point.x);
                    y[i] = this.convertPointToPixelY(point.y);
                    ++i;
                }
                this.movingShape = new MovingBlob(new Blob2D(x, y));
            } else if (shape2 instanceof Ring2D) {
                Ring2D r = (Ring2D)shape2;
                int xc = this.convertPointToPixelX(r.getX());
                int yc = this.convertPointToPixelY(r.getY());
                int ai = this.convertPointToPixelX(r.getInnerDiameter());
                int bi = this.convertPointToPixelY(r.getInnerDiameter());
                int ao = this.convertPointToPixelX(r.getOuterDiameter());
                int bo = this.convertPointToPixelY(r.getOuterDiameter());
                Ellipse2D.Float outer = new Ellipse2D.Float(xc - ao / 2, yc - bo / 2, ao, bo);
                Ellipse2D.Float inner = new Ellipse2D.Float(xc - ai / 2, yc - bi / 2, ai, bi);
                this.movingShape = new MovingAnnulus(outer, inner);
            }
        } else if (this.selectedManipulable instanceof Particle) {
            Ellipse2D.Float e = (Ellipse2D.Float)this.selectedManipulable.getShape();
            int a = this.convertPointToPixelX(e.x);
            int b = this.convertPointToPixelY(e.y);
            int c = this.convertLengthToPixelX(e.width);
            int d = this.convertLengthToPixelY(e.height);
            if (anchor) {
                this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
            }
            this.movingShape = new MovingEllipse(new Ellipse2D.Float(a, b, c, d));
        } else if (this.selectedManipulable instanceof Sensor || this.selectedManipulable instanceof TextBox) {
            Rectangle2D.Float r = (Rectangle2D.Float)this.selectedManipulable.getShape();
            int a = this.convertPointToPixelX(r.x);
            int b = this.convertPointToPixelY(r.y);
            int c = this.convertLengthToPixelX(r.width);
            int d = this.convertLengthToPixelY(r.height);
            if (anchor) {
                this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
            }
            this.movingShape = new MovingRoundRectangle(new RoundRectangle2D.Float(a, b, c, d, 0.0f, 0.0f));
        } else if (this.selectedManipulable instanceof Cloud) {
            Cloud cloud = (Cloud)this.selectedManipulable;
            Rectangle2D.Float r = new Rectangle2D.Float();
            int x = this.convertPointToPixelX(cloud.getX());
            int y = this.convertPointToPixelY(cloud.getY());
            r.width = this.convertLengthToPixelX(cloud.getWidth());
            r.height = this.convertLengthToPixelY(cloud.getHeight());
            if (anchor) {
                this.setAnchorPointForRectangularShape(this.selectedSpot, x, y, r.width, r.height);
            }
            this.movingShape = new MovingCloud(r);
            ((MovingCloud)this.movingShape).setLocation(x, y);
        } else if (this.selectedManipulable instanceof Tree) {
            Tree tree = (Tree)this.selectedManipulable;
            Rectangle2D.Float r = new Rectangle2D.Float();
            int x = this.convertPointToPixelX(tree.getX());
            int y = this.convertPointToPixelY(tree.getY());
            r.width = this.convertLengthToPixelX(tree.getWidth());
            r.height = this.convertLengthToPixelY(tree.getHeight());
            if (anchor) {
                this.setAnchorPointForRectangularShape(this.selectedSpot, x, y, r.width, r.height);
            }
            this.movingShape = new MovingTree(r, ((Tree)this.selectedManipulable).getType());
            ((MovingTree)this.movingShape).setLocation(x, y);
        } else if (this.selectedManipulable instanceof Fan) {
            Fan f2 = (Fan)this.selectedManipulable;
            Shape shape3 = f2.getShape();
            if (shape3 instanceof Rectangle2D.Float) {
                Rectangle2D.Float r = (Rectangle2D.Float)shape3;
                int a = this.convertPointToPixelX(r.x);
                int b = this.convertPointToPixelY(r.y);
                int c = this.convertLengthToPixelX(r.width);
                int d = this.convertLengthToPixelY(r.height);
                if (anchor) {
                    this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
                }
                float rotation = f2.getSpeed() * this.model.getTime();
                this.movingShape = new MovingFan(new Rectangle2D.Float(a, b, c, d), f2.getSpeed(), f2.getAngle(), (float)Math.abs(Math.sin(rotation)));
            }
        } else if (this.selectedManipulable instanceof Heliostat) {
            Heliostat h = (Heliostat)this.selectedManipulable;
            Shape shape4 = h.getShape();
            if (shape4 instanceof Rectangle2D.Float) {
                Rectangle2D.Float r = (Rectangle2D.Float)shape4;
                int a = this.convertPointToPixelX(r.x);
                int b = this.convertPointToPixelY(r.y);
                int c = this.convertLengthToPixelX(r.width);
                int d = this.convertLengthToPixelY(r.height);
                if (anchor) {
                    this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
                }
                this.movingShape = new MovingHeliostat(new Rectangle2D.Float(a, b, c, d), h.getAngle());
            }
        } else if (this.selectedManipulable instanceof ParticleFeeder && (shape = (f = (ParticleFeeder)this.selectedManipulable).getShape()) instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)shape;
            int a = this.convertPointToPixelX(r.x);
            int b = this.convertPointToPixelY(r.y);
            int c = this.convertLengthToPixelX(r.width);
            int d = this.convertLengthToPixelY(r.height);
            if (anchor) {
                this.setAnchorPointForRectangularShape(this.selectedSpot, a, b, c, d);
            }
            this.movingShape = new MovingParticleFeeder(new RoundRectangle2D.Float(a, b, c, d, 8.0f, 8.0f));
        }
    }

    private float convertPixelToPointXPrecisely(int x) {
        return this.xmin + (this.xmax - this.xmin) * (float)x / (float)this.getWidth();
    }

    private float convertPixelToPointYPrecisely(int y) {
        return this.ymin + (this.ymax - this.ymin) * (float)y / (float)this.getHeight();
    }

    private float convertPixelToLengthXPrecisely(int l) {
        return (this.xmax - this.xmin) * (float)l / (float)this.getWidth();
    }

    private float convertPixelToLengthYPrecisely(int l) {
        return (this.ymax - this.ymin) * (float)l / (float)this.getHeight();
    }

    private float convertPixelToPointX(int x) {
        if (this.snapToGrid) {
            return this.xmin + (this.xmax - this.xmin) / (float)this.nx * (float)Math.round((float)x / (float)this.getWidth() * (float)this.nx);
        }
        return this.convertPixelToPointXPrecisely(x);
    }

    private float convertPixelToPointY(int y) {
        if (this.snapToGrid) {
            return this.ymin + (this.ymax - this.ymin) / (float)this.ny * (float)Math.round((float)y / (float)this.getHeight() * (float)this.ny);
        }
        return this.convertPixelToPointYPrecisely(y);
    }

    private float convertPixelToLengthX(int l) {
        if (this.snapToGrid) {
            return (this.xmax - this.xmin) / (float)this.nx * (float)Math.round((float)l / (float)this.getWidth() * (float)this.nx);
        }
        return this.convertPixelToLengthXPrecisely(l);
    }

    private float convertPixelToLengthY(int l) {
        if (this.snapToGrid) {
            return (this.ymax - this.ymin) / (float)this.ny * (float)Math.round((float)l / (float)this.getHeight() * (float)this.ny);
        }
        return this.convertPixelToLengthYPrecisely(l);
    }

    private int getXOnGrid(int x) {
        float dx = (float)this.getWidth() / (float)this.nx;
        int ix = Math.round((float)x / dx);
        return Math.round((float)ix * dx);
    }

    private int getYOnGrid(int y) {
        float dy = (float)this.getHeight() / (float)this.ny;
        int iy = Math.round((float)y / dy);
        return Math.round((float)iy * dy);
    }

    public int convertPointToPixelX(float x) {
        int w = this.getWidth();
        if (w == 0) {
            w = this.getPreferredSize().width;
        }
        return Math.round((x - this.xmin) / (this.xmax - this.xmin) * (float)w);
    }

    public int convertPointToPixelY(float y) {
        int h = this.getHeight();
        if (h == 0) {
            h = this.getPreferredSize().height;
        }
        return Math.round((y - this.ymin) / (this.ymax - this.ymin) * (float)h);
    }

    public int convertLengthToPixelX(float l) {
        int w = this.getWidth();
        if (w == 0) {
            w = this.getPreferredSize().width;
        }
        return Math.round(l / (this.xmax - this.xmin) * (float)w);
    }

    public int convertLengthToPixelY(float l) {
        int h = this.getHeight();
        if (h == 0) {
            h = this.getPreferredSize().height;
        }
        return Math.round(l / (this.ymax - this.ymin) * (float)h);
    }

    private void showTipPopupMenu(String msg, int x, int y, int time) {
        if (this.tipPopupMenu == null) {
            this.tipPopupMenu = new JPopupMenu("Tip");
            this.tipPopupMenu.setBorder(BorderFactory.createLineBorder(Color.black));
            this.tipPopupMenu.setBackground(SystemColor.info);
            JLabel l = new JLabel(msg);
            l.setFont(new Font(null, 0, 10));
            l.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.tipPopupMenu.add(l);
        } else {
            ((JLabel)this.tipPopupMenu.getComponent(0)).setText(msg);
        }
        this.tipPopupMenu.show(this, x, y);
        if (time > 0) {
            Timer timer = new Timer(time, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View2D.this.tipPopupMenu.setVisible(false);
                }
            });
            timer.setRepeats(false);
            timer.setInitialDelay(time);
            timer.start();
        }
    }

    private Symbol overWhichButton(int x, int y) {
        if (this.showControlPanel) {
            if (this.startIcon != null && this.startIcon.contains(x, y)) {
                return this.startIcon;
            }
            if (this.resetIcon != null && this.resetIcon.contains(x, y)) {
                return this.resetIcon;
            }
            if (this.graphIcon != null && this.graphIcon.contains(x, y)) {
                return this.graphIcon;
            }
            if (this.nextIcon != null && this.nextIcon.contains(x, y)) {
                return this.nextIcon;
            }
            if (this.prevIcon != null && this.prevIcon.contains(x, y)) {
                return this.prevIcon;
            }
            if (this.modeIcon != null && this.modeIcon.contains(x, y)) {
                return this.modeIcon;
            }
            if (this.isFullScreen() && this.switchIcon != null && this.switchIcon.contains(x, y)) {
                return this.switchIcon;
            }
        }
        if (this.frankOn && this.brand.contains(x, y)) {
            return this.brand;
        }
        return null;
    }

    private void drawControlPanel(Graphics2D g, int x, int y) {
        if (this.startIcon != null) {
            g.setStroke(thinStroke);
            this.startIcon.setColor(this.getContrastColor(x, y));
            this.startIcon.paintIcon(this, g, x - this.startIcon.getIconWidth() * 3 - 12, y);
        }
        if (this.resetIcon != null) {
            g.setStroke(thinStroke);
            this.resetIcon.setColor(this.getContrastColor(x, y));
            this.resetIcon.paintIcon(this, g, x - this.resetIcon.getIconWidth() * 2 - 8, y);
        }
        if (this.graphIcon != null) {
            g.setStroke(thinStroke);
            this.graphIcon.setColor(this.getContrastColor(x, y));
            this.graphIcon.paintIcon(this, g, x - this.graphIcon.getIconWidth() - 4, y);
        }
        if (this.modeIcon != null) {
            g.setStroke(thinStroke);
            this.modeIcon.setColor(this.getContrastColor(x, y));
            this.modeIcon.paintIcon(this, g, x, y);
        }
        if (this.prevIcon != null) {
            g.setStroke(thinStroke);
            this.prevIcon.setColor(this.getContrastColor(x, y));
            this.prevIcon.paintIcon(this, g, x + this.nextIcon.getIconWidth() + 4, y);
        }
        if (this.nextIcon != null) {
            g.setStroke(thinStroke);
            this.nextIcon.setColor(this.getContrastColor(x, y));
            this.nextIcon.paintIcon(this, g, x + this.nextIcon.getIconWidth() * 2 + 8, y);
        }
        if (this.isFullScreen() && this.switchIcon != null) {
            g.setStroke(thinStroke);
            this.switchIcon.setColor(this.getContrastColor(x, y));
            this.switchIcon.paintIcon(this, g, x + this.switchIcon.getIconWidth() * 3 + 12, y);
        }
    }

    private boolean isFullScreen() {
        return this.getClientProperty("close_full_screen") != null;
    }
}

