/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.concord.energy2d.view.View2D;

class VectorRenderer {
    private static final float COS = (float)Math.cos(Math.toRadians(30.0));
    private static final float SIN = (float)Math.sin(Math.toRadians(30.0));
    private BasicStroke stroke = new BasicStroke(1.0f);
    private int nx;
    private int ny;
    private int spacing = 4;
    private static float defaultScale = 100.0f;
    private static float defaultMinSquare = 1.0E-10f;
    private View2D view;

    VectorRenderer(View2D view, int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
        this.view = view;
    }

    static float getDefaultMinimumValueSquare() {
        return defaultMinSquare;
    }

    static float getDefaultScale() {
        return defaultScale;
    }

    void setStroke(BasicStroke s) {
        this.stroke = s;
    }

    void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    int getSpacing() {
        return this.spacing;
    }

    private void drawVector(Graphics2D g, int x, int y, float vx, float vy, float scale) {
        VectorRenderer.drawVector(g, x, y, 0.0f, vx, vy, scale, this.stroke);
    }

    static void drawVector(Graphics2D g, float x, float y, float radius, float vx, float vy, float scale, BasicStroke stroke) {
        float r = 1.0f / (float)Math.hypot(vx, vy);
        float arrowx = vx * r;
        float arrowy = vy * r;
        float x0 = radius * arrowx;
        float y0 = radius * arrowy;
        r = stroke.getLineWidth();
        float x1 = x + x0 + arrowx * (2.0f + r * 2.0f) + vx * scale;
        float y1 = y + y0 + arrowy * (2.0f + r * 2.0f) + vy * scale;
        g.drawLine(Math.round(x + x0), Math.round(y + y0), Math.round(x1), Math.round(y1));
        r = 4.0f;
        float wingx = r * (arrowx * COS + arrowy * SIN);
        float wingy = r * (arrowy * COS - arrowx * SIN);
        g.drawLine(Math.round(x1), Math.round(y1), Math.round(x1 - wingx), Math.round(y1 - wingy));
        wingx = r * (arrowx * COS - arrowy * SIN);
        wingy = r * (arrowy * COS + arrowx * SIN);
        g.drawLine(Math.round(x1), Math.round(y1), Math.round(x1 - wingx), Math.round(y1 - wingy));
    }

    void renderVectors(float[][] u, float[][] v, JComponent c, Graphics2D g) {
        if (!c.isVisible()) {
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        float dx = (float)w / (float)this.nx;
        float dy = (float)h / (float)this.ny;
        g.setStroke(this.stroke);
        Color color = null;
        int i = 1;
        while (i < this.nx - 1) {
            int x = Math.round((float)i * dx);
            int j = 1;
            while (j < this.ny - 1) {
                int y = Math.round((float)j * dy);
                float uij = u[i][j];
                float vij = v[i][j];
                if (uij * uij + vij * vij > defaultMinSquare) {
                    color = this.view.getContrastColor(x, y);
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
                    g.setColor(color);
                    this.drawVector(g, x, y, uij, vij, defaultScale);
                }
                j += this.spacing;
            }
            i += this.spacing;
        }
    }

    void renderHeatFlux(float[][] t, float[][] k, JComponent c, Graphics2D g, float scale, float minSquare, boolean dotForZero) {
        if (!c.isVisible()) {
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        float dx = (float)w / (float)this.nx;
        float dy = (float)h / (float)this.ny;
        g.setStroke(this.stroke);
        int i = 1;
        while (i < this.nx - 1) {
            int x = Math.round((float)i * dx);
            int j = 1;
            while (j < this.ny - 1) {
                int y = Math.round((float)j * dy);
                float uij = -k[i][j] * (t[i + 1][j] - t[i - 1][j]) / (2.0f * dx);
                float vij = -k[i][j] * (t[i][j + 1] - t[i][j - 1]) / (2.0f * dy);
                g.setColor(this.view.getContrastColor(x, y));
                if (uij * uij + vij * vij > minSquare) {
                    this.drawVector(g, x, y, uij, vij, scale);
                } else if (dotForZero) {
                    g.fillOval(x, y, 4, 4);
                }
                j += this.spacing;
            }
            i += this.spacing;
        }
    }
}

