/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.util.BackgroundComboBox;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.view.View2D;

class TreeDialog
extends JDialog {
    private JColorChooser colorChooser;
    private JCheckBox draggableCheckBox;
    private BackgroundComboBox bgComboBox;
    private JComboBox<String> typeComboBox;
    private ActionListener okListener;

    TreeDialog(final View2D view, final Tree tree, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Tree (#" + view.model.getTrees().indexOf(tree) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(tree, (byte)3);
                view.repaint();
                TreeDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = TreeDialog.this.typeComboBox.getSelectedItem().toString();
                if ("Pine".equalsIgnoreCase(s)) {
                    tree.setType((byte)1);
                } else if ("Regular".equalsIgnoreCase(s)) {
                    tree.setType((byte)0);
                }
                tree.setDraggable(TreeDialog.this.draggableCheckBox.isSelected());
                view.notifyManipulationListeners(tree, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                TreeDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        Box miscBox = Box.createVerticalBox();
        miscBox.setBorder(BorderFactory.createTitledBorder("General"));
        box.add(miscBox);
        JPanel p = new JPanel(new FlowLayout(0));
        miscBox.add(p);
        p.add(new JLabel("Type:"));
        this.typeComboBox = new JComboBox<String>(new String[]{"Regular", "Pine"});
        switch (tree.getType()) {
            case 0: {
                this.typeComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.typeComboBox.setSelectedIndex(1);
            }
        }
        p.add(this.typeComboBox);
        p.add(new JLabel("Color:"));
        this.colorChooser = new JColorChooser();
        this.colorChooser.setColor(tree.getColor());
        this.bgComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.bgComboBox.setToolTipText("Background color");
        this.bgComboBox.setFillPattern(new ColorFill(tree.getColor()));
        this.bgComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = TreeDialog.this.bgComboBox.getColorMenu().getColor();
                tree.setColor(c);
                view.repaint();
                TreeDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.bgComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = TreeDialog.this.bgComboBox.getColorMenu().getColorChooser().getColor();
                tree.setColor(c);
                view.repaint();
                TreeDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.bgComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = TreeDialog.this.bgComboBox.getColorMenu().getHexInputColor(tree.getColor());
                if (c == null) {
                    return;
                }
                tree.setColor(c);
                view.repaint();
                TreeDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.bgComboBox);
        this.draggableCheckBox = new JCheckBox("Draggable by user", tree.isDraggable());
        p.add(this.draggableCheckBox);
        this.pack();
        this.setLocationRelativeTo(view);
    }
}

