/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.text.DecimalFormat;
import org.concord.energy2d.view.View2D;

class TickmarksRenderer {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat("####.####");
    private Stroke stroke = new BasicStroke(1.0f);
    private Font smallFont = new Font(null, 0, 9);
    private int nx = 100;
    private int ny = 100;
    private float dx;
    private float dy;
    private float xmin;
    private float ymin;
    private String unit = "m";

    TickmarksRenderer() {
    }

    void setSize(float xmin, float xmax, float ymin, float ymax) {
        float ratio = (ymax - ymin) / (xmax - xmin);
        this.ny = (int)((float)this.nx * ratio);
        this.dx = (xmax - xmin) / (float)this.nx;
        this.dy = (ymax - ymin) / (float)this.ny;
        this.xmin = xmin;
        this.ymin = ymin;
    }

    private static void centerString(String s, Graphics2D g, int x, int y) {
        int stringWidth = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x - stringWidth / 2, y);
    }

    void render(View2D c, Graphics2D g) {
        int k;
        if (!c.isVisible()) {
            return;
        }
        Font oldFont = g.getFont();
        Stroke oldStroke = g.getStroke();
        int w = c.getWidth();
        int h = c.getHeight();
        g.setStroke(this.stroke);
        g.setFont(this.smallFont);
        int i = 1;
        while (i < this.nx) {
            k = Math.round(i * w / this.nx);
            g.setColor(c.getContrastColor(k, h - 12));
            if (i % 10 == 0) {
                g.drawLine(k, h, k, h - 10);
                TickmarksRenderer.centerString(SIZE_FORMAT.format(this.xmin + (float)i * this.dx), g, k, h - 12);
            } else {
                g.drawLine(k, h, k, h - 5);
            }
            ++i;
        }
        g.setColor(c.getContrastColor(w - 10, h - 12));
        TickmarksRenderer.centerString(this.unit, g, w - 10, h - 12);
        i = 1;
        while (i < this.ny) {
            k = Math.round((1.0f - (float)i / (float)this.ny) * (float)h);
            g.setColor(c.getContrastColor(15, k + 3));
            if (i % 10 == 0) {
                g.drawLine(0, k, 10, k);
                TickmarksRenderer.centerString(SIZE_FORMAT.format(this.ymin + (float)i * this.dy), g, 15, k + 3);
            } else {
                g.drawLine(0, k, 5, k);
            }
            ++i;
        }
        g.setColor(c.getContrastColor(15, 10));
        TickmarksRenderer.centerString(this.unit, g, 15, 10);
        g.setStroke(oldStroke);
        g.setFont(oldFont);
    }
}

