/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ThermostatDialog
extends JDialog {
    private Window owner;
    private ActionListener okListener;
    private JTextField setpointField;
    private JTextField deadbandField;
    private JCheckBox enableCheckBox;

    ThermostatDialog(final View2D view, final Part powerSource, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Thermostat", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(powerSource, (byte)3);
                view.repaint();
                ThermostatDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThermostatDialog.this.enableCheckBox.isSelected()) {
                    float setpoint = ThermostatDialog.this.parse(ThermostatDialog.this.setpointField.getText());
                    if (Float.isNaN(setpoint)) {
                        return;
                    }
                    float deadband = ThermostatDialog.this.parse(ThermostatDialog.this.deadbandField.getText());
                    if (Float.isNaN(deadband)) {
                        return;
                    }
                    Thermostat t = view.model.addThermostat(null, powerSource);
                    t.setSetPoint(setpoint);
                    t.setDeadband(deadband);
                } else {
                    view.model.removeThermostat(null, powerSource);
                }
                view.notifyManipulationListeners(powerSource, (byte)3);
                view.repaint();
                ThermostatDialog.this.dispose();
            }
        };
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThermostatDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new FlowLayout(0, 10, 10));
        p.setBorder(BorderFactory.createTitledBorder("Internal Thermostat"));
        box.add(p);
        Thermostat thermostat = view.model.getThermostat(null, powerSource);
        this.enableCheckBox = new JCheckBox("Enabled", thermostat != null);
        p.add(this.enableCheckBox);
        p.add(new JLabel("Set point: "));
        this.setpointField = new JTextField(thermostat == null ? "20" : String.valueOf(thermostat.getSetPoint()), 10);
        this.setpointField.addActionListener(this.okListener);
        p.add(this.setpointField);
        p.add(new JLabel("\u2103"));
        p.add(new JLabel("Deadband: "));
        this.deadbandField = new JTextField(thermostat == null ? "1" : String.valueOf(thermostat.getDeadband()), 10);
        this.deadbandField.addActionListener(this.okListener);
        p.add(this.deadbandField);
        p.add(new JLabel("\u2103"));
        p = new JPanel(new FlowLayout(0, 10, 10));
        p.add(new JLabel("<html><font size=2>This type of thermostat uses the temperature at the center of this source to control its power.<br>To control the power using temperature elsewhere, use the thermostat controlled by a thermometer.</html>"));
        box.add(p);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

