/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Thermostat;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ThermometerDialog
extends JDialog {
    private Window owner;
    private ActionListener okListener;
    private JTextField xField;
    private JTextField yField;
    private JTextField labelField;
    private JTextField uidField;
    private JTextField attachField;
    private JTextField setpointField;
    private JTextField deadbandField;
    private JRadioButton onePointButton;
    private JRadioButton fivePointsButton;
    private JRadioButton ninePointsButton;
    private JCheckBox[] powerSourceCheckBoxes;
    private List<Part> powerSources;

    ThermometerDialog(final View2D view, final Thermometer thermometer, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Thermometer (#" + view.model.getThermometers().indexOf(thermometer) + ") Options", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(thermometer, (byte)3);
                view.repaint();
                ThermometerDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String attachID;
                boolean moved;
                boolean thermostatSet = false;
                int i = 0;
                while (i < ThermometerDialog.this.powerSourceCheckBoxes.length) {
                    if (ThermometerDialog.this.powerSourceCheckBoxes[i].isSelected()) {
                        thermostatSet = true;
                        break;
                    }
                    ++i;
                }
                if (thermostatSet && ThermometerDialog.this.checkUidField()) {
                    return;
                }
                float x = ThermometerDialog.this.parse(ThermometerDialog.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = ThermometerDialog.this.parse(ThermometerDialog.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                y = view.model.getLy() - y - thermometer.getSensingSpotY();
                boolean bl = moved = (double)Math.abs(x - thermometer.getX()) > 1.0E-6 * (double)view.model.getLx() || (double)Math.abs(y - thermometer.getY()) > 1.0E-6 * (double)view.model.getLy();
                if (moved) {
                    view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                }
                thermometer.setX(x);
                thermometer.setY(y);
                thermometer.setLabel(ThermometerDialog.this.labelField.getText());
                String uid = ThermometerDialog.this.uidField.getText();
                if (uid != null && !(uid = uid.trim()).equals("") && !uid.equals(thermometer.getUid())) {
                    if (view.isUidUsed(uid)) {
                        JOptionPane.showMessageDialog(ThermometerDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                        return;
                    }
                    thermometer.setUid(uid);
                }
                if ((attachID = ThermometerDialog.this.attachField.getText()) != null && !(attachID = attachID.trim()).equals("")) {
                    if (attachID.equals(thermometer.getUid())) {
                        JOptionPane.showMessageDialog(ThermometerDialog.this.owner, "Thermometer " + attachID + " cannot be attached to itself.", "Error", 0);
                        return;
                    }
                    if (!view.isUidUsed(attachID)) {
                        JOptionPane.showMessageDialog(ThermometerDialog.this.owner, "Object " + attachID + " not found.", "Error", 0);
                        return;
                    }
                    thermometer.setAttachID(attachID);
                    Particle particle = view.model.getParticle(attachID);
                    if (particle != null) {
                        thermometer.setX(particle.getRx());
                        thermometer.setY(particle.getRy() - thermometer.getSensingSpotY());
                    }
                }
                if (ThermometerDialog.this.onePointButton.isSelected()) {
                    thermometer.setStencil((byte)1);
                } else if (ThermometerDialog.this.fivePointsButton.isSelected()) {
                    thermometer.setStencil((byte)5);
                } else if (ThermometerDialog.this.ninePointsButton.isSelected()) {
                    thermometer.setStencil((byte)9);
                }
                float setpoint = ThermometerDialog.this.parse(ThermometerDialog.this.setpointField.getText());
                if (Float.isNaN(setpoint)) {
                    return;
                }
                float deadband = ThermometerDialog.this.parse(ThermometerDialog.this.deadbandField.getText());
                if (Float.isNaN(deadband)) {
                    return;
                }
                int i2 = 0;
                while (i2 < ThermometerDialog.this.powerSourceCheckBoxes.length) {
                    Part ps = (Part)ThermometerDialog.this.powerSources.get(i2);
                    if (ThermometerDialog.this.powerSourceCheckBoxes[i2].isSelected()) {
                        Thermostat t = view.model.addThermostat(thermometer, ps);
                        t.setSetPoint(setpoint);
                        t.setDeadband(deadband);
                    } else {
                        view.model.removeThermostat(thermometer, ps);
                    }
                    ++i2;
                }
                view.notifyManipulationListeners(thermometer, (byte)3);
                view.repaint();
                ThermometerDialog.this.dispose();
            }
        };
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThermometerDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new GridLayout(3, 2, 8, 8));
        p.setBorder(BorderFactory.createTitledBorder("General properties"));
        box.add(p);
        p.add(new JLabel("X:"));
        this.xField = new JTextField(View2D.COORDINATES_FORMAT.format(thermometer.getX()), 10);
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel("Y:"));
        this.yField = new JTextField(View2D.COORDINATES_FORMAT.format(view.model.getLy() - thermometer.getY() - thermometer.getSensingSpotY()), 10);
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(thermometer.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Attached to:"));
        this.attachField = new JTextField(thermometer.getAttachID(), 10);
        this.attachField.addActionListener(this.okListener);
        p.add(this.attachField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(thermometer.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p = new JPanel(new FlowLayout(0));
        p.setBorder(BorderFactory.createTitledBorder("Sampled area (stencil)"));
        box.add(p);
        ButtonGroup bg = new ButtonGroup();
        this.onePointButton = new JRadioButton("One point");
        p.add(this.onePointButton);
        bg.add(this.onePointButton);
        this.fivePointsButton = new JRadioButton("Five points");
        p.add(this.fivePointsButton);
        bg.add(this.fivePointsButton);
        this.ninePointsButton = new JRadioButton("Nine points");
        p.add(this.ninePointsButton);
        bg.add(this.ninePointsButton);
        switch (thermometer.getStencil()) {
            case 5: {
                this.fivePointsButton.setSelected(true);
                break;
            }
            case 9: {
                this.ninePointsButton.setSelected(true);
                break;
            }
            default: {
                this.onePointButton.setSelected(true);
            }
        }
        Thermostat thermostat = view.model.getThermostat(thermometer);
        List<Part> parts = view.model.getParts();
        this.powerSources = new ArrayList<Part>();
        for (Part x : parts) {
            Thermostat ts;
            if (x.getPower() == 0.0f || (ts = view.model.getThermostat(x)) != null && ts.getThermometer() != thermometer) continue;
            this.powerSources.add(x);
        }
        this.powerSourceCheckBoxes = new JCheckBox[this.powerSources.size()];
        JPanel thermostatPanel = new JPanel(new BorderLayout());
        thermostatPanel.setBorder(BorderFactory.createTitledBorder("Thermostat connection"));
        box.add(thermostatPanel);
        p = new JPanel(new FlowLayout(0));
        thermostatPanel.add((Component)p, "North");
        p.add(new JLabel("Set point: "));
        this.setpointField = new JTextField(thermostat == null ? "20" : String.valueOf(thermostat.getSetPoint()), 10);
        this.setpointField.addActionListener(this.okListener);
        p.add(this.setpointField);
        p.add(new JLabel("\u2103"));
        p.add(new JLabel("      Deadband: "));
        this.deadbandField = new JTextField(thermostat == null ? "1" : String.valueOf(thermostat.getDeadband()), 10);
        this.deadbandField.addActionListener(this.okListener);
        p.add(this.deadbandField);
        p.add(new JLabel("\u2103"));
        p = new JPanel(new FlowLayout(0));
        thermostatPanel.add((Component)p, "Center");
        p.add(new JLabel(this.powerSources.isEmpty() ? "No power source." : "Power sources:"));
        p = new JPanel(new GridLayout(1 + this.powerSources.size() / 5, 5));
        thermostatPanel.add((Component)p, "South");
        int i = 0;
        while (i < this.powerSources.size()) {
            Part ps = this.powerSources.get(i);
            String uid = ps.getUid();
            if (uid == null) {
                uid = Long.toHexString(System.currentTimeMillis());
                ps.setUid(uid);
            }
            this.powerSourceCheckBoxes[i] = new JCheckBox(ps.getUid());
            if (view.model.isConnected(thermometer, ps)) {
                this.powerSourceCheckBoxes[i].setSelected(true);
            }
            this.powerSourceCheckBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThermometerDialog.this.checkUidField();
                }
            });
            p.add(this.powerSourceCheckBoxes[i]);
            ++i;
        }
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private boolean checkUidField() {
        String s = this.uidField.getText();
        if (s == null || s.trim().length() == 0) {
            JOptionPane.showMessageDialog(this.owner, "Please provide a unique ID for this thermometer.", "Reminder", 2);
            this.uidField.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

